// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ivs

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchGetChannel = "BatchGetChannel"

// BatchGetChannelRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetChannel for more information on using the BatchGetChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetChannelRequest method.
//	req, resp := client.BatchGetChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/BatchGetChannel
func (c *IVS) BatchGetChannelRequest(input *BatchGetChannelInput) (req *request.Request, output *BatchGetChannelOutput) {
	op := &request.Operation{
		Name:       opBatchGetChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/BatchGetChannel",
	}

	if input == nil {
		input = &BatchGetChannelInput{}
	}

	output = &BatchGetChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetChannel API operation for Amazon Interactive Video Service.
//
// Performs GetChannel on multiple ARNs simultaneously.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation BatchGetChannel for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/BatchGetChannel
func (c *IVS) BatchGetChannel(input *BatchGetChannelInput) (*BatchGetChannelOutput, error) {
	req, out := c.BatchGetChannelRequest(input)
	return out, req.Send()
}

// BatchGetChannelWithContext is the same as BatchGetChannel with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) BatchGetChannelWithContext(ctx aws.Context, input *BatchGetChannelInput, opts ...request.Option) (*BatchGetChannelOutput, error) {
	req, out := c.BatchGetChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetStreamKey = "BatchGetStreamKey"

// BatchGetStreamKeyRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetStreamKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetStreamKey for more information on using the BatchGetStreamKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetStreamKeyRequest method.
//	req, resp := client.BatchGetStreamKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/BatchGetStreamKey
func (c *IVS) BatchGetStreamKeyRequest(input *BatchGetStreamKeyInput) (req *request.Request, output *BatchGetStreamKeyOutput) {
	op := &request.Operation{
		Name:       opBatchGetStreamKey,
		HTTPMethod: "POST",
		HTTPPath:   "/BatchGetStreamKey",
	}

	if input == nil {
		input = &BatchGetStreamKeyInput{}
	}

	output = &BatchGetStreamKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetStreamKey API operation for Amazon Interactive Video Service.
//
// Performs GetStreamKey on multiple ARNs simultaneously.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation BatchGetStreamKey for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/BatchGetStreamKey
func (c *IVS) BatchGetStreamKey(input *BatchGetStreamKeyInput) (*BatchGetStreamKeyOutput, error) {
	req, out := c.BatchGetStreamKeyRequest(input)
	return out, req.Send()
}

// BatchGetStreamKeyWithContext is the same as BatchGetStreamKey with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetStreamKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) BatchGetStreamKeyWithContext(ctx aws.Context, input *BatchGetStreamKeyInput, opts ...request.Option) (*BatchGetStreamKeyOutput, error) {
	req, out := c.BatchGetStreamKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchStartViewerSessionRevocation = "BatchStartViewerSessionRevocation"

// BatchStartViewerSessionRevocationRequest generates a "aws/request.Request" representing the
// client's request for the BatchStartViewerSessionRevocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchStartViewerSessionRevocation for more information on using the BatchStartViewerSessionRevocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchStartViewerSessionRevocationRequest method.
//	req, resp := client.BatchStartViewerSessionRevocationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/BatchStartViewerSessionRevocation
func (c *IVS) BatchStartViewerSessionRevocationRequest(input *BatchStartViewerSessionRevocationInput) (req *request.Request, output *BatchStartViewerSessionRevocationOutput) {
	op := &request.Operation{
		Name:       opBatchStartViewerSessionRevocation,
		HTTPMethod: "POST",
		HTTPPath:   "/BatchStartViewerSessionRevocation",
	}

	if input == nil {
		input = &BatchStartViewerSessionRevocationInput{}
	}

	output = &BatchStartViewerSessionRevocationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchStartViewerSessionRevocation API operation for Amazon Interactive Video Service.
//
// Performs StartViewerSessionRevocation on multiple channel ARN and viewer
// ID pairs simultaneously.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation BatchStartViewerSessionRevocation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - PendingVerification
//
//   - ThrottlingException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/BatchStartViewerSessionRevocation
func (c *IVS) BatchStartViewerSessionRevocation(input *BatchStartViewerSessionRevocationInput) (*BatchStartViewerSessionRevocationOutput, error) {
	req, out := c.BatchStartViewerSessionRevocationRequest(input)
	return out, req.Send()
}

// BatchStartViewerSessionRevocationWithContext is the same as BatchStartViewerSessionRevocation with the addition of
// the ability to pass a context and additional request options.
//
// See BatchStartViewerSessionRevocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) BatchStartViewerSessionRevocationWithContext(ctx aws.Context, input *BatchStartViewerSessionRevocationInput, opts ...request.Option) (*BatchStartViewerSessionRevocationOutput, error) {
	req, out := c.BatchStartViewerSessionRevocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannel = "CreateChannel"

// CreateChannelRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannel for more information on using the CreateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateChannelRequest method.
//	req, resp := client.CreateChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/CreateChannel
func (c *IVS) CreateChannelRequest(input *CreateChannelInput) (req *request.Request, output *CreateChannelOutput) {
	op := &request.Operation{
		Name:       opCreateChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateChannel",
	}

	if input == nil {
		input = &CreateChannelInput{}
	}

	output = &CreateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChannel API operation for Amazon Interactive Video Service.
//
// Creates a new channel and an associated stream key to start streaming.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation CreateChannel for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - PendingVerification
//
//   - ServiceQuotaExceededException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/CreateChannel
func (c *IVS) CreateChannel(input *CreateChannelInput) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	return out, req.Send()
}

// CreateChannelWithContext is the same as CreateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) CreateChannelWithContext(ctx aws.Context, input *CreateChannelInput, opts ...request.Option) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRecordingConfiguration = "CreateRecordingConfiguration"

// CreateRecordingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateRecordingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRecordingConfiguration for more information on using the CreateRecordingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRecordingConfigurationRequest method.
//	req, resp := client.CreateRecordingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/CreateRecordingConfiguration
func (c *IVS) CreateRecordingConfigurationRequest(input *CreateRecordingConfigurationInput) (req *request.Request, output *CreateRecordingConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateRecordingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateRecordingConfiguration",
	}

	if input == nil {
		input = &CreateRecordingConfigurationInput{}
	}

	output = &CreateRecordingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRecordingConfiguration API operation for Amazon Interactive Video Service.
//
// Creates a new recording configuration, used to enable recording to Amazon
// S3.
//
// Known issue: In the us-east-1 region, if you use the Amazon Web Services
// CLI to create a recording configuration, it returns success even if the S3
// bucket is in a different region. In this case, the state of the recording
// configuration is CREATE_FAILED (instead of ACTIVE). (In other regions, the
// CLI correctly returns failure if the bucket is in a different region.)
//
// Workaround: Ensure that your S3 bucket is in the same region as the recording
// configuration. If you create a recording configuration in a different region
// as your S3 bucket, delete that recording configuration and create a new one
// with an S3 bucket from the correct region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation CreateRecordingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - PendingVerification
//
//   - ConflictException
//
//   - ServiceQuotaExceededException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/CreateRecordingConfiguration
func (c *IVS) CreateRecordingConfiguration(input *CreateRecordingConfigurationInput) (*CreateRecordingConfigurationOutput, error) {
	req, out := c.CreateRecordingConfigurationRequest(input)
	return out, req.Send()
}

// CreateRecordingConfigurationWithContext is the same as CreateRecordingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRecordingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) CreateRecordingConfigurationWithContext(ctx aws.Context, input *CreateRecordingConfigurationInput, opts ...request.Option) (*CreateRecordingConfigurationOutput, error) {
	req, out := c.CreateRecordingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStreamKey = "CreateStreamKey"

// CreateStreamKeyRequest generates a "aws/request.Request" representing the
// client's request for the CreateStreamKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStreamKey for more information on using the CreateStreamKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateStreamKeyRequest method.
//	req, resp := client.CreateStreamKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/CreateStreamKey
func (c *IVS) CreateStreamKeyRequest(input *CreateStreamKeyInput) (req *request.Request, output *CreateStreamKeyOutput) {
	op := &request.Operation{
		Name:       opCreateStreamKey,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateStreamKey",
	}

	if input == nil {
		input = &CreateStreamKeyInput{}
	}

	output = &CreateStreamKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStreamKey API operation for Amazon Interactive Video Service.
//
// Creates a stream key, used to initiate a stream, for the specified channel
// ARN.
//
// Note that CreateChannel creates a stream key. If you subsequently use CreateStreamKey
// on the same channel, it will fail because a stream key already exists and
// there is a limit of 1 stream key per channel. To reset the stream key on
// a channel, use DeleteStreamKey and then CreateStreamKey.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation CreateStreamKey for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - PendingVerification
//
//   - ServiceQuotaExceededException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/CreateStreamKey
func (c *IVS) CreateStreamKey(input *CreateStreamKeyInput) (*CreateStreamKeyOutput, error) {
	req, out := c.CreateStreamKeyRequest(input)
	return out, req.Send()
}

// CreateStreamKeyWithContext is the same as CreateStreamKey with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStreamKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) CreateStreamKeyWithContext(ctx aws.Context, input *CreateStreamKeyInput, opts ...request.Option) (*CreateStreamKeyOutput, error) {
	req, out := c.CreateStreamKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannel = "DeleteChannel"

// DeleteChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannel for more information on using the DeleteChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChannelRequest method.
//	req, resp := client.DeleteChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeleteChannel
func (c *IVS) DeleteChannelRequest(input *DeleteChannelInput) (req *request.Request, output *DeleteChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteChannel",
	}

	if input == nil {
		input = &DeleteChannelInput{}
	}

	output = &DeleteChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannel API operation for Amazon Interactive Video Service.
//
// Deletes the specified channel and its associated stream keys.
//
// If you try to delete a live channel, you will get an error (409 ConflictException).
// To delete a channel that is live, call StopStream, wait for the Amazon EventBridge
// "Stream End" event (to verify that the stream's state is no longer Live),
// then call DeleteChannel. (See Using EventBridge with Amazon IVS (https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html).)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation DeleteChannel for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - PendingVerification
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeleteChannel
func (c *IVS) DeleteChannel(input *DeleteChannelInput) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	return out, req.Send()
}

// DeleteChannelWithContext is the same as DeleteChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) DeleteChannelWithContext(ctx aws.Context, input *DeleteChannelInput, opts ...request.Option) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePlaybackKeyPair = "DeletePlaybackKeyPair"

// DeletePlaybackKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the DeletePlaybackKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePlaybackKeyPair for more information on using the DeletePlaybackKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePlaybackKeyPairRequest method.
//	req, resp := client.DeletePlaybackKeyPairRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeletePlaybackKeyPair
func (c *IVS) DeletePlaybackKeyPairRequest(input *DeletePlaybackKeyPairInput) (req *request.Request, output *DeletePlaybackKeyPairOutput) {
	op := &request.Operation{
		Name:       opDeletePlaybackKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/DeletePlaybackKeyPair",
	}

	if input == nil {
		input = &DeletePlaybackKeyPairInput{}
	}

	output = &DeletePlaybackKeyPairOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePlaybackKeyPair API operation for Amazon Interactive Video Service.
//
// Deletes a specified authorization key pair. This invalidates future viewer
// tokens generated using the key pair’s privateKey. For more information,
// see Setting Up Private Channels (https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html)
// in the Amazon IVS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation DeletePlaybackKeyPair for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeletePlaybackKeyPair
func (c *IVS) DeletePlaybackKeyPair(input *DeletePlaybackKeyPairInput) (*DeletePlaybackKeyPairOutput, error) {
	req, out := c.DeletePlaybackKeyPairRequest(input)
	return out, req.Send()
}

// DeletePlaybackKeyPairWithContext is the same as DeletePlaybackKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePlaybackKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) DeletePlaybackKeyPairWithContext(ctx aws.Context, input *DeletePlaybackKeyPairInput, opts ...request.Option) (*DeletePlaybackKeyPairOutput, error) {
	req, out := c.DeletePlaybackKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRecordingConfiguration = "DeleteRecordingConfiguration"

// DeleteRecordingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRecordingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRecordingConfiguration for more information on using the DeleteRecordingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRecordingConfigurationRequest method.
//	req, resp := client.DeleteRecordingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeleteRecordingConfiguration
func (c *IVS) DeleteRecordingConfigurationRequest(input *DeleteRecordingConfigurationInput) (req *request.Request, output *DeleteRecordingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteRecordingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteRecordingConfiguration",
	}

	if input == nil {
		input = &DeleteRecordingConfigurationInput{}
	}

	output = &DeleteRecordingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRecordingConfiguration API operation for Amazon Interactive Video Service.
//
// Deletes the recording configuration for the specified ARN.
//
// If you try to delete a recording configuration that is associated with a
// channel, you will get an error (409 ConflictException). To avoid this, for
// all channels that reference the recording configuration, first use UpdateChannel
// to set the recordingConfigurationArn field to an empty string, then use DeleteRecordingConfiguration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation DeleteRecordingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - InternalServerException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeleteRecordingConfiguration
func (c *IVS) DeleteRecordingConfiguration(input *DeleteRecordingConfigurationInput) (*DeleteRecordingConfigurationOutput, error) {
	req, out := c.DeleteRecordingConfigurationRequest(input)
	return out, req.Send()
}

// DeleteRecordingConfigurationWithContext is the same as DeleteRecordingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRecordingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) DeleteRecordingConfigurationWithContext(ctx aws.Context, input *DeleteRecordingConfigurationInput, opts ...request.Option) (*DeleteRecordingConfigurationOutput, error) {
	req, out := c.DeleteRecordingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStreamKey = "DeleteStreamKey"

// DeleteStreamKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStreamKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStreamKey for more information on using the DeleteStreamKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteStreamKeyRequest method.
//	req, resp := client.DeleteStreamKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeleteStreamKey
func (c *IVS) DeleteStreamKeyRequest(input *DeleteStreamKeyInput) (req *request.Request, output *DeleteStreamKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteStreamKey,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteStreamKey",
	}

	if input == nil {
		input = &DeleteStreamKeyInput{}
	}

	output = &DeleteStreamKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStreamKey API operation for Amazon Interactive Video Service.
//
// Deletes the stream key for the specified ARN, so it can no longer be used
// to stream.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation DeleteStreamKey for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeleteStreamKey
func (c *IVS) DeleteStreamKey(input *DeleteStreamKeyInput) (*DeleteStreamKeyOutput, error) {
	req, out := c.DeleteStreamKeyRequest(input)
	return out, req.Send()
}

// DeleteStreamKeyWithContext is the same as DeleteStreamKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStreamKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) DeleteStreamKeyWithContext(ctx aws.Context, input *DeleteStreamKeyInput, opts ...request.Option) (*DeleteStreamKeyOutput, error) {
	req, out := c.DeleteStreamKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChannel = "GetChannel"

// GetChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChannel for more information on using the GetChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetChannelRequest method.
//	req, resp := client.GetChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetChannel
func (c *IVS) GetChannelRequest(input *GetChannelInput) (req *request.Request, output *GetChannelOutput) {
	op := &request.Operation{
		Name:       opGetChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/GetChannel",
	}

	if input == nil {
		input = &GetChannelInput{}
	}

	output = &GetChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChannel API operation for Amazon Interactive Video Service.
//
// Gets the channel configuration for the specified channel ARN. See also BatchGetChannel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation GetChannel for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - AccessDeniedException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetChannel
func (c *IVS) GetChannel(input *GetChannelInput) (*GetChannelOutput, error) {
	req, out := c.GetChannelRequest(input)
	return out, req.Send()
}

// GetChannelWithContext is the same as GetChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) GetChannelWithContext(ctx aws.Context, input *GetChannelInput, opts ...request.Option) (*GetChannelOutput, error) {
	req, out := c.GetChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPlaybackKeyPair = "GetPlaybackKeyPair"

// GetPlaybackKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the GetPlaybackKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPlaybackKeyPair for more information on using the GetPlaybackKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPlaybackKeyPairRequest method.
//	req, resp := client.GetPlaybackKeyPairRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetPlaybackKeyPair
func (c *IVS) GetPlaybackKeyPairRequest(input *GetPlaybackKeyPairInput) (req *request.Request, output *GetPlaybackKeyPairOutput) {
	op := &request.Operation{
		Name:       opGetPlaybackKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/GetPlaybackKeyPair",
	}

	if input == nil {
		input = &GetPlaybackKeyPairInput{}
	}

	output = &GetPlaybackKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPlaybackKeyPair API operation for Amazon Interactive Video Service.
//
// Gets a specified playback authorization key pair and returns the arn and
// fingerprint. The privateKey held by the caller can be used to generate viewer
// authorization tokens, to grant viewers access to private channels. For more
// information, see Setting Up Private Channels (https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html)
// in the Amazon IVS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation GetPlaybackKeyPair for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - AccessDeniedException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetPlaybackKeyPair
func (c *IVS) GetPlaybackKeyPair(input *GetPlaybackKeyPairInput) (*GetPlaybackKeyPairOutput, error) {
	req, out := c.GetPlaybackKeyPairRequest(input)
	return out, req.Send()
}

// GetPlaybackKeyPairWithContext is the same as GetPlaybackKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See GetPlaybackKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) GetPlaybackKeyPairWithContext(ctx aws.Context, input *GetPlaybackKeyPairInput, opts ...request.Option) (*GetPlaybackKeyPairOutput, error) {
	req, out := c.GetPlaybackKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRecordingConfiguration = "GetRecordingConfiguration"

// GetRecordingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetRecordingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRecordingConfiguration for more information on using the GetRecordingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRecordingConfigurationRequest method.
//	req, resp := client.GetRecordingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetRecordingConfiguration
func (c *IVS) GetRecordingConfigurationRequest(input *GetRecordingConfigurationInput) (req *request.Request, output *GetRecordingConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetRecordingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/GetRecordingConfiguration",
	}

	if input == nil {
		input = &GetRecordingConfigurationInput{}
	}

	output = &GetRecordingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRecordingConfiguration API operation for Amazon Interactive Video Service.
//
// Gets the recording configuration for the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation GetRecordingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - InternalServerException
//
//   - AccessDeniedException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetRecordingConfiguration
func (c *IVS) GetRecordingConfiguration(input *GetRecordingConfigurationInput) (*GetRecordingConfigurationOutput, error) {
	req, out := c.GetRecordingConfigurationRequest(input)
	return out, req.Send()
}

// GetRecordingConfigurationWithContext is the same as GetRecordingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetRecordingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) GetRecordingConfigurationWithContext(ctx aws.Context, input *GetRecordingConfigurationInput, opts ...request.Option) (*GetRecordingConfigurationOutput, error) {
	req, out := c.GetRecordingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStream = "GetStream"

// GetStreamRequest generates a "aws/request.Request" representing the
// client's request for the GetStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStream for more information on using the GetStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStreamRequest method.
//	req, resp := client.GetStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetStream
func (c *IVS) GetStreamRequest(input *GetStreamInput) (req *request.Request, output *GetStreamOutput) {
	op := &request.Operation{
		Name:       opGetStream,
		HTTPMethod: "POST",
		HTTPPath:   "/GetStream",
	}

	if input == nil {
		input = &GetStreamInput{}
	}

	output = &GetStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStream API operation for Amazon Interactive Video Service.
//
// Gets information about the active (live) stream on a specified channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation GetStream for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - ChannelNotBroadcasting
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetStream
func (c *IVS) GetStream(input *GetStreamInput) (*GetStreamOutput, error) {
	req, out := c.GetStreamRequest(input)
	return out, req.Send()
}

// GetStreamWithContext is the same as GetStream with the addition of
// the ability to pass a context and additional request options.
//
// See GetStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) GetStreamWithContext(ctx aws.Context, input *GetStreamInput, opts ...request.Option) (*GetStreamOutput, error) {
	req, out := c.GetStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStreamKey = "GetStreamKey"

// GetStreamKeyRequest generates a "aws/request.Request" representing the
// client's request for the GetStreamKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStreamKey for more information on using the GetStreamKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStreamKeyRequest method.
//	req, resp := client.GetStreamKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetStreamKey
func (c *IVS) GetStreamKeyRequest(input *GetStreamKeyInput) (req *request.Request, output *GetStreamKeyOutput) {
	op := &request.Operation{
		Name:       opGetStreamKey,
		HTTPMethod: "POST",
		HTTPPath:   "/GetStreamKey",
	}

	if input == nil {
		input = &GetStreamKeyInput{}
	}

	output = &GetStreamKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStreamKey API operation for Amazon Interactive Video Service.
//
// Gets stream-key information for a specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation GetStreamKey for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - AccessDeniedException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetStreamKey
func (c *IVS) GetStreamKey(input *GetStreamKeyInput) (*GetStreamKeyOutput, error) {
	req, out := c.GetStreamKeyRequest(input)
	return out, req.Send()
}

// GetStreamKeyWithContext is the same as GetStreamKey with the addition of
// the ability to pass a context and additional request options.
//
// See GetStreamKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) GetStreamKeyWithContext(ctx aws.Context, input *GetStreamKeyInput, opts ...request.Option) (*GetStreamKeyOutput, error) {
	req, out := c.GetStreamKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStreamSession = "GetStreamSession"

// GetStreamSessionRequest generates a "aws/request.Request" representing the
// client's request for the GetStreamSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStreamSession for more information on using the GetStreamSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStreamSessionRequest method.
//	req, resp := client.GetStreamSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetStreamSession
func (c *IVS) GetStreamSessionRequest(input *GetStreamSessionInput) (req *request.Request, output *GetStreamSessionOutput) {
	op := &request.Operation{
		Name:       opGetStreamSession,
		HTTPMethod: "POST",
		HTTPPath:   "/GetStreamSession",
	}

	if input == nil {
		input = &GetStreamSessionInput{}
	}

	output = &GetStreamSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStreamSession API operation for Amazon Interactive Video Service.
//
// Gets metadata on a specified stream.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation GetStreamSession for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - AccessDeniedException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetStreamSession
func (c *IVS) GetStreamSession(input *GetStreamSessionInput) (*GetStreamSessionOutput, error) {
	req, out := c.GetStreamSessionRequest(input)
	return out, req.Send()
}

// GetStreamSessionWithContext is the same as GetStreamSession with the addition of
// the ability to pass a context and additional request options.
//
// See GetStreamSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) GetStreamSessionWithContext(ctx aws.Context, input *GetStreamSessionInput, opts ...request.Option) (*GetStreamSessionOutput, error) {
	req, out := c.GetStreamSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportPlaybackKeyPair = "ImportPlaybackKeyPair"

// ImportPlaybackKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the ImportPlaybackKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportPlaybackKeyPair for more information on using the ImportPlaybackKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportPlaybackKeyPairRequest method.
//	req, resp := client.ImportPlaybackKeyPairRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ImportPlaybackKeyPair
func (c *IVS) ImportPlaybackKeyPairRequest(input *ImportPlaybackKeyPairInput) (req *request.Request, output *ImportPlaybackKeyPairOutput) {
	op := &request.Operation{
		Name:       opImportPlaybackKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/ImportPlaybackKeyPair",
	}

	if input == nil {
		input = &ImportPlaybackKeyPairInput{}
	}

	output = &ImportPlaybackKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportPlaybackKeyPair API operation for Amazon Interactive Video Service.
//
// Imports the public portion of a new key pair and returns its arn and fingerprint.
// The privateKey can then be used to generate viewer authorization tokens,
// to grant viewers access to private channels. For more information, see Setting
// Up Private Channels (https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html)
// in the Amazon IVS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation ImportPlaybackKeyPair for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - PendingVerification
//
//   - ConflictException
//
//   - ServiceQuotaExceededException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ImportPlaybackKeyPair
func (c *IVS) ImportPlaybackKeyPair(input *ImportPlaybackKeyPairInput) (*ImportPlaybackKeyPairOutput, error) {
	req, out := c.ImportPlaybackKeyPairRequest(input)
	return out, req.Send()
}

// ImportPlaybackKeyPairWithContext is the same as ImportPlaybackKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See ImportPlaybackKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ImportPlaybackKeyPairWithContext(ctx aws.Context, input *ImportPlaybackKeyPairInput, opts ...request.Option) (*ImportPlaybackKeyPairOutput, error) {
	req, out := c.ImportPlaybackKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListChannels = "ListChannels"

// ListChannelsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannels for more information on using the ListChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelsRequest method.
//	req, resp := client.ListChannelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListChannels
func (c *IVS) ListChannelsRequest(input *ListChannelsInput) (req *request.Request, output *ListChannelsOutput) {
	op := &request.Operation{
		Name:       opListChannels,
		HTTPMethod: "POST",
		HTTPPath:   "/ListChannels",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelsInput{}
	}

	output = &ListChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannels API operation for Amazon Interactive Video Service.
//
// Gets summary information about all channels in your account, in the Amazon
// Web Services region where the API request is processed. This list can be
// filtered to match a specified name or recording-configuration ARN. Filters
// are mutually exclusive and cannot be used together. If you try to use both
// filters, you will get an error (409 ConflictException).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation ListChannels for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListChannels
func (c *IVS) ListChannels(input *ListChannelsInput) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	return out, req.Send()
}

// ListChannelsWithContext is the same as ListChannels with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListChannelsWithContext(ctx aws.Context, input *ListChannelsInput, opts ...request.Option) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelsPages iterates over the pages of a ListChannels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannels operation.
//	pageNum := 0
//	err := client.ListChannelsPages(params,
//	    func(page *ivs.ListChannelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IVS) ListChannelsPages(input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool) error {
	return c.ListChannelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelsPagesWithContext same as ListChannelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListChannelsPagesWithContext(ctx aws.Context, input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPlaybackKeyPairs = "ListPlaybackKeyPairs"

// ListPlaybackKeyPairsRequest generates a "aws/request.Request" representing the
// client's request for the ListPlaybackKeyPairs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPlaybackKeyPairs for more information on using the ListPlaybackKeyPairs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPlaybackKeyPairsRequest method.
//	req, resp := client.ListPlaybackKeyPairsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListPlaybackKeyPairs
func (c *IVS) ListPlaybackKeyPairsRequest(input *ListPlaybackKeyPairsInput) (req *request.Request, output *ListPlaybackKeyPairsOutput) {
	op := &request.Operation{
		Name:       opListPlaybackKeyPairs,
		HTTPMethod: "POST",
		HTTPPath:   "/ListPlaybackKeyPairs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPlaybackKeyPairsInput{}
	}

	output = &ListPlaybackKeyPairsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPlaybackKeyPairs API operation for Amazon Interactive Video Service.
//
// Gets summary information about playback key pairs. For more information,
// see Setting Up Private Channels (https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html)
// in the Amazon IVS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation ListPlaybackKeyPairs for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListPlaybackKeyPairs
func (c *IVS) ListPlaybackKeyPairs(input *ListPlaybackKeyPairsInput) (*ListPlaybackKeyPairsOutput, error) {
	req, out := c.ListPlaybackKeyPairsRequest(input)
	return out, req.Send()
}

// ListPlaybackKeyPairsWithContext is the same as ListPlaybackKeyPairs with the addition of
// the ability to pass a context and additional request options.
//
// See ListPlaybackKeyPairs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListPlaybackKeyPairsWithContext(ctx aws.Context, input *ListPlaybackKeyPairsInput, opts ...request.Option) (*ListPlaybackKeyPairsOutput, error) {
	req, out := c.ListPlaybackKeyPairsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPlaybackKeyPairsPages iterates over the pages of a ListPlaybackKeyPairs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPlaybackKeyPairs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPlaybackKeyPairs operation.
//	pageNum := 0
//	err := client.ListPlaybackKeyPairsPages(params,
//	    func(page *ivs.ListPlaybackKeyPairsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IVS) ListPlaybackKeyPairsPages(input *ListPlaybackKeyPairsInput, fn func(*ListPlaybackKeyPairsOutput, bool) bool) error {
	return c.ListPlaybackKeyPairsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPlaybackKeyPairsPagesWithContext same as ListPlaybackKeyPairsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListPlaybackKeyPairsPagesWithContext(ctx aws.Context, input *ListPlaybackKeyPairsInput, fn func(*ListPlaybackKeyPairsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPlaybackKeyPairsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPlaybackKeyPairsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPlaybackKeyPairsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecordingConfigurations = "ListRecordingConfigurations"

// ListRecordingConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListRecordingConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecordingConfigurations for more information on using the ListRecordingConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRecordingConfigurationsRequest method.
//	req, resp := client.ListRecordingConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListRecordingConfigurations
func (c *IVS) ListRecordingConfigurationsRequest(input *ListRecordingConfigurationsInput) (req *request.Request, output *ListRecordingConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListRecordingConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/ListRecordingConfigurations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecordingConfigurationsInput{}
	}

	output = &ListRecordingConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecordingConfigurations API operation for Amazon Interactive Video Service.
//
// Gets summary information about all recording configurations in your account,
// in the Amazon Web Services region where the API request is processed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation ListRecordingConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//
//   - AccessDeniedException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListRecordingConfigurations
func (c *IVS) ListRecordingConfigurations(input *ListRecordingConfigurationsInput) (*ListRecordingConfigurationsOutput, error) {
	req, out := c.ListRecordingConfigurationsRequest(input)
	return out, req.Send()
}

// ListRecordingConfigurationsWithContext is the same as ListRecordingConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecordingConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListRecordingConfigurationsWithContext(ctx aws.Context, input *ListRecordingConfigurationsInput, opts ...request.Option) (*ListRecordingConfigurationsOutput, error) {
	req, out := c.ListRecordingConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecordingConfigurationsPages iterates over the pages of a ListRecordingConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecordingConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRecordingConfigurations operation.
//	pageNum := 0
//	err := client.ListRecordingConfigurationsPages(params,
//	    func(page *ivs.ListRecordingConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IVS) ListRecordingConfigurationsPages(input *ListRecordingConfigurationsInput, fn func(*ListRecordingConfigurationsOutput, bool) bool) error {
	return c.ListRecordingConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecordingConfigurationsPagesWithContext same as ListRecordingConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListRecordingConfigurationsPagesWithContext(ctx aws.Context, input *ListRecordingConfigurationsInput, fn func(*ListRecordingConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecordingConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecordingConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecordingConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStreamKeys = "ListStreamKeys"

// ListStreamKeysRequest generates a "aws/request.Request" representing the
// client's request for the ListStreamKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStreamKeys for more information on using the ListStreamKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStreamKeysRequest method.
//	req, resp := client.ListStreamKeysRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreamKeys
func (c *IVS) ListStreamKeysRequest(input *ListStreamKeysInput) (req *request.Request, output *ListStreamKeysOutput) {
	op := &request.Operation{
		Name:       opListStreamKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/ListStreamKeys",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStreamKeysInput{}
	}

	output = &ListStreamKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStreamKeys API operation for Amazon Interactive Video Service.
//
// Gets summary information about stream keys for the specified channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation ListStreamKeys for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - AccessDeniedException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreamKeys
func (c *IVS) ListStreamKeys(input *ListStreamKeysInput) (*ListStreamKeysOutput, error) {
	req, out := c.ListStreamKeysRequest(input)
	return out, req.Send()
}

// ListStreamKeysWithContext is the same as ListStreamKeys with the addition of
// the ability to pass a context and additional request options.
//
// See ListStreamKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListStreamKeysWithContext(ctx aws.Context, input *ListStreamKeysInput, opts ...request.Option) (*ListStreamKeysOutput, error) {
	req, out := c.ListStreamKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStreamKeysPages iterates over the pages of a ListStreamKeys operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStreamKeys method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStreamKeys operation.
//	pageNum := 0
//	err := client.ListStreamKeysPages(params,
//	    func(page *ivs.ListStreamKeysOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IVS) ListStreamKeysPages(input *ListStreamKeysInput, fn func(*ListStreamKeysOutput, bool) bool) error {
	return c.ListStreamKeysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStreamKeysPagesWithContext same as ListStreamKeysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListStreamKeysPagesWithContext(ctx aws.Context, input *ListStreamKeysInput, fn func(*ListStreamKeysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStreamKeysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStreamKeysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStreamKeysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStreamSessions = "ListStreamSessions"

// ListStreamSessionsRequest generates a "aws/request.Request" representing the
// client's request for the ListStreamSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStreamSessions for more information on using the ListStreamSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStreamSessionsRequest method.
//	req, resp := client.ListStreamSessionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreamSessions
func (c *IVS) ListStreamSessionsRequest(input *ListStreamSessionsInput) (req *request.Request, output *ListStreamSessionsOutput) {
	op := &request.Operation{
		Name:       opListStreamSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/ListStreamSessions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStreamSessionsInput{}
	}

	output = &ListStreamSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStreamSessions API operation for Amazon Interactive Video Service.
//
// Gets a summary of current and previous streams for a specified channel in
// your account, in the AWS region where the API request is processed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation ListStreamSessions for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - AccessDeniedException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreamSessions
func (c *IVS) ListStreamSessions(input *ListStreamSessionsInput) (*ListStreamSessionsOutput, error) {
	req, out := c.ListStreamSessionsRequest(input)
	return out, req.Send()
}

// ListStreamSessionsWithContext is the same as ListStreamSessions with the addition of
// the ability to pass a context and additional request options.
//
// See ListStreamSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListStreamSessionsWithContext(ctx aws.Context, input *ListStreamSessionsInput, opts ...request.Option) (*ListStreamSessionsOutput, error) {
	req, out := c.ListStreamSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStreamSessionsPages iterates over the pages of a ListStreamSessions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStreamSessions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStreamSessions operation.
//	pageNum := 0
//	err := client.ListStreamSessionsPages(params,
//	    func(page *ivs.ListStreamSessionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IVS) ListStreamSessionsPages(input *ListStreamSessionsInput, fn func(*ListStreamSessionsOutput, bool) bool) error {
	return c.ListStreamSessionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStreamSessionsPagesWithContext same as ListStreamSessionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListStreamSessionsPagesWithContext(ctx aws.Context, input *ListStreamSessionsInput, fn func(*ListStreamSessionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStreamSessionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStreamSessionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStreamSessionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStreams = "ListStreams"

// ListStreamsRequest generates a "aws/request.Request" representing the
// client's request for the ListStreams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStreams for more information on using the ListStreams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStreamsRequest method.
//	req, resp := client.ListStreamsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreams
func (c *IVS) ListStreamsRequest(input *ListStreamsInput) (req *request.Request, output *ListStreamsOutput) {
	op := &request.Operation{
		Name:       opListStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/ListStreams",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStreamsInput{}
	}

	output = &ListStreamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStreams API operation for Amazon Interactive Video Service.
//
// Gets summary information about live streams in your account, in the Amazon
// Web Services region where the API request is processed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation ListStreams for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreams
func (c *IVS) ListStreams(input *ListStreamsInput) (*ListStreamsOutput, error) {
	req, out := c.ListStreamsRequest(input)
	return out, req.Send()
}

// ListStreamsWithContext is the same as ListStreams with the addition of
// the ability to pass a context and additional request options.
//
// See ListStreams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListStreamsWithContext(ctx aws.Context, input *ListStreamsInput, opts ...request.Option) (*ListStreamsOutput, error) {
	req, out := c.ListStreamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStreamsPages iterates over the pages of a ListStreams operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStreams method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStreams operation.
//	pageNum := 0
//	err := client.ListStreamsPages(params,
//	    func(page *ivs.ListStreamsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IVS) ListStreamsPages(input *ListStreamsInput, fn func(*ListStreamsOutput, bool) bool) error {
	return c.ListStreamsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStreamsPagesWithContext same as ListStreamsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListStreamsPagesWithContext(ctx aws.Context, input *ListStreamsInput, fn func(*ListStreamsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStreamsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStreamsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStreamsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListTagsForResource
func (c *IVS) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Interactive Video Service.
//
// Gets information about Amazon Web Services tags for the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - InternalServerException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListTagsForResource
func (c *IVS) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutMetadata = "PutMetadata"

// PutMetadataRequest generates a "aws/request.Request" representing the
// client's request for the PutMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutMetadata for more information on using the PutMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutMetadataRequest method.
//	req, resp := client.PutMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/PutMetadata
func (c *IVS) PutMetadataRequest(input *PutMetadataInput) (req *request.Request, output *PutMetadataOutput) {
	op := &request.Operation{
		Name:       opPutMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/PutMetadata",
	}

	if input == nil {
		input = &PutMetadataInput{}
	}

	output = &PutMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutMetadata API operation for Amazon Interactive Video Service.
//
// Inserts metadata into the active stream of the specified channel. At most
// 5 requests per second per channel are allowed, each with a maximum 1 KB payload.
// (If 5 TPS is not sufficient for your needs, we recommend batching your data
// into a single PutMetadata call.) At most 155 requests per second per account
// are allowed. Also see Embedding Metadata within a Video Stream (https://docs.aws.amazon.com/ivs/latest/userguide/metadata.html)
// in the Amazon IVS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation PutMetadata for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - ChannelNotBroadcasting
//
//   - ThrottlingException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/PutMetadata
func (c *IVS) PutMetadata(input *PutMetadataInput) (*PutMetadataOutput, error) {
	req, out := c.PutMetadataRequest(input)
	return out, req.Send()
}

// PutMetadataWithContext is the same as PutMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See PutMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) PutMetadataWithContext(ctx aws.Context, input *PutMetadataInput, opts ...request.Option) (*PutMetadataOutput, error) {
	req, out := c.PutMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartViewerSessionRevocation = "StartViewerSessionRevocation"

// StartViewerSessionRevocationRequest generates a "aws/request.Request" representing the
// client's request for the StartViewerSessionRevocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartViewerSessionRevocation for more information on using the StartViewerSessionRevocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartViewerSessionRevocationRequest method.
//	req, resp := client.StartViewerSessionRevocationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/StartViewerSessionRevocation
func (c *IVS) StartViewerSessionRevocationRequest(input *StartViewerSessionRevocationInput) (req *request.Request, output *StartViewerSessionRevocationOutput) {
	op := &request.Operation{
		Name:       opStartViewerSessionRevocation,
		HTTPMethod: "POST",
		HTTPPath:   "/StartViewerSessionRevocation",
	}

	if input == nil {
		input = &StartViewerSessionRevocationInput{}
	}

	output = &StartViewerSessionRevocationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartViewerSessionRevocation API operation for Amazon Interactive Video Service.
//
// Starts the process of revoking the viewer session associated with a specified
// channel ARN and viewer ID. Optionally, you can provide a version to revoke
// viewer sessions less than and including that version. For instructions on
// associating a viewer ID with a viewer session, see Setting Up Private Channels
// (https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation StartViewerSessionRevocation for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - InternalServerException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - PendingVerification
//
//   - ThrottlingException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/StartViewerSessionRevocation
func (c *IVS) StartViewerSessionRevocation(input *StartViewerSessionRevocationInput) (*StartViewerSessionRevocationOutput, error) {
	req, out := c.StartViewerSessionRevocationRequest(input)
	return out, req.Send()
}

// StartViewerSessionRevocationWithContext is the same as StartViewerSessionRevocation with the addition of
// the ability to pass a context and additional request options.
//
// See StartViewerSessionRevocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) StartViewerSessionRevocationWithContext(ctx aws.Context, input *StartViewerSessionRevocationInput, opts ...request.Option) (*StartViewerSessionRevocationOutput, error) {
	req, out := c.StartViewerSessionRevocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopStream = "StopStream"

// StopStreamRequest generates a "aws/request.Request" representing the
// client's request for the StopStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopStream for more information on using the StopStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopStreamRequest method.
//	req, resp := client.StopStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/StopStream
func (c *IVS) StopStreamRequest(input *StopStreamInput) (req *request.Request, output *StopStreamOutput) {
	op := &request.Operation{
		Name:       opStopStream,
		HTTPMethod: "POST",
		HTTPPath:   "/StopStream",
	}

	if input == nil {
		input = &StopStreamInput{}
	}

	output = &StopStreamOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopStream API operation for Amazon Interactive Video Service.
//
// Disconnects the incoming RTMPS stream for the specified channel. Can be used
// in conjunction with DeleteStreamKey to prevent further streaming to a channel.
//
// Many streaming client-software libraries automatically reconnect a dropped
// RTMPS session, so to stop the stream permanently, you may want to first revoke
// the streamKey attached to the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation StopStream for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - ChannelNotBroadcasting
//
//   - StreamUnavailable
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/StopStream
func (c *IVS) StopStream(input *StopStreamInput) (*StopStreamOutput, error) {
	req, out := c.StopStreamRequest(input)
	return out, req.Send()
}

// StopStreamWithContext is the same as StopStream with the addition of
// the ability to pass a context and additional request options.
//
// See StopStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) StopStreamWithContext(ctx aws.Context, input *StopStreamInput, opts ...request.Option) (*StopStreamOutput, error) {
	req, out := c.StopStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/TagResource
func (c *IVS) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Interactive Video Service.
//
// Adds or updates tags for the Amazon Web Services resource with the specified
// ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - InternalServerException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/TagResource
func (c *IVS) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/UntagResource
func (c *IVS) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Interactive Video Service.
//
// Removes tags from the resource with the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - InternalServerException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/UntagResource
func (c *IVS) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannel = "UpdateChannel"

// UpdateChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannel for more information on using the UpdateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateChannelRequest method.
//	req, resp := client.UpdateChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/UpdateChannel
func (c *IVS) UpdateChannelRequest(input *UpdateChannelInput) (req *request.Request, output *UpdateChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateChannel",
	}

	if input == nil {
		input = &UpdateChannelInput{}
	}

	output = &UpdateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChannel API operation for Amazon Interactive Video Service.
//
// Updates a channel's configuration. Live channels cannot be updated. You must
// stop the ongoing stream, update the channel, and restart the stream for the
// changes to take effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation UpdateChannel for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - PendingVerification
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/UpdateChannel
func (c *IVS) UpdateChannel(input *UpdateChannelInput) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	return out, req.Send()
}

// UpdateChannelWithContext is the same as UpdateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) UpdateChannelWithContext(ctx aws.Context, input *UpdateChannelInput, opts ...request.Option) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// User does not have sufficient access to perform this action.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Object specifying a stream’s audio configuration, as set up by the broadcaster
// (usually in an encoder). This is part of the IngestConfiguration object and
// used for monitoring stream health.
type AudioConfiguration struct {
	_ struct{} `type:"structure"`

	// Number of audio channels.
	Channels *int64 `locationName:"channels" type:"long"`

	// Codec used for the audio encoding.
	Codec *string `locationName:"codec" type:"string"`

	// Number of audio samples recorded per second.
	SampleRate *int64 `locationName:"sampleRate" type:"long"`

	// The expected ingest bitrate (bits per second). This is configured in the
	// encoder.
	TargetBitrate *int64 `locationName:"targetBitrate" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioConfiguration) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *AudioConfiguration) SetChannels(v int64) *AudioConfiguration {
	s.Channels = &v
	return s
}

// SetCodec sets the Codec field's value.
func (s *AudioConfiguration) SetCodec(v string) *AudioConfiguration {
	s.Codec = &v
	return s
}

// SetSampleRate sets the SampleRate field's value.
func (s *AudioConfiguration) SetSampleRate(v int64) *AudioConfiguration {
	s.SampleRate = &v
	return s
}

// SetTargetBitrate sets the TargetBitrate field's value.
func (s *AudioConfiguration) SetTargetBitrate(v int64) *AudioConfiguration {
	s.TargetBitrate = &v
	return s
}

// Error related to a specific channel, specified by its ARN.
type BatchError struct {
	_ struct{} `type:"structure"`

	// Channel ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Error code.
	Code *string `locationName:"code" type:"string"`

	// Error message, determined by the application.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchError) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *BatchError) SetArn(v string) *BatchError {
	s.Arn = &v
	return s
}

// SetCode sets the Code field's value.
func (s *BatchError) SetCode(v string) *BatchError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchError) SetMessage(v string) *BatchError {
	s.Message = &v
	return s
}

type BatchGetChannelInput struct {
	_ struct{} `type:"structure"`

	// Array of ARNs, one per channel.
	//
	// Arns is a required field
	Arns []*string `locationName:"arns" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetChannelInput"}
	if s.Arns == nil {
		invalidParams.Add(request.NewErrParamRequired("Arns"))
	}
	if s.Arns != nil && len(s.Arns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArns sets the Arns field's value.
func (s *BatchGetChannelInput) SetArns(v []*string) *BatchGetChannelInput {
	s.Arns = v
	return s
}

type BatchGetChannelOutput struct {
	_ struct{} `type:"structure"`

	Channels []*Channel `locationName:"channels" type:"list"`

	// Each error object is related to a specific ARN in the request.
	Errors []*BatchError `locationName:"errors" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetChannelOutput) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *BatchGetChannelOutput) SetChannels(v []*Channel) *BatchGetChannelOutput {
	s.Channels = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchGetChannelOutput) SetErrors(v []*BatchError) *BatchGetChannelOutput {
	s.Errors = v
	return s
}

type BatchGetStreamKeyInput struct {
	_ struct{} `type:"structure"`

	// Array of ARNs, one per stream key.
	//
	// Arns is a required field
	Arns []*string `locationName:"arns" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetStreamKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetStreamKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetStreamKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetStreamKeyInput"}
	if s.Arns == nil {
		invalidParams.Add(request.NewErrParamRequired("Arns"))
	}
	if s.Arns != nil && len(s.Arns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArns sets the Arns field's value.
func (s *BatchGetStreamKeyInput) SetArns(v []*string) *BatchGetStreamKeyInput {
	s.Arns = v
	return s
}

type BatchGetStreamKeyOutput struct {
	_ struct{} `type:"structure"`

	Errors []*BatchError `locationName:"errors" type:"list"`

	StreamKeys []*StreamKey `locationName:"streamKeys" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetStreamKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetStreamKeyOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchGetStreamKeyOutput) SetErrors(v []*BatchError) *BatchGetStreamKeyOutput {
	s.Errors = v
	return s
}

// SetStreamKeys sets the StreamKeys field's value.
func (s *BatchGetStreamKeyOutput) SetStreamKeys(v []*StreamKey) *BatchGetStreamKeyOutput {
	s.StreamKeys = v
	return s
}

// Error for a request in the batch for BatchStartViewerSessionRevocation. Each
// error is related to a specific channel-ARN and viewer-ID pair.
type BatchStartViewerSessionRevocationError struct {
	_ struct{} `type:"structure"`

	// Channel ARN.
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`

	// Error code.
	Code *string `locationName:"code" type:"string"`

	// Error message, determined by the application.
	Message *string `locationName:"message" type:"string"`

	// The ID of the viewer session to revoke.
	//
	// ViewerId is a required field
	ViewerId *string `locationName:"viewerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStartViewerSessionRevocationError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStartViewerSessionRevocationError) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *BatchStartViewerSessionRevocationError) SetChannelArn(v string) *BatchStartViewerSessionRevocationError {
	s.ChannelArn = &v
	return s
}

// SetCode sets the Code field's value.
func (s *BatchStartViewerSessionRevocationError) SetCode(v string) *BatchStartViewerSessionRevocationError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchStartViewerSessionRevocationError) SetMessage(v string) *BatchStartViewerSessionRevocationError {
	s.Message = &v
	return s
}

// SetViewerId sets the ViewerId field's value.
func (s *BatchStartViewerSessionRevocationError) SetViewerId(v string) *BatchStartViewerSessionRevocationError {
	s.ViewerId = &v
	return s
}

type BatchStartViewerSessionRevocationInput struct {
	_ struct{} `type:"structure"`

	// Array of viewer sessions, one per channel-ARN and viewer-ID pair.
	//
	// ViewerSessions is a required field
	ViewerSessions []*BatchStartViewerSessionRevocationViewerSession `locationName:"viewerSessions" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStartViewerSessionRevocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStartViewerSessionRevocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchStartViewerSessionRevocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchStartViewerSessionRevocationInput"}
	if s.ViewerSessions == nil {
		invalidParams.Add(request.NewErrParamRequired("ViewerSessions"))
	}
	if s.ViewerSessions != nil && len(s.ViewerSessions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ViewerSessions", 1))
	}
	if s.ViewerSessions != nil {
		for i, v := range s.ViewerSessions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ViewerSessions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetViewerSessions sets the ViewerSessions field's value.
func (s *BatchStartViewerSessionRevocationInput) SetViewerSessions(v []*BatchStartViewerSessionRevocationViewerSession) *BatchStartViewerSessionRevocationInput {
	s.ViewerSessions = v
	return s
}

type BatchStartViewerSessionRevocationOutput struct {
	_ struct{} `type:"structure"`

	// Each error object is related to a specific channelArn and viewerId pair in
	// the request.
	Errors []*BatchStartViewerSessionRevocationError `locationName:"errors" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStartViewerSessionRevocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStartViewerSessionRevocationOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchStartViewerSessionRevocationOutput) SetErrors(v []*BatchStartViewerSessionRevocationError) *BatchStartViewerSessionRevocationOutput {
	s.Errors = v
	return s
}

// A viewer session to revoke in the call to BatchStartViewerSessionRevocation.
type BatchStartViewerSessionRevocationViewerSession struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel associated with the viewer session to revoke.
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`

	// The ID of the viewer associated with the viewer session to revoke. Do not
	// use this field for personally identifying, confidential, or sensitive information.
	//
	// ViewerId is a required field
	ViewerId *string `locationName:"viewerId" min:"1" type:"string" required:"true"`

	// An optional filter on which versions of the viewer session to revoke. All
	// versions less than or equal to the specified version will be revoked. Default:
	// 0.
	ViewerSessionVersionsLessThanOrEqualTo *int64 `locationName:"viewerSessionVersionsLessThanOrEqualTo" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStartViewerSessionRevocationViewerSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStartViewerSessionRevocationViewerSession) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchStartViewerSessionRevocationViewerSession) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchStartViewerSessionRevocationViewerSession"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 1))
	}
	if s.ViewerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ViewerId"))
	}
	if s.ViewerId != nil && len(*s.ViewerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ViewerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *BatchStartViewerSessionRevocationViewerSession) SetChannelArn(v string) *BatchStartViewerSessionRevocationViewerSession {
	s.ChannelArn = &v
	return s
}

// SetViewerId sets the ViewerId field's value.
func (s *BatchStartViewerSessionRevocationViewerSession) SetViewerId(v string) *BatchStartViewerSessionRevocationViewerSession {
	s.ViewerId = &v
	return s
}

// SetViewerSessionVersionsLessThanOrEqualTo sets the ViewerSessionVersionsLessThanOrEqualTo field's value.
func (s *BatchStartViewerSessionRevocationViewerSession) SetViewerSessionVersionsLessThanOrEqualTo(v int64) *BatchStartViewerSessionRevocationViewerSession {
	s.ViewerSessionVersionsLessThanOrEqualTo = &v
	return s
}

// Object specifying a channel.
type Channel struct {
	_ struct{} `type:"structure"`

	// Channel ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Whether the channel is private (enabled for playback authorization). Default:
	// false.
	Authorized *bool `locationName:"authorized" type:"boolean"`

	// Channel ingest endpoint, part of the definition of an ingest server, used
	// when you set up streaming software.
	IngestEndpoint *string `locationName:"ingestEndpoint" type:"string"`

	// Whether the channel allows insecure RTMP ingest. Default: false.
	InsecureIngest *bool `locationName:"insecureIngest" type:"boolean"`

	// Channel latency mode. Use NORMAL to broadcast and deliver live video up to
	// Full HD. Use LOW for near-real-time interaction with viewers. Default: LOW.
	// (Note: In the Amazon IVS console, LOW and NORMAL correspond to Ultra-low
	// and Standard, respectively.)
	LatencyMode *string `locationName:"latencyMode" type:"string" enum:"ChannelLatencyMode"`

	// Channel name.
	Name *string `locationName:"name" type:"string"`

	// Channel playback URL.
	PlaybackUrl *string `locationName:"playbackUrl" type:"string"`

	// Optional transcode preset for the channel. This is selectable only for ADVANCED_HD
	// and ADVANCED_SD channel types. For those channel types, the default preset
	// is HIGHER_BANDWIDTH_DELIVERY. For other channel types (BASIC and STANDARD),
	// preset is the empty string ("").
	Preset *string `locationName:"preset" type:"string" enum:"TranscodePreset"`

	// Recording-configuration ARN. A value other than an empty string indicates
	// that recording is enabled. Default: "" (empty string, recording is disabled).
	RecordingConfigurationArn *string `locationName:"recordingConfigurationArn" type:"string"`

	// Tags attached to the resource. Array of 1-50 maps, each of the form string:string
	// (key:value). See Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for more information, including restrictions that apply to tags and "Tag
	// naming limits and requirements"; Amazon IVS has no service-specific constraints
	// beyond what is documented there.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Channel type, which determines the allowable resolution and bitrate. If you
	// exceed the allowable input resolution or bitrate, the stream probably will
	// disconnect immediately. Some types generate multiple qualities (renditions)
	// from the original input; this automatically gives viewers the best experience
	// for their devices and network conditions. Some types provide transcoded video;
	// transcoding allows higher playback quality across a range of download speeds.
	// Default: STANDARD. Valid values:
	//
	//    * BASIC: Video is transmuxed: Amazon IVS delivers the original input quality
	//    to viewers. The viewer’s video-quality choice is limited to the original
	//    input. Input resolution can be up to 1080p and bitrate can be up to 1.5
	//    Mbps for 480p and up to 3.5 Mbps for resolutions between 480p and 1080p.
	//    Original audio is passed through.
	//
	//    * STANDARD: Video is transcoded: multiple qualities are generated from
	//    the original input, to automatically give viewers the best experience
	//    for their devices and network conditions. Transcoding allows higher playback
	//    quality across a range of download speeds. Resolution can be up to 1080p
	//    and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions
	//    360p and below; above that, audio is passed through. This is the default
	//    when you create a channel.
	//
	//    * ADVANCED_SD: Video is transcoded; multiple qualities are generated from
	//    the original input, to automatically give viewers the best experience
	//    for their devices and network conditions. Input resolution can be up to
	//    1080p and bitrate can be up to 8.5 Mbps; output is capped at SD quality
	//    (480p). You can select an optional transcode preset (see below). Audio
	//    for all renditions is transcoded, and an audio-only rendition is available.
	//
	//    * ADVANCED_HD: Video is transcoded; multiple qualities are generated from
	//    the original input, to automatically give viewers the best experience
	//    for their devices and network conditions. Input resolution can be up to
	//    1080p and bitrate can be up to 8.5 Mbps; output is capped at HD quality
	//    (720p). You can select an optional transcode preset (see below). Audio
	//    for all renditions is transcoded, and an audio-only rendition is available.
	//
	// Optional transcode presets (available for the ADVANCED types) allow you to
	// trade off available download bandwidth and video quality, to optimize the
	// viewing experience. There are two presets:
	//
	//    * Constrained bandwidth delivery uses a lower bitrate for each quality
	//    level. Use it if you have low download bandwidth and/or simple video content
	//    (e.g., talking heads)
	//
	//    * Higher bandwidth delivery uses a higher bitrate for each quality level.
	//    Use it if you have high download bandwidth and/or complex video content
	//    (e.g., flashes and quick scene changes).
	Type *string `locationName:"type" type:"string" enum:"ChannelType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Channel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Channel) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Channel) SetArn(v string) *Channel {
	s.Arn = &v
	return s
}

// SetAuthorized sets the Authorized field's value.
func (s *Channel) SetAuthorized(v bool) *Channel {
	s.Authorized = &v
	return s
}

// SetIngestEndpoint sets the IngestEndpoint field's value.
func (s *Channel) SetIngestEndpoint(v string) *Channel {
	s.IngestEndpoint = &v
	return s
}

// SetInsecureIngest sets the InsecureIngest field's value.
func (s *Channel) SetInsecureIngest(v bool) *Channel {
	s.InsecureIngest = &v
	return s
}

// SetLatencyMode sets the LatencyMode field's value.
func (s *Channel) SetLatencyMode(v string) *Channel {
	s.LatencyMode = &v
	return s
}

// SetName sets the Name field's value.
func (s *Channel) SetName(v string) *Channel {
	s.Name = &v
	return s
}

// SetPlaybackUrl sets the PlaybackUrl field's value.
func (s *Channel) SetPlaybackUrl(v string) *Channel {
	s.PlaybackUrl = &v
	return s
}

// SetPreset sets the Preset field's value.
func (s *Channel) SetPreset(v string) *Channel {
	s.Preset = &v
	return s
}

// SetRecordingConfigurationArn sets the RecordingConfigurationArn field's value.
func (s *Channel) SetRecordingConfigurationArn(v string) *Channel {
	s.RecordingConfigurationArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Channel) SetTags(v map[string]*string) *Channel {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *Channel) SetType(v string) *Channel {
	s.Type = &v
	return s
}

type ChannelNotBroadcasting struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The stream is offline for the given channel ARN.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelNotBroadcasting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelNotBroadcasting) GoString() string {
	return s.String()
}

func newErrorChannelNotBroadcasting(v protocol.ResponseMetadata) error {
	return &ChannelNotBroadcasting{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ChannelNotBroadcasting) Code() string {
	return "ChannelNotBroadcasting"
}

// Message returns the exception's message.
func (s *ChannelNotBroadcasting) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ChannelNotBroadcasting) OrigErr() error {
	return nil
}

func (s *ChannelNotBroadcasting) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ChannelNotBroadcasting) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ChannelNotBroadcasting) RequestID() string {
	return s.RespMetadata.RequestID
}

// Summary information about a channel.
type ChannelSummary struct {
	_ struct{} `type:"structure"`

	// Channel ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Whether the channel is private (enabled for playback authorization). Default:
	// false.
	Authorized *bool `locationName:"authorized" type:"boolean"`

	// Whether the channel allows insecure RTMP ingest. Default: false.
	InsecureIngest *bool `locationName:"insecureIngest" type:"boolean"`

	// Channel latency mode. Use NORMAL to broadcast and deliver live video up to
	// Full HD. Use LOW for near-real-time interaction with viewers. Default: LOW.
	// (Note: In the Amazon IVS console, LOW and NORMAL correspond to Ultra-low
	// and Standard, respectively.)
	LatencyMode *string `locationName:"latencyMode" type:"string" enum:"ChannelLatencyMode"`

	// Channel name.
	Name *string `locationName:"name" type:"string"`

	// Optional transcode preset for the channel. This is selectable only for ADVANCED_HD
	// and ADVANCED_SD channel types. For those channel types, the default preset
	// is HIGHER_BANDWIDTH_DELIVERY. For other channel types (BASIC and STANDARD),
	// preset is the empty string ("").
	Preset *string `locationName:"preset" type:"string" enum:"TranscodePreset"`

	// Recording-configuration ARN. A value other than an empty string indicates
	// that recording is enabled. Default: "" (empty string, recording is disabled).
	RecordingConfigurationArn *string `locationName:"recordingConfigurationArn" type:"string"`

	// Tags attached to the resource. Array of 1-50 maps, each of the form string:string
	// (key:value). See Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for more information, including restrictions that apply to tags and "Tag
	// naming limits and requirements"; Amazon IVS has no service-specific constraints
	// beyond what is documented there.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Channel type, which determines the allowable resolution and bitrate. If you
	// exceed the allowable input resolution or bitrate, the stream probably will
	// disconnect immediately. Some types generate multiple qualities (renditions)
	// from the original input; this automatically gives viewers the best experience
	// for their devices and network conditions. Some types provide transcoded video;
	// transcoding allows higher playback quality across a range of download speeds.
	// Default: STANDARD. Valid values:
	//
	//    * BASIC: Video is transmuxed: Amazon IVS delivers the original input quality
	//    to viewers. The viewer’s video-quality choice is limited to the original
	//    input. Input resolution can be up to 1080p and bitrate can be up to 1.5
	//    Mbps for 480p and up to 3.5 Mbps for resolutions between 480p and 1080p.
	//    Original audio is passed through.
	//
	//    * STANDARD: Video is transcoded: multiple qualities are generated from
	//    the original input, to automatically give viewers the best experience
	//    for their devices and network conditions. Transcoding allows higher playback
	//    quality across a range of download speeds. Resolution can be up to 1080p
	//    and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions
	//    360p and below; above that, audio is passed through. This is the default
	//    when you create a channel.
	//
	//    * ADVANCED_SD: Video is transcoded; multiple qualities are generated from
	//    the original input, to automatically give viewers the best experience
	//    for their devices and network conditions. Input resolution can be up to
	//    1080p and bitrate can be up to 8.5 Mbps; output is capped at SD quality
	//    (480p). You can select an optional transcode preset (see below). Audio
	//    for all renditions is transcoded, and an audio-only rendition is available.
	//
	//    * ADVANCED_HD: Video is transcoded; multiple qualities are generated from
	//    the original input, to automatically give viewers the best experience
	//    for their devices and network conditions. Input resolution can be up to
	//    1080p and bitrate can be up to 8.5 Mbps; output is capped at HD quality
	//    (720p). You can select an optional transcode preset (see below). Audio
	//    for all renditions is transcoded, and an audio-only rendition is available.
	//
	// Optional transcode presets (available for the ADVANCED types) allow you to
	// trade off available download bandwidth and video quality, to optimize the
	// viewing experience. There are two presets:
	//
	//    * Constrained bandwidth delivery uses a lower bitrate for each quality
	//    level. Use it if you have low download bandwidth and/or simple video content
	//    (e.g., talking heads)
	//
	//    * Higher bandwidth delivery uses a higher bitrate for each quality level.
	//    Use it if you have high download bandwidth and/or complex video content
	//    (e.g., flashes and quick scene changes).
	Type *string `locationName:"type" type:"string" enum:"ChannelType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ChannelSummary) SetArn(v string) *ChannelSummary {
	s.Arn = &v
	return s
}

// SetAuthorized sets the Authorized field's value.
func (s *ChannelSummary) SetAuthorized(v bool) *ChannelSummary {
	s.Authorized = &v
	return s
}

// SetInsecureIngest sets the InsecureIngest field's value.
func (s *ChannelSummary) SetInsecureIngest(v bool) *ChannelSummary {
	s.InsecureIngest = &v
	return s
}

// SetLatencyMode sets the LatencyMode field's value.
func (s *ChannelSummary) SetLatencyMode(v string) *ChannelSummary {
	s.LatencyMode = &v
	return s
}

// SetName sets the Name field's value.
func (s *ChannelSummary) SetName(v string) *ChannelSummary {
	s.Name = &v
	return s
}

// SetPreset sets the Preset field's value.
func (s *ChannelSummary) SetPreset(v string) *ChannelSummary {
	s.Preset = &v
	return s
}

// SetRecordingConfigurationArn sets the RecordingConfigurationArn field's value.
func (s *ChannelSummary) SetRecordingConfigurationArn(v string) *ChannelSummary {
	s.RecordingConfigurationArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ChannelSummary) SetTags(v map[string]*string) *ChannelSummary {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *ChannelSummary) SetType(v string) *ChannelSummary {
	s.Type = &v
	return s
}

type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Updating or deleting a resource can cause an inconsistent state.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateChannelInput struct {
	_ struct{} `type:"structure"`

	// Whether the channel is private (enabled for playback authorization). Default:
	// false.
	Authorized *bool `locationName:"authorized" type:"boolean"`

	// Whether the channel allows insecure RTMP ingest. Default: false.
	InsecureIngest *bool `locationName:"insecureIngest" type:"boolean"`

	// Channel latency mode. Use NORMAL to broadcast and deliver live video up to
	// Full HD. Use LOW for near-real-time interaction with viewers. (Note: In the
	// Amazon IVS console, LOW and NORMAL correspond to Ultra-low and Standard,
	// respectively.) Default: LOW.
	LatencyMode *string `locationName:"latencyMode" type:"string" enum:"ChannelLatencyMode"`

	// Channel name.
	Name *string `locationName:"name" type:"string"`

	// Optional transcode preset for the channel. This is selectable only for ADVANCED_HD
	// and ADVANCED_SD channel types. For those channel types, the default preset
	// is HIGHER_BANDWIDTH_DELIVERY. For other channel types (BASIC and STANDARD),
	// preset is the empty string ("").
	Preset *string `locationName:"preset" type:"string" enum:"TranscodePreset"`

	// Recording-configuration ARN. Default: "" (empty string, recording is disabled).
	RecordingConfigurationArn *string `locationName:"recordingConfigurationArn" type:"string"`

	// Array of 1-50 maps, each of the form string:string (key:value). See Tagging
	// Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for more information, including restrictions that apply to tags and "Tag
	// naming limits and requirements"; Amazon IVS has no service-specific constraints
	// beyond what is documented there.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Channel type, which determines the allowable resolution and bitrate. If you
	// exceed the allowable input resolution or bitrate, the stream probably will
	// disconnect immediately. Some types generate multiple qualities (renditions)
	// from the original input; this automatically gives viewers the best experience
	// for their devices and network conditions. Some types provide transcoded video;
	// transcoding allows higher playback quality across a range of download speeds.
	// Default: STANDARD. Valid values:
	//
	//    * BASIC: Video is transmuxed: Amazon IVS delivers the original input quality
	//    to viewers. The viewer’s video-quality choice is limited to the original
	//    input. Input resolution can be up to 1080p and bitrate can be up to 1.5
	//    Mbps for 480p and up to 3.5 Mbps for resolutions between 480p and 1080p.
	//    Original audio is passed through.
	//
	//    * STANDARD: Video is transcoded: multiple qualities are generated from
	//    the original input, to automatically give viewers the best experience
	//    for their devices and network conditions. Transcoding allows higher playback
	//    quality across a range of download speeds. Resolution can be up to 1080p
	//    and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions
	//    360p and below; above that, audio is passed through. This is the default
	//    when you create a channel.
	//
	//    * ADVANCED_SD: Video is transcoded; multiple qualities are generated from
	//    the original input, to automatically give viewers the best experience
	//    for their devices and network conditions. Input resolution can be up to
	//    1080p and bitrate can be up to 8.5 Mbps; output is capped at SD quality
	//    (480p). You can select an optional transcode preset (see below). Audio
	//    for all renditions is transcoded, and an audio-only rendition is available.
	//
	//    * ADVANCED_HD: Video is transcoded; multiple qualities are generated from
	//    the original input, to automatically give viewers the best experience
	//    for their devices and network conditions. Input resolution can be up to
	//    1080p and bitrate can be up to 8.5 Mbps; output is capped at HD quality
	//    (720p). You can select an optional transcode preset (see below). Audio
	//    for all renditions is transcoded, and an audio-only rendition is available.
	//
	// Optional transcode presets (available for the ADVANCED types) allow you to
	// trade off available download bandwidth and video quality, to optimize the
	// viewing experience. There are two presets:
	//
	//    * Constrained bandwidth delivery uses a lower bitrate for each quality
	//    level. Use it if you have low download bandwidth and/or simple video content
	//    (e.g., talking heads)
	//
	//    * Higher bandwidth delivery uses a higher bitrate for each quality level.
	//    Use it if you have high download bandwidth and/or complex video content
	//    (e.g., flashes and quick scene changes).
	Type *string `locationName:"type" type:"string" enum:"ChannelType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelInput) GoString() string {
	return s.String()
}

// SetAuthorized sets the Authorized field's value.
func (s *CreateChannelInput) SetAuthorized(v bool) *CreateChannelInput {
	s.Authorized = &v
	return s
}

// SetInsecureIngest sets the InsecureIngest field's value.
func (s *CreateChannelInput) SetInsecureIngest(v bool) *CreateChannelInput {
	s.InsecureIngest = &v
	return s
}

// SetLatencyMode sets the LatencyMode field's value.
func (s *CreateChannelInput) SetLatencyMode(v string) *CreateChannelInput {
	s.LatencyMode = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateChannelInput) SetName(v string) *CreateChannelInput {
	s.Name = &v
	return s
}

// SetPreset sets the Preset field's value.
func (s *CreateChannelInput) SetPreset(v string) *CreateChannelInput {
	s.Preset = &v
	return s
}

// SetRecordingConfigurationArn sets the RecordingConfigurationArn field's value.
func (s *CreateChannelInput) SetRecordingConfigurationArn(v string) *CreateChannelInput {
	s.RecordingConfigurationArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChannelInput) SetTags(v map[string]*string) *CreateChannelInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateChannelInput) SetType(v string) *CreateChannelInput {
	s.Type = &v
	return s
}

type CreateChannelOutput struct {
	_ struct{} `type:"structure"`

	// Object specifying a channel.
	Channel *Channel `locationName:"channel" type:"structure"`

	// Object specifying a stream key.
	StreamKey *StreamKey `locationName:"streamKey" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelOutput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *CreateChannelOutput) SetChannel(v *Channel) *CreateChannelOutput {
	s.Channel = v
	return s
}

// SetStreamKey sets the StreamKey field's value.
func (s *CreateChannelOutput) SetStreamKey(v *StreamKey) *CreateChannelOutput {
	s.StreamKey = v
	return s
}

type CreateRecordingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains a destination configuration for where recorded
	// video will be stored.
	//
	// DestinationConfiguration is a required field
	DestinationConfiguration *DestinationConfiguration `locationName:"destinationConfiguration" type:"structure" required:"true"`

	// Recording-configuration name. The value does not need to be unique.
	Name *string `locationName:"name" type:"string"`

	// If a broadcast disconnects and then reconnects within the specified interval,
	// the multiple streams will be considered a single broadcast and merged together.
	// Default: 0.
	RecordingReconnectWindowSeconds *int64 `locationName:"recordingReconnectWindowSeconds" type:"integer"`

	// Object that describes which renditions should be recorded for a stream.
	RenditionConfiguration *RenditionConfiguration `locationName:"renditionConfiguration" type:"structure"`

	// Array of 1-50 maps, each of the form string:string (key:value). See Tagging
	// Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for more information, including restrictions that apply to tags and "Tag
	// naming limits and requirements"; Amazon IVS has no service-specific constraints
	// beyond what is documented there.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A complex type that allows you to enable/disable the recording of thumbnails
	// for a live session and modify the interval at which thumbnails are generated
	// for the live session.
	ThumbnailConfiguration *ThumbnailConfiguration `locationName:"thumbnailConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecordingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecordingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRecordingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRecordingConfigurationInput"}
	if s.DestinationConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationConfiguration"))
	}
	if s.DestinationConfiguration != nil {
		if err := s.DestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ThumbnailConfiguration != nil {
		if err := s.ThumbnailConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ThumbnailConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationConfiguration sets the DestinationConfiguration field's value.
func (s *CreateRecordingConfigurationInput) SetDestinationConfiguration(v *DestinationConfiguration) *CreateRecordingConfigurationInput {
	s.DestinationConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRecordingConfigurationInput) SetName(v string) *CreateRecordingConfigurationInput {
	s.Name = &v
	return s
}

// SetRecordingReconnectWindowSeconds sets the RecordingReconnectWindowSeconds field's value.
func (s *CreateRecordingConfigurationInput) SetRecordingReconnectWindowSeconds(v int64) *CreateRecordingConfigurationInput {
	s.RecordingReconnectWindowSeconds = &v
	return s
}

// SetRenditionConfiguration sets the RenditionConfiguration field's value.
func (s *CreateRecordingConfigurationInput) SetRenditionConfiguration(v *RenditionConfiguration) *CreateRecordingConfigurationInput {
	s.RenditionConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRecordingConfigurationInput) SetTags(v map[string]*string) *CreateRecordingConfigurationInput {
	s.Tags = v
	return s
}

// SetThumbnailConfiguration sets the ThumbnailConfiguration field's value.
func (s *CreateRecordingConfigurationInput) SetThumbnailConfiguration(v *ThumbnailConfiguration) *CreateRecordingConfigurationInput {
	s.ThumbnailConfiguration = v
	return s
}

type CreateRecordingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// An object representing a configuration to record a channel stream.
	RecordingConfiguration *RecordingConfiguration `locationName:"recordingConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecordingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecordingConfigurationOutput) GoString() string {
	return s.String()
}

// SetRecordingConfiguration sets the RecordingConfiguration field's value.
func (s *CreateRecordingConfigurationOutput) SetRecordingConfiguration(v *RecordingConfiguration) *CreateRecordingConfigurationOutput {
	s.RecordingConfiguration = v
	return s
}

type CreateStreamKeyInput struct {
	_ struct{} `type:"structure"`

	// ARN of the channel for which to create the stream key.
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`

	// Array of 1-50 maps, each of the form string:string (key:value). See Tagging
	// Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for more information, including restrictions that apply to tags and "Tag
	// naming limits and requirements"; Amazon IVS has no service-specific constraints
	// beyond what is documented there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStreamKeyInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *CreateStreamKeyInput) SetChannelArn(v string) *CreateStreamKeyInput {
	s.ChannelArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStreamKeyInput) SetTags(v map[string]*string) *CreateStreamKeyInput {
	s.Tags = v
	return s
}

type CreateStreamKeyOutput struct {
	_ struct{} `type:"structure"`

	// Stream key used to authenticate an RTMPS stream for ingestion.
	StreamKey *StreamKey `locationName:"streamKey" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamKeyOutput) GoString() string {
	return s.String()
}

// SetStreamKey sets the StreamKey field's value.
func (s *CreateStreamKeyOutput) SetStreamKey(v *StreamKey) *CreateStreamKeyOutput {
	s.StreamKey = v
	return s
}

type DeleteChannelInput struct {
	_ struct{} `type:"structure"`

	// ARN of the channel to be deleted.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteChannelInput) SetArn(v string) *DeleteChannelInput {
	s.Arn = &v
	return s
}

type DeleteChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelOutput) GoString() string {
	return s.String()
}

type DeletePlaybackKeyPairInput struct {
	_ struct{} `type:"structure"`

	// ARN of the key pair to be deleted.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePlaybackKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePlaybackKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePlaybackKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePlaybackKeyPairInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeletePlaybackKeyPairInput) SetArn(v string) *DeletePlaybackKeyPairInput {
	s.Arn = &v
	return s
}

type DeletePlaybackKeyPairOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePlaybackKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePlaybackKeyPairOutput) GoString() string {
	return s.String()
}

type DeleteRecordingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// ARN of the recording configuration to be deleted.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecordingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecordingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRecordingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRecordingConfigurationInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteRecordingConfigurationInput) SetArn(v string) *DeleteRecordingConfigurationInput {
	s.Arn = &v
	return s
}

type DeleteRecordingConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecordingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecordingConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteStreamKeyInput struct {
	_ struct{} `type:"structure"`

	// ARN of the stream key to be deleted.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStreamKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStreamKeyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteStreamKeyInput) SetArn(v string) *DeleteStreamKeyInput {
	s.Arn = &v
	return s
}

type DeleteStreamKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamKeyOutput) GoString() string {
	return s.String()
}

// A complex type that describes a location where recorded videos will be stored.
// Each member represents a type of destination configuration. For recording,
// you define one and only one type of destination configuration.
type DestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// An S3 destination configuration where recorded videos will be stored.
	S3 *S3DestinationConfiguration `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DestinationConfiguration"}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3 sets the S3 field's value.
func (s *DestinationConfiguration) SetS3(v *S3DestinationConfiguration) *DestinationConfiguration {
	s.S3 = v
	return s
}

type GetChannelInput struct {
	_ struct{} `type:"structure"`

	// ARN of the channel for which the configuration is to be retrieved.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChannelInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetChannelInput) SetArn(v string) *GetChannelInput {
	s.Arn = &v
	return s
}

type GetChannelOutput struct {
	_ struct{} `type:"structure"`

	// Object specifying a channel.
	Channel *Channel `locationName:"channel" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelOutput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *GetChannelOutput) SetChannel(v *Channel) *GetChannelOutput {
	s.Channel = v
	return s
}

type GetPlaybackKeyPairInput struct {
	_ struct{} `type:"structure"`

	// ARN of the key pair to be returned.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPlaybackKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPlaybackKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPlaybackKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPlaybackKeyPairInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetPlaybackKeyPairInput) SetArn(v string) *GetPlaybackKeyPairInput {
	s.Arn = &v
	return s
}

type GetPlaybackKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// A key pair used to sign and validate a playback authorization token.
	KeyPair *PlaybackKeyPair `locationName:"keyPair" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPlaybackKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPlaybackKeyPairOutput) GoString() string {
	return s.String()
}

// SetKeyPair sets the KeyPair field's value.
func (s *GetPlaybackKeyPairOutput) SetKeyPair(v *PlaybackKeyPair) *GetPlaybackKeyPairOutput {
	s.KeyPair = v
	return s
}

type GetRecordingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// ARN of the recording configuration to be retrieved.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecordingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecordingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRecordingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRecordingConfigurationInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetRecordingConfigurationInput) SetArn(v string) *GetRecordingConfigurationInput {
	s.Arn = &v
	return s
}

type GetRecordingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// An object representing a configuration to record a channel stream.
	RecordingConfiguration *RecordingConfiguration `locationName:"recordingConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecordingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecordingConfigurationOutput) GoString() string {
	return s.String()
}

// SetRecordingConfiguration sets the RecordingConfiguration field's value.
func (s *GetRecordingConfigurationOutput) SetRecordingConfiguration(v *RecordingConfiguration) *GetRecordingConfigurationOutput {
	s.RecordingConfiguration = v
	return s
}

type GetStreamInput struct {
	_ struct{} `type:"structure"`

	// Channel ARN for stream to be accessed.
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStreamInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *GetStreamInput) SetChannelArn(v string) *GetStreamInput {
	s.ChannelArn = &v
	return s
}

type GetStreamKeyInput struct {
	_ struct{} `type:"structure"`

	// ARN for the stream key to be retrieved.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStreamKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStreamKeyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetStreamKeyInput) SetArn(v string) *GetStreamKeyInput {
	s.Arn = &v
	return s
}

type GetStreamKeyOutput struct {
	_ struct{} `type:"structure"`

	// Object specifying a stream key.
	StreamKey *StreamKey `locationName:"streamKey" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamKeyOutput) GoString() string {
	return s.String()
}

// SetStreamKey sets the StreamKey field's value.
func (s *GetStreamKeyOutput) SetStreamKey(v *StreamKey) *GetStreamKeyOutput {
	s.StreamKey = v
	return s
}

type GetStreamOutput struct {
	_ struct{} `type:"structure"`

	// Specifies a live video stream that has been ingested and distributed.
	Stream *Stream `locationName:"stream" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamOutput) GoString() string {
	return s.String()
}

// SetStream sets the Stream field's value.
func (s *GetStreamOutput) SetStream(v *Stream) *GetStreamOutput {
	s.Stream = v
	return s
}

type GetStreamSessionInput struct {
	_ struct{} `type:"structure"`

	// ARN of the channel resource
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`

	// Unique identifier for a live or previously live stream in the specified channel.
	// If no streamId is provided, this returns the most recent stream session for
	// the channel, if it exists.
	StreamId *string `locationName:"streamId" min:"26" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStreamSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStreamSessionInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 1))
	}
	if s.StreamId != nil && len(*s.StreamId) < 26 {
		invalidParams.Add(request.NewErrParamMinLen("StreamId", 26))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *GetStreamSessionInput) SetChannelArn(v string) *GetStreamSessionInput {
	s.ChannelArn = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *GetStreamSessionInput) SetStreamId(v string) *GetStreamSessionInput {
	s.StreamId = &v
	return s
}

type GetStreamSessionOutput struct {
	_ struct{} `type:"structure"`

	// List of stream details.
	StreamSession *StreamSession `locationName:"streamSession" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamSessionOutput) GoString() string {
	return s.String()
}

// SetStreamSession sets the StreamSession field's value.
func (s *GetStreamSessionOutput) SetStreamSession(v *StreamSession) *GetStreamSessionOutput {
	s.StreamSession = v
	return s
}

type ImportPlaybackKeyPairInput struct {
	_ struct{} `type:"structure"`

	// Playback-key-pair name. The value does not need to be unique.
	Name *string `locationName:"name" type:"string"`

	// The public portion of a customer-generated key pair.
	//
	// PublicKeyMaterial is a required field
	PublicKeyMaterial *string `locationName:"publicKeyMaterial" type:"string" required:"true"`

	// Any tags provided with the request are added to the playback key pair tags.
	// See Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for more information, including restrictions that apply to tags and "Tag
	// naming limits and requirements"; Amazon IVS has no service-specific constraints
	// beyond what is documented there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportPlaybackKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportPlaybackKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportPlaybackKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportPlaybackKeyPairInput"}
	if s.PublicKeyMaterial == nil {
		invalidParams.Add(request.NewErrParamRequired("PublicKeyMaterial"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ImportPlaybackKeyPairInput) SetName(v string) *ImportPlaybackKeyPairInput {
	s.Name = &v
	return s
}

// SetPublicKeyMaterial sets the PublicKeyMaterial field's value.
func (s *ImportPlaybackKeyPairInput) SetPublicKeyMaterial(v string) *ImportPlaybackKeyPairInput {
	s.PublicKeyMaterial = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportPlaybackKeyPairInput) SetTags(v map[string]*string) *ImportPlaybackKeyPairInput {
	s.Tags = v
	return s
}

type ImportPlaybackKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// A key pair used to sign and validate a playback authorization token.
	KeyPair *PlaybackKeyPair `locationName:"keyPair" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportPlaybackKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportPlaybackKeyPairOutput) GoString() string {
	return s.String()
}

// SetKeyPair sets the KeyPair field's value.
func (s *ImportPlaybackKeyPairOutput) SetKeyPair(v *PlaybackKeyPair) *ImportPlaybackKeyPairOutput {
	s.KeyPair = v
	return s
}

// Object specifying the ingest configuration set up by the broadcaster, usually
// in an encoder.
type IngestConfiguration struct {
	_ struct{} `type:"structure"`

	// Encoder settings for audio.
	Audio *AudioConfiguration `locationName:"audio" type:"structure"`

	// Encoder settings for video.
	Video *VideoConfiguration `locationName:"video" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestConfiguration) GoString() string {
	return s.String()
}

// SetAudio sets the Audio field's value.
func (s *IngestConfiguration) SetAudio(v *AudioConfiguration) *IngestConfiguration {
	s.Audio = v
	return s
}

// SetVideo sets the Video field's value.
func (s *IngestConfiguration) SetVideo(v *VideoConfiguration) *IngestConfiguration {
	s.Video = v
	return s
}

type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Unexpected error during processing of request.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListChannelsInput struct {
	_ struct{} `type:"structure"`

	// Filters the channel list to match the specified name.
	FilterByName *string `locationName:"filterByName" type:"string"`

	// Filters the channel list to match the specified recording-configuration ARN.
	FilterByRecordingConfigurationArn *string `locationName:"filterByRecordingConfigurationArn" type:"string"`

	// Maximum number of channels to return. Default: 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first channel to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterByName sets the FilterByName field's value.
func (s *ListChannelsInput) SetFilterByName(v string) *ListChannelsInput {
	s.FilterByName = &v
	return s
}

// SetFilterByRecordingConfigurationArn sets the FilterByRecordingConfigurationArn field's value.
func (s *ListChannelsInput) SetFilterByRecordingConfigurationArn(v string) *ListChannelsInput {
	s.FilterByRecordingConfigurationArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelsInput) SetMaxResults(v int64) *ListChannelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsInput) SetNextToken(v string) *ListChannelsInput {
	s.NextToken = &v
	return s
}

type ListChannelsOutput struct {
	_ struct{} `type:"structure"`

	// List of the matching channels.
	//
	// Channels is a required field
	Channels []*ChannelSummary `locationName:"channels" type:"list" required:"true"`

	// If there are more channels than maxResults, use nextToken in the request
	// to get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsOutput) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *ListChannelsOutput) SetChannels(v []*ChannelSummary) *ListChannelsOutput {
	s.Channels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsOutput) SetNextToken(v string) *ListChannelsOutput {
	s.NextToken = &v
	return s
}

type ListPlaybackKeyPairsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of key pairs to return. Default: your service quota or 100,
	// whichever is smaller.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first key pair to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPlaybackKeyPairsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPlaybackKeyPairsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPlaybackKeyPairsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPlaybackKeyPairsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPlaybackKeyPairsInput) SetMaxResults(v int64) *ListPlaybackKeyPairsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlaybackKeyPairsInput) SetNextToken(v string) *ListPlaybackKeyPairsInput {
	s.NextToken = &v
	return s
}

type ListPlaybackKeyPairsOutput struct {
	_ struct{} `type:"structure"`

	// List of key pairs.
	//
	// KeyPairs is a required field
	KeyPairs []*PlaybackKeyPairSummary `locationName:"keyPairs" type:"list" required:"true"`

	// If there are more key pairs than maxResults, use nextToken in the request
	// to get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPlaybackKeyPairsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPlaybackKeyPairsOutput) GoString() string {
	return s.String()
}

// SetKeyPairs sets the KeyPairs field's value.
func (s *ListPlaybackKeyPairsOutput) SetKeyPairs(v []*PlaybackKeyPairSummary) *ListPlaybackKeyPairsOutput {
	s.KeyPairs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlaybackKeyPairsOutput) SetNextToken(v string) *ListPlaybackKeyPairsOutput {
	s.NextToken = &v
	return s
}

type ListRecordingConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of recording configurations to return. Default: your service
	// quota or 100, whichever is smaller.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first recording configuration to retrieve. This is used for pagination;
	// see the nextToken response field.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecordingConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecordingConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecordingConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecordingConfigurationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRecordingConfigurationsInput) SetMaxResults(v int64) *ListRecordingConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecordingConfigurationsInput) SetNextToken(v string) *ListRecordingConfigurationsInput {
	s.NextToken = &v
	return s
}

type ListRecordingConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more recording configurations than maxResults, use nextToken
	// in the request to get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of the matching recording configurations.
	//
	// RecordingConfigurations is a required field
	RecordingConfigurations []*RecordingConfigurationSummary `locationName:"recordingConfigurations" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecordingConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecordingConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecordingConfigurationsOutput) SetNextToken(v string) *ListRecordingConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetRecordingConfigurations sets the RecordingConfigurations field's value.
func (s *ListRecordingConfigurationsOutput) SetRecordingConfigurations(v []*RecordingConfigurationSummary) *ListRecordingConfigurationsOutput {
	s.RecordingConfigurations = v
	return s
}

type ListStreamKeysInput struct {
	_ struct{} `type:"structure"`

	// Channel ARN used to filter the list.
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`

	// Maximum number of streamKeys to return. Default: 1.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first stream key to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStreamKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStreamKeysInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListStreamKeysInput) SetChannelArn(v string) *ListStreamKeysInput {
	s.ChannelArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStreamKeysInput) SetMaxResults(v int64) *ListStreamKeysInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamKeysInput) SetNextToken(v string) *ListStreamKeysInput {
	s.NextToken = &v
	return s
}

type ListStreamKeysOutput struct {
	_ struct{} `type:"structure"`

	// If there are more stream keys than maxResults, use nextToken in the request
	// to get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of stream keys.
	//
	// StreamKeys is a required field
	StreamKeys []*StreamKeySummary `locationName:"streamKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamKeysOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamKeysOutput) SetNextToken(v string) *ListStreamKeysOutput {
	s.NextToken = &v
	return s
}

// SetStreamKeys sets the StreamKeys field's value.
func (s *ListStreamKeysOutput) SetStreamKeys(v []*StreamKeySummary) *ListStreamKeysOutput {
	s.StreamKeys = v
	return s
}

type ListStreamSessionsInput struct {
	_ struct{} `type:"structure"`

	// Channel ARN used to filter the list.
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`

	// Maximum number of streams to return. Default: 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first stream to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStreamSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStreamSessionsInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListStreamSessionsInput) SetChannelArn(v string) *ListStreamSessionsInput {
	s.ChannelArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStreamSessionsInput) SetMaxResults(v int64) *ListStreamSessionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamSessionsInput) SetNextToken(v string) *ListStreamSessionsInput {
	s.NextToken = &v
	return s
}

type ListStreamSessionsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more streams than maxResults, use nextToken in the request to
	// get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of stream sessions.
	//
	// StreamSessions is a required field
	StreamSessions []*StreamSessionSummary `locationName:"streamSessions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamSessionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamSessionsOutput) SetNextToken(v string) *ListStreamSessionsOutput {
	s.NextToken = &v
	return s
}

// SetStreamSessions sets the StreamSessions field's value.
func (s *ListStreamSessionsOutput) SetStreamSessions(v []*StreamSessionSummary) *ListStreamSessionsOutput {
	s.StreamSessions = v
	return s
}

type ListStreamsInput struct {
	_ struct{} `type:"structure"`

	// Filters the stream list to match the specified criterion.
	FilterBy *StreamFilters `locationName:"filterBy" type:"structure"`

	// Maximum number of streams to return. Default: 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first stream to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStreamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStreamsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterBy sets the FilterBy field's value.
func (s *ListStreamsInput) SetFilterBy(v *StreamFilters) *ListStreamsInput {
	s.FilterBy = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStreamsInput) SetMaxResults(v int64) *ListStreamsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamsInput) SetNextToken(v string) *ListStreamsInput {
	s.NextToken = &v
	return s
}

type ListStreamsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more streams than maxResults, use nextToken in the request to
	// get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of streams.
	//
	// Streams is a required field
	Streams []*StreamSummary `locationName:"streams" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamsOutput) SetNextToken(v string) *ListStreamsOutput {
	s.NextToken = &v
	return s
}

// SetStreams sets the Streams field's value.
func (s *ListStreamsOutput) SetStreams(v []*StreamSummary) *ListStreamsOutput {
	s.Streams = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource to be retrieved. The ARN must be URL-encoded.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value).
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type PendingVerification struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Your account is pending verification.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PendingVerification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PendingVerification) GoString() string {
	return s.String()
}

func newErrorPendingVerification(v protocol.ResponseMetadata) error {
	return &PendingVerification{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PendingVerification) Code() string {
	return "PendingVerification"
}

// Message returns the exception's message.
func (s *PendingVerification) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PendingVerification) OrigErr() error {
	return nil
}

func (s *PendingVerification) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PendingVerification) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PendingVerification) RequestID() string {
	return s.RespMetadata.RequestID
}

// A key pair used to sign and validate a playback authorization token.
type PlaybackKeyPair struct {
	_ struct{} `type:"structure"`

	// Key-pair ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Key-pair identifier.
	Fingerprint *string `locationName:"fingerprint" type:"string"`

	// Playback-key-pair name. The value does not need to be unique.
	Name *string `locationName:"name" type:"string"`

	// Tags attached to the resource. Array of 1-50 maps, each of the form string:string
	// (key:value). See Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for more information, including restrictions that apply to tags and "Tag
	// naming limits and requirements"; Amazon IVS has no service-specific constraints
	// beyond what is documented there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlaybackKeyPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlaybackKeyPair) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PlaybackKeyPair) SetArn(v string) *PlaybackKeyPair {
	s.Arn = &v
	return s
}

// SetFingerprint sets the Fingerprint field's value.
func (s *PlaybackKeyPair) SetFingerprint(v string) *PlaybackKeyPair {
	s.Fingerprint = &v
	return s
}

// SetName sets the Name field's value.
func (s *PlaybackKeyPair) SetName(v string) *PlaybackKeyPair {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PlaybackKeyPair) SetTags(v map[string]*string) *PlaybackKeyPair {
	s.Tags = v
	return s
}

// Summary information about a playback key pair.
type PlaybackKeyPairSummary struct {
	_ struct{} `type:"structure"`

	// Key-pair ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Playback-key-pair name. The value does not need to be unique.
	Name *string `locationName:"name" type:"string"`

	// Tags attached to the resource. Array of 1-50 maps, each of the form string:string
	// (key:value). See Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for more information, including restrictions that apply to tags and "Tag
	// naming limits and requirements"; Amazon IVS has no service-specific constraints
	// beyond what is documented there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlaybackKeyPairSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlaybackKeyPairSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PlaybackKeyPairSummary) SetArn(v string) *PlaybackKeyPairSummary {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *PlaybackKeyPairSummary) SetName(v string) *PlaybackKeyPairSummary {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PlaybackKeyPairSummary) SetTags(v map[string]*string) *PlaybackKeyPairSummary {
	s.Tags = v
	return s
}

type PutMetadataInput struct {
	_ struct{} `type:"structure"`

	// ARN of the channel into which metadata is inserted. This channel must have
	// an active stream.
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`

	// Metadata to insert into the stream. Maximum: 1 KB per request.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PutMetadataInput's
	// String and GoString methods.
	//
	// Metadata is a required field
	Metadata *string `locationName:"metadata" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutMetadataInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 1))
	}
	if s.Metadata == nil {
		invalidParams.Add(request.NewErrParamRequired("Metadata"))
	}
	if s.Metadata != nil && len(*s.Metadata) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Metadata", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *PutMetadataInput) SetChannelArn(v string) *PutMetadataInput {
	s.ChannelArn = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *PutMetadataInput) SetMetadata(v string) *PutMetadataInput {
	s.Metadata = &v
	return s
}

type PutMetadataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetadataOutput) GoString() string {
	return s.String()
}

// An object representing a configuration to record a channel stream.
type RecordingConfiguration struct {
	_ struct{} `type:"structure"`

	// Recording-configuration ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// A complex type that contains information about where recorded video will
	// be stored.
	//
	// DestinationConfiguration is a required field
	DestinationConfiguration *DestinationConfiguration `locationName:"destinationConfiguration" type:"structure" required:"true"`

	// Recording-configuration name. The value does not need to be unique.
	Name *string `locationName:"name" type:"string"`

	// If a broadcast disconnects and then reconnects within the specified interval,
	// the multiple streams will be considered a single broadcast and merged together.
	// Default: 0.
	RecordingReconnectWindowSeconds *int64 `locationName:"recordingReconnectWindowSeconds" type:"integer"`

	// Object that describes which renditions should be recorded for a stream.
	RenditionConfiguration *RenditionConfiguration `locationName:"renditionConfiguration" type:"structure"`

	// Indicates the current state of the recording configuration. When the state
	// is ACTIVE, the configuration is ready for recording a channel stream.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"RecordingConfigurationState"`

	// Tags attached to the resource. Array of 1-50 maps, each of the form string:string
	// (key:value). See Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for more information, including restrictions that apply to tags and "Tag
	// naming limits and requirements"; Amazon IVS has no service-specific constraints
	// beyond what is documented there.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A complex type that allows you to enable/disable the recording of thumbnails
	// for a live session and modify the interval at which thumbnails are generated
	// for the live session.
	ThumbnailConfiguration *ThumbnailConfiguration `locationName:"thumbnailConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordingConfiguration) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RecordingConfiguration) SetArn(v string) *RecordingConfiguration {
	s.Arn = &v
	return s
}

// SetDestinationConfiguration sets the DestinationConfiguration field's value.
func (s *RecordingConfiguration) SetDestinationConfiguration(v *DestinationConfiguration) *RecordingConfiguration {
	s.DestinationConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *RecordingConfiguration) SetName(v string) *RecordingConfiguration {
	s.Name = &v
	return s
}

// SetRecordingReconnectWindowSeconds sets the RecordingReconnectWindowSeconds field's value.
func (s *RecordingConfiguration) SetRecordingReconnectWindowSeconds(v int64) *RecordingConfiguration {
	s.RecordingReconnectWindowSeconds = &v
	return s
}

// SetRenditionConfiguration sets the RenditionConfiguration field's value.
func (s *RecordingConfiguration) SetRenditionConfiguration(v *RenditionConfiguration) *RecordingConfiguration {
	s.RenditionConfiguration = v
	return s
}

// SetState sets the State field's value.
func (s *RecordingConfiguration) SetState(v string) *RecordingConfiguration {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RecordingConfiguration) SetTags(v map[string]*string) *RecordingConfiguration {
	s.Tags = v
	return s
}

// SetThumbnailConfiguration sets the ThumbnailConfiguration field's value.
func (s *RecordingConfiguration) SetThumbnailConfiguration(v *ThumbnailConfiguration) *RecordingConfiguration {
	s.ThumbnailConfiguration = v
	return s
}

// Summary information about a RecordingConfiguration.
type RecordingConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// Recording-configuration ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// A complex type that contains information about where recorded video will
	// be stored.
	//
	// DestinationConfiguration is a required field
	DestinationConfiguration *DestinationConfiguration `locationName:"destinationConfiguration" type:"structure" required:"true"`

	// Recording-configuration name. The value does not need to be unique.
	Name *string `locationName:"name" type:"string"`

	// Indicates the current state of the recording configuration. When the state
	// is ACTIVE, the configuration is ready for recording a channel stream.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"RecordingConfigurationState"`

	// Tags attached to the resource. Array of 1-50 maps, each of the form string:string
	// (key:value). See Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for more information, including restrictions that apply to tags and "Tag
	// naming limits and requirements"; Amazon IVS has no service-specific constraints
	// beyond what is documented there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordingConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordingConfigurationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RecordingConfigurationSummary) SetArn(v string) *RecordingConfigurationSummary {
	s.Arn = &v
	return s
}

// SetDestinationConfiguration sets the DestinationConfiguration field's value.
func (s *RecordingConfigurationSummary) SetDestinationConfiguration(v *DestinationConfiguration) *RecordingConfigurationSummary {
	s.DestinationConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *RecordingConfigurationSummary) SetName(v string) *RecordingConfigurationSummary {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *RecordingConfigurationSummary) SetState(v string) *RecordingConfigurationSummary {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RecordingConfigurationSummary) SetTags(v map[string]*string) *RecordingConfigurationSummary {
	s.Tags = v
	return s
}

// Object that describes which renditions should be recorded for a stream.
type RenditionConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates which set of renditions are recorded for a stream. For BASIC channels,
	// the CUSTOM value has no effect. If CUSTOM is specified, a set of renditions
	// must be specified in the renditions field. Default: ALL.
	RenditionSelection *string `locationName:"renditionSelection" type:"string" enum:"RenditionConfigurationRenditionSelection"`

	// Indicates which renditions are recorded for a stream, if renditionSelection
	// is CUSTOM; otherwise, this field is irrelevant. The selected renditions are
	// recorded if they are available during the stream. If a selected rendition
	// is unavailable, the best available rendition is recorded. For details on
	// the resolution dimensions of each rendition, see Auto-Record to Amazon S3
	// (https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html).
	Renditions []*string `locationName:"renditions" type:"list" enum:"RenditionConfigurationRendition"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RenditionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RenditionConfiguration) GoString() string {
	return s.String()
}

// SetRenditionSelection sets the RenditionSelection field's value.
func (s *RenditionConfiguration) SetRenditionSelection(v string) *RenditionConfiguration {
	s.RenditionSelection = &v
	return s
}

// SetRenditions sets the Renditions field's value.
func (s *RenditionConfiguration) SetRenditions(v []*string) *RenditionConfiguration {
	s.Renditions = v
	return s
}

type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Request references a resource which does not exist.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A complex type that describes an S3 location where recorded videos will be
// stored.
type S3DestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// Location (S3 bucket name) where recorded videos will be stored.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3DestinationConfiguration"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3DestinationConfiguration) SetBucketName(v string) *S3DestinationConfiguration {
	s.BucketName = &v
	return s
}

type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Request would cause a service quota to be exceeded.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartViewerSessionRevocationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel associated with the viewer session to revoke.
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`

	// The ID of the viewer associated with the viewer session to revoke. Do not
	// use this field for personally identifying, confidential, or sensitive information.
	//
	// ViewerId is a required field
	ViewerId *string `locationName:"viewerId" min:"1" type:"string" required:"true"`

	// An optional filter on which versions of the viewer session to revoke. All
	// versions less than or equal to the specified version will be revoked. Default:
	// 0.
	ViewerSessionVersionsLessThanOrEqualTo *int64 `locationName:"viewerSessionVersionsLessThanOrEqualTo" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartViewerSessionRevocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartViewerSessionRevocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartViewerSessionRevocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartViewerSessionRevocationInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 1))
	}
	if s.ViewerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ViewerId"))
	}
	if s.ViewerId != nil && len(*s.ViewerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ViewerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *StartViewerSessionRevocationInput) SetChannelArn(v string) *StartViewerSessionRevocationInput {
	s.ChannelArn = &v
	return s
}

// SetViewerId sets the ViewerId field's value.
func (s *StartViewerSessionRevocationInput) SetViewerId(v string) *StartViewerSessionRevocationInput {
	s.ViewerId = &v
	return s
}

// SetViewerSessionVersionsLessThanOrEqualTo sets the ViewerSessionVersionsLessThanOrEqualTo field's value.
func (s *StartViewerSessionRevocationInput) SetViewerSessionVersionsLessThanOrEqualTo(v int64) *StartViewerSessionRevocationInput {
	s.ViewerSessionVersionsLessThanOrEqualTo = &v
	return s
}

type StartViewerSessionRevocationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartViewerSessionRevocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartViewerSessionRevocationOutput) GoString() string {
	return s.String()
}

type StopStreamInput struct {
	_ struct{} `type:"structure"`

	// ARN of the channel for which the stream is to be stopped.
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopStreamInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *StopStreamInput) SetChannelArn(v string) *StopStreamInput {
	s.ChannelArn = &v
	return s
}

type StopStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStreamOutput) GoString() string {
	return s.String()
}

// Specifies a live video stream that has been ingested and distributed.
type Stream struct {
	_ struct{} `type:"structure"`

	// Channel ARN for the stream.
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string"`

	// The stream’s health.
	Health *string `locationName:"health" type:"string" enum:"StreamHealth"`

	// URL of the master playlist, required by the video player to play the HLS
	// stream.
	PlaybackUrl *string `locationName:"playbackUrl" type:"string"`

	// Time of the stream’s start. This is an ISO 8601 timestamp; note that this
	// is returned as a string.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// The stream’s state. Do not rely on the OFFLINE state, as the API may not
	// return it; instead, a "NotBroadcasting" error will indicate that the stream
	// is not live.
	State *string `locationName:"state" type:"string" enum:"StreamState"`

	// Unique identifier for a live or previously live stream in the specified channel.
	StreamId *string `locationName:"streamId" min:"26" type:"string"`

	// A count of concurrent views of the stream. Typically, a new view appears
	// in viewerCount within 15 seconds of when video playback starts and a view
	// is removed from viewerCount within 1 minute of when video playback ends.
	// A value of -1 indicates that the request timed out; in this case, retry.
	ViewerCount *int64 `locationName:"viewerCount" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Stream) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Stream) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *Stream) SetChannelArn(v string) *Stream {
	s.ChannelArn = &v
	return s
}

// SetHealth sets the Health field's value.
func (s *Stream) SetHealth(v string) *Stream {
	s.Health = &v
	return s
}

// SetPlaybackUrl sets the PlaybackUrl field's value.
func (s *Stream) SetPlaybackUrl(v string) *Stream {
	s.PlaybackUrl = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Stream) SetStartTime(v time.Time) *Stream {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *Stream) SetState(v string) *Stream {
	s.State = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *Stream) SetStreamId(v string) *Stream {
	s.StreamId = &v
	return s
}

// SetViewerCount sets the ViewerCount field's value.
func (s *Stream) SetViewerCount(v int64) *Stream {
	s.ViewerCount = &v
	return s
}

// Object specifying a stream’s events. For a list of events, see Using Amazon
// EventBridge with Amazon IVS (https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html).
type StreamEvent struct {
	_ struct{} `type:"structure"`

	// Time when the event occurred. This is an ISO 8601 timestamp; note that this
	// is returned as a string.
	EventTime *time.Time `locationName:"eventTime" type:"timestamp" timestampFormat:"iso8601"`

	// Name that identifies the stream event within a type.
	Name *string `locationName:"name" type:"string"`

	// Logical group for certain events.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamEvent) GoString() string {
	return s.String()
}

// SetEventTime sets the EventTime field's value.
func (s *StreamEvent) SetEventTime(v time.Time) *StreamEvent {
	s.EventTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *StreamEvent) SetName(v string) *StreamEvent {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *StreamEvent) SetType(v string) *StreamEvent {
	s.Type = &v
	return s
}

// Object specifying the stream attribute on which to filter.
type StreamFilters struct {
	_ struct{} `type:"structure"`

	// The stream’s health.
	Health *string `locationName:"health" type:"string" enum:"StreamHealth"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamFilters) GoString() string {
	return s.String()
}

// SetHealth sets the Health field's value.
func (s *StreamFilters) SetHealth(v string) *StreamFilters {
	s.Health = &v
	return s
}

// Object specifying a stream key.
type StreamKey struct {
	_ struct{} `type:"structure"`

	// Stream-key ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Channel ARN for the stream.
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string"`

	// Tags attached to the resource. Array of 1-50 maps, each of the form string:string
	// (key:value). See Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for more information, including restrictions that apply to tags and "Tag
	// naming limits and requirements"; Amazon IVS has no service-specific constraints
	// beyond what is documented there.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Stream-key value.
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StreamKey's
	// String and GoString methods.
	Value *string `locationName:"value" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamKey) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StreamKey) SetArn(v string) *StreamKey {
	s.Arn = &v
	return s
}

// SetChannelArn sets the ChannelArn field's value.
func (s *StreamKey) SetChannelArn(v string) *StreamKey {
	s.ChannelArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StreamKey) SetTags(v map[string]*string) *StreamKey {
	s.Tags = v
	return s
}

// SetValue sets the Value field's value.
func (s *StreamKey) SetValue(v string) *StreamKey {
	s.Value = &v
	return s
}

// Summary information about a stream key.
type StreamKeySummary struct {
	_ struct{} `type:"structure"`

	// Stream-key ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Channel ARN for the stream.
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string"`

	// Tags attached to the resource. Array of 1-50 maps, each of the form string:string
	// (key:value). See Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for more information, including restrictions that apply to tags and "Tag
	// naming limits and requirements"; Amazon IVS has no service-specific constraints
	// beyond what is documented there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamKeySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamKeySummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StreamKeySummary) SetArn(v string) *StreamKeySummary {
	s.Arn = &v
	return s
}

// SetChannelArn sets the ChannelArn field's value.
func (s *StreamKeySummary) SetChannelArn(v string) *StreamKeySummary {
	s.ChannelArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StreamKeySummary) SetTags(v map[string]*string) *StreamKeySummary {
	s.Tags = v
	return s
}

// Object that captures the Amazon IVS configuration that the customer provisioned,
// the ingest configurations that the broadcaster used, and the most recent
// Amazon IVS stream events it encountered.
type StreamSession struct {
	_ struct{} `type:"structure"`

	// The properties of the channel at the time of going live.
	Channel *Channel `locationName:"channel" type:"structure"`

	// Time when the channel went offline. This is an ISO 8601 timestamp; note that
	// this is returned as a string. For live streams, this is NULL.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// The properties of the incoming RTMP stream for the stream.
	IngestConfiguration *IngestConfiguration `locationName:"ingestConfiguration" type:"structure"`

	// The properties of recording the live stream.
	RecordingConfiguration *RecordingConfiguration `locationName:"recordingConfiguration" type:"structure"`

	// Time when the channel went live. This is an ISO 8601 timestamp; note that
	// this is returned as a string.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// Unique identifier for a live or previously live stream in the specified channel.
	StreamId *string `locationName:"streamId" min:"26" type:"string"`

	// List of Amazon IVS events that the stream encountered. The list is sorted
	// by most recent events and contains up to 500 events. For Amazon IVS events,
	// see Using Amazon EventBridge with Amazon IVS (https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html).
	TruncatedEvents []*StreamEvent `locationName:"truncatedEvents" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamSession) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *StreamSession) SetChannel(v *Channel) *StreamSession {
	s.Channel = v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *StreamSession) SetEndTime(v time.Time) *StreamSession {
	s.EndTime = &v
	return s
}

// SetIngestConfiguration sets the IngestConfiguration field's value.
func (s *StreamSession) SetIngestConfiguration(v *IngestConfiguration) *StreamSession {
	s.IngestConfiguration = v
	return s
}

// SetRecordingConfiguration sets the RecordingConfiguration field's value.
func (s *StreamSession) SetRecordingConfiguration(v *RecordingConfiguration) *StreamSession {
	s.RecordingConfiguration = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *StreamSession) SetStartTime(v time.Time) *StreamSession {
	s.StartTime = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *StreamSession) SetStreamId(v string) *StreamSession {
	s.StreamId = &v
	return s
}

// SetTruncatedEvents sets the TruncatedEvents field's value.
func (s *StreamSession) SetTruncatedEvents(v []*StreamEvent) *StreamSession {
	s.TruncatedEvents = v
	return s
}

// Summary information about a stream session.
type StreamSessionSummary struct {
	_ struct{} `type:"structure"`

	// Time when the channel went offline. This is an ISO 8601 timestamp; note that
	// this is returned as a string. For live streams, this is NULL.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// If true, this stream encountered a quota breach or failure.
	HasErrorEvent *bool `locationName:"hasErrorEvent" type:"boolean"`

	// Time when the channel went live. This is an ISO 8601 timestamp; note that
	// this is returned as a string.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// Unique identifier for a live or previously live stream in the specified channel.
	StreamId *string `locationName:"streamId" min:"26" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamSessionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamSessionSummary) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *StreamSessionSummary) SetEndTime(v time.Time) *StreamSessionSummary {
	s.EndTime = &v
	return s
}

// SetHasErrorEvent sets the HasErrorEvent field's value.
func (s *StreamSessionSummary) SetHasErrorEvent(v bool) *StreamSessionSummary {
	s.HasErrorEvent = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *StreamSessionSummary) SetStartTime(v time.Time) *StreamSessionSummary {
	s.StartTime = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *StreamSessionSummary) SetStreamId(v string) *StreamSessionSummary {
	s.StreamId = &v
	return s
}

// Summary information about a stream.
type StreamSummary struct {
	_ struct{} `type:"structure"`

	// Channel ARN for the stream.
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string"`

	// The stream’s health.
	Health *string `locationName:"health" type:"string" enum:"StreamHealth"`

	// Time of the stream’s start. This is an ISO 8601 timestamp; note that this
	// is returned as a string.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// The stream’s state. Do not rely on the OFFLINE state, as the API may not
	// return it; instead, a "NotBroadcasting" error will indicate that the stream
	// is not live.
	State *string `locationName:"state" type:"string" enum:"StreamState"`

	// Unique identifier for a live or previously live stream in the specified channel.
	StreamId *string `locationName:"streamId" min:"26" type:"string"`

	// A count of concurrent views of the stream. Typically, a new view appears
	// in viewerCount within 15 seconds of when video playback starts and a view
	// is removed from viewerCount within 1 minute of when video playback ends.
	// A value of -1 indicates that the request timed out; in this case, retry.
	ViewerCount *int64 `locationName:"viewerCount" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamSummary) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *StreamSummary) SetChannelArn(v string) *StreamSummary {
	s.ChannelArn = &v
	return s
}

// SetHealth sets the Health field's value.
func (s *StreamSummary) SetHealth(v string) *StreamSummary {
	s.Health = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *StreamSummary) SetStartTime(v time.Time) *StreamSummary {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *StreamSummary) SetState(v string) *StreamSummary {
	s.State = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *StreamSummary) SetStreamId(v string) *StreamSummary {
	s.StreamId = &v
	return s
}

// SetViewerCount sets the ViewerCount field's value.
func (s *StreamSummary) SetViewerCount(v int64) *StreamSummary {
	s.ViewerCount = &v
	return s
}

type StreamUnavailable struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The stream is temporarily unavailable.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamUnavailable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamUnavailable) GoString() string {
	return s.String()
}

func newErrorStreamUnavailable(v protocol.ResponseMetadata) error {
	return &StreamUnavailable{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *StreamUnavailable) Code() string {
	return "StreamUnavailable"
}

// Message returns the exception's message.
func (s *StreamUnavailable) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *StreamUnavailable) OrigErr() error {
	return nil
}

func (s *StreamUnavailable) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *StreamUnavailable) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *StreamUnavailable) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ARN of the resource for which tags are to be added or updated. The ARN must
	// be URL-encoded.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// Array of tags to be added or updated. Array of maps, each of the form string:string
	// (key:value). See Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for more information, including restrictions that apply to tags and "Tag
	// naming limits and requirements"; Amazon IVS has no service-specific constraints
	// beyond what is documented there.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Request was denied due to request throttling.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object representing a configuration of thumbnails for recorded video.
type ThumbnailConfiguration struct {
	_ struct{} `type:"structure"`

	// Thumbnail recording mode. Default: INTERVAL.
	RecordingMode *string `locationName:"recordingMode" type:"string" enum:"RecordingMode"`

	// Indicates the desired resolution of recorded thumbnails. Thumbnails are recorded
	// at the selected resolution if the corresponding rendition is available during
	// the stream; otherwise, they are recorded at source resolution. For more information
	// about resolution values and their corresponding height and width dimensions,
	// see Auto-Record to Amazon S3 (https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html).
	// Default: Null (source resolution is returned).
	Resolution *string `locationName:"resolution" type:"string" enum:"ThumbnailConfigurationResolution"`

	// Indicates the format in which thumbnails are recorded. SEQUENTIAL records
	// all generated thumbnails in a serial manner, to the media/thumbnails directory.
	// LATEST saves the latest thumbnail in media/latest_thumbnail/thumb.jpg and
	// overwrites it at the interval specified by targetIntervalSeconds. You can
	// enable both SEQUENTIAL and LATEST. Default: SEQUENTIAL.
	Storage []*string `locationName:"storage" type:"list" enum:"ThumbnailConfigurationStorage"`

	// The targeted thumbnail-generation interval in seconds. This is configurable
	// (and required) only if recordingMode is INTERVAL. Default: 60.
	//
	// Important: For the BASIC channel type, setting a value for targetIntervalSeconds
	// does not guarantee that thumbnails are generated at the specified interval.
	// For thumbnails to be generated at the targetIntervalSeconds interval, the
	// IDR/Keyframe value for the input video must be less than the targetIntervalSeconds
	// value. See Amazon IVS Streaming Configuration (https://docs.aws.amazon.com/ivs/latest/userguide/streaming-config.html)
	// for information on setting IDR/Keyframe to the recommended value in video-encoder
	// settings.
	TargetIntervalSeconds *int64 `locationName:"targetIntervalSeconds" min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThumbnailConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThumbnailConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ThumbnailConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ThumbnailConfiguration"}
	if s.TargetIntervalSeconds != nil && *s.TargetIntervalSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TargetIntervalSeconds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecordingMode sets the RecordingMode field's value.
func (s *ThumbnailConfiguration) SetRecordingMode(v string) *ThumbnailConfiguration {
	s.RecordingMode = &v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *ThumbnailConfiguration) SetResolution(v string) *ThumbnailConfiguration {
	s.Resolution = &v
	return s
}

// SetStorage sets the Storage field's value.
func (s *ThumbnailConfiguration) SetStorage(v []*string) *ThumbnailConfiguration {
	s.Storage = v
	return s
}

// SetTargetIntervalSeconds sets the TargetIntervalSeconds field's value.
func (s *ThumbnailConfiguration) SetTargetIntervalSeconds(v int64) *ThumbnailConfiguration {
	s.TargetIntervalSeconds = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ARN of the resource for which tags are to be removed. The ARN must be URL-encoded.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// Array of tags to be removed. Array of maps, each of the form string:string
	// (key:value). See Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for more information, including restrictions that apply to tags and "Tag
	// naming limits and requirements"; Amazon IVS has no service-specific constraints
	// beyond what is documented there.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateChannelInput struct {
	_ struct{} `type:"structure"`

	// ARN of the channel to be updated.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Whether the channel is private (enabled for playback authorization).
	Authorized *bool `locationName:"authorized" type:"boolean"`

	// Whether the channel allows insecure RTMP ingest. Default: false.
	InsecureIngest *bool `locationName:"insecureIngest" type:"boolean"`

	// Channel latency mode. Use NORMAL to broadcast and deliver live video up to
	// Full HD. Use LOW for near-real-time interaction with viewers. (Note: In the
	// Amazon IVS console, LOW and NORMAL correspond to Ultra-low and Standard,
	// respectively.)
	LatencyMode *string `locationName:"latencyMode" type:"string" enum:"ChannelLatencyMode"`

	// Channel name.
	Name *string `locationName:"name" type:"string"`

	// Optional transcode preset for the channel. This is selectable only for ADVANCED_HD
	// and ADVANCED_SD channel types. For those channel types, the default preset
	// is HIGHER_BANDWIDTH_DELIVERY. For other channel types (BASIC and STANDARD),
	// preset is the empty string ("").
	Preset *string `locationName:"preset" type:"string" enum:"TranscodePreset"`

	// Recording-configuration ARN. If this is set to an empty string, recording
	// is disabled. A value other than an empty string indicates that recording
	// is enabled
	RecordingConfigurationArn *string `locationName:"recordingConfigurationArn" type:"string"`

	// Channel type, which determines the allowable resolution and bitrate. If you
	// exceed the allowable input resolution or bitrate, the stream probably will
	// disconnect immediately. Some types generate multiple qualities (renditions)
	// from the original input; this automatically gives viewers the best experience
	// for their devices and network conditions. Some types provide transcoded video;
	// transcoding allows higher playback quality across a range of download speeds.
	// Default: STANDARD. Valid values:
	//
	//    * BASIC: Video is transmuxed: Amazon IVS delivers the original input quality
	//    to viewers. The viewer’s video-quality choice is limited to the original
	//    input. Input resolution can be up to 1080p and bitrate can be up to 1.5
	//    Mbps for 480p and up to 3.5 Mbps for resolutions between 480p and 1080p.
	//    Original audio is passed through.
	//
	//    * STANDARD: Video is transcoded: multiple qualities are generated from
	//    the original input, to automatically give viewers the best experience
	//    for their devices and network conditions. Transcoding allows higher playback
	//    quality across a range of download speeds. Resolution can be up to 1080p
	//    and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions
	//    360p and below; above that, audio is passed through. This is the default
	//    when you create a channel.
	//
	//    * ADVANCED_SD: Video is transcoded; multiple qualities are generated from
	//    the original input, to automatically give viewers the best experience
	//    for their devices and network conditions. Input resolution can be up to
	//    1080p and bitrate can be up to 8.5 Mbps; output is capped at SD quality
	//    (480p). You can select an optional transcode preset (see below). Audio
	//    for all renditions is transcoded, and an audio-only rendition is available.
	//
	//    * ADVANCED_HD: Video is transcoded; multiple qualities are generated from
	//    the original input, to automatically give viewers the best experience
	//    for their devices and network conditions. Input resolution can be up to
	//    1080p and bitrate can be up to 8.5 Mbps; output is capped at HD quality
	//    (720p). You can select an optional transcode preset (see below). Audio
	//    for all renditions is transcoded, and an audio-only rendition is available.
	//
	// Optional transcode presets (available for the ADVANCED types) allow you to
	// trade off available download bandwidth and video quality, to optimize the
	// viewing experience. There are two presets:
	//
	//    * Constrained bandwidth delivery uses a lower bitrate for each quality
	//    level. Use it if you have low download bandwidth and/or simple video content
	//    (e.g., talking heads)
	//
	//    * Higher bandwidth delivery uses a higher bitrate for each quality level.
	//    Use it if you have high download bandwidth and/or complex video content
	//    (e.g., flashes and quick scene changes).
	Type *string `locationName:"type" type:"string" enum:"ChannelType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChannelInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateChannelInput) SetArn(v string) *UpdateChannelInput {
	s.Arn = &v
	return s
}

// SetAuthorized sets the Authorized field's value.
func (s *UpdateChannelInput) SetAuthorized(v bool) *UpdateChannelInput {
	s.Authorized = &v
	return s
}

// SetInsecureIngest sets the InsecureIngest field's value.
func (s *UpdateChannelInput) SetInsecureIngest(v bool) *UpdateChannelInput {
	s.InsecureIngest = &v
	return s
}

// SetLatencyMode sets the LatencyMode field's value.
func (s *UpdateChannelInput) SetLatencyMode(v string) *UpdateChannelInput {
	s.LatencyMode = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateChannelInput) SetName(v string) *UpdateChannelInput {
	s.Name = &v
	return s
}

// SetPreset sets the Preset field's value.
func (s *UpdateChannelInput) SetPreset(v string) *UpdateChannelInput {
	s.Preset = &v
	return s
}

// SetRecordingConfigurationArn sets the RecordingConfigurationArn field's value.
func (s *UpdateChannelInput) SetRecordingConfigurationArn(v string) *UpdateChannelInput {
	s.RecordingConfigurationArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateChannelInput) SetType(v string) *UpdateChannelInput {
	s.Type = &v
	return s
}

type UpdateChannelOutput struct {
	_ struct{} `type:"structure"`

	// Object specifying a channel.
	Channel *Channel `locationName:"channel" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelOutput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *UpdateChannelOutput) SetChannel(v *Channel) *UpdateChannelOutput {
	s.Channel = v
	return s
}

type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The input fails to satisfy the constraints specified by an Amazon Web Services
	// service.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Object specifying a stream’s video configuration, as set up by the broadcaster
// (usually in an encoder). This is part of the IngestConfiguration object and
// used for monitoring stream health.
type VideoConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates the degree of required decoder performance for a profile. Normally
	// this is set automatically by the encoder. For details, see the H.264 specification.
	AvcLevel *string `locationName:"avcLevel" type:"string"`

	// Indicates to the decoder the requirements for decoding the stream. For definitions
	// of the valid values, see the H.264 specification.
	AvcProfile *string `locationName:"avcProfile" type:"string"`

	// Codec used for the video encoding.
	Codec *string `locationName:"codec" type:"string"`

	// Software or hardware used to encode the video.
	Encoder *string `locationName:"encoder" type:"string"`

	// The expected ingest bitrate (bits per second). This is configured in the
	// encoder.
	TargetBitrate *int64 `locationName:"targetBitrate" type:"long"`

	// The expected ingest framerate. This is configured in the encoder.
	TargetFramerate *int64 `locationName:"targetFramerate" type:"long"`

	// Video-resolution height in pixels.
	VideoHeight *int64 `locationName:"videoHeight" type:"long"`

	// Video-resolution width in pixels.
	VideoWidth *int64 `locationName:"videoWidth" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VideoConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VideoConfiguration) GoString() string {
	return s.String()
}

// SetAvcLevel sets the AvcLevel field's value.
func (s *VideoConfiguration) SetAvcLevel(v string) *VideoConfiguration {
	s.AvcLevel = &v
	return s
}

// SetAvcProfile sets the AvcProfile field's value.
func (s *VideoConfiguration) SetAvcProfile(v string) *VideoConfiguration {
	s.AvcProfile = &v
	return s
}

// SetCodec sets the Codec field's value.
func (s *VideoConfiguration) SetCodec(v string) *VideoConfiguration {
	s.Codec = &v
	return s
}

// SetEncoder sets the Encoder field's value.
func (s *VideoConfiguration) SetEncoder(v string) *VideoConfiguration {
	s.Encoder = &v
	return s
}

// SetTargetBitrate sets the TargetBitrate field's value.
func (s *VideoConfiguration) SetTargetBitrate(v int64) *VideoConfiguration {
	s.TargetBitrate = &v
	return s
}

// SetTargetFramerate sets the TargetFramerate field's value.
func (s *VideoConfiguration) SetTargetFramerate(v int64) *VideoConfiguration {
	s.TargetFramerate = &v
	return s
}

// SetVideoHeight sets the VideoHeight field's value.
func (s *VideoConfiguration) SetVideoHeight(v int64) *VideoConfiguration {
	s.VideoHeight = &v
	return s
}

// SetVideoWidth sets the VideoWidth field's value.
func (s *VideoConfiguration) SetVideoWidth(v int64) *VideoConfiguration {
	s.VideoWidth = &v
	return s
}

const (
	// ChannelLatencyModeNormal is a ChannelLatencyMode enum value
	ChannelLatencyModeNormal = "NORMAL"

	// ChannelLatencyModeLow is a ChannelLatencyMode enum value
	ChannelLatencyModeLow = "LOW"
)

// ChannelLatencyMode_Values returns all elements of the ChannelLatencyMode enum
func ChannelLatencyMode_Values() []string {
	return []string{
		ChannelLatencyModeNormal,
		ChannelLatencyModeLow,
	}
}

const (
	// ChannelTypeBasic is a ChannelType enum value
	ChannelTypeBasic = "BASIC"

	// ChannelTypeStandard is a ChannelType enum value
	ChannelTypeStandard = "STANDARD"

	// ChannelTypeAdvancedSd is a ChannelType enum value
	ChannelTypeAdvancedSd = "ADVANCED_SD"

	// ChannelTypeAdvancedHd is a ChannelType enum value
	ChannelTypeAdvancedHd = "ADVANCED_HD"
)

// ChannelType_Values returns all elements of the ChannelType enum
func ChannelType_Values() []string {
	return []string{
		ChannelTypeBasic,
		ChannelTypeStandard,
		ChannelTypeAdvancedSd,
		ChannelTypeAdvancedHd,
	}
}

const (
	// RecordingConfigurationStateCreating is a RecordingConfigurationState enum value
	RecordingConfigurationStateCreating = "CREATING"

	// RecordingConfigurationStateCreateFailed is a RecordingConfigurationState enum value
	RecordingConfigurationStateCreateFailed = "CREATE_FAILED"

	// RecordingConfigurationStateActive is a RecordingConfigurationState enum value
	RecordingConfigurationStateActive = "ACTIVE"
)

// RecordingConfigurationState_Values returns all elements of the RecordingConfigurationState enum
func RecordingConfigurationState_Values() []string {
	return []string{
		RecordingConfigurationStateCreating,
		RecordingConfigurationStateCreateFailed,
		RecordingConfigurationStateActive,
	}
}

const (
	// RecordingModeDisabled is a RecordingMode enum value
	RecordingModeDisabled = "DISABLED"

	// RecordingModeInterval is a RecordingMode enum value
	RecordingModeInterval = "INTERVAL"
)

// RecordingMode_Values returns all elements of the RecordingMode enum
func RecordingMode_Values() []string {
	return []string{
		RecordingModeDisabled,
		RecordingModeInterval,
	}
}

const (
	// RenditionConfigurationRenditionFullHd is a RenditionConfigurationRendition enum value
	RenditionConfigurationRenditionFullHd = "FULL_HD"

	// RenditionConfigurationRenditionHd is a RenditionConfigurationRendition enum value
	RenditionConfigurationRenditionHd = "HD"

	// RenditionConfigurationRenditionSd is a RenditionConfigurationRendition enum value
	RenditionConfigurationRenditionSd = "SD"

	// RenditionConfigurationRenditionLowestResolution is a RenditionConfigurationRendition enum value
	RenditionConfigurationRenditionLowestResolution = "LOWEST_RESOLUTION"
)

// RenditionConfigurationRendition_Values returns all elements of the RenditionConfigurationRendition enum
func RenditionConfigurationRendition_Values() []string {
	return []string{
		RenditionConfigurationRenditionFullHd,
		RenditionConfigurationRenditionHd,
		RenditionConfigurationRenditionSd,
		RenditionConfigurationRenditionLowestResolution,
	}
}

const (
	// RenditionConfigurationRenditionSelectionAll is a RenditionConfigurationRenditionSelection enum value
	RenditionConfigurationRenditionSelectionAll = "ALL"

	// RenditionConfigurationRenditionSelectionNone is a RenditionConfigurationRenditionSelection enum value
	RenditionConfigurationRenditionSelectionNone = "NONE"

	// RenditionConfigurationRenditionSelectionCustom is a RenditionConfigurationRenditionSelection enum value
	RenditionConfigurationRenditionSelectionCustom = "CUSTOM"
)

// RenditionConfigurationRenditionSelection_Values returns all elements of the RenditionConfigurationRenditionSelection enum
func RenditionConfigurationRenditionSelection_Values() []string {
	return []string{
		RenditionConfigurationRenditionSelectionAll,
		RenditionConfigurationRenditionSelectionNone,
		RenditionConfigurationRenditionSelectionCustom,
	}
}

const (
	// StreamHealthHealthy is a StreamHealth enum value
	StreamHealthHealthy = "HEALTHY"

	// StreamHealthStarving is a StreamHealth enum value
	StreamHealthStarving = "STARVING"

	// StreamHealthUnknown is a StreamHealth enum value
	StreamHealthUnknown = "UNKNOWN"
)

// StreamHealth_Values returns all elements of the StreamHealth enum
func StreamHealth_Values() []string {
	return []string{
		StreamHealthHealthy,
		StreamHealthStarving,
		StreamHealthUnknown,
	}
}

const (
	// StreamStateLive is a StreamState enum value
	StreamStateLive = "LIVE"

	// StreamStateOffline is a StreamState enum value
	StreamStateOffline = "OFFLINE"
)

// StreamState_Values returns all elements of the StreamState enum
func StreamState_Values() []string {
	return []string{
		StreamStateLive,
		StreamStateOffline,
	}
}

const (
	// ThumbnailConfigurationResolutionFullHd is a ThumbnailConfigurationResolution enum value
	ThumbnailConfigurationResolutionFullHd = "FULL_HD"

	// ThumbnailConfigurationResolutionHd is a ThumbnailConfigurationResolution enum value
	ThumbnailConfigurationResolutionHd = "HD"

	// ThumbnailConfigurationResolutionSd is a ThumbnailConfigurationResolution enum value
	ThumbnailConfigurationResolutionSd = "SD"

	// ThumbnailConfigurationResolutionLowestResolution is a ThumbnailConfigurationResolution enum value
	ThumbnailConfigurationResolutionLowestResolution = "LOWEST_RESOLUTION"
)

// ThumbnailConfigurationResolution_Values returns all elements of the ThumbnailConfigurationResolution enum
func ThumbnailConfigurationResolution_Values() []string {
	return []string{
		ThumbnailConfigurationResolutionFullHd,
		ThumbnailConfigurationResolutionHd,
		ThumbnailConfigurationResolutionSd,
		ThumbnailConfigurationResolutionLowestResolution,
	}
}

const (
	// ThumbnailConfigurationStorageSequential is a ThumbnailConfigurationStorage enum value
	ThumbnailConfigurationStorageSequential = "SEQUENTIAL"

	// ThumbnailConfigurationStorageLatest is a ThumbnailConfigurationStorage enum value
	ThumbnailConfigurationStorageLatest = "LATEST"
)

// ThumbnailConfigurationStorage_Values returns all elements of the ThumbnailConfigurationStorage enum
func ThumbnailConfigurationStorage_Values() []string {
	return []string{
		ThumbnailConfigurationStorageSequential,
		ThumbnailConfigurationStorageLatest,
	}
}

const (
	// TranscodePresetHigherBandwidthDelivery is a TranscodePreset enum value
	TranscodePresetHigherBandwidthDelivery = "HIGHER_BANDWIDTH_DELIVERY"

	// TranscodePresetConstrainedBandwidthDelivery is a TranscodePreset enum value
	TranscodePresetConstrainedBandwidthDelivery = "CONSTRAINED_BANDWIDTH_DELIVERY"
)

// TranscodePreset_Values returns all elements of the TranscodePreset enum
func TranscodePreset_Values() []string {
	return []string{
		TranscodePresetHigherBandwidthDelivery,
		TranscodePresetConstrainedBandwidthDelivery,
	}
}
