/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.changedetection.state.FileSystemSnapshotter;
import org.gradle.api.internal.file.TaskFileVarFactory;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.tasks.LifecycleAwareTaskProperty;
import org.gradle.api.provider.Provider;
import org.gradle.cache.PersistentStateCache;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.CompilationStateCacheFactory;
import org.gradle.language.nativeplatform.internal.incremental.DefaultHeaderDependenciesCollector;
import org.gradle.language.nativeplatform.internal.incremental.DefaultSourceIncludesParser;
import org.gradle.language.nativeplatform.internal.incremental.DefaultSourceIncludesResolver;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilation;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompileFilesFactory;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompileProcessor;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilerBuilder;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalNativeCompiler;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.CSourceParser;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;

public class DefaultIncrementalCompilerBuilder
implements IncrementalCompilerBuilder {
    private final FileSystemSnapshotter fileSystemSnapshotter;
    private final CompilationStateCacheFactory compilationStateCacheFactory;
    private final CSourceParser sourceParser;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final TaskFileVarFactory fileVarFactory;
    private final BuildOperationExecutor buildOperationExecutor;

    public DefaultIncrementalCompilerBuilder(FileSystemSnapshotter fileSystemSnapshotter, CompilationStateCacheFactory compilationStateCacheFactory, CSourceParser sourceParser, DirectoryFileTreeFactory directoryFileTreeFactory, TaskFileVarFactory fileVarFactory, BuildOperationExecutor buildOperationExecutor) {
        this.fileSystemSnapshotter = fileSystemSnapshotter;
        this.compilationStateCacheFactory = compilationStateCacheFactory;
        this.sourceParser = sourceParser;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.fileVarFactory = fileVarFactory;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public IncrementalCompilerBuilder.IncrementalCompiler newCompiler(TaskInternal task, FileCollection sourceFiles, FileCollection includeDirs, Provider<Boolean> importAware) {
        return new StateCollectingIncrementalCompiler(task, includeDirs, sourceFiles, this.fileSystemSnapshotter, this.compilationStateCacheFactory, this.sourceParser, this.directoryFileTreeFactory, this.fileVarFactory, this.buildOperationExecutor, importAware);
    }

    private static class StateCollectingIncrementalCompiler
    implements IncrementalCompilerBuilder.IncrementalCompiler,
    MinimalFileSet,
    LifecycleAwareTaskProperty {
        private final FileSystemSnapshotter fileSystemSnapshotter;
        private final CompilationStateCacheFactory compilationStateCacheFactory;
        private final CSourceParser sourceParser;
        private final DirectoryFileTreeFactory directoryFileTreeFactory;
        private final BuildOperationExecutor buildOperationExecutor;
        private final TaskOutputsInternal taskOutputs;
        private final FileCollection includeDirs;
        private final String taskPath;
        private final FileCollection sourceFiles;
        private final FileCollection headerFilesCollection;
        private final Provider<Boolean> importAware;
        private PersistentStateCache<CompilationState> compileStateCache;
        private IncrementalCompilation incrementalCompilation;

        StateCollectingIncrementalCompiler(TaskInternal task, FileCollection includeDirs, FileCollection sourceFiles, FileSystemSnapshotter fileSystemSnapshotter, CompilationStateCacheFactory compilationStateCacheFactory, CSourceParser sourceParser, DirectoryFileTreeFactory directoryFileTreeFactory, TaskFileVarFactory fileVarFactory, BuildOperationExecutor buildOperationExecutor, Provider<Boolean> importAware) {
            this.taskOutputs = task.getOutputs();
            this.taskPath = task.getPath();
            this.includeDirs = includeDirs;
            this.sourceFiles = sourceFiles;
            this.fileSystemSnapshotter = fileSystemSnapshotter;
            this.compilationStateCacheFactory = compilationStateCacheFactory;
            this.sourceParser = sourceParser;
            this.directoryFileTreeFactory = directoryFileTreeFactory;
            this.buildOperationExecutor = buildOperationExecutor;
            this.importAware = importAware;
            this.headerFilesCollection = fileVarFactory.newCalculatedInputFileCollection((Task)task, (MinimalFileSet)this, new FileCollection[]{sourceFiles, includeDirs});
        }

        @Override
        public <T extends NativeCompileSpec> Compiler<T> createCompiler(Compiler<T> compiler) {
            if (this.incrementalCompilation == null) {
                throw new IllegalStateException("Header files should be calculated before compiler is created.");
            }
            return new IncrementalNativeCompiler<T>(this.taskOutputs, compiler, this.compileStateCache, this.incrementalCompilation);
        }

        public Set<File> getFiles() {
            ImmutableList includeRoots = ImmutableList.copyOf((Iterable)this.includeDirs);
            this.compileStateCache = this.compilationStateCacheFactory.create(this.taskPath);
            DefaultSourceIncludesParser sourceIncludesParser = new DefaultSourceIncludesParser(this.sourceParser, (Boolean)this.importAware.get());
            DefaultSourceIncludesResolver dependencyParser = new DefaultSourceIncludesResolver((List<File>)includeRoots, this.fileSystemSnapshotter);
            IncrementalCompileFilesFactory incrementalCompileFilesFactory = new IncrementalCompileFilesFactory(sourceIncludesParser, dependencyParser, this.fileSystemSnapshotter);
            IncrementalCompileProcessor incrementalCompileProcessor = new IncrementalCompileProcessor(this.compileStateCache, incrementalCompileFilesFactory, this.buildOperationExecutor);
            this.incrementalCompilation = incrementalCompileProcessor.processSourceFiles(this.sourceFiles.getFiles());
            DefaultHeaderDependenciesCollector headerDependenciesCollector = new DefaultHeaderDependenciesCollector(this.directoryFileTreeFactory);
            return headerDependenciesCollector.collectExistingHeaderDependencies(this.taskPath, (List<File>)includeRoots, this.incrementalCompilation);
        }

        public void prepareValue() {
        }

        public void cleanupValue() {
            this.compileStateCache = null;
            this.incrementalCompilation = null;
        }

        public String getDisplayName() {
            return "header files for " + this.taskPath;
        }

        @Override
        public FileCollection getHeaderFiles() {
            return this.headerFilesCollection;
        }
    }
}

