/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.gradle.cache.CleanableStore;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.cache.internal.NonReservedFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCacheCleanup
implements CleanupAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCacheCleanup.class);
    private final FilesFinder eligibleFilesFinder;

    public AbstractCacheCleanup(FilesFinder eligibleFilesFinder) {
        this.eligibleFilesFinder = eligibleFilesFinder;
    }

    @Override
    public void clean(CleanableStore cleanableStore, CleanupProgressMonitor progressMonitor) {
        int filesDeleted = 0;
        for (File file : this.findEligibleFiles(cleanableStore)) {
            if (this.shouldDelete(file)) {
                progressMonitor.incrementDeleted();
                if (!FileUtils.deleteQuietly((File)file)) continue;
                this.handleDeletion(file);
                filesDeleted += 1 + this.deleteEmptyParentDirectories(cleanableStore.getBaseDir(), file.getParentFile());
                continue;
            }
            progressMonitor.incrementSkipped();
        }
        LOGGER.debug("{} cleanup deleted {} files/directories.", (Object)cleanableStore.getDisplayName(), (Object)filesDeleted);
    }

    protected int deleteEmptyParentDirectories(File baseDir, File dir) {
        if (dir.equals(baseDir)) {
            return 0;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length == 0 && dir.delete()) {
            this.handleDeletion(dir);
            return 1 + this.deleteEmptyParentDirectories(baseDir, dir.getParentFile());
        }
        return 0;
    }

    protected abstract boolean shouldDelete(File var1);

    protected abstract void handleDeletion(File var1);

    private Iterable<File> findEligibleFiles(CleanableStore cleanableStore) {
        return this.eligibleFilesFinder.find(cleanableStore.getBaseDir(), new NonReservedFileFilter(cleanableStore.getReservedCacheFiles()));
    }
}

