/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;

public class ArrayAccessTranslator
extends AbstractTranslator
implements AccessTranslator {
    @NotNull
    private final KtArrayAccessExpression expression;

    static ArrayAccessTranslator newInstance(@NotNull KtArrayAccessExpression expression2, @NotNull TranslationContext context) {
        return new ArrayAccessTranslator(expression2, context);
    }

    private ArrayAccessTranslator(@NotNull KtArrayAccessExpression expression2, @NotNull TranslationContext context) {
        super(context);
        this.expression = expression2;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        return this.translateAsGet(this.getArrayExpression());
    }

    @NotNull
    protected JsExpression translateAsGet(@NotNull JsExpression arrayExpression) {
        return this.translateAsMethodCall(arrayExpression, null);
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        return this.translateAsMethodCall(this.getArrayExpression(), setTo);
    }

    @NotNull
    private JsExpression translateAsMethodCall(@NotNull JsExpression arrayExpression, @Nullable JsExpression toSetTo) {
        boolean isGetter = toSetTo == null;
        TranslationContext context = this.context();
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getResolvedCallForArrayAccess(this.bindingContext(), this.expression, isGetter);
        if (!isGetter) {
            context = this.contextWithValueParameterAliasInArrayGetAccess(toSetTo);
        }
        return CallTranslator.translate(context, resolvedCall2, arrayExpression);
    }

    @NotNull
    protected JsExpression getArrayExpression() {
        KtExpression arrayExpression = this.expression.getArrayExpression();
        assert (arrayExpression != null) : "Code with parsing errors shouldn't be translated";
        return Translation.translateAsExpression(arrayExpression, this.context());
    }

    @NotNull
    private TranslationContext contextWithValueParameterAliasInArrayGetAccess(@NotNull JsExpression toSetTo) {
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getResolvedCallForArrayAccess(this.bindingContext(), this.expression, false);
        List<ResolvedValueArgument> arguments2 = resolvedCall2.getValueArgumentsByIndex();
        if (arguments2 == null) {
            throw new IllegalStateException("Failed to arrange value arguments by index: " + resolvedCall2.getResultingDescriptor());
        }
        ResolvedValueArgument lastArgument = arguments2.get(arguments2.size() - 1);
        assert (lastArgument instanceof ExpressionValueArgument) : "Last argument of array-like setter must be ExpressionValueArgument: " + lastArgument;
        ValueArgument valueArgument = ((ExpressionValueArgument)lastArgument).getValueArgument();
        assert (valueArgument != null);
        KtExpression element = valueArgument.getArgumentExpression();
        return this.context().innerContextWithAliasesForExpressions(Collections.singletonMap(element, toSetTo));
    }

    @Override
    @NotNull
    public AccessTranslator getCached() {
        HashMap<KtExpression, JsExpression> aliases = new HashMap<KtExpression, JsExpression>();
        JsExpression arrayExpression = this.context().cacheExpressionIfNeeded(this.getArrayExpression());
        aliases.put(this.expression.getArrayExpression(), arrayExpression);
        for (KtExpression ktExpression : this.expression.getIndexExpressions()) {
            JsExpression jsExpression = this.context().cacheExpressionIfNeeded(Translation.translateAsExpression(ktExpression, this.context()));
            aliases.put(ktExpression, jsExpression);
        }
        return new CachedArrayAccessTranslator(this.expression, this.context().innerContextWithAliasesForExpressions(aliases), arrayExpression);
    }

    private static class CachedArrayAccessTranslator
    extends ArrayAccessTranslator {
        @NotNull
        private final JsExpression arrayExpression;

        protected CachedArrayAccessTranslator(@NotNull KtArrayAccessExpression expression2, @NotNull TranslationContext context, @NotNull JsExpression arrayExpression) {
            super(expression2, context);
            this.arrayExpression = arrayExpression;
        }

        @Override
        @NotNull
        protected JsExpression getArrayExpression() {
            return this.arrayExpression;
        }

        @Override
        @NotNull
        public AccessTranslator getCached() {
            return this;
        }
    }
}

