+++
dep = 1
title = "DEP Purpose and Guidelines"
authors = [ "Matt Fisher <matt.fisher@microsoft.com>" ]
created = 2017-10-18
+++

# Introduction

DEP stands for Draft Enhancement Proposal. A DEP is a design document providing information to the Draft community, or describing a new feature for Draft or its processes or environment. The DEP should provide a concise technical specification of the feature and a rationale for the feature.

We intend DEPs to be the primary mechanisms for proposing major new features, for collecting community input on an issue, and for documenting the design decisions that have gone into Draft. The DEP author is responsible for building consensus within the community and documenting dissenting opinions.

The system is heavily influenced by Python's Enhancement Proposal (PEP) system, hence the name. Given that Draft is a much (MUCH) smaller project than Python, there are a few changes in the DEP workflow to make it a looser format for proposals, most notably the lack of DEP "editors", a BDFL and a much smaller review & resolution cycle for proposals.

Because the DEPs are maintained as markdown files in a versioned repository, their revision history is the historical record of the proposal.

# DEP Workflow

## Start with an idea for Draft

The DEP process begins with a new idea for Draft. It is highly recommended that a single DEP contain a single key proposal or new idea. Small enhancements or patches often don't need a DEP and can be injected into the Draft development workflow with a patch submission to [the Draft issue tracker][1]. The more focused the DEP, the more successful it tends to be. The Draft mantainers reserve the right to reject DEP proposals if they appear too unfocused or too broad. If in doubt, split your DEP into several well-focused ones.

Each DEP must have a champion -- someone who writes the DEP using the style and format described below, shepherds the discussions in the appropriate communication channels, and attempts to build community consensus around the idea. The DEP champion (a.k.a. author) should first attempt to ascertain whether the idea is DEP-able. Posting to the draft-users mailing list is the best way to go about this.

Vetting an idea publicly before going as far as writing a DEP is meant to save the potential author time. Many ideas have been brought forward for changing Draft that have been rejected for various reasons. Asking the Draft community first if an idea is original helps prevent too much time being spent on something that is guaranteed to be rejected based on prior discussions (searching the internet does not always do the trick). It also helps to make sure the idea is applicable to the entire community and not just the author. Just because an idea sounds good to the author does not mean it will work for most people in most areas where Draft is used.

Once the champion has asked the Draft community as to whether an idea has any chance of acceptance, a draft of the DEP should be presented to draft-users. This gives the author a chance to flesh out the DEP as a high quality, well-formatted proposal, and to address initial concerns about the proposal.

## Submitting a DEP

Following a discussion on draft-users, the proposal should be submitted as a DEP via a [GitHub pull request][2]. The draft must be written in DEP style as described below, else it will fail review immediately (although minor errors may be corrected by the maintainers).
The standard DEP workflow is:

- You, as the DEP author, fork the Draft repostitory and create a new DEP
- Push this to your GitHub fork and [submit a pull request][2].

Once the review process is complete, the Draft core maintainers will approve it (note that this is not the same as accepting your DEP!)

The core maintainers will not unreasonably deny a DEP. Reasons for denying DEP status include duplication of effort, being technically unsound, not providing proper motivation or addressing backwards compatibility, or not in keeping with [Draft's design][3]. The core maintainers can be consulted during the approval phase.

Once approved, DEP authors are responsible for collecting community feedback on a DEP before submitting a feature taht satisfies the DEP for review. However, wherever possible, long open-ended discussions on public mailing lists should be avoided. Strategies to keep the discussions efficient include: setting up a separate meetings for the topic, having the DEP author accept private comments in the early design phases, setting up a wiki page, etc. DEP authors should use their discretion here.

# What belongs in a successful DEP

Each DEP should have the following parts:

1. Preamble - TOML style headers containing metadata about the DEP, including the DEP number, a short descriptive title, the author names, etc.
1. Abstract - a short (~200 word) description of the technical issue being addressed.
1. Specification - The technical specification should describe the syntax and semantics of any new feature. The specification should be detailed enough to allow competing, interoperable implementations for at least the current major cloud platforms (Azure, GKE, AWS)
1. Motivation - The motivation is critical for DEPs that want to change Draft in a significant way. It should clearly explain why existing features are inadequate to address the problem that the DEP solves. DEP submissions without sufficient motivation may be rejected outright.
1. Rationale - The rationale fleshes out the specification by describing what motivated the design and why particular design decisions were made. It should describe alternate designs that were considered and related work, e.g. how the feature is supported in other projects.
1. Backwards Compatibility - All DEPs that introduce backwards incompatibilities must include a section describing these incompatibilities and their severity. The DEP must explain how the author proposes to deal with these incompatibilities. DEP submissions without a sufficient backwards compatibility treatise may be rejected outright.
1. Reference Implementation - The reference implementation must be completed before any DEP is given status "Final", but it need not be completed before the DEP is accepted. While there is merit to the approach of reaching consensus on the specification and rationale before writing code, the principle of "rough consensus and running code" is still useful when it comes to resolving many discussions of API details.

The final implementation must include test code and documentation appropriate for Draft project reference or the community at large.

# DEP Header Preamble

Each DEP must begin with a [TOML][5] style header preamble. The headers must appear in the following order. Headers marked with "*" are optional and are described below. All other headers are required.

```toml
+++
dep = <dep number>
title = "<dep title>"
authors = [ "<list of authors' real names and optionally, email addrs>" ]
created = 2017-10-18
* draft-version = "<version number>"
* requires = [ <dep numbers> ]
* replaces = <dep number>
* superseded-by = <dep number>
+++
```

The `authors` header lists the names, and optionally the email addresses of all the authors/owners of the DEP. The format of the author header value must be

```toml
authors = [ "John Doe <john@example.com>", "Jane Doe <jane@example.com>" ]
```

If the email address is included, and

```toml
authors = [ "John Doe", "Jane Doe" ]
```

If the address is not given.

The `created` header records the date that the DEP was published to the Draft project on Github. The header should be in [RFC 3339][6] format, e.g. 2017-10-18.

DEPs will typically have a `draft-version` header which indicates the version of Draft that the feature will be released with. DEPs without a `draft-version` header indicate interoperability standards that will initially be supported through external libraries and tools, and then supplemented by a later DEP to add support to the project's standard library or Command Line Interface. Informational and process DEPs do not need a `draft-version` header.

DEPs may have a `requires` header, indicating the DEP numbers that this DEP depends on.

DEPs may also have a `superseded-by` header indicating that a DEP has been rendered obsolete by a later document; the value is the number of the DEP that replaces the current document. The newer DEP must have a `replaces` header containing the number of the DEP that it rendered obsolete.

# Auxiliary Files

DEPs may include auxiliary files such as diagrams. Such files must be named dep-XXX-YY.ext, where "XXX" is the DEP number, "YY" is a serial number (starting at 01), and "ext" is replaced by the actual file extension (e.g. "png").

# Transferring DEP Ownership

It occasionally becomes necessary to transfer ownership of DEPs to a new champion. In general, it is preferable to retain the original author as a co-author of the transferred DEP, but that's really up to the original author. A good reason to transfer ownership is because the original author no longer has the time or interest in updating it or following through with the DEP process, or has fallen off the face of the earth (i.e. is unreachable or not responding to email). A bad reason to transfer ownership is because the author doesn't agree with the direction of the DEP. One aim of the DEP process is to try to build consensus around a DEP, but if that's not possible, an author can always submit a competing DEP.

If you are interested in assuming ownership of a DEP, you can also do this via pull request. Fork the Draft project, make your ownership modification, and submit a pull request. You should also send a message asking to take over, addressed to both the original author and the core maintainers <draft-maintainers@microsoft.com>. If the original author doesn't respond to email in a timely manner, the core maintainers will make a unilateral decision. It's not like these decisions can't be reversed) :).

[1]: https://github.com/Azure/draft/issues
[2]: https://github.com/Azure/draft/pulls
[3]: dep-002.md
[4]: http://www.opencontent.org/openpub/
[5]: https://github.com/toml-lang/toml
[6]: https://tools.ietf.org/html/rfc3339
