// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/filters/http/bandwidth_limit/v3/bandwidth_limit.proto

package bandwidth_limitv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on BandwidthLimit with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *BandwidthLimit) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BandwidthLimit with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in BandwidthLimitMultiError,
// or nil if none found.
func (m *BandwidthLimit) ValidateAll() error {
	return m.validate(true)
}

func (m *BandwidthLimit) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetStatPrefix()) < 1 {
		err := BandwidthLimitValidationError{
			field:  "StatPrefix",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if _, ok := BandwidthLimit_EnableMode_name[int32(m.GetEnableMode())]; !ok {
		err := BandwidthLimitValidationError{
			field:  "EnableMode",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if wrapper := m.GetLimitKbps(); wrapper != nil {

		if wrapper.GetValue() < 1 {
			err := BandwidthLimitValidationError{
				field:  "LimitKbps",
				reason: "value must be greater than or equal to 1",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if d := m.GetFillInterval(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = BandwidthLimitValidationError{
				field:  "FillInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			lte := time.Duration(1*time.Second + 0*time.Nanosecond)
			gte := time.Duration(0*time.Second + 20000000*time.Nanosecond)

			if dur < gte || dur > lte {
				err := BandwidthLimitValidationError{
					field:  "FillInterval",
					reason: "value must be inside range [20ms, 1s]",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if all {
		switch v := interface{}(m.GetRuntimeEnabled()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BandwidthLimitValidationError{
					field:  "RuntimeEnabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BandwidthLimitValidationError{
					field:  "RuntimeEnabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRuntimeEnabled()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BandwidthLimitValidationError{
				field:  "RuntimeEnabled",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for EnableResponseTrailers

	// no validation rules for ResponseTrailerPrefix

	if len(errors) > 0 {
		return BandwidthLimitMultiError(errors)
	}

	return nil
}

// BandwidthLimitMultiError is an error wrapping multiple validation errors
// returned by BandwidthLimit.ValidateAll() if the designated constraints
// aren't met.
type BandwidthLimitMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BandwidthLimitMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BandwidthLimitMultiError) AllErrors() []error { return m }

// BandwidthLimitValidationError is the validation error returned by
// BandwidthLimit.Validate if the designated constraints aren't met.
type BandwidthLimitValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BandwidthLimitValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BandwidthLimitValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BandwidthLimitValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BandwidthLimitValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BandwidthLimitValidationError) ErrorName() string { return "BandwidthLimitValidationError" }

// Error satisfies the builtin error interface
func (e BandwidthLimitValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBandwidthLimit.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BandwidthLimitValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BandwidthLimitValidationError{}
