/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.plugins.wifi101;

import cc.arduino.plugins.wifi101.flashers.Flasher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import processing.app.Theme;

public class UpdaterJFrame
extends JFrame {
    private JPanel contentPane;
    private JList<String> serialPortList;
    private JComboBox<Flasher> firmwareSelector;
    private JProgressBar updateProgressBar;
    private JButton removeCertificateButton;
    private JList<String> certSelector;
    private JPanel panel_2;
    private JPanel panel;
    private JPanel panel_1;
    private JLabel textArea;
    private JLabel textFwNot;
    private JButton uploadCertificatesButton;
    private JButton addCertificateButton;
    private JButton updateFirmwareButton;
    private JButton testConnectionButton;
    private JButton openFirmwareUpdaterSketchButton;

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UpdaterJFrame updaterJFrame = new UpdaterJFrame();
                    updaterJFrame.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public UpdaterJFrame() {
        int n = Theme.getScale();
        this.setTitle("WiFi101 / WiFiNINA Firmware/Certificates Updater");
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setBounds(100 * n / 100, 100 * n / 100, 500 * n / 100, 520 * n / 100);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, 1.0, 1.0, 0.0, Double.MIN_VALUE};
        this.contentPane.setLayout(gridBagLayout);
        this.panel_1 = new JPanel();
        this.panel_1.setBorder(new TitledBorder(null, "1. Select port of the WiFi module", 4, 2, null, null));
        this.panel_1.setMinimumSize(new Dimension(500 * n / 100, 150 * n / 100));
        this.panel_1.setPreferredSize(new Dimension(500 * n / 100, 150 * n / 100));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.contentPane.add((Component)this.panel_1, gridBagConstraints);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        gridBagLayout2.columnWidths = new int[]{0, 0, 0};
        gridBagLayout2.rowHeights = new int[]{0, 0, 0, 0};
        gridBagLayout2.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout2.rowWeights = new double[]{1.0, 1.0, 0.0, Double.MIN_VALUE};
        this.panel_1.setLayout(gridBagLayout2);
        JLabel jLabel = new JLabel("If the port is not listed click \"Refresh list\" button to regenerate the list");
        jLabel.setOpaque(false);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        this.panel_1.add((Component)jLabel, gridBagConstraints2);
        this.serialPortList = new JList();
        JScrollPane jScrollPane = new JScrollPane(this.serialPortList);
        this.serialPortList.setMaximumSize(new Dimension(300 * n / 100, 100 * n / 100));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridheight = 5;
        this.panel_1.add((Component)jScrollPane, gridBagConstraints3);
        this.serialPortList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                UpdaterJFrame.this.SelectBoardModule();
            }
        });
        JButton jButton = new JButton("Refresh list");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdaterJFrame.this.refreshSerialPortList();
            }
        });
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 2;
        this.panel_1.add((Component)jButton, gridBagConstraints4);
        this.testConnectionButton = new JButton("Test connection");
        this.testConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdaterJFrame.this.testConnection();
            }
        });
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 3;
        this.panel_1.add((Component)this.testConnectionButton, gridBagConstraints5);
        this.openFirmwareUpdaterSketchButton = new JButton("Open Updater sketch");
        this.openFirmwareUpdaterSketchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdaterJFrame.this.openFirmwareUpdaterSketch();
            }
        });
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.gridy = 1;
        this.panel_1.add((Component)this.openFirmwareUpdaterSketchButton, gridBagConstraints6);
        this.panel = new JPanel();
        this.panel.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "2. Update firmware", 4, 2, null, new Color(51, 51, 51)));
        this.panel.setMinimumSize(new Dimension(500 * n / 100, 150 * n / 100));
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints7.fill = 1;
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 1;
        this.contentPane.add((Component)this.panel, gridBagConstraints7);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        gridBagLayout3.columnWidths = new int[]{0, 0};
        gridBagLayout3.rowHeights = new int[]{0, 0, 0, 0};
        gridBagLayout3.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout3.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.panel.setLayout(gridBagLayout3);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Select the firmware from the dropdown box below");
        jLabel2.setOpaque(false);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints8.fill = 1;
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridy = 1;
        this.panel.add((Component)jLabel2, gridBagConstraints8);
        this.firmwareSelector = new JComboBox();
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints9.fill = 2;
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 2;
        this.panel.add(this.firmwareSelector, gridBagConstraints9);
        this.firmwareSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdaterJFrame.this.updateCertSection();
            }
        });
        this.updateFirmwareButton = new JButton("Update Firmware");
        this.updateFirmwareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdaterJFrame.this.updateFirmware();
            }
        });
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints10.gridx = 0;
        gridBagConstraints10.gridy = 3;
        this.panel.add((Component)this.updateFirmwareButton, gridBagConstraints10);
        this.panel_2 = new JPanel();
        this.panel_2.setBorder(new TitledBorder(null, "3. Update SSL root certificates", 1, 2, null, null));
        this.panel_2.setMinimumSize(new Dimension(500 * n / 100, 200 * n / 100));
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints11.fill = 1;
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 2;
        this.contentPane.add((Component)this.panel_2, gridBagConstraints11);
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        gridBagLayout4.columnWidths = new int[]{0, 0};
        gridBagLayout4.rowHeights = new int[]{0, 0, 0, 0, 0};
        gridBagLayout4.columnWeights = new double[]{1.0, 0.0};
        gridBagLayout4.rowWeights = new double[]{1.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        this.panel_2.setLayout(gridBagLayout4);
        this.textArea = new JLabel();
        this.textArea.setText("Add domains in the list below using \"Add domain\" button");
        this.textArea.setOpaque(false);
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridwidth = 2;
        gridBagConstraints12.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints12.fill = 1;
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.gridy = 0;
        this.panel_2.add((Component)this.textArea, gridBagConstraints12);
        this.textFwNot = new JLabel();
        this.textFwNot.setText("No certificates available");
        this.textFwNot.setOpaque(false);
        this.textFwNot.setMinimumSize(new Dimension(500 * n / 100, 500 * n / 100));
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridwidth = 2;
        gridBagConstraints13.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints13.fill = 1;
        gridBagConstraints13.gridx = 0;
        gridBagConstraints13.gridy = 0;
        this.panel_2.add((Component)this.textFwNot, gridBagConstraints13);
        this.textFwNot.setVisible(false);
        this.certSelector = new JList();
        this.certSelector.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = UpdaterJFrame.this.getCertSelector().getSelectedIndex() != -1;
                UpdaterJFrame.this.getRemoveCertificateButton().setEnabled(bl);
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(this.certSelector);
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.gridheight = 2;
        gridBagConstraints14.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints14.fill = 1;
        gridBagConstraints14.gridx = 0;
        gridBagConstraints14.gridy = 1;
        this.panel_2.add((Component)jScrollPane2, gridBagConstraints14);
        this.addCertificateButton = new JButton("Add domain");
        this.addCertificateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdaterJFrame.this.addCertificate();
            }
        });
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints15.fill = 2;
        gridBagConstraints15.gridx = 1;
        gridBagConstraints15.gridy = 1;
        this.panel_2.add((Component)this.addCertificateButton, gridBagConstraints15);
        this.removeCertificateButton = new JButton("Remove domain");
        this.removeCertificateButton.setEnabled(false);
        this.removeCertificateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdaterJFrame.this.removeCertificate();
            }
        });
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints16.fill = 2;
        gridBagConstraints16.gridx = 1;
        gridBagConstraints16.gridy = 2;
        this.panel_2.add((Component)this.removeCertificateButton, gridBagConstraints16);
        this.uploadCertificatesButton = new JButton("Upload Certificates to WiFi module");
        this.uploadCertificatesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdaterJFrame.this.uploadCertificates();
            }
        });
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.gridwidth = 2;
        gridBagConstraints17.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints17.gridx = 0;
        gridBagConstraints17.gridy = 3;
        this.panel_2.add((Component)this.uploadCertificatesButton, gridBagConstraints17);
        this.updateProgressBar = new JProgressBar();
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints18.fill = 2;
        gridBagConstraints18.gridx = 0;
        gridBagConstraints18.gridy = 3;
        this.contentPane.add((Component)this.updateProgressBar, gridBagConstraints18);
    }

    protected void hideCertificatePanel(boolean bl) {
        this.panel_2.setEnabled(bl);
        this.certSelector.setVisible(bl);
        this.uploadCertificatesButton.setVisible(bl);
        this.addCertificateButton.setVisible(bl);
        this.removeCertificateButton.setVisible(bl);
        this.textArea.setVisible(bl);
        this.textFwNot.setVisible(!bl);
    }

    protected void setEnabledCommand(boolean bl) {
        this.uploadCertificatesButton.setEnabled(bl);
        this.addCertificateButton.setEnabled(bl);
        this.testConnectionButton.setEnabled(bl);
        this.updateFirmwareButton.setEnabled(bl);
        this.firmwareSelector.setEnabled(bl);
        this.certSelector.setEnabled(bl);
    }

    protected void uploadCertificates() {
    }

    protected void removeCertificate() {
    }

    protected void addCertificate() {
    }

    protected void updateFirmware() {
    }

    protected void testConnection() {
    }

    protected void openFirmwareUpdaterSketch() {
    }

    protected void refreshSerialPortList() {
    }

    protected void SelectBoardModule() {
    }

    protected void updateCertSection() {
    }

    protected JList<String> getSerialPortList() {
        return this.serialPortList;
    }

    protected JComboBox<Flasher> getFirmwareSelector() {
        return this.firmwareSelector;
    }

    protected JProgressBar getUpdateProgressBar() {
        return this.updateProgressBar;
    }

    protected JButton getRemoveCertificateButton() {
        return this.removeCertificateButton;
    }

    protected JList<String> getCertSelector() {
        return this.certSelector;
    }
}

