// https://docs.microsoft.com/en-us/typography/opentype/spec/featurelist

#![allow(dead_code)]

use crate::Tag;

// `Character Variants N` and `Stylistic Set N` are excluded.

pub const ACCESS_ALL_ALTERNATES: Tag                        = Tag::from_bytes(b"aalt");
pub const ABOVE_BASE_FORMS: Tag                             = Tag::from_bytes(b"abvf");
pub const ABOVE_BASE_MARK_POSITIONING: Tag                  = Tag::from_bytes(b"abvm");
pub const ABOVE_BASE_SUBSTITUTIONS: Tag                     = Tag::from_bytes(b"abvs");
pub const ALTERNATIVE_FRACTIONS: Tag                        = Tag::from_bytes(b"afrc");
pub const AKHANDS: Tag                                      = Tag::from_bytes(b"akhn");
pub const BELOW_BASE_FORMS: Tag                             = Tag::from_bytes(b"blwf");
pub const BELOW_BASE_MARK_POSITIONING: Tag                  = Tag::from_bytes(b"blwm");
pub const BELOW_BASE_SUBSTITUTIONS: Tag                     = Tag::from_bytes(b"blws");
pub const CONTEXTUAL_ALTERNATES: Tag                        = Tag::from_bytes(b"calt");
pub const CASE_SENSITIVE_FORMS: Tag                         = Tag::from_bytes(b"case");
pub const GLYPH_COMPOSITION_DECOMPOSITION: Tag              = Tag::from_bytes(b"ccmp");
pub const CONJUNCT_FORM_AFTER_RO: Tag                       = Tag::from_bytes(b"cfar");
pub const CONJUNCT_FORMS: Tag                               = Tag::from_bytes(b"cjct");
pub const CONTEXTUAL_LIGATURES: Tag                         = Tag::from_bytes(b"clig");
pub const CENTERED_CJK_PUNCTUATION: Tag                     = Tag::from_bytes(b"cpct");
pub const CAPITAL_SPACING: Tag                              = Tag::from_bytes(b"cpsp");
pub const CONTEXTUAL_SWASH: Tag                             = Tag::from_bytes(b"cswh");
pub const CURSIVE_POSITIONING: Tag                          = Tag::from_bytes(b"curs");
pub const PETITE_CAPITALS_FROM_CAPITALS: Tag                = Tag::from_bytes(b"c2pc");
pub const SMALL_CAPITALS_FROM_CAPITALS: Tag                 = Tag::from_bytes(b"c2sc");
pub const DISTANCES: Tag                                    = Tag::from_bytes(b"dist");
pub const DISCRETIONARY_LIGATURES: Tag                      = Tag::from_bytes(b"dlig");
pub const DENOMINATORS: Tag                                 = Tag::from_bytes(b"dnom");
pub const DOTLESS_FORMS: Tag                                = Tag::from_bytes(b"dtls");
pub const EXPERT_FORMS: Tag                                 = Tag::from_bytes(b"expt");
pub const FINAL_GLYPH_ON_LINE_ALTERNATES: Tag               = Tag::from_bytes(b"falt");
pub const TERMINAL_FORMS_1: Tag                             = Tag::from_bytes(b"fina");
pub const TERMINAL_FORMS_2: Tag                             = Tag::from_bytes(b"fin2");
pub const TERMINAL_FORMS_3: Tag                             = Tag::from_bytes(b"fin3");
pub const FLATTENED_ACCENT_FORMS: Tag                       = Tag::from_bytes(b"flac");
pub const FRACTIONS: Tag                                    = Tag::from_bytes(b"frac");
pub const FULL_WIDTHS: Tag                                  = Tag::from_bytes(b"fwid");
pub const HALF_FORMS: Tag                                   = Tag::from_bytes(b"half");
pub const HALANT_FORMS: Tag                                 = Tag::from_bytes(b"haln");
pub const ALTERNATE_HALF_WIDTHS: Tag                        = Tag::from_bytes(b"halt");
pub const HISTORICAL_FORMS: Tag                             = Tag::from_bytes(b"hist");
pub const HORIZONTAL_KANA_ALTERNATES: Tag                   = Tag::from_bytes(b"hkna");
pub const HISTORICAL_LIGATURES: Tag                         = Tag::from_bytes(b"hlig");
pub const HANGUL: Tag                                       = Tag::from_bytes(b"hngl");
pub const HOJO_KANJI_FORMS: Tag                             = Tag::from_bytes(b"hojo");
pub const HALF_WIDTHS: Tag                                  = Tag::from_bytes(b"hwid");
pub const INITIAL_FORMS: Tag                                = Tag::from_bytes(b"init");
pub const ISOLATED_FORMS: Tag                               = Tag::from_bytes(b"isol");
pub const ITALICS: Tag                                      = Tag::from_bytes(b"ital");
pub const JUSTIFICATION_ALTERNATES: Tag                     = Tag::from_bytes(b"jalt");
pub const JIS_78_FORMS: Tag                                 = Tag::from_bytes(b"jp78");
pub const JIS_83_FORMS: Tag                                 = Tag::from_bytes(b"jp83");
pub const JIS_90_FORMS: Tag                                 = Tag::from_bytes(b"jp90");
pub const JIS_2004_FORMS: Tag                               = Tag::from_bytes(b"jp04");
pub const KERNING: Tag                                      = Tag::from_bytes(b"kern");
pub const LEFT_BOUNDS: Tag                                  = Tag::from_bytes(b"lfbd");
pub const STANDARD_LIGATURES: Tag                           = Tag::from_bytes(b"liga");
pub const LEADING_JAMO_FORMS: Tag                           = Tag::from_bytes(b"ljmo");
pub const LINING_FIGURES: Tag                               = Tag::from_bytes(b"lnum");
pub const LOCALIZED_FORMS: Tag                              = Tag::from_bytes(b"locl");
pub const LEFT_TO_RIGHT_ALTERNATES: Tag                     = Tag::from_bytes(b"ltra");
pub const LEFT_TO_RIGHT_MIRRORED_FORMS: Tag                 = Tag::from_bytes(b"ltrm");
pub const MARK_POSITIONING: Tag                             = Tag::from_bytes(b"mark");
pub const MEDIAL_FORMS_1: Tag                               = Tag::from_bytes(b"medi");
pub const MEDIAL_FORMS_2: Tag                               = Tag::from_bytes(b"med2");
pub const MATHEMATICAL_GREEK: Tag                           = Tag::from_bytes(b"mgrk");
pub const MARK_TO_MARK_POSITIONING: Tag                     = Tag::from_bytes(b"mkmk");
pub const MARK_POSITIONING_VIA_SUBSTITUTION: Tag            = Tag::from_bytes(b"mset");
pub const ALTERNATE_ANNOTATION_FORMS: Tag                   = Tag::from_bytes(b"nalt");
pub const NLC_KANJI_FORMS: Tag                              = Tag::from_bytes(b"nlck");
pub const NUKTA_FORMS: Tag                                  = Tag::from_bytes(b"nukt");
pub const NUMERATORS: Tag                                   = Tag::from_bytes(b"numr");
pub const OLDSTYLE_FIGURES: Tag                             = Tag::from_bytes(b"onum");
pub const OPTICAL_BOUNDS: Tag                               = Tag::from_bytes(b"opbd");
pub const ORDINALS: Tag                                     = Tag::from_bytes(b"ordn");
pub const ORNAMENTS: Tag                                    = Tag::from_bytes(b"ornm");
pub const PROPORTIONAL_ALTERNATE_WIDTHS: Tag                = Tag::from_bytes(b"palt");
pub const PETITE_CAPITALS: Tag                              = Tag::from_bytes(b"pcap");
pub const PROPORTIONAL_KANA: Tag                            = Tag::from_bytes(b"pkna");
pub const PROPORTIONAL_FIGURES: Tag                         = Tag::from_bytes(b"pnum");
pub const PRE_BASE_FORMS: Tag                               = Tag::from_bytes(b"pref");
pub const PRE_BASE_SUBSTITUTIONS: Tag                       = Tag::from_bytes(b"pres");
pub const POST_BASE_FORMS: Tag                              = Tag::from_bytes(b"pstf");
pub const POST_BASE_SUBSTITUTIONS: Tag                      = Tag::from_bytes(b"psts");
pub const PROPORTIONAL_WIDTHS: Tag                          = Tag::from_bytes(b"pwid");
pub const QUARTER_WIDTHS: Tag                               = Tag::from_bytes(b"qwid");
pub const RANDOMIZE: Tag                                    = Tag::from_bytes(b"rand");
pub const REQUIRED_CONTEXTUAL_ALTERNATES: Tag               = Tag::from_bytes(b"rclt");
pub const RAKAR_FORMS: Tag                                  = Tag::from_bytes(b"rkrf");
pub const REQUIRED_LIGATURES: Tag                           = Tag::from_bytes(b"rlig");
pub const REPH_FORMS: Tag                                   = Tag::from_bytes(b"rphf");
pub const RIGHT_BOUNDS: Tag                                 = Tag::from_bytes(b"rtbd");
pub const RIGHT_TO_LEFT_ALTERNATES: Tag                     = Tag::from_bytes(b"rtla");
pub const RIGHT_TO_LEFT_MIRRORED_FORMS: Tag                 = Tag::from_bytes(b"rtlm");
pub const RUBY_NOTATION_FORMS: Tag                          = Tag::from_bytes(b"ruby");
pub const REQUIRED_VARIATION_ALTERNATES: Tag                = Tag::from_bytes(b"rvrn");
pub const STYLISTIC_ALTERNATES: Tag                         = Tag::from_bytes(b"salt");
pub const SCIENTIFIC_INFERIORS: Tag                         = Tag::from_bytes(b"sinf");
pub const OPTICAL_SIZE: Tag                                 = Tag::from_bytes(b"size");
pub const SMALL_CAPITALS: Tag                               = Tag::from_bytes(b"smcp");
pub const SIMPLIFIED_FORMS: Tag                             = Tag::from_bytes(b"smpl");
pub const MATH_SCRIPT_STYLE_ALTERNATES: Tag                 = Tag::from_bytes(b"ssty");
pub const STRETCHING_GLYPH_DECOMPOSITION: Tag               = Tag::from_bytes(b"stch");
pub const SUBSCRIPT: Tag                                    = Tag::from_bytes(b"subs");
pub const SUPERSCRIPT: Tag                                  = Tag::from_bytes(b"sups");
pub const SWASH: Tag                                        = Tag::from_bytes(b"swsh");
pub const TITLING: Tag                                      = Tag::from_bytes(b"titl");
pub const TRAILING_JAMO_FORMS: Tag                          = Tag::from_bytes(b"tjmo");
pub const TRADITIONAL_NAME_FORMS: Tag                       = Tag::from_bytes(b"tnam");
pub const TABULAR_FIGURES: Tag                              = Tag::from_bytes(b"tnum");
pub const TRADITIONAL_FORMS: Tag                            = Tag::from_bytes(b"trad");
pub const THIRD_WIDTHS: Tag                                 = Tag::from_bytes(b"twid");
pub const UNICASE: Tag                                      = Tag::from_bytes(b"unic");
pub const ALTERNATE_VERTICAL_METRICS: Tag                   = Tag::from_bytes(b"valt");
pub const VATTU_VARIANTS: Tag                               = Tag::from_bytes(b"vatu");
pub const VERTICAL_WRITING: Tag                             = Tag::from_bytes(b"vert");
pub const ALTERNATE_VERTICAL_HALF_METRICS: Tag              = Tag::from_bytes(b"vhal");
pub const VOWEL_JAMO_FORMS: Tag                             = Tag::from_bytes(b"vjmo");
pub const VERTICAL_KANA_ALTERNATES: Tag                     = Tag::from_bytes(b"vkna");
pub const VERTICAL_KERNING: Tag                             = Tag::from_bytes(b"vkrn");
pub const PROPORTIONAL_ALTERNATE_VERTICAL_METRICS: Tag      = Tag::from_bytes(b"vpal");
pub const VERTICAL_ALTERNATES_AND_ROTATION: Tag             = Tag::from_bytes(b"vrt2");
pub const VERTICAL_ALTERNATES_FOR_ROTATION: Tag             = Tag::from_bytes(b"vrtr");
pub const SLASHED_ZERO: Tag                                 = Tag::from_bytes(b"zero");
