/*
 * Decompiled with CFR 0.152.
 */
package classycle;

import classycle.ClassAttributes;
import classycle.ClassNameExtractor;
import classycle.GraphBuilder;
import classycle.UnresolvedNode;
import classycle.classfile.ClassConstant;
import classycle.classfile.Constant;
import classycle.classfile.StringConstant;
import classycle.classfile.UTF8Constant;
import classycle.graph.AtomicVertex;
import classycle.util.StringPattern;
import classycle.util.TrueStringPattern;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Parser {
    private static final int ACC_INTERFACE = 512;
    private static final int ACC_ABSTRACT = 1024;
    private static final String[] ZIP_FILE_TYPES = new String[]{".zip", ".jar", ".war", ".ear"};

    private Parser() {
    }

    public static AtomicVertex[] readClassFiles(String[] classFiles) throws IOException {
        return Parser.readClassFiles(classFiles, new TrueStringPattern(), null, false);
    }

    public static AtomicVertex[] readClassFiles(String[] classFiles, StringPattern pattern, StringPattern reflectionPattern, boolean mergeInnerClasses) throws IOException {
        ArrayList unresolvedNodes = new ArrayList();
        for (int i = 0; i < classFiles.length; ++i) {
            String classFile = classFiles[i];
            File file = new File(classFile);
            if (file.isDirectory()) {
                Parser.analyseClassFile(file, classFile, unresolvedNodes, reflectionPattern);
                File[] files = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return Parser.isZipFile(file);
                    }
                });
                for (int j = 0; j < files.length; ++j) {
                    String source = Parser.createSourceName(classFile, files[j].getName());
                    Parser.analyseClassFiles(new ZipFile(files[j].getAbsoluteFile()), source, unresolvedNodes, reflectionPattern);
                }
                continue;
            }
            if (file.getName().endsWith(".class")) {
                Parser.analyseClassFile(file, null, unresolvedNodes, reflectionPattern);
                continue;
            }
            if (Parser.isZipFile(file)) {
                Parser.analyseClassFiles(new ZipFile(file.getAbsoluteFile()), classFile, unresolvedNodes, reflectionPattern);
                continue;
            }
            throw new IOException(classFile + " is an invalid file.");
        }
        ArrayList<UnresolvedNode> filteredNodes = new ArrayList<UnresolvedNode>();
        int n = unresolvedNodes.size();
        for (int i = 0; i < n; ++i) {
            UnresolvedNode node = (UnresolvedNode)unresolvedNodes.get(i);
            if (!node.isMatchedBy(pattern)) continue;
            filteredNodes.add(node);
        }
        UnresolvedNode[] nodes = new UnresolvedNode[filteredNodes.size()];
        nodes = filteredNodes.toArray(nodes);
        return GraphBuilder.createGraph(nodes, mergeInnerClasses);
    }

    private static String createSourceName(String classFile, String name) {
        return classFile + (classFile.endsWith(File.separator) ? name : File.separatorChar + name);
    }

    private static boolean isZipFile(File file) {
        boolean result = false;
        String name = file.getName();
        for (int i = 0; i < ZIP_FILE_TYPES.length; ++i) {
            if (!name.endsWith(ZIP_FILE_TYPES[i])) continue;
            result = true;
            break;
        }
        return result;
    }

    private static void analyseClassFile(File file, String source, ArrayList unresolvedNodes, StringPattern reflectionPattern) throws IOException {
        if (file.isDirectory()) {
            String[] files = file.list();
            for (int i = 0; i < files.length; ++i) {
                File child = new File(file, files[i]);
                if (!child.isDirectory() && !files[i].endsWith(".class")) continue;
                Parser.analyseClassFile(child, source, unresolvedNodes, reflectionPattern);
            }
        } else {
            unresolvedNodes.add(Parser.extractNode(file, source, reflectionPattern));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UnresolvedNode extractNode(File file, String source, StringPattern reflectionPattern) throws IOException {
        FileInputStream stream = null;
        UnresolvedNode result = null;
        try {
            stream = new FileInputStream(file);
            result = Parser.createNode(stream, source, (int)file.length(), reflectionPattern);
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e) {}
        }
        return result;
    }

    private static void analyseClassFiles(ZipFile zipFile, String source, ArrayList unresolvedNodes, StringPattern reflectionPattern) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            InputStream stream = zipFile.getInputStream(entry);
            int size = (int)entry.getSize();
            unresolvedNodes.add(Parser.createNode(stream, source, size, reflectionPattern));
        }
    }

    private static UnresolvedNode createNode(InputStream stream, String source, int size, StringPattern reflectionPattern) throws IOException {
        DataInputStream dataStream = new DataInputStream(stream);
        Constant[] pool = Constant.extractConstantPool(dataStream);
        int accessFlags = dataStream.readUnsignedShort();
        String name = ((ClassConstant)pool[dataStream.readUnsignedShort()]).getName();
        ClassAttributes attributes = null;
        attributes = (accessFlags & 0x200) != 0 ? ClassAttributes.createInterface(name, source, size) : ((accessFlags & 0x400) != 0 ? ClassAttributes.createAbstractClass(name, source, size) : ClassAttributes.createClass(name, source, size));
        UnresolvedNode node = new UnresolvedNode();
        node.setAttributes(attributes);
        for (int i = 0; i < pool.length; ++i) {
            String str;
            Constant constant = pool[i];
            if (constant instanceof ClassConstant) {
                ClassConstant cc = (ClassConstant)constant;
                if (cc.getName().startsWith("[") || cc.getName().equals(name)) continue;
                node.addLinkTo(cc.getName());
                continue;
            }
            if (constant instanceof UTF8Constant) {
                Parser.parseUTF8Constant((UTF8Constant)constant, node, name);
                continue;
            }
            if (reflectionPattern == null || !(constant instanceof StringConstant) || !ClassNameExtractor.isValid(str = ((StringConstant)constant).getString()) || !reflectionPattern.matches(str)) continue;
            node.addLinkTo(str);
        }
        return node;
    }

    static void parseUTF8Constant(UTF8Constant constant, UnresolvedNode node, String className) {
        Set classNames = new ClassNameExtractor(constant).extract();
        for (String element : classNames) {
            if (className.equals(element)) continue;
            node.addLinkTo(element);
        }
    }
}

