/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.DefaultPreferenceFactory;
import classycle.dependency.Preference;
import classycle.dependency.PreferenceFactory;
import classycle.dependency.Result;
import classycle.dependency.ResultContainer;
import classycle.dependency.ResultRenderer;
import classycle.dependency.TextResult;

public class DefaultResultRenderer
extends ResultRenderer {
    private static final String SHOW = "show ";
    private static final PreferenceFactory FACTORY = new DefaultPreferenceFactory();
    private static final TextResult ONLY_SHORTEST_PATHS = new TextResult("show " + DefaultPreferenceFactory.ONLY_SHORTEST_PATHS.getKey() + '\n');
    private static final TextResult ALL_PATHS = new TextResult("show " + DefaultPreferenceFactory.ALL_PATHS.getKey() + '\n');
    private boolean _allResults;

    public PreferenceFactory getPreferenceFactory() {
        return FACTORY;
    }

    public void considerPreference(Preference preference) {
        if (preference == DefaultPreferenceFactory.ONLY_SHORTEST_PATHS) {
            this._shortestPaths = true;
        } else if (preference == DefaultPreferenceFactory.ALL_PATHS) {
            this._shortestPaths = false;
        } else if (preference == DefaultPreferenceFactory.ALL_RESULTS) {
            this._allResults = true;
        } else if (preference == DefaultPreferenceFactory.ONLY_FAILURES) {
            this._allResults = false;
        }
    }

    public Result getDescriptionOfCurrentPreferences() {
        StringBuffer buffer = new StringBuffer(SHOW);
        buffer.append(this._shortestPaths ? DefaultPreferenceFactory.ONLY_SHORTEST_PATHS.getKey() : DefaultPreferenceFactory.ALL_PATHS.getKey()).append(' ').append(this._allResults ? DefaultPreferenceFactory.ALL_RESULTS.getKey() : DefaultPreferenceFactory.ONLY_FAILURES.getKey()).append('\n');
        return new TextResult(new String(buffer));
    }

    public String render(Result result) {
        StringBuffer buffer = new StringBuffer();
        this.render(buffer, result);
        return new String(buffer);
    }

    private void render(StringBuffer buffer, Result result) {
        if (result instanceof ResultContainer) {
            ResultContainer results = (ResultContainer)result;
            int n = results.getNumberOfResults();
            for (int i = 0; i < n; ++i) {
                this.render(buffer, results.getResult(i));
            }
        } else if (this._allResults || !result.isOk()) {
            buffer.append(result.toString());
        }
    }
}

