/*
 * Decompiled with CFR 0.152.
 */
package classycle.graph;

import classycle.graph.AtomicVertex;
import classycle.graph.GraphProcessor;
import classycle.graph.StrongComponent;
import classycle.graph.Vertex;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class StrongComponentProcessor
extends GraphProcessor {
    private final boolean _calculateAttributes;
    private int _counter;
    private Stack _vertexStack = new Stack();
    private Vector _strongComponents = new Vector();
    private Hashtable _vertexToComponents = new Hashtable();
    private StrongComponent[] _graph;

    public StrongComponentProcessor(boolean calculateAttributes) {
        this._calculateAttributes = calculateAttributes;
    }

    public StrongComponent[] getStrongComponents() {
        return this._graph;
    }

    protected void initializeProcessing(Vertex[] graph) {
        this._counter = 0;
        this._vertexStack.setSize(0);
        this._strongComponents.setSize(0);
        this._vertexToComponents.clear();
    }

    protected void processBefore(Vertex vertex) {
        AtomicVertex atomicVertex = this.castAsAtomicVertex(vertex);
        atomicVertex.setOrder(this._counter);
        atomicVertex.setLow(this._counter++);
        this._vertexStack.push(atomicVertex);
    }

    protected void processArc(Vertex tail, Vertex head) {
        AtomicVertex t = this.castAsAtomicVertex(tail);
        AtomicVertex h = this.castAsAtomicVertex(head);
        if (h.isGraphVertex()) {
            if (!h.isVisited()) {
                this.process(h);
                t.setLow(Math.min(t.getLow(), h.getLow()));
            } else if (h.getOrder() < t.getOrder() && this._vertexStack.contains(h)) {
                t.setLow(Math.min(t.getLow(), h.getOrder()));
            }
        }
    }

    protected void processAfter(Vertex vertex) {
        AtomicVertex atomicVertex = this.castAsAtomicVertex(vertex);
        if (atomicVertex.getLow() == atomicVertex.getOrder()) {
            StrongComponent component = new StrongComponent();
            while (!this._vertexStack.isEmpty() && ((AtomicVertex)this._vertexStack.peek()).getOrder() >= atomicVertex.getOrder()) {
                AtomicVertex vertexOfComponent = (AtomicVertex)this._vertexStack.pop();
                component.addVertex(vertexOfComponent);
                this._vertexToComponents.put(vertexOfComponent, component);
            }
            this._strongComponents.addElement(component);
        }
    }

    protected void finishProcessing(Vertex[] graph) {
        this._graph = new StrongComponent[this._strongComponents.size()];
        for (int i = 0; i < this._graph.length; ++i) {
            this._graph[i] = (StrongComponent)this._strongComponents.elementAt(i);
            if (!this._calculateAttributes) continue;
            this._graph[i].calculateAttributes();
        }
        Enumeration keys = this._vertexToComponents.keys();
        while (keys.hasMoreElements()) {
            AtomicVertex vertex = (AtomicVertex)keys.nextElement();
            StrongComponent tail = (StrongComponent)this._vertexToComponents.get(vertex);
            int n = vertex.getNumberOfOutgoingArcs();
            for (int i = 0; i < n; ++i) {
                StrongComponent head;
                AtomicVertex h = (AtomicVertex)vertex.getHeadVertex(i);
                if (!h.isGraphVertex() || (head = (StrongComponent)this._vertexToComponents.get(h)) == null || head == tail) continue;
                tail.addOutgoingArcTo(head);
            }
        }
    }

    private AtomicVertex castAsAtomicVertex(Vertex vertex) {
        if (vertex instanceof AtomicVertex) {
            return (AtomicVertex)vertex;
        }
        throw new IllegalArgumentException(vertex + " is not an instance of AtomicVertex");
    }
}

