/*
 * Decompiled with CFR 0.152.
 */
package sbt.std;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import sbt.DeferredWriter;
import sbt.IO$;
import sbt.Logger;
import sbt.Path$;
import sbt.std.CloseableStreams;
import sbt.std.ManagedStreams;
import sbt.std.Streams;
import sbt.std.Streams$;
import sbt.std.Streams$$anon$3$;
import sbt.std.Streams$class;
import sbt.std.TaskStreams;
import sbt.std.TaskStreams$class;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.sys.package$;

public final class Streams$ {
    public static final Streams$ MODULE$;
    public final Function1<Closeable, BoxedUnit> sbt$std$Streams$$closeQuietly;

    static {
        new Streams$();
    }

    public <Key> CloseableStreams<Key> closeable(Streams<Key> delegate) {
        return new CloseableStreams<Key>(delegate){
            private final HashMap<Key, ManagedStreams<Key>> streams;
            private final Streams delegate$1;

            public <T> T use(Key key, Function1<TaskStreams<Key>, T> f) {
                return (T)Streams$class.use(this, key, f);
            }

            public synchronized ManagedStreams<Key> apply(Key key) {
                ManagedStreams<Key> managedStreams;
                Some some;
                ManagedStreams<Key> s;
                Option option = this.streams.get(key);
                if (option instanceof Some && !(s = (ManagedStreams<Key>)(some = (Some)option).x()).isClosed()) {
                    managedStreams = s;
                } else {
                    ManagedStreams<Key> newS = this.delegate$1.apply(key);
                    this.streams.put(key, newS);
                    managedStreams = newS;
                }
                return managedStreams;
            }

            public synchronized void close() {
                this.streams.values().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(ManagedStreams<Key> x$1) {
                        x$1.close();
                    }
                });
                this.streams.clear();
            }
            {
                this.delegate$1 = delegate$1;
                Streams$class.$init$(this);
                this.streams = new HashMap();
            }
        };
    }

    public <Key> Streams<Key> apply(Function1<Key, File> taskDirectory, Function1<Key, String> name, Function2<Key, PrintWriter, Logger> mkLogger) {
        return new Streams<Key>(taskDirectory, name, mkLogger){
            public final Function1 taskDirectory$1;
            public final Function1 name$1;
            public final Function2 mkLogger$1;

            public <T> T use(Key key, Function1<TaskStreams<Key>, T> f) {
                return (T)Streams$class.use(this, key, f);
            }

            public ManagedStreams<Key> apply(Key a) {
                return new ManagedStreams<Key>(this, a){
                    private List<Closeable> opened;
                    private boolean closed;
                    private File cacheDirectory;
                    private final /* synthetic */ anon.3 $outer;
                    private final Object a$1;
                    private final Logger log;
                    private volatile byte bitmap$0;

                    /*
                     * WARNING - void declaration
                     */
                    private File cacheDirectory$lzycompute() {
                        anon$3$$anon$2 var1_1 = this;
                        synchronized (var1_1) {
                            if ((byte)(this.bitmap$0 & 1) == 0) {
                                void var2_2;
                                File dir = (File)this.$outer.taskDirectory$1.apply(this.a$1);
                                IO$.MODULE$.createDirectory(dir);
                                this.cacheDirectory = var2_2;
                                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                            }
                            return this.cacheDirectory;
                        }
                    }

                    private Logger log$lzycompute() {
                        anon$3$$anon$2 var1_1 = this;
                        synchronized (var1_1) {
                            if ((byte)(this.bitmap$0 & 2) == 0) {
                                this.log = TaskStreams$class.log(this);
                                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                            }
                            return this.log;
                        }
                    }

                    public final Logger log() {
                        return (byte)(this.bitmap$0 & 2) == 0 ? this.log$lzycompute() : this.log;
                    }

                    public String default() {
                        return TaskStreams$class.default(this);
                    }

                    public String outID() {
                        return TaskStreams$class.outID(this);
                    }

                    public String errorID() {
                        return TaskStreams$class.errorID(this);
                    }

                    public final BufferedReader readText(Key a, Option<String> sid) {
                        return TaskStreams$class.readText(this, a, sid);
                    }

                    public final BufferedInputStream readBinary(Key a, Option<String> sid) {
                        return TaskStreams$class.readBinary(this, a, sid);
                    }

                    public BufferedReader readText(Key a, String sid) {
                        return (BufferedReader)this.make(a, sid, (Function1<File, T>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final BufferedReader apply(File f) {
                                return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), IO$.MODULE$.defaultCharset()));
                            }
                        });
                    }

                    public String readText$default$2() {
                        return this.default();
                    }

                    public BufferedInputStream readBinary(Key a, String sid) {
                        return (BufferedInputStream)this.make(a, sid, (Function1<File, T>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final BufferedInputStream apply(File f) {
                                return new BufferedInputStream(new FileInputStream(f));
                            }
                        });
                    }

                    public String readBinary$default$2() {
                        return this.default();
                    }

                    public PrintWriter text(String sid) {
                        return (PrintWriter)this.make((Key)this.a$1, sid, (Function1<File, T>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final PrintWriter apply(File f) {
                                return new PrintWriter((Writer)new DeferredWriter((Function0)new Serializable(this, f){
                                    public static final long serialVersionUID = 0L;
                                    private final File f$1;

                                    public final BufferedWriter apply() {
                                        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.f$1), IO$.MODULE$.defaultCharset()));
                                    }
                                    {
                                        this.f$1 = f$1;
                                    }
                                }));
                            }
                        });
                    }

                    public String text$default$1() {
                        return this.default();
                    }

                    public BufferedOutputStream binary(String sid) {
                        return (BufferedOutputStream)this.make((Key)this.a$1, sid, (Function1<File, T>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final BufferedOutputStream apply(File f) {
                                return new BufferedOutputStream(new FileOutputStream(f));
                            }
                        });
                    }

                    public String binary$default$1() {
                        return this.default();
                    }

                    public File cacheDirectory() {
                        return (byte)(this.bitmap$0 & 1) == 0 ? this.cacheDirectory$lzycompute() : this.cacheDirectory;
                    }

                    public Logger log(String sid) {
                        return (Logger)this.$outer.mkLogger$1.apply(this.a$1, (Object)this.text(sid));
                    }

                    private synchronized <T extends Closeable> T make(Key a, String sid, Function1<File, T> f) {
                        this.checkOpen();
                        File file = Path$.MODULE$.richFile((File)this.$outer.taskDirectory$1.apply(a)).$div(sid);
                        IO$.MODULE$.touch(file, false);
                        Closeable t = (Closeable)f.apply((Object)file);
                        this.opened = this.opened.$colon$colon((Object)t);
                        return (T)t;
                    }

                    public Key key() {
                        return (Key)this.a$1;
                    }

                    public void open() {
                    }

                    public synchronized boolean isClosed() {
                        return this.closed;
                    }

                    public synchronized void close() {
                        if (!this.closed) {
                            this.closed = true;
                            this.opened.foreach(Streams$.MODULE$.sbt$std$Streams$$closeQuietly);
                        }
                    }

                    private synchronized void checkOpen() {
                        if (this.closed) {
                            throw package$.MODULE$.error(new StringBuilder().append((Object)"Streams for '").append(this.$outer.name$1.apply(this.a$1)).append((Object)"' have been closed.").toString());
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.a$1 = a$1;
                        TaskStreams$class.$init$(this);
                        this.opened = Nil$.MODULE$;
                        this.closed = false;
                    }
                };
            }
            {
                this.taskDirectory$1 = taskDirectory$1;
                this.name$1 = name$1;
                this.mkLogger$1 = mkLogger$1;
                Streams$class.$init$(this);
            }
        };
    }

    private Streams$() {
        MODULE$ = this;
        this.sbt$std$Streams$$closeQuietly = new anonfun.1();
    }
}

