/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar;

import java.io.IOException;
import java.util.List;
import org.pantsbuild.jarjar.PatternElement;
import org.pantsbuild.jarjar.Wildcard;
import org.pantsbuild.jarjar.Zap;
import org.pantsbuild.jarjar.util.EntryStruct;
import org.pantsbuild.jarjar.util.JarProcessor;

class ZapProcessor
implements JarProcessor {
    private List<Wildcard> wildcards;

    public ZapProcessor(List<Zap> zapList) {
        this.wildcards = PatternElement.createWildcards(zapList);
    }

    @Override
    public boolean process(EntryStruct struct) throws IOException {
        String name = struct.name;
        if (name.endsWith(".class")) {
            return !this.zap(name.substring(0, name.length() - 6));
        }
        return true;
    }

    private boolean zap(String desc) {
        for (Wildcard wildcard : this.wildcards) {
            if (!wildcard.matches(desc)) continue;
            return true;
        }
        return false;
    }
}

