/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import jnr.posix.FileStat;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.JarFileStat;
import org.jruby.util.ResourceException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ModeFlags;

public class ClasspathResource
implements FileResource {
    public static final String CLASSPATH = "classpath:/";
    private final String uri;
    private final JarFileStat fileStat;
    private boolean isFile;

    ClasspathResource(String uri, URL url) {
        this.uri = uri;
        this.fileStat = new JarFileStat(this);
        this.isFile = url != null;
    }

    public static URL getResourceURL(String pathname2) {
        String path2 = pathname2.substring(CLASSPATH.length());
        URL url = Thread.currentThread().getContextClassLoader().getResource(path2);
        if (url != null) {
            return url;
        }
        if (ClasspathResource.class.getClassLoader() != null) {
            return ClasspathResource.class.getClassLoader().getResource(path2);
        }
        return null;
    }

    public static FileResource create(String pathname2) {
        if (!pathname2.startsWith("classpath:")) {
            return null;
        }
        if (pathname2.equals("classpath:")) {
            return new ClasspathResource(pathname2, null);
        }
        URL url = ClasspathResource.getResourceURL(pathname2);
        return new ClasspathResource(pathname2, url);
    }

    @Override
    public String absolutePath() {
        return this.uri;
    }

    @Override
    public String canonicalPath() {
        return this.uri;
    }

    @Override
    public boolean exists() {
        return this.isFile;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return this.isFile;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public String[] list() {
        return null;
    }

    @Override
    public boolean isSymLink() {
        return false;
    }

    @Override
    public FileStat stat() {
        return this.fileStat;
    }

    @Override
    public FileStat lstat() {
        return this.stat();
    }

    @Override
    public JRubyFile hackyGetJRubyFile() {
        return null;
    }

    @Override
    public InputStream openInputStream() {
        try {
            return ClasspathResource.getResourceURL(this.uri).openStream();
        }
        catch (IOException ioE) {
            return null;
        }
    }

    @Override
    public ChannelDescriptor openDescriptor(ModeFlags flags, int perm) throws ResourceException {
        return null;
    }
}

