/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.matcher;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;

public class MapMatcher {
    private Map matchers = new HashMap();
    private PatternMatcher pm;
    private Map attributes;

    public MapMatcher(Map map, PatternMatcher patternMatcher) {
        this.attributes = map;
        this.pm = patternMatcher;
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getValue();
            if (string == null) continue;
            this.matchers.put(entry.getKey(), patternMatcher.getMatcher(string));
        }
    }

    public boolean matches(Map map) {
        for (Map.Entry entry : this.matchers.entrySet()) {
            Matcher matcher = (Matcher)entry.getValue();
            String string = (String)map.get(entry.getKey());
            if (string != null && matcher.matches(string)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.attributes + " (" + this.pm.getName() + ")";
    }

    public Map getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public PatternMatcher getPatternMatcher() {
        return this.pm;
    }
}

