/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.jdk;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.Body;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.MaxRedirectException;
import com.ning.http.client.PerRequestConfig;
import com.ning.http.client.ProgressAsyncHandler;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.cookie.CookieEncoder;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.IOExceptionFilter;
import com.ning.http.client.filter.ResponseFilter;
import com.ning.http.client.listener.TransferCompletionHandler;
import com.ning.http.client.providers.jdk.JDKAsyncHttpProviderConfig;
import com.ning.http.client.providers.jdk.JDKDelegateFuture;
import com.ning.http.client.providers.jdk.JDKResponse;
import com.ning.http.client.providers.jdk.ResponseBodyPart;
import com.ning.http.client.providers.jdk.ResponseHeaders;
import com.ning.http.client.providers.jdk.ResponseStatus;
import com.ning.http.multipart.MultipartRequestEntity;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.AuthenticatorUtils;
import com.ning.http.util.MiscUtil;
import com.ning.http.util.ProxyUtils;
import com.ning.http.util.SslUtils;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import javax.naming.AuthenticationException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKAsyncHttpProvider
implements AsyncHttpProvider {
    private static final Logger logger = LoggerFactory.getLogger(JDKAsyncHttpProvider.class);
    private static final String NTLM_DOMAIN = "http.auth.ntlm.domain";
    private final AsyncHttpClientConfig config;
    private final AtomicBoolean isClose = new AtomicBoolean(false);
    private static final int MAX_BUFFERED_BYTES = 8192;
    private final AtomicInteger maxConnections = new AtomicInteger();
    private String jdkNtlmDomain;
    private Authenticator jdkAuthenticator;
    private boolean bufferResponseInMemory = false;

    public JDKAsyncHttpProvider(AsyncHttpClientConfig config) {
        this.config = config;
        AsyncHttpProviderConfig<?, ?> providerConfig = config.getAsyncHttpProviderConfig();
        if (providerConfig instanceof JDKAsyncHttpProviderConfig) {
            this.configure((JDKAsyncHttpProviderConfig)JDKAsyncHttpProviderConfig.class.cast(providerConfig));
        }
    }

    private void configure(JDKAsyncHttpProviderConfig config) {
        for (Map.Entry<String, String> e : config.propertiesSet()) {
            System.setProperty(e.getKey(), e.getValue());
        }
        if (config.getProperty("bufferResponseInMemory") != null) {
            this.bufferResponseInMemory = true;
        }
    }

    @Override
    public <T> ListenableFuture<T> execute(Request request, AsyncHandler<T> handler) throws IOException {
        return this.execute(request, handler, null);
    }

    public <T> ListenableFuture<T> execute(Request request, AsyncHandler<T> handler, ListenableFuture<?> future) throws IOException {
        if (this.isClose.get()) {
            throw new IOException("Closed");
        }
        if (this.config.getMaxTotalConnections() > -1 && this.maxConnections.get() + 1 > this.config.getMaxTotalConnections()) {
            throw new IOException(String.format("Too many connections %s", this.config.getMaxTotalConnections()));
        }
        ProxyServer proxyServer = ProxyUtils.getProxyServer(this.config, request);
        Realm realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        Proxy proxy = null;
        if (proxyServer != null || realm != null) {
            try {
                proxy = this.configureProxyAndAuth(proxyServer, realm);
            }
            catch (AuthenticationException e) {
                throw new IOException(e.getMessage());
            }
        }
        HttpURLConnection urlConnection = this.createUrlConnection(request);
        PerRequestConfig conf = request.getPerRequestConfig();
        int requestTimeout = conf != null && conf.getRequestTimeoutInMs() != 0 ? conf.getRequestTimeoutInMs() : this.config.getRequestTimeoutInMs();
        JDKDelegateFuture<T> delegate = null;
        if (future != null) {
            delegate = new JDKDelegateFuture<T>(handler, requestTimeout, future, urlConnection);
        }
        JDKDelegateFuture<T> f = delegate == null ? new JDKDelegateFuture<T>(handler, requestTimeout, urlConnection) : delegate;
        f.touch();
        f.setInnerFuture(this.config.executorService().submit(new AsyncHttpUrlConnection<T>(urlConnection, request, handler, f)));
        this.maxConnections.incrementAndGet();
        return f;
    }

    private HttpURLConnection createUrlConnection(Request request) throws IOException {
        ProxyServer proxyServer = ProxyUtils.getProxyServer(this.config, request);
        Realm realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        Proxy proxy = null;
        if (proxyServer != null || realm != null) {
            try {
                proxy = this.configureProxyAndAuth(proxyServer, realm);
            }
            catch (AuthenticationException e) {
                throw new IOException(e.getMessage());
            }
        }
        HttpURLConnection urlConnection = (HttpURLConnection)request.getURI().toURL().openConnection(proxy == null ? Proxy.NO_PROXY : proxy);
        if (request.getUrl().startsWith("https")) {
            HttpsURLConnection secure = (HttpsURLConnection)urlConnection;
            SSLContext sslContext = this.config.getSSLContext();
            if (sslContext == null) {
                try {
                    sslContext = SslUtils.getSSLContext();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException(e.getMessage());
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e.getMessage());
                }
            }
            secure.setSSLSocketFactory(sslContext.getSocketFactory());
            secure.setHostnameVerifier(this.config.getHostnameVerifier());
        }
        return urlConnection;
    }

    @Override
    public void close() {
        this.isClose.set(true);
    }

    @Override
    public Response prepareResponse(HttpResponseStatus status, HttpResponseHeaders headers, List<HttpResponseBodyPart> bodyParts) {
        return new JDKResponse(status, headers, bodyParts);
    }

    private Proxy configureProxyAndAuth(final ProxyServer proxyServer, final Realm realm) throws AuthenticationException {
        boolean hasAuthentication;
        Proxy proxy = null;
        if (proxyServer != null) {
            String proxyHost = proxyServer.getHost().startsWith("http://") ? proxyServer.getHost().substring("http://".length()) : proxyServer.getHost();
            InetSocketAddress addr = new InetSocketAddress(proxyHost, proxyServer.getPort());
            proxy = new Proxy(Proxy.Type.HTTP, addr);
        }
        final boolean hasProxy = proxyServer != null && proxyServer.getPrincipal() != null;
        boolean bl = hasAuthentication = realm != null && realm.getPrincipal() != null;
        if (hasProxy || hasAuthentication) {
            Field f = null;
            try {
                f = Authenticator.class.getDeclaredField("theAuthenticator");
                f.setAccessible(true);
                this.jdkAuthenticator = (Authenticator)f.get(Authenticator.class);
            }
            catch (NoSuchFieldException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    if (hasProxy && this.getRequestingHost().equals(proxyServer.getHost()) && this.getRequestingPort() == proxyServer.getPort()) {
                        String password = "";
                        if (proxyServer.getPassword() != null) {
                            password = proxyServer.getPassword();
                        }
                        return new PasswordAuthentication(proxyServer.getPrincipal(), password.toCharArray());
                    }
                    if (hasAuthentication) {
                        return new PasswordAuthentication(realm.getPrincipal(), realm.getPassword().toCharArray());
                    }
                    return super.getPasswordAuthentication();
                }
            });
        } else {
            Authenticator.setDefault(null);
        }
        return proxy;
    }

    private InputStream getInputStream(HttpURLConnection urlConnection) throws IOException {
        if (urlConnection.getResponseCode() < 400) {
            return urlConnection.getInputStream();
        }
        InputStream ein = urlConnection.getErrorStream();
        return ein != null ? ein : new ByteArrayInputStream(new byte[0]);
    }

    static /* synthetic */ HttpURLConnection access$200(JDKAsyncHttpProvider x0, Request x1) throws IOException {
        return x0.createUrlConnection(x1);
    }

    static /* synthetic */ InputStream access$300(JDKAsyncHttpProvider x0, HttpURLConnection x1) throws IOException {
        return x0.getInputStream(x1);
    }

    static /* synthetic */ boolean access$400(JDKAsyncHttpProvider x0) {
        return x0.bufferResponseInMemory;
    }

    static /* synthetic */ AtomicInteger access$500(JDKAsyncHttpProvider x0) {
        return x0.maxConnections;
    }

    static /* synthetic */ String access$600(JDKAsyncHttpProvider x0) {
        return x0.jdkNtlmDomain;
    }

    static /* synthetic */ Authenticator access$700(JDKAsyncHttpProvider x0) {
        return x0.jdkAuthenticator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AsyncHttpUrlConnection<T>
    implements Callable<T> {
        private HttpURLConnection urlConnection;
        private Request request;
        private final AsyncHandler<T> asyncHandler;
        private final ListenableFuture<T> future;
        private int currentRedirectCount;
        private AtomicBoolean isAuth = new AtomicBoolean(false);
        private byte[] cachedBytes;
        private int cachedBytesLenght;
        private boolean terminate = true;

        public AsyncHttpUrlConnection(HttpURLConnection urlConnection, Request request, AsyncHandler<T> asyncHandler, ListenableFuture<T> future) {
            this.urlConnection = urlConnection;
            this.request = request;
            this.asyncHandler = asyncHandler;
            this.future = future;
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public T call() throws Exception {
            block50: {
                block51: {
                    block47: {
                        block48: {
                            block49: {
                                block53: {
                                    block44: {
                                        block45: {
                                            block46: {
                                                block41: {
                                                    block42: {
                                                        block43: {
                                                            state = AsyncHandler.STATE.ABORT;
                                                            uri = null;
                                                            try {
                                                                uri = AsyncHttpProviderUtils.createUri(this.request.getRawUrl());
                                                            }
                                                            catch (IllegalArgumentException u) {
                                                                uri = AsyncHttpProviderUtils.createUri(this.request.getUrl());
                                                            }
                                                            this.configure(uri, this.urlConnection, this.request);
                                                            this.urlConnection.connect();
                                                            if (this.asyncHandler instanceof TransferCompletionHandler) {
                                                                throw new IllegalStateException(TransferCompletionHandler.class.getName() + "not supported by this provider");
                                                            }
                                                            statusCode = this.urlConnection.getResponseCode();
                                                            JDKAsyncHttpProvider.access$000().debug("\n\nRequest {}\n\nResponse {}\n", (Object)this.request, (Object)statusCode);
                                                            status = new ResponseStatus(uri, this.urlConnection, JDKAsyncHttpProvider.this);
                                                            fc = new FilterContext.FilterContextBuilder<T>().asyncHandler(this.asyncHandler).request(this.request).responseStatus(status).build();
                                                            for (ResponseFilter asyncFilter : JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getResponseFilters()) {
                                                                fc = asyncFilter.filter(fc);
                                                                if (fc != null) continue;
                                                                throw new NullPointerException("FilterContext is null");
                                                            }
                                                            if (!fc.replayRequest()) break block41;
                                                            this.request = fc.getRequest();
                                                            this.urlConnection = JDKAsyncHttpProvider.access$200(JDKAsyncHttpProvider.this, this.request);
                                                            this.terminate = false;
                                                            i$ /* !! */  = this.call();
                                                            if (!this.terminate) break block42;
                                                            if (JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getMaxTotalConnections() == -1) break block43;
                                                            JDKAsyncHttpProvider.access$500(JDKAsyncHttpProvider.this).decrementAndGet();
                                                        }
                                                        this.urlConnection.disconnect();
                                                        if (JDKAsyncHttpProvider.access$600(JDKAsyncHttpProvider.this) != null) {
                                                            System.setProperty("http.auth.ntlm.domain", JDKAsyncHttpProvider.access$600(JDKAsyncHttpProvider.this));
                                                        }
                                                        Authenticator.setDefault(JDKAsyncHttpProvider.access$700(JDKAsyncHttpProvider.this));
                                                    }
                                                    return (T)i$ /* !! */ ;
                                                }
                                                v0 = redirectEnabled = this.request.isRedirectEnabled() != false || JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).isRedirectEnabled() != false;
                                                if (!redirectEnabled || statusCode != 302 && statusCode != 301) ** GOTO lbl69
                                                if (this.currentRedirectCount++ >= JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getMaxRedirects()) ** GOTO lbl68
                                                location = this.urlConnection.getHeaderField("Location");
                                                redirUri = AsyncHttpProviderUtils.getRedirectUri(uri, location);
                                                newUrl = redirUri.toString();
                                                if (newUrl.equals(uri.toString())) break block44;
                                                builder = new RequestBuilder(this.request);
                                                JDKAsyncHttpProvider.access$000().debug("Redirecting to {}", (Object)newUrl);
                                                this.request = builder.setUrl(newUrl).build();
                                                this.urlConnection = JDKAsyncHttpProvider.access$200(JDKAsyncHttpProvider.this, this.request);
                                                this.terminate = false;
                                                var11_20 = this.call();
                                                if (!this.terminate) break block45;
                                                if (JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getMaxTotalConnections() == -1) break block46;
                                                JDKAsyncHttpProvider.access$500(JDKAsyncHttpProvider.this).decrementAndGet();
                                            }
                                            this.urlConnection.disconnect();
                                            if (JDKAsyncHttpProvider.access$600(JDKAsyncHttpProvider.this) != null) {
                                                System.setProperty("http.auth.ntlm.domain", JDKAsyncHttpProvider.access$600(JDKAsyncHttpProvider.this));
                                            }
                                            Authenticator.setDefault(JDKAsyncHttpProvider.access$700(JDKAsyncHttpProvider.this));
                                        }
                                        return var11_20;
                                    }
                                    break block53;
lbl68:
                                    // 1 sources

                                    throw new MaxRedirectException("Maximum redirect reached: " + JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getMaxRedirects());
                                }
                                v1 = realm = this.request.getRealm() != null ? this.request.getRealm() : JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getRealm();
                                if (statusCode != 401 || this.isAuth.getAndSet(true) || realm == null) break block47;
                                wwwAuth = this.urlConnection.getHeaderField("WWW-Authenticate");
                                JDKAsyncHttpProvider.access$000().debug("Sending authentication to {}", (Object)this.request.getUrl());
                                nr = new Realm.RealmBuilder().clone(realm).parseWWWAuthenticateHeader(wwwAuth).setUri(URI.create(this.request.getUrl()).getPath()).setMethodName(this.request.getMethod()).setUsePreemptiveAuth(true).build();
                                builder = new RequestBuilder(this.request);
                                this.request = ((RequestBuilder)builder.setRealm(nr)).build();
                                this.urlConnection = JDKAsyncHttpProvider.access$200(JDKAsyncHttpProvider.this, this.request);
                                this.terminate = false;
                                var11_21 = this.call();
                                if (!this.terminate) break block48;
                                if (JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getMaxTotalConnections() == -1) break block49;
                                JDKAsyncHttpProvider.access$500(JDKAsyncHttpProvider.this).decrementAndGet();
                            }
                            this.urlConnection.disconnect();
                            if (JDKAsyncHttpProvider.access$600(JDKAsyncHttpProvider.this) != null) {
                                System.setProperty("http.auth.ntlm.domain", JDKAsyncHttpProvider.access$600(JDKAsyncHttpProvider.this));
                            }
                            Authenticator.setDefault(JDKAsyncHttpProvider.access$700(JDKAsyncHttpProvider.this));
                        }
                        return var11_21;
                    }
                    state = this.asyncHandler.onStatusReceived(status);
                    if (state == AsyncHandler.STATE.CONTINUE) {
                        state = this.asyncHandler.onHeadersReceived(new ResponseHeaders(uri, this.urlConnection, JDKAsyncHttpProvider.this));
                    }
                    if (state == AsyncHandler.STATE.CONTINUE) {
                        is = JDKAsyncHttpProvider.access$300(JDKAsyncHttpProvider.this, this.urlConnection);
                        contentEncoding /* !! */  = this.urlConnection.getHeaderField("Content-Encoding");
                        v2 = isGZipped = contentEncoding /* !! */  == null ? false : "gzip".equalsIgnoreCase(contentEncoding /* !! */ );
                        if (isGZipped) {
                            is = new GZIPInputStream(is);
                        }
                        byteToRead = this.urlConnection.getContentLength();
                        stream = is;
                        if (JDKAsyncHttpProvider.access$400(JDKAsyncHttpProvider.this) || byteToRead <= 0) {
                            lengthWrapper = new int[1];
                            bytes = AsyncHttpProviderUtils.readFully(is, lengthWrapper);
                            stream = new ByteArrayInputStream(bytes, 0, lengthWrapper[0]);
                            byteToRead = lengthWrapper[0];
                        }
                        if (byteToRead > 0) {
                            minBytes = Math.min(8192, byteToRead);
                            bytes = new byte[minBytes];
                            leftBytes = minBytes < 8192 ? minBytes : byteToRead;
                            read = 0;
                            while (leftBytes > -1 && (read = stream.read(bytes)) != -1) {
                                this.future.touch();
                                b = new byte[read];
                                System.arraycopy(bytes, 0, b, 0, read);
                                this.asyncHandler.onBodyPartReceived(new ResponseBodyPart(uri, b, JDKAsyncHttpProvider.this, (leftBytes -= read) > -1));
                            }
                        }
                        if (this.request.getMethod().equalsIgnoreCase("HEAD")) {
                            this.asyncHandler.onBodyPartReceived(new ResponseBodyPart(uri, "".getBytes(), JDKAsyncHttpProvider.this, true));
                        }
                    }
                    if (this.asyncHandler instanceof ProgressAsyncHandler) {
                        progressAsyncHandler = (ProgressAsyncHandler)this.asyncHandler;
                        progressAsyncHandler.onHeaderWriteCompleted();
                        progressAsyncHandler.onContentWriteCompleted();
                    }
                    t = this.asyncHandler.onCompleted();
                    this.future.content(t);
                    this.future.done();
                    contentEncoding /* !! */  = t;
                    if (!this.terminate) break block50;
                    if (JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getMaxTotalConnections() == -1) break block51;
                    JDKAsyncHttpProvider.access$500(JDKAsyncHttpProvider.this).decrementAndGet();
                }
                this.urlConnection.disconnect();
                if (JDKAsyncHttpProvider.access$600(JDKAsyncHttpProvider.this) != null) {
                    System.setProperty("http.auth.ntlm.domain", JDKAsyncHttpProvider.access$600(JDKAsyncHttpProvider.this));
                }
                Authenticator.setDefault(JDKAsyncHttpProvider.access$700(JDKAsyncHttpProvider.this));
            }
            return (T)contentEncoding /* !! */ ;
            {
                catch (Throwable t) {
                    try {
                        ex = new RuntimeException();
                        ex.initCause(t);
                        throw ex;
                    }
                    catch (Throwable t) {
                        JDKAsyncHttpProvider.access$000().debug(t.getMessage(), t);
                        if (t instanceof IOException && !JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getIOExceptionFilters().isEmpty()) {
                            fc = new FilterContext.FilterContextBuilder<T>().asyncHandler(this.asyncHandler).request(this.request).ioException((IOException)IOException.class.cast(t)).build();
                            try {
                                fc = this.handleIoException(fc);
                            }
                            catch (FilterException e) {
                                if (JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getMaxTotalConnections() != -1) {
                                    JDKAsyncHttpProvider.access$500(JDKAsyncHttpProvider.this).decrementAndGet();
                                }
                                this.future.done();
                            }
                            if (fc.replayRequest()) {
                                this.request = fc.getRequest();
                                this.urlConnection = JDKAsyncHttpProvider.access$200(JDKAsyncHttpProvider.this, this.request);
                                var4_8 = this.call();
                                if (this.terminate) {
                                    if (JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getMaxTotalConnections() != -1) {
                                        JDKAsyncHttpProvider.access$500(JDKAsyncHttpProvider.this).decrementAndGet();
                                    }
                                    this.urlConnection.disconnect();
                                    if (JDKAsyncHttpProvider.access$600(JDKAsyncHttpProvider.this) != null) {
                                        System.setProperty("http.auth.ntlm.domain", JDKAsyncHttpProvider.access$600(JDKAsyncHttpProvider.this));
                                    }
                                    Authenticator.setDefault(JDKAsyncHttpProvider.access$700(JDKAsyncHttpProvider.this));
                                }
                                return var4_8;
                            }
                        }
                        try {
                            try {
                                this.future.abort(this.filterException(t));
                            }
                            catch (Throwable t2) {
                                JDKAsyncHttpProvider.access$000().error(t2.getMessage(), t2);
                            }
                        }
                        catch (Throwable var18_30) {
                            throw var18_30;
                        }
                        finally {
                            if (this.terminate) {
                                if (JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getMaxTotalConnections() != -1) {
                                    JDKAsyncHttpProvider.access$500(JDKAsyncHttpProvider.this).decrementAndGet();
                                }
                                this.urlConnection.disconnect();
                                if (JDKAsyncHttpProvider.access$600(JDKAsyncHttpProvider.this) != null) {
                                    System.setProperty("http.auth.ntlm.domain", JDKAsyncHttpProvider.access$600(JDKAsyncHttpProvider.this));
                                }
                                Authenticator.setDefault(JDKAsyncHttpProvider.access$700(JDKAsyncHttpProvider.this));
                            }
                        }
                    }
                }
            }
            return null;
        }

        private FilterContext handleIoException(FilterContext fc) throws FilterException {
            for (IOExceptionFilter asyncFilter : JDKAsyncHttpProvider.this.config.getIOExceptionFilters()) {
                fc = asyncFilter.filter(fc);
                if (fc != null) continue;
                throw new NullPointerException("FilterContext is null");
            }
            return fc;
        }

        private Throwable filterException(Throwable t) {
            if (t instanceof UnknownHostException) {
                t = new ConnectException(t.getMessage());
            } else if (t instanceof SocketTimeoutException) {
                int responseTimeoutInMs = JDKAsyncHttpProvider.this.config.getRequestTimeoutInMs();
                if (this.request.getPerRequestConfig() != null && this.request.getPerRequestConfig().getRequestTimeoutInMs() != -1) {
                    responseTimeoutInMs = this.request.getPerRequestConfig().getRequestTimeoutInMs();
                }
                t = new TimeoutException(String.format("No response received after %s", responseTimeoutInMs));
            } else if (t instanceof SSLHandshakeException) {
                ConnectException t2 = new ConnectException();
                t2.initCause(t);
                t = t2;
            }
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void configure(URI uri, HttpURLConnection urlConnection, Request request) throws IOException, AuthenticationException {
            block68: {
                Realm realm;
                FluentCaseInsensitiveStringsMap h;
                PerRequestConfig conf = request.getPerRequestConfig();
                int requestTimeout = conf != null && conf.getRequestTimeoutInMs() != 0 ? conf.getRequestTimeoutInMs() : JDKAsyncHttpProvider.this.config.getRequestTimeoutInMs();
                urlConnection.setConnectTimeout(JDKAsyncHttpProvider.this.config.getConnectionTimeoutInMs());
                if (requestTimeout != -1) {
                    urlConnection.setReadTimeout(requestTimeout);
                }
                urlConnection.setInstanceFollowRedirects(false);
                String host = uri.getHost();
                String method = request.getMethod();
                if (request.getVirtualHost() != null) {
                    host = request.getVirtualHost();
                }
                if (uri.getPort() == -1 || request.getVirtualHost() != null) {
                    urlConnection.setRequestProperty("Host", host);
                } else {
                    urlConnection.setRequestProperty("Host", host + ":" + uri.getPort());
                }
                if (JDKAsyncHttpProvider.this.config.isCompressionEnabled()) {
                    urlConnection.setRequestProperty("Accept-Encoding", "gzip");
                }
                if (!method.equalsIgnoreCase("CONNECT") && (h = request.getHeaders()) != null) {
                    for (String name : h.keySet()) {
                        if ("host".equalsIgnoreCase(name)) continue;
                        Iterator i$ = h.get(name).iterator();
                        while (i$.hasNext()) {
                            String value = (String)i$.next();
                            urlConnection.setRequestProperty(name, value);
                            if (!name.equalsIgnoreCase("Expect")) continue;
                            throw new IllegalStateException("Expect: 100-Continue not supported");
                        }
                    }
                }
                String ka = AsyncHttpProviderUtils.keepAliveHeaderValue(JDKAsyncHttpProvider.this.config);
                urlConnection.setRequestProperty("Connection", ka);
                ProxyServer proxyServer = ProxyUtils.getProxyServer(JDKAsyncHttpProvider.this.config, request);
                boolean avoidProxy = ProxyUtils.avoidProxy(proxyServer, uri.getHost());
                if (!avoidProxy) {
                    urlConnection.setRequestProperty("Proxy-Connection", ka);
                    if (proxyServer.getPrincipal() != null) {
                        urlConnection.setRequestProperty("Proxy-Authorization", AuthenticatorUtils.computeBasicAuthentication(proxyServer));
                    }
                    if (proxyServer.getProtocol().equals((Object)ProxyServer.Protocol.NTLM)) {
                        JDKAsyncHttpProvider.this.jdkNtlmDomain = System.getProperty(JDKAsyncHttpProvider.NTLM_DOMAIN);
                        System.setProperty(JDKAsyncHttpProvider.NTLM_DOMAIN, proxyServer.getNtlmDomain());
                    }
                }
                Realm realm2 = realm = request.getRealm() != null ? request.getRealm() : JDKAsyncHttpProvider.this.config.getRealm();
                if (realm != null && realm.getUsePreemptiveAuth()) {
                    switch (realm.getAuthScheme()) {
                        case BASIC: {
                            urlConnection.setRequestProperty("Authorization", AuthenticatorUtils.computeBasicAuthentication(realm));
                            break;
                        }
                        case DIGEST: {
                            if (!MiscUtil.isNonEmpty(realm.getNonce())) break;
                            try {
                                urlConnection.setRequestProperty("Authorization", AuthenticatorUtils.computeDigestAuthentication(realm));
                                break;
                            }
                            catch (NoSuchAlgorithmException e) {
                                throw new SecurityException(e);
                            }
                        }
                        case NTLM: {
                            JDKAsyncHttpProvider.this.jdkNtlmDomain = System.getProperty(JDKAsyncHttpProvider.NTLM_DOMAIN);
                            System.setProperty(JDKAsyncHttpProvider.NTLM_DOMAIN, realm.getDomain());
                            break;
                        }
                        case NONE: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException(String.format("Invalid Authentication %s", realm.toString()));
                        }
                    }
                }
                if (request.getHeaders().getFirstValue("Accept") == null) {
                    urlConnection.setRequestProperty("Accept", "*/*");
                }
                if (request.getHeaders().getFirstValue("User-Agent") != null) {
                    urlConnection.setRequestProperty("User-Agent", request.getHeaders().getFirstValue("User-Agent"));
                } else if (JDKAsyncHttpProvider.this.config.getUserAgent() != null) {
                    urlConnection.setRequestProperty("User-Agent", JDKAsyncHttpProvider.this.config.getUserAgent());
                } else {
                    urlConnection.setRequestProperty("User-Agent", AsyncHttpProviderUtils.constructUserAgent(JDKAsyncHttpProvider.class));
                }
                if (MiscUtil.isNonEmpty(request.getCookies())) {
                    urlConnection.setRequestProperty("Cookie", CookieEncoder.encode(request.getCookies()));
                }
                String reqType = request.getMethod();
                urlConnection.setRequestMethod(reqType);
                if ("POST".equals(reqType) || "PUT".equals(reqType)) {
                    String bodyCharset;
                    urlConnection.setRequestProperty("Content-Length", "0");
                    urlConnection.setDoOutput(true);
                    String string = bodyCharset = request.getBodyEncoding() == null ? "ISO-8859-1" : request.getBodyEncoding();
                    if (this.cachedBytes != null) {
                        urlConnection.setRequestProperty("Content-Length", String.valueOf(this.cachedBytesLenght));
                        urlConnection.setFixedLengthStreamingMode(this.cachedBytesLenght);
                        urlConnection.getOutputStream().write(this.cachedBytes, 0, this.cachedBytesLenght);
                    } else if (request.getByteData() != null) {
                        urlConnection.setRequestProperty("Content-Length", String.valueOf(request.getByteData().length));
                        urlConnection.setFixedLengthStreamingMode(request.getByteData().length);
                        urlConnection.getOutputStream().write(request.getByteData());
                    } else if (request.getStringData() != null) {
                        if (!request.getHeaders().containsKey("Content-Type")) {
                            urlConnection.setRequestProperty("Content-Type", "text/html;" + bodyCharset);
                        }
                        byte[] b = request.getStringData().getBytes(bodyCharset);
                        urlConnection.setRequestProperty("Content-Length", String.valueOf(b.length));
                        urlConnection.getOutputStream().write(b);
                    } else if (request.getStreamData() != null) {
                        int[] lengthWrapper = new int[1];
                        this.cachedBytes = AsyncHttpProviderUtils.readFully(request.getStreamData(), lengthWrapper);
                        this.cachedBytesLenght = lengthWrapper[0];
                        urlConnection.setRequestProperty("Content-Length", String.valueOf(this.cachedBytesLenght));
                        urlConnection.setFixedLengthStreamingMode(this.cachedBytesLenght);
                        urlConnection.getOutputStream().write(this.cachedBytes, 0, this.cachedBytesLenght);
                    } else if (request.getParams() != null) {
                        StringBuilder sb = new StringBuilder();
                        for (Map.Entry<String, List<String>> paramEntry : request.getParams()) {
                            String key = paramEntry.getKey();
                            for (String value : paramEntry.getValue()) {
                                if (sb.length() > 0) {
                                    sb.append("&");
                                }
                                UTF8UrlEncoder.appendEncoded(sb, key);
                                sb.append("=");
                                UTF8UrlEncoder.appendEncoded(sb, value);
                            }
                        }
                        urlConnection.setRequestProperty("Content-Length", String.valueOf(sb.length()));
                        urlConnection.setFixedLengthStreamingMode(sb.length());
                        if (!request.getHeaders().containsKey("Content-Type")) {
                            urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        }
                        urlConnection.getOutputStream().write(sb.toString().getBytes(bodyCharset));
                    } else if (request.getParts() != null) {
                        int lenght = (int)request.getContentLength();
                        if (lenght != -1) {
                            urlConnection.setRequestProperty("Content-Length", String.valueOf(lenght));
                            urlConnection.setFixedLengthStreamingMode(lenght);
                        }
                        if (lenght == -1) {
                            lenght = 8192;
                        }
                        MultipartRequestEntity mre = AsyncHttpProviderUtils.createMultipartRequestEntity(request.getParts(), request.getHeaders());
                        urlConnection.setRequestProperty("Content-Type", mre.getContentType());
                        urlConnection.setRequestProperty("Content-Length", String.valueOf(mre.getContentLength()));
                        mre.writeRequest(urlConnection.getOutputStream());
                    } else if (request.getEntityWriter() != null) {
                        int lenght = (int)request.getContentLength();
                        if (lenght != -1) {
                            urlConnection.setRequestProperty("Content-Length", String.valueOf(lenght));
                            urlConnection.setFixedLengthStreamingMode(lenght);
                        }
                        request.getEntityWriter().writeEntity(urlConnection.getOutputStream());
                    } else {
                        if (request.getFile() != null) {
                            File file = request.getFile();
                            if (!file.isFile()) {
                                throw new IOException(String.format(Thread.currentThread() + "File %s is not a file or doesn't exist", file.getAbsolutePath()));
                            }
                            urlConnection.setRequestProperty("Content-Length", String.valueOf(file.length()));
                            urlConnection.setFixedLengthStreamingMode((int)file.length());
                            FileInputStream fis = new FileInputStream(file);
                            try {
                                OutputStream os = urlConnection.getOutputStream();
                                byte[] buffer = new byte[16384];
                                while (true) {
                                    int read;
                                    if ((read = fis.read(buffer)) < 0) {
                                        break block68;
                                    }
                                    os.write(buffer, 0, read);
                                }
                            }
                            finally {
                                fis.close();
                            }
                        }
                        if (request.getBodyGenerator() != null) {
                            Body body = request.getBodyGenerator().createBody();
                            try {
                                int length = (int)body.getContentLength();
                                if (length < 0) {
                                    length = (int)request.getContentLength();
                                }
                                if (length >= 0) {
                                    urlConnection.setRequestProperty("Content-Length", String.valueOf(length));
                                    urlConnection.setFixedLengthStreamingMode(length);
                                }
                                OutputStream os = urlConnection.getOutputStream();
                                ByteBuffer buffer = ByteBuffer.allocate(8192);
                                while (true) {
                                    buffer.clear();
                                    if (body.read(buffer) < 0L) {
                                        break;
                                    }
                                    os.write(buffer.array(), buffer.arrayOffset(), buffer.position());
                                }
                            }
                            finally {
                                try {
                                    body.close();
                                }
                                catch (IOException e) {
                                    logger.warn("Failed to close request body: {}", (Object)e.getMessage(), (Object)e);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

