/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.pgm.AbstractFetchCommand;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.SystemReader;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_cloneRepositoryIntoNewDir")
class Clone
extends AbstractFetchCommand {
    @Option(name="--origin", aliases={"-o"}, metaVar="metaVar_remoteName", usage="usage_useNameInsteadOfOriginToTrackUpstream")
    private String remoteName = "origin";
    @Option(name="--branch", aliases={"-b"}, metaVar="metaVar_branchName", usage="usage_checkoutBranchAfterClone")
    private String branch;
    @Option(name="--no-checkout", aliases={"-n"}, usage="usage_noCheckoutAfterClone")
    private boolean noCheckout;
    @Option(name="--bare", usage="usage_bareClone")
    private boolean isBare;
    @Argument(index=0, required=true, metaVar="metaVar_uriish")
    private String sourceUri;
    @Argument(index=1, metaVar="metaVar_directory")
    private String localName;

    Clone() {
    }

    protected final boolean requiresRepository() {
        return false;
    }

    protected void run() throws Exception {
        File localNameF;
        if (this.localName != null && this.gitdir != null) {
            throw Clone.die(CLIText.get().conflictingUsageOf_git_dir_andArguments);
        }
        URIish uri = new URIish(this.sourceUri);
        if (this.localName == null) {
            try {
                this.localName = uri.getHumanishName();
                localNameF = new File(SystemReader.getInstance().getProperty("user.dir"), this.localName);
            }
            catch (IllegalArgumentException e) {
                throw Clone.die(MessageFormat.format(CLIText.get().cannotGuessLocalNameFrom, this.sourceUri));
            }
        } else {
            localNameF = new File(this.localName);
        }
        if (this.branch == null) {
            this.branch = "HEAD";
        }
        CloneCommand command = Git.cloneRepository();
        command.setURI(this.sourceUri).setRemote(this.remoteName).setBare(this.isBare).setNoCheckout(this.noCheckout).setBranch(this.branch);
        command.setGitDir(this.gitdir == null ? null : new File(this.gitdir));
        command.setDirectory(localNameF);
        this.outw.println(MessageFormat.format(CLIText.get().cloningInto, this.localName));
        try {
            this.db = command.call().getRepository();
            if (this.db.resolve("HEAD") == null) {
                this.outw.println(CLIText.get().clonedEmptyRepository);
            }
        }
        catch (InvalidRemoteException e) {
            throw Clone.die(MessageFormat.format(CLIText.get().doesNotExist, this.sourceUri));
        }
        finally {
            if (this.db != null) {
                this.db.close();
            }
        }
        this.outw.println();
        this.outw.flush();
    }
}

