/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.Coords;
import megamek.common.CriticalSlot;
import megamek.common.HitData;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Mounted;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.RapidfireACWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HVACWeaponHandler
extends RapidfireACWeaponHandler {
    private static final long serialVersionUID = 7326881584091651519L;

    public HVACWeaponHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    public boolean handle(IGame.Phase phase, Vector<Report> vector) {
        if (this.game.getOptions().booleanOption("tacops_start_fire") && this.game.getPlanetaryConditions().getAtmosphere() >= 1) {
            int n = (this.ae.getFacing() + 3) % 6;
            Coords coords = this.ae.getPosition();
            Coords coords2 = coords.translated(n);
            IBoard iBoard = this.game.getBoard();
            IHex iHex = iBoard.getHex(coords);
            if (!iBoard.contains(coords2)) {
                coords2 = coords;
            } else if (iBoard.getHex(coords2).getElevation() > iHex.getElevation() + 4) {
                coords2 = coords;
            } else if (iBoard.getBuildingAt(coords2) != null && iBoard.getHex(coords2).terrainLevel(24) + iBoard.getHex(coords2).getElevation() > iHex.getElevation() + 4) {
                coords2 = coords;
            }
            this.server.createSmoke(coords2, 2, 2);
        }
        return super.handle(phase, vector);
    }

    @Override
    protected boolean doChecks(Vector<Report> vector) {
        int n;
        if (this.roll == 2) {
            this.r = new Report(3162);
            this.r.subject = this.subjectId;
            this.weapon.setJammed(false);
            this.weapon.setHit(true);
            n = this.weapon.getLocation();
            this.weapon.setDestroyed(true);
            for (int i = 0; i < this.ae.getNumberOfCriticals(n); ++i) {
                Mounted mounted;
                CriticalSlot criticalSlot = this.ae.getCritical(n, i);
                if (criticalSlot == null || criticalSlot.getType() != 0 || !(mounted = this.ae.getEquipment(criticalSlot.getIndex())).equals(this.weapon)) continue;
                this.ae.hitAllCriticals(n, i);
                break;
            }
        } else {
            return super.doChecks(vector);
        }
        vector.addAll(this.server.damageEntity(this.ae, new HitData(n), this.wtype.getDamage(), true, Server.DamageType.NONE, true));
        this.r.choose(false);
        vector.addElement(this.r);
        return false;
    }
}

