/*
 * Decompiled with CFR 0.152.
 */
package megamek.server.commands;

import megamek.common.Coords;
import megamek.common.LosEffects;
import megamek.common.ToHitData;
import megamek.server.Server;
import megamek.server.commands.ServerCommand;

public class RulerCommand
extends ServerCommand {
    public RulerCommand(Server server) {
        super(server, "ruler", "Show Line of Sight (LOS) information between two points of the map. Usage: /ruler x1 y1 x2 y2 [elev1 [elev2]]. Where x1, y1 and x2, y2 are the coordiantes of the tiles, and the optional elev numbers are the elevations of the targets over the terrain. If elev is not given 1 is assumed which is for standing mechs. Prone mechs and most other units are at elevation 0.");
    }

    public void run(int n, String[] stringArray) {
        try {
            ToHitData toHitData;
            int n2 = 1;
            int n3 = 1;
            Coords coords = null;
            Coords coords2 = null;
            String string = "";
            String string2 = "";
            coords = new Coords(Integer.parseInt(stringArray[1]) - 1, Integer.parseInt(stringArray[2]) - 1);
            coords2 = new Coords(Integer.parseInt(stringArray[3]) - 1, Integer.parseInt(stringArray[4]) - 1);
            if (stringArray.length > 5) {
                try {
                    n2 = Integer.parseInt(stringArray[5]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (stringArray.length > 6) {
                    try {
                        n2 = Integer.parseInt(stringArray[6]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if ((toHitData = LosEffects.calculateLos(this.server.getGame(), this.buildAttackInfo(coords, coords2, n2, n3)).losModifiers(this.server.getGame())).getValue() != Integer.MAX_VALUE) {
                string = toHitData.getValue() + " because ";
            }
            string = string + toHitData.getDesc();
            toHitData = LosEffects.calculateLos(this.server.getGame(), this.buildAttackInfo(coords2, coords, n3, n2)).losModifiers(this.server.getGame());
            if (toHitData.getValue() != Integer.MAX_VALUE) {
                string2 = toHitData.getValue() + " because  ";
            }
            string2 = string2 + toHitData.getDesc();
            this.server.sendServerChat(n, "The ToHit from hex (" + (coords.x + 1) + ", " + (coords.y + 1) + ") at elevation " + n2 + " to (" + (coords2.x + 1) + ", " + (coords2.y + 1) + ") at elevation " + n3 + " has a range of " + coords.distance(coords2) + " and a modifier of " + string + " and return fire has a modifier of " + string2 + ".");
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private LosEffects.AttackInfo buildAttackInfo(Coords coords, Coords coords2, int n, int n2) {
        LosEffects.AttackInfo attackInfo = new LosEffects.AttackInfo();
        attackInfo.attackPos = coords;
        attackInfo.targetPos = coords2;
        attackInfo.attackHeight = n;
        attackInfo.targetHeight = n2;
        attackInfo.attackAbsHeight = this.server.getGame().getBoard().getHex(coords).floor() + n;
        attackInfo.targetAbsHeight = this.server.getGame().getBoard().getHex(coords2).floor() + n2;
        return attackInfo;
    }
}

