#!/bin/bash

set -eo pipefail

mkdir -p /dev/net

if ! [ -c /dev/net/tun ]; then
    echo "$(date) Creating tun/tap device."
    mknod /dev/net/tun c 10 200
fi

# Update proto in client.conf in shared volume just in case
sed -r -i "s/(^proto) .*$/\1 $PROTO/" /vpn/client.ovpn || echo "failed to update /vpn/client.ovpn"

if [[ "$HOP_PT" == "1" ]]; then
    if [[ "$KCP" == "1" ]]; then
        echo -e "\nStarting Hopping PT and KCP is currently mutual exclusive. Ignoring KCP environment variable.\n"
    fi

    echo "Starting obfsvpn-client in hopping mode"
    /usr/bin/obfsvpn-client -h -c "$OBFS4_CERT1,$OBFS4_CERT1" -r "$OBFS4_SERVER_HOST1,$OBFS4_SERVER_HOST2" \
      -m "$MIN_HOP_SECONDS" -j "$HOP_JITTER" -v &

    # start openvpn in udp hopping mode
    # set connect-retry low to help facilitate integration test
    openvpn --config /vpn/client.ovpn --connect-retry 1 --remote 127.0.0.1 8080

elif [[ "$KCP" == "1" ]]; then
    echo "Starting obfsvpn-client in KCP mode"
    /usr/bin/obfsvpn-client -kcp -c "$OBFS4_CERT1" -r "$OBFS4_SERVER_HOST_KCP" -rp "$OBFS4_PORT" -v &

    # start openvpn in traditional mode
    openvpn --config /vpn/client.ovpn --socks-proxy 127.0.0.1 8080 --remote "$OBFS4_SERVER_HOST_KCP" "$OBFS4_PORT"
else
    # start the obfsvpn-client in traditional mode
    /usr/bin/obfsvpn-client -c "$OBFS4_CERT1" -r "$OBFS4_SERVER_HOST1" -rp "$OBFS4_PORT" -v &

    # start openvpn in traditional mode
    openvpn --config /vpn/client.ovpn --socks-proxy 127.0.0.1 8080 --remote "$OBFS4_SERVER_HOST1" "$OBFS4_PORT"
fi

exit $?

