/*
* This code is released under the GNU General Public License.  See COPYING for 
* details.  Copyright 2003 John Spray: spray_john@users.sourceforge.net
*/



#include "Events.h"
#include "SoundCore.h"
#include "Visual.h"
#include "Config.h"
#include "Ufo.h"

extern Config GLOB_conf;
#include <SDL.h>


Events::Events()
{
				//SDL_EventState(SDL_SysWMEvent, SDL_ENABLE);
}

void Events::HandleEvents()
{
	SDL_Event event;

	while(SDL_PollEvent(&event)){
		switch(event.type){
			case SDL_KEYDOWN:
				HandleKeysDown(event.key.keysym);
				break;
			case SDL_KEYUP:
				HandleKeysUp(event.key.keysym);
				break;
			case SDL_JOYAXISMOTION:
				break;
			case SDL_JOYBUTTONDOWN:
				break;
			case SDL_JOYBUTTONUP:
				break;
			case SDL_QUIT:
				game->quit=2;
				break;
			case SDL_VIDEORESIZE:
				game->Resize(event.resize.w,event.resize.h);
				break;
			case SDL_MOUSEMOTION:
				//keyboardtarget->bearv=(keyboardtarget->bear-GLOB_conf.mousespeed*(((float)event.motion.xrel/50.0f)))/game->dtf;
				keyboardtarget->bear-=GLOB_conf.mousespeed*(((float)event.motion.xrel/50.0f));
				break;
			case SDL_MOUSEBUTTONDOWN:
				if(event.button.button==SDL_BUTTON_RIGHT)
					keyboardtarget->FireMissile();
				if(event.button.button==SDL_BUTTON_LEFT)
					keyboardtarget->StartCannon();
				break;
			case SDL_MOUSEBUTTONUP:
				if(event.button.button==SDL_BUTTON_LEFT)
					keyboardtarget->StopCannon();
				break;
			case SDL_ACTIVEEVENT:
				if(event.active.gain==0)
								game->ShowMenu();
				break;
		}
	}
}



void Events::HandleKeysDown(SDL_keysym keysym)
{
	if(!keyboardtarget){
		printf("Events::HandleKeysDown: keyboardtarget is unset!\n");
	}
	else if(keysym.sym==SDLK_ESCAPE){
		game->ShowMenu();
	}
	else if(keysym.sym==SDLK_RETURN){
		keyboardtarget->Respawn();
	}
	else if(keysym.sym==GLOB_conf.keys.turnleft){
		keyboardtarget->beara+=0.00004f;
	}
	else if(keysym.sym== GLOB_conf.keys.turnright){
		keyboardtarget->beara-=0.00004f;
	}
	else if(keysym.sym==GLOB_conf.keys.strafeleft){
		keyboardtarget->strafea+=1.0f;
	}
	else if(keysym.sym== GLOB_conf.keys.straferight){
		keyboardtarget->strafea-=1.0f;
	}
	else if(keysym.sym== GLOB_conf.keys.forward){
		keyboardtarget->thrust+=1.0f;
	}
	else if(keysym.sym== GLOB_conf.keys.back){
		keyboardtarget->thrust-=1.0f;
	}
	else if(keysym.sym== GLOB_conf.keys.firemissile){
		keyboardtarget->FireMissile();
	}
	else if(keysym.sym== GLOB_conf.keys.firecannon){
		keyboardtarget->StartCannon();
	}
	else if(keysym.sym== SDLK_0){
		targetcam->movemode=CAMERA_MOVEMODE_FREE;
	}
	else if(keysym.sym== SDLK_1){
		targetcam->movemode=CAMERA_MOVEMODE_CHASE;
	}
	else if(keysym.sym== SDLK_2){
		targetcam->movemode=CAMERA_MOVEMODE_CLOSE;
	}
	else if(keysym.sym== SDLK_3){
		targetcam->movemode=CAMERA_MOVEMODE_GOD;
	}
	else if(keysym.sym== SDLK_4){
		targetcam->movemode=CAMERA_MOVEMODE_REAR;
	}
	else if(keysym.sym== SDLK_KP_PLUS){
		targetcam->offset*=1.1f;
	}
	else if(keysym.sym== SDLK_KP_MINUS){
		targetcam->offset/=1.1f;
	}
	#ifndef RELEASE
	else if(keysym.sym== SDLK_F1){
		printf("%f,%f,%f\n",keyboardtarget->s.x,keyboardtarget->s.y,keyboardtarget->s.z);
	}
	else if(keysym.sym== SDLK_F2){
		keyboardtarget->TriggerShield();
	}
	else if(keysym.sym== SDLK_F3){
		Ufo newufo;
		newufo.s.x=1;
		newufo.s.z=1;
   		game->NewUfo(&newufo);
	}
	else if(keysym.sym==SDLK_F4){
		keyboardtarget->Hurt(1.0f);
	}
	else if(keysym.sym== SDLK_F5){
		PowerUp newpup;
		newpup.s.x=1.0f;
		newpup.s.z=1.0f;
		newpup.s.y=3.0f;
		newpup.nature=POWERUP_GUIDANCE;
		game->NewPowerUp(&newpup);
	}
	else if(keysym.sym==SDLK_F6){
		keyboardtarget->Explode();
	}
	else if(keysym.sym==SDLK_F7){
		Mine newmine;
		newmine.s.x=1.0f;
		newmine.s.z=1.0f;
		newmine.s.y=3.0f;
		game->NewMine(&newmine);
	}
	else if(keysym.sym==SDLK_F8){
		keyboardtarget->GivePowerUp(POWERUP_GUIDANCE);
	}
	else if(keysym.sym==SDLK_F12){
		SDL_SaveBMP(game->screen,"your_mother.bmp");
	}
	else if(keysym.sym== SDLK_MINUS){
		game->timescale/=1.1f;
		printf("Events::HandleKeysDown: game->timescale=%f\n",game->timescale);
	}
	else if(keysym.sym== SDLK_EQUALS){
		game->timescale*=1.1f;
		printf("Events::HandleKeysDown: game->timescale=%f\n",game->timescale);
	}
	#endif //RELEASE
	else if(keysym.sym==GLOB_conf.keys.fullscreen){
		if(SDL_WM_ToggleFullScreen(game->screen))
			GLOB_conf.fullscreen=!GLOB_conf.fullscreen;
	}
	else if(keysym.sym== GLOB_conf.keys.togglegrab){
		ToggleGrab();
	}
	else if(keysym.sym== GLOB_conf.keys.camleft){
		targetcam->bearv=0.005f;
	}
	else if(keysym.sym== GLOB_conf.keys.camright){
		targetcam->bearv=-0.005f;
	}
	else if(keysym.sym== SDLK_PAGEUP){
		game->sound->SetVolume(game->sound->GetVolume()+0.1f);
		printf("Events::HandleKeysDown: game->sound->volume is %f\n",game->sound->GetVolume());
	}
	else if(keysym.sym== SDLK_PAGEDOWN){
		game->sound->SetVolume(game->sound->GetVolume()-0.1f);
		printf("Events::HandleKeysDown: game->sound->volume is %f\n",game->sound->GetVolume());
	}

	
}


void Events::HandleKeysUp(SDL_keysym keysym)
{
	if(keysym.sym== GLOB_conf.keys.turnleft){
		keyboardtarget->beara-=0.00004f;
	}
	else if(keysym.sym== GLOB_conf.keys.turnright){
		keyboardtarget->beara+=0.00004f;
	}
	else if(keysym.sym==GLOB_conf.keys.strafeleft){
		keyboardtarget->strafea-=1.0f;
	}
	else if(keysym.sym== GLOB_conf.keys.straferight){
		keyboardtarget->strafea+=1.0f;
	}
	else if(keysym.sym== GLOB_conf.keys.forward){
		keyboardtarget->thrust-=1.0f;
	}
	else if(keysym.sym== GLOB_conf.keys.back){
		keyboardtarget->thrust+=1.0f;
	}
	else if(keysym.sym== GLOB_conf.keys.camleft){
		targetcam->bearv=0.0f;
	}
	else if(keysym.sym== GLOB_conf.keys.camright){
		targetcam->bearv=0.0f;
	}
	else if(keysym.sym== GLOB_conf.keys.firecannon){
		keyboardtarget->StopCannon();
	}

}

void Events::ToggleGrab()
{
	if(SDL_WM_GrabInput(SDL_GRAB_QUERY)==SDL_GRAB_ON){
		SDL_WM_GrabInput(SDL_GRAB_OFF);
		SDL_ShowCursor(SDL_TRUE);
		printf("Events::HandleKeysDown: ungrabbed input\n");}
	else{
		SDL_WM_GrabInput(SDL_GRAB_ON);
		SDL_ShowCursor(SDL_FALSE);
		printf("Events::HandleKeysDown: grabbed input\n");}
}

