#[cfg(feature = "UI_Composition_Core")]
pub mod Core;
#[cfg(feature = "UI_Composition_Desktop")]
pub mod Desktop;
#[cfg(feature = "UI_Composition_Diagnostics")]
pub mod Diagnostics;
#[cfg(feature = "UI_Composition_Effects")]
pub mod Effects;
#[cfg(feature = "UI_Composition_Interactions")]
pub mod Interactions;
#[cfg(feature = "UI_Composition_Scenes")]
pub mod Scenes;
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct AmbientLight(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(AmbientLight, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(AmbientLight, IAnimationObject, super::super::Foundation::IClosable, CompositionLight, CompositionObject);
impl AmbientLight {
    pub fn Color(&self) -> windows_core::Result<super::Color> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Color)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetColor(&self, value: super::Color) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetColor)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Intensity(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<IAmbientLight2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Intensity)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetIntensity(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IAmbientLight2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetIntensity)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn Targets(&self) -> windows_core::Result<VisualUnorderedCollection> {
        let this = &windows_core::Interface::cast::<ICompositionLight>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Targets)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ExclusionsFromTargets(&self) -> windows_core::Result<VisualUnorderedCollection> {
        let this = &windows_core::Interface::cast::<ICompositionLight2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ExclusionsFromTargets)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn IsEnabled(&self) -> windows_core::Result<bool> {
        let this = &windows_core::Interface::cast::<ICompositionLight3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IsEnabled)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetIsEnabled(&self, value: bool) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionLight3>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetIsEnabled)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for AmbientLight {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, IAmbientLight>();
}
unsafe impl windows_core::Interface for AmbientLight {
    type Vtable = <IAmbientLight as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <IAmbientLight as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for AmbientLight {
    const NAME: &'static str = "Windows.UI.Composition.AmbientLight";
}
unsafe impl Send for AmbientLight {}
unsafe impl Sync for AmbientLight {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct AnimationController(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(AnimationController, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(AnimationController, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl AnimationController {
    pub fn PlaybackRate(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).PlaybackRate)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetPlaybackRate(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetPlaybackRate)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Progress(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Progress)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetProgress(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetProgress)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn ProgressBehavior(&self) -> windows_core::Result<AnimationControllerProgressBehavior> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ProgressBehavior)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetProgressBehavior(&self, value: AnimationControllerProgressBehavior) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetProgressBehavior)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Pause(&self) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).Pause)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Resume(&self) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).Resume)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn MaxPlaybackRate() -> windows_core::Result<f32> {
        Self::IAnimationControllerStatics(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).MaxPlaybackRate)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        })
    }
    pub fn MinPlaybackRate() -> windows_core::Result<f32> {
        Self::IAnimationControllerStatics(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).MinPlaybackRate)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        })
    }
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    fn IAnimationControllerStatics<R, F: FnOnce(&IAnimationControllerStatics) -> windows_core::Result<R>>(callback: F) -> windows_core::Result<R> {
        static SHARED: windows_core::imp::FactoryCache<AnimationController, IAnimationControllerStatics> = windows_core::imp::FactoryCache::new();
        SHARED.call(callback)
    }
}
impl windows_core::RuntimeType for AnimationController {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, IAnimationController>();
}
unsafe impl windows_core::Interface for AnimationController {
    type Vtable = <IAnimationController as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <IAnimationController as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for AnimationController {
    const NAME: &'static str = "Windows.UI.Composition.AnimationController";
}
unsafe impl Send for AnimationController {}
unsafe impl Sync for AnimationController {}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AnimationControllerProgressBehavior(pub i32);
impl AnimationControllerProgressBehavior {
    pub const Default: Self = Self(0i32);
    pub const IncludesDelayTime: Self = Self(1i32);
}
impl windows_core::TypeKind for AnimationControllerProgressBehavior {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for AnimationControllerProgressBehavior {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.AnimationControllerProgressBehavior;i4)");
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AnimationDelayBehavior(pub i32);
impl AnimationDelayBehavior {
    pub const SetInitialValueAfterDelay: Self = Self(0i32);
    pub const SetInitialValueBeforeDelay: Self = Self(1i32);
}
impl windows_core::TypeKind for AnimationDelayBehavior {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for AnimationDelayBehavior {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.AnimationDelayBehavior;i4)");
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AnimationDirection(pub i32);
impl AnimationDirection {
    pub const Normal: Self = Self(0i32);
    pub const Reverse: Self = Self(1i32);
    pub const Alternate: Self = Self(2i32);
    pub const AlternateReverse: Self = Self(3i32);
}
impl windows_core::TypeKind for AnimationDirection {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for AnimationDirection {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.AnimationDirection;i4)");
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AnimationIterationBehavior(pub i32);
impl AnimationIterationBehavior {
    pub const Count: Self = Self(0i32);
    pub const Forever: Self = Self(1i32);
}
impl windows_core::TypeKind for AnimationIterationBehavior {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for AnimationIterationBehavior {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.AnimationIterationBehavior;i4)");
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AnimationPropertyAccessMode(pub i32);
impl AnimationPropertyAccessMode {
    pub const None: Self = Self(0i32);
    pub const ReadOnly: Self = Self(1i32);
    pub const WriteOnly: Self = Self(2i32);
    pub const ReadWrite: Self = Self(3i32);
}
impl windows_core::TypeKind for AnimationPropertyAccessMode {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for AnimationPropertyAccessMode {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.AnimationPropertyAccessMode;i4)");
}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct AnimationPropertyInfo(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(AnimationPropertyInfo, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(AnimationPropertyInfo, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl AnimationPropertyInfo {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn AccessMode(&self) -> windows_core::Result<AnimationPropertyAccessMode> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).AccessMode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetAccessMode(&self, value: AnimationPropertyAccessMode) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetAccessMode)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn GetResolvedCompositionObject(&self) -> windows_core::Result<CompositionObject> {
        let this = &windows_core::Interface::cast::<IAnimationPropertyInfo2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).GetResolvedCompositionObject)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn GetResolvedCompositionObjectProperty(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<IAnimationPropertyInfo2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).GetResolvedCompositionObjectProperty)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for AnimationPropertyInfo {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, IAnimationPropertyInfo>();
}
unsafe impl windows_core::Interface for AnimationPropertyInfo {
    type Vtable = <IAnimationPropertyInfo as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <IAnimationPropertyInfo as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for AnimationPropertyInfo {
    const NAME: &'static str = "Windows.UI.Composition.AnimationPropertyInfo";
}
unsafe impl Send for AnimationPropertyInfo {}
unsafe impl Sync for AnimationPropertyInfo {}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AnimationStopBehavior(pub i32);
impl AnimationStopBehavior {
    pub const LeaveCurrentValue: Self = Self(0i32);
    pub const SetToInitialValue: Self = Self(1i32);
    pub const SetToFinalValue: Self = Self(2i32);
}
impl windows_core::TypeKind for AnimationStopBehavior {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for AnimationStopBehavior {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.AnimationStopBehavior;i4)");
}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct BackEasingFunction(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(BackEasingFunction, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(BackEasingFunction, IAnimationObject, super::super::Foundation::IClosable, CompositionEasingFunction, CompositionObject);
impl BackEasingFunction {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Mode(&self) -> windows_core::Result<CompositionEasingFunctionMode> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Mode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn Amplitude(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Amplitude)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for BackEasingFunction {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, IBackEasingFunction>();
}
unsafe impl windows_core::Interface for BackEasingFunction {
    type Vtable = <IBackEasingFunction as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <IBackEasingFunction as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for BackEasingFunction {
    const NAME: &'static str = "Windows.UI.Composition.BackEasingFunction";
}
unsafe impl Send for BackEasingFunction {}
unsafe impl Sync for BackEasingFunction {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct BooleanKeyFrameAnimation(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(BooleanKeyFrameAnimation, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(BooleanKeyFrameAnimation, IAnimationObject, super::super::Foundation::IClosable, ICompositionAnimationBase, KeyFrameAnimation, CompositionAnimation, CompositionObject);
impl BooleanKeyFrameAnimation {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn InsertKeyFrame(&self, normalizedprogresskey: f32, value: bool) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).InsertKeyFrame)(windows_core::Interface::as_raw(this), normalizedprogresskey, value).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearAllParameters(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).ClearAllParameters)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearParameter(&self, key: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).ClearParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key)).ok() }
    }
    pub fn SetColorParameter(&self, key: &windows_core::HSTRING, value: super::Color) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetColorParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix3x2Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix3x2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetMatrix3x2Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix4x4Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix4x4) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetMatrix4x4Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetQuaternionParameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Quaternion) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetQuaternionParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetReferenceParameter<P1>(&self, key: &windows_core::HSTRING, compositionobject: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionObject>,
    {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetReferenceParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), compositionobject.param().abi()).ok() }
    }
    pub fn SetScalarParameter(&self, key: &windows_core::HSTRING, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetScalarParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector2Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetVector2Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector3Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetVector3Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector4Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector4) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetVector4Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetBooleanParameter(&self, key: &windows_core::HSTRING, value: bool) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetBooleanParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn Target(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Target)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetTarget(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTarget)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn InitialValueExpressions(&self) -> windows_core::Result<InitialValueExpressionCollection> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).InitialValueExpressions)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetExpressionReferenceParameter<P1>(&self, parametername: &windows_core::HSTRING, source: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<IAnimationObject>,
    {
        let this = &windows_core::Interface::cast::<ICompositionAnimation4>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetExpressionReferenceParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(parametername), source.param().abi()).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn DelayTime(&self) -> windows_core::Result<super::super::Foundation::TimeSpan> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DelayTime)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetDelayTime(&self, value: super::super::Foundation::TimeSpan) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetDelayTime)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Duration(&self) -> windows_core::Result<super::super::Foundation::TimeSpan> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Duration)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetDuration(&self, value: super::super::Foundation::TimeSpan) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetDuration)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn IterationBehavior(&self) -> windows_core::Result<AnimationIterationBehavior> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IterationBehavior)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetIterationBehavior(&self, value: AnimationIterationBehavior) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetIterationBehavior)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn IterationCount(&self) -> windows_core::Result<i32> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IterationCount)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetIterationCount(&self, value: i32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetIterationCount)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn KeyFrameCount(&self) -> windows_core::Result<i32> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).KeyFrameCount)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn StopBehavior(&self) -> windows_core::Result<AnimationStopBehavior> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).StopBehavior)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetStopBehavior(&self, value: AnimationStopBehavior) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetStopBehavior)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn InsertExpressionKeyFrame(&self, normalizedprogresskey: f32, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).InsertExpressionKeyFrame)(windows_core::Interface::as_raw(this), normalizedprogresskey, core::mem::transmute_copy(value)).ok() }
    }
    pub fn InsertExpressionKeyFrameWithEasingFunction<P2>(&self, normalizedprogresskey: f32, value: &windows_core::HSTRING, easingfunction: P2) -> windows_core::Result<()>
    where
        P2: windows_core::Param<CompositionEasingFunction>,
    {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).InsertExpressionKeyFrameWithEasingFunction)(windows_core::Interface::as_raw(this), normalizedprogresskey, core::mem::transmute_copy(value), easingfunction.param().abi()).ok() }
    }
    pub fn Direction(&self) -> windows_core::Result<AnimationDirection> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Direction)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetDirection(&self, value: AnimationDirection) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetDirection)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn DelayBehavior(&self) -> windows_core::Result<AnimationDelayBehavior> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DelayBehavior)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetDelayBehavior(&self, value: AnimationDelayBehavior) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation3>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetDelayBehavior)(windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl windows_core::RuntimeType for BooleanKeyFrameAnimation {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, IBooleanKeyFrameAnimation>();
}
unsafe impl windows_core::Interface for BooleanKeyFrameAnimation {
    type Vtable = <IBooleanKeyFrameAnimation as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <IBooleanKeyFrameAnimation as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for BooleanKeyFrameAnimation {
    const NAME: &'static str = "Windows.UI.Composition.BooleanKeyFrameAnimation";
}
unsafe impl Send for BooleanKeyFrameAnimation {}
unsafe impl Sync for BooleanKeyFrameAnimation {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct BounceEasingFunction(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(BounceEasingFunction, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(BounceEasingFunction, IAnimationObject, super::super::Foundation::IClosable, CompositionEasingFunction, CompositionObject);
impl BounceEasingFunction {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Mode(&self) -> windows_core::Result<CompositionEasingFunctionMode> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Mode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn Bounces(&self) -> windows_core::Result<i32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Bounces)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn Bounciness(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Bounciness)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for BounceEasingFunction {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, IBounceEasingFunction>();
}
unsafe impl windows_core::Interface for BounceEasingFunction {
    type Vtable = <IBounceEasingFunction as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <IBounceEasingFunction as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for BounceEasingFunction {
    const NAME: &'static str = "Windows.UI.Composition.BounceEasingFunction";
}
unsafe impl Send for BounceEasingFunction {}
unsafe impl Sync for BounceEasingFunction {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct BounceScalarNaturalMotionAnimation(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(BounceScalarNaturalMotionAnimation, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(BounceScalarNaturalMotionAnimation, IAnimationObject, super::super::Foundation::IClosable, ICompositionAnimationBase, ScalarNaturalMotionAnimation, NaturalMotionAnimation, CompositionAnimation, CompositionObject);
impl BounceScalarNaturalMotionAnimation {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Acceleration(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Acceleration)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetAcceleration(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetAcceleration)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Restitution(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Restitution)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRestitution(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetRestitution)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearAllParameters(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).ClearAllParameters)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearParameter(&self, key: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).ClearParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key)).ok() }
    }
    pub fn SetColorParameter(&self, key: &windows_core::HSTRING, value: super::Color) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetColorParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix3x2Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix3x2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetMatrix3x2Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix4x4Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix4x4) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetMatrix4x4Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetQuaternionParameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Quaternion) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetQuaternionParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetReferenceParameter<P1>(&self, key: &windows_core::HSTRING, compositionobject: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionObject>,
    {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetReferenceParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), compositionobject.param().abi()).ok() }
    }
    pub fn SetScalarParameter(&self, key: &windows_core::HSTRING, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetScalarParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector2Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetVector2Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector3Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetVector3Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector4Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector4) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetVector4Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetBooleanParameter(&self, key: &windows_core::HSTRING, value: bool) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetBooleanParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn Target(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Target)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetTarget(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTarget)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn InitialValueExpressions(&self) -> windows_core::Result<InitialValueExpressionCollection> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).InitialValueExpressions)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetExpressionReferenceParameter<P1>(&self, parametername: &windows_core::HSTRING, source: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<IAnimationObject>,
    {
        let this = &windows_core::Interface::cast::<ICompositionAnimation4>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetExpressionReferenceParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(parametername), source.param().abi()).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn DelayBehavior(&self) -> windows_core::Result<AnimationDelayBehavior> {
        let this = &windows_core::Interface::cast::<INaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DelayBehavior)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetDelayBehavior(&self, value: AnimationDelayBehavior) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<INaturalMotionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetDelayBehavior)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn DelayTime(&self) -> windows_core::Result<super::super::Foundation::TimeSpan> {
        let this = &windows_core::Interface::cast::<INaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DelayTime)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetDelayTime(&self, value: super::super::Foundation::TimeSpan) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<INaturalMotionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetDelayTime)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StopBehavior(&self) -> windows_core::Result<AnimationStopBehavior> {
        let this = &windows_core::Interface::cast::<INaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).StopBehavior)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetStopBehavior(&self, value: AnimationStopBehavior) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<INaturalMotionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetStopBehavior)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn FinalValue(&self) -> windows_core::Result<super::super::Foundation::IReference<f32>> {
        let this = &windows_core::Interface::cast::<IScalarNaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).FinalValue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetFinalValue<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::IReference<f32>>,
    {
        let this = &windows_core::Interface::cast::<IScalarNaturalMotionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetFinalValue)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn InitialValue(&self) -> windows_core::Result<super::super::Foundation::IReference<f32>> {
        let this = &windows_core::Interface::cast::<IScalarNaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).InitialValue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetInitialValue<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::IReference<f32>>,
    {
        let this = &windows_core::Interface::cast::<IScalarNaturalMotionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetInitialValue)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn InitialVelocity(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<IScalarNaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).InitialVelocity)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetInitialVelocity(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IScalarNaturalMotionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetInitialVelocity)(windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl windows_core::RuntimeType for BounceScalarNaturalMotionAnimation {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, IBounceScalarNaturalMotionAnimation>();
}
unsafe impl windows_core::Interface for BounceScalarNaturalMotionAnimation {
    type Vtable = <IBounceScalarNaturalMotionAnimation as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <IBounceScalarNaturalMotionAnimation as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for BounceScalarNaturalMotionAnimation {
    const NAME: &'static str = "Windows.UI.Composition.BounceScalarNaturalMotionAnimation";
}
unsafe impl Send for BounceScalarNaturalMotionAnimation {}
unsafe impl Sync for BounceScalarNaturalMotionAnimation {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct BounceVector2NaturalMotionAnimation(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(BounceVector2NaturalMotionAnimation, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(BounceVector2NaturalMotionAnimation, IAnimationObject, super::super::Foundation::IClosable, ICompositionAnimationBase, Vector2NaturalMotionAnimation, NaturalMotionAnimation, CompositionAnimation, CompositionObject);
impl BounceVector2NaturalMotionAnimation {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Acceleration(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Acceleration)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetAcceleration(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetAcceleration)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Restitution(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Restitution)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRestitution(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetRestitution)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearAllParameters(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).ClearAllParameters)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearParameter(&self, key: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).ClearParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key)).ok() }
    }
    pub fn SetColorParameter(&self, key: &windows_core::HSTRING, value: super::Color) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetColorParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix3x2Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix3x2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetMatrix3x2Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix4x4Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix4x4) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetMatrix4x4Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetQuaternionParameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Quaternion) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetQuaternionParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetReferenceParameter<P1>(&self, key: &windows_core::HSTRING, compositionobject: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionObject>,
    {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetReferenceParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), compositionobject.param().abi()).ok() }
    }
    pub fn SetScalarParameter(&self, key: &windows_core::HSTRING, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetScalarParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector2Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetVector2Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector3Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetVector3Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector4Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector4) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetVector4Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetBooleanParameter(&self, key: &windows_core::HSTRING, value: bool) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetBooleanParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn Target(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Target)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetTarget(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTarget)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn InitialValueExpressions(&self) -> windows_core::Result<InitialValueExpressionCollection> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).InitialValueExpressions)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetExpressionReferenceParameter<P1>(&self, parametername: &windows_core::HSTRING, source: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<IAnimationObject>,
    {
        let this = &windows_core::Interface::cast::<ICompositionAnimation4>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetExpressionReferenceParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(parametername), source.param().abi()).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn DelayBehavior(&self) -> windows_core::Result<AnimationDelayBehavior> {
        let this = &windows_core::Interface::cast::<INaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DelayBehavior)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetDelayBehavior(&self, value: AnimationDelayBehavior) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<INaturalMotionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetDelayBehavior)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn DelayTime(&self) -> windows_core::Result<super::super::Foundation::TimeSpan> {
        let this = &windows_core::Interface::cast::<INaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DelayTime)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetDelayTime(&self, value: super::super::Foundation::TimeSpan) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<INaturalMotionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetDelayTime)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StopBehavior(&self) -> windows_core::Result<AnimationStopBehavior> {
        let this = &windows_core::Interface::cast::<INaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).StopBehavior)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetStopBehavior(&self, value: AnimationStopBehavior) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<INaturalMotionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetStopBehavior)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn FinalValue(&self) -> windows_core::Result<super::super::Foundation::IReference<super::super::Foundation::Numerics::Vector2>> {
        let this = &windows_core::Interface::cast::<IVector2NaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).FinalValue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetFinalValue<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::IReference<super::super::Foundation::Numerics::Vector2>>,
    {
        let this = &windows_core::Interface::cast::<IVector2NaturalMotionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetFinalValue)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InitialValue(&self) -> windows_core::Result<super::super::Foundation::IReference<super::super::Foundation::Numerics::Vector2>> {
        let this = &windows_core::Interface::cast::<IVector2NaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).InitialValue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetInitialValue<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::IReference<super::super::Foundation::Numerics::Vector2>>,
    {
        let this = &windows_core::Interface::cast::<IVector2NaturalMotionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetInitialValue)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InitialVelocity(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<IVector2NaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).InitialVelocity)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetInitialVelocity(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVector2NaturalMotionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetInitialVelocity)(windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl windows_core::RuntimeType for BounceVector2NaturalMotionAnimation {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, IBounceVector2NaturalMotionAnimation>();
}
unsafe impl windows_core::Interface for BounceVector2NaturalMotionAnimation {
    type Vtable = <IBounceVector2NaturalMotionAnimation as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <IBounceVector2NaturalMotionAnimation as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for BounceVector2NaturalMotionAnimation {
    const NAME: &'static str = "Windows.UI.Composition.BounceVector2NaturalMotionAnimation";
}
unsafe impl Send for BounceVector2NaturalMotionAnimation {}
unsafe impl Sync for BounceVector2NaturalMotionAnimation {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct BounceVector3NaturalMotionAnimation(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(BounceVector3NaturalMotionAnimation, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(BounceVector3NaturalMotionAnimation, IAnimationObject, super::super::Foundation::IClosable, ICompositionAnimationBase, Vector3NaturalMotionAnimation, NaturalMotionAnimation, CompositionAnimation, CompositionObject);
impl BounceVector3NaturalMotionAnimation {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Acceleration(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Acceleration)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetAcceleration(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetAcceleration)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Restitution(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Restitution)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRestitution(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetRestitution)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearAllParameters(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).ClearAllParameters)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearParameter(&self, key: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).ClearParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key)).ok() }
    }
    pub fn SetColorParameter(&self, key: &windows_core::HSTRING, value: super::Color) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetColorParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix3x2Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix3x2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetMatrix3x2Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix4x4Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix4x4) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetMatrix4x4Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetQuaternionParameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Quaternion) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetQuaternionParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetReferenceParameter<P1>(&self, key: &windows_core::HSTRING, compositionobject: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionObject>,
    {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetReferenceParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), compositionobject.param().abi()).ok() }
    }
    pub fn SetScalarParameter(&self, key: &windows_core::HSTRING, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetScalarParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector2Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetVector2Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector3Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetVector3Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector4Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector4) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetVector4Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetBooleanParameter(&self, key: &windows_core::HSTRING, value: bool) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetBooleanParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn Target(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Target)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetTarget(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTarget)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn InitialValueExpressions(&self) -> windows_core::Result<InitialValueExpressionCollection> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).InitialValueExpressions)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetExpressionReferenceParameter<P1>(&self, parametername: &windows_core::HSTRING, source: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<IAnimationObject>,
    {
        let this = &windows_core::Interface::cast::<ICompositionAnimation4>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetExpressionReferenceParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(parametername), source.param().abi()).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn DelayBehavior(&self) -> windows_core::Result<AnimationDelayBehavior> {
        let this = &windows_core::Interface::cast::<INaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DelayBehavior)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetDelayBehavior(&self, value: AnimationDelayBehavior) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<INaturalMotionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetDelayBehavior)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn DelayTime(&self) -> windows_core::Result<super::super::Foundation::TimeSpan> {
        let this = &windows_core::Interface::cast::<INaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DelayTime)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetDelayTime(&self, value: super::super::Foundation::TimeSpan) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<INaturalMotionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetDelayTime)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StopBehavior(&self) -> windows_core::Result<AnimationStopBehavior> {
        let this = &windows_core::Interface::cast::<INaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).StopBehavior)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetStopBehavior(&self, value: AnimationStopBehavior) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<INaturalMotionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetStopBehavior)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn FinalValue(&self) -> windows_core::Result<super::super::Foundation::IReference<super::super::Foundation::Numerics::Vector3>> {
        let this = &windows_core::Interface::cast::<IVector3NaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).FinalValue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetFinalValue<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::IReference<super::super::Foundation::Numerics::Vector3>>,
    {
        let this = &windows_core::Interface::cast::<IVector3NaturalMotionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetFinalValue)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InitialValue(&self) -> windows_core::Result<super::super::Foundation::IReference<super::super::Foundation::Numerics::Vector3>> {
        let this = &windows_core::Interface::cast::<IVector3NaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).InitialValue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetInitialValue<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::IReference<super::super::Foundation::Numerics::Vector3>>,
    {
        let this = &windows_core::Interface::cast::<IVector3NaturalMotionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetInitialValue)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InitialVelocity(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector3> {
        let this = &windows_core::Interface::cast::<IVector3NaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).InitialVelocity)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetInitialVelocity(&self, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVector3NaturalMotionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetInitialVelocity)(windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl windows_core::RuntimeType for BounceVector3NaturalMotionAnimation {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, IBounceVector3NaturalMotionAnimation>();
}
unsafe impl windows_core::Interface for BounceVector3NaturalMotionAnimation {
    type Vtable = <IBounceVector3NaturalMotionAnimation as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <IBounceVector3NaturalMotionAnimation as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for BounceVector3NaturalMotionAnimation {
    const NAME: &'static str = "Windows.UI.Composition.BounceVector3NaturalMotionAnimation";
}
unsafe impl Send for BounceVector3NaturalMotionAnimation {}
unsafe impl Sync for BounceVector3NaturalMotionAnimation {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CircleEasingFunction(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CircleEasingFunction, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CircleEasingFunction, IAnimationObject, super::super::Foundation::IClosable, CompositionEasingFunction, CompositionObject);
impl CircleEasingFunction {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Mode(&self) -> windows_core::Result<CompositionEasingFunctionMode> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Mode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CircleEasingFunction {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICircleEasingFunction>();
}
unsafe impl windows_core::Interface for CircleEasingFunction {
    type Vtable = <ICircleEasingFunction as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICircleEasingFunction as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CircleEasingFunction {
    const NAME: &'static str = "Windows.UI.Composition.CircleEasingFunction";
}
unsafe impl Send for CircleEasingFunction {}
unsafe impl Sync for CircleEasingFunction {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct ColorKeyFrameAnimation(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(ColorKeyFrameAnimation, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(ColorKeyFrameAnimation, IAnimationObject, super::super::Foundation::IClosable, ICompositionAnimationBase, KeyFrameAnimation, CompositionAnimation, CompositionObject);
impl ColorKeyFrameAnimation {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn InterpolationColorSpace(&self) -> windows_core::Result<CompositionColorSpace> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).InterpolationColorSpace)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetInterpolationColorSpace(&self, value: CompositionColorSpace) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetInterpolationColorSpace)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn InsertKeyFrame(&self, normalizedprogresskey: f32, value: super::Color) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).InsertKeyFrame)(windows_core::Interface::as_raw(this), normalizedprogresskey, value).ok() }
    }
    pub fn InsertKeyFrameWithEasingFunction<P2>(&self, normalizedprogresskey: f32, value: super::Color, easingfunction: P2) -> windows_core::Result<()>
    where
        P2: windows_core::Param<CompositionEasingFunction>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).InsertKeyFrameWithEasingFunction)(windows_core::Interface::as_raw(this), normalizedprogresskey, value, easingfunction.param().abi()).ok() }
    }
    pub fn ClearAllParameters(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).ClearAllParameters)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearParameter(&self, key: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).ClearParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key)).ok() }
    }
    pub fn SetColorParameter(&self, key: &windows_core::HSTRING, value: super::Color) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetColorParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix3x2Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix3x2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetMatrix3x2Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix4x4Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix4x4) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetMatrix4x4Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetQuaternionParameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Quaternion) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetQuaternionParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetReferenceParameter<P1>(&self, key: &windows_core::HSTRING, compositionobject: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionObject>,
    {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetReferenceParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), compositionobject.param().abi()).ok() }
    }
    pub fn SetScalarParameter(&self, key: &windows_core::HSTRING, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetScalarParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector2Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetVector2Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector3Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetVector3Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector4Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector4) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetVector4Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetBooleanParameter(&self, key: &windows_core::HSTRING, value: bool) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetBooleanParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn Target(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Target)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetTarget(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTarget)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn InitialValueExpressions(&self) -> windows_core::Result<InitialValueExpressionCollection> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).InitialValueExpressions)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetExpressionReferenceParameter<P1>(&self, parametername: &windows_core::HSTRING, source: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<IAnimationObject>,
    {
        let this = &windows_core::Interface::cast::<ICompositionAnimation4>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetExpressionReferenceParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(parametername), source.param().abi()).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn DelayTime(&self) -> windows_core::Result<super::super::Foundation::TimeSpan> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DelayTime)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetDelayTime(&self, value: super::super::Foundation::TimeSpan) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetDelayTime)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Duration(&self) -> windows_core::Result<super::super::Foundation::TimeSpan> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Duration)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetDuration(&self, value: super::super::Foundation::TimeSpan) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetDuration)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn IterationBehavior(&self) -> windows_core::Result<AnimationIterationBehavior> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IterationBehavior)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetIterationBehavior(&self, value: AnimationIterationBehavior) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetIterationBehavior)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn IterationCount(&self) -> windows_core::Result<i32> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IterationCount)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetIterationCount(&self, value: i32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetIterationCount)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn KeyFrameCount(&self) -> windows_core::Result<i32> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).KeyFrameCount)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn StopBehavior(&self) -> windows_core::Result<AnimationStopBehavior> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).StopBehavior)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetStopBehavior(&self, value: AnimationStopBehavior) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetStopBehavior)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn InsertExpressionKeyFrame(&self, normalizedprogresskey: f32, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).InsertExpressionKeyFrame)(windows_core::Interface::as_raw(this), normalizedprogresskey, core::mem::transmute_copy(value)).ok() }
    }
    pub fn InsertExpressionKeyFrameWithEasingFunction<P2>(&self, normalizedprogresskey: f32, value: &windows_core::HSTRING, easingfunction: P2) -> windows_core::Result<()>
    where
        P2: windows_core::Param<CompositionEasingFunction>,
    {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).InsertExpressionKeyFrameWithEasingFunction)(windows_core::Interface::as_raw(this), normalizedprogresskey, core::mem::transmute_copy(value), easingfunction.param().abi()).ok() }
    }
    pub fn Direction(&self) -> windows_core::Result<AnimationDirection> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Direction)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetDirection(&self, value: AnimationDirection) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetDirection)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn DelayBehavior(&self) -> windows_core::Result<AnimationDelayBehavior> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DelayBehavior)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetDelayBehavior(&self, value: AnimationDelayBehavior) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IKeyFrameAnimation3>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetDelayBehavior)(windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl windows_core::RuntimeType for ColorKeyFrameAnimation {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, IColorKeyFrameAnimation>();
}
unsafe impl windows_core::Interface for ColorKeyFrameAnimation {
    type Vtable = <IColorKeyFrameAnimation as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <IColorKeyFrameAnimation as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for ColorKeyFrameAnimation {
    const NAME: &'static str = "Windows.UI.Composition.ColorKeyFrameAnimation";
}
unsafe impl Send for ColorKeyFrameAnimation {}
unsafe impl Sync for ColorKeyFrameAnimation {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionAnimation(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionAnimation, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionAnimation, IAnimationObject, super::super::Foundation::IClosable, ICompositionAnimationBase, CompositionObject);
impl CompositionAnimation {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearAllParameters(&self) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).ClearAllParameters)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearParameter(&self, key: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).ClearParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key)).ok() }
    }
    pub fn SetColorParameter(&self, key: &windows_core::HSTRING, value: super::Color) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetColorParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix3x2Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix3x2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetMatrix3x2Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix4x4Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix4x4) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetMatrix4x4Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetQuaternionParameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Quaternion) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetQuaternionParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetReferenceParameter<P1>(&self, key: &windows_core::HSTRING, compositionobject: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionObject>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetReferenceParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), compositionobject.param().abi()).ok() }
    }
    pub fn SetScalarParameter(&self, key: &windows_core::HSTRING, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetScalarParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector2Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetVector2Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector3Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetVector3Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector4Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector4) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetVector4Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetBooleanParameter(&self, key: &windows_core::HSTRING, value: bool) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetBooleanParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn Target(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Target)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetTarget(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTarget)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn InitialValueExpressions(&self) -> windows_core::Result<InitialValueExpressionCollection> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).InitialValueExpressions)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetExpressionReferenceParameter<P1>(&self, parametername: &windows_core::HSTRING, source: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<IAnimationObject>,
    {
        let this = &windows_core::Interface::cast::<ICompositionAnimation4>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetExpressionReferenceParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(parametername), source.param().abi()).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionAnimation {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionAnimation>();
}
unsafe impl windows_core::Interface for CompositionAnimation {
    type Vtable = <ICompositionAnimation as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionAnimation as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionAnimation {
    const NAME: &'static str = "Windows.UI.Composition.CompositionAnimation";
}
unsafe impl Send for CompositionAnimation {}
unsafe impl Sync for CompositionAnimation {}
#[cfg(feature = "Foundation_Collections")]
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionAnimationGroup(windows_core::IUnknown);
#[cfg(feature = "Foundation_Collections")]
windows_core::imp::interface_hierarchy!(CompositionAnimationGroup, windows_core::IUnknown, windows_core::IInspectable);
#[cfg(feature = "Foundation_Collections")]
windows_core::imp::required_hierarchy!(CompositionAnimationGroup, IAnimationObject, super::super::Foundation::IClosable, ICompositionAnimationBase, super::super::Foundation::Collections::IIterable<CompositionAnimation>, CompositionObject);
#[cfg(feature = "Foundation_Collections")]
impl CompositionAnimationGroup {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Count(&self) -> windows_core::Result<i32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Count)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn Add<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionAnimation>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).Add)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn Remove<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionAnimation>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).Remove)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn RemoveAll(&self) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).RemoveAll)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn First(&self) -> windows_core::Result<super::super::Foundation::Collections::IIterator<CompositionAnimation>> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::Collections::IIterable<CompositionAnimation>>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).First)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[cfg(feature = "Foundation_Collections")]
impl windows_core::RuntimeType for CompositionAnimationGroup {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionAnimationGroup>();
}
#[cfg(feature = "Foundation_Collections")]
unsafe impl windows_core::Interface for CompositionAnimationGroup {
    type Vtable = <ICompositionAnimationGroup as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionAnimationGroup as windows_core::Interface>::IID;
}
#[cfg(feature = "Foundation_Collections")]
impl windows_core::RuntimeName for CompositionAnimationGroup {
    const NAME: &'static str = "Windows.UI.Composition.CompositionAnimationGroup";
}
#[cfg(feature = "Foundation_Collections")]
unsafe impl Send for CompositionAnimationGroup {}
#[cfg(feature = "Foundation_Collections")]
unsafe impl Sync for CompositionAnimationGroup {}
#[cfg(feature = "Foundation_Collections")]
impl IntoIterator for CompositionAnimationGroup {
    type Item = CompositionAnimation;
    type IntoIter = super::super::Foundation::Collections::IIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        IntoIterator::into_iter(&self)
    }
}
#[cfg(feature = "Foundation_Collections")]
impl IntoIterator for &CompositionAnimationGroup {
    type Item = CompositionAnimation;
    type IntoIter = super::super::Foundation::Collections::IIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        self.First().unwrap()
    }
}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionBackdropBrush(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionBackdropBrush, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionBackdropBrush, IAnimationObject, super::super::Foundation::IClosable, CompositionBrush, CompositionObject);
impl CompositionBackdropBrush {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionBackdropBrush {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionBackdropBrush>();
}
unsafe impl windows_core::Interface for CompositionBackdropBrush {
    type Vtable = <ICompositionBackdropBrush as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionBackdropBrush as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionBackdropBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionBackdropBrush";
}
unsafe impl Send for CompositionBackdropBrush {}
unsafe impl Sync for CompositionBackdropBrush {}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CompositionBackfaceVisibility(pub i32);
impl CompositionBackfaceVisibility {
    pub const Inherit: Self = Self(0i32);
    pub const Visible: Self = Self(1i32);
    pub const Hidden: Self = Self(2i32);
}
impl windows_core::TypeKind for CompositionBackfaceVisibility {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for CompositionBackfaceVisibility {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.CompositionBackfaceVisibility;i4)");
}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionBatchCompletedEventArgs(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionBatchCompletedEventArgs, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionBatchCompletedEventArgs, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionBatchCompletedEventArgs {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionBatchCompletedEventArgs {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionBatchCompletedEventArgs>();
}
unsafe impl windows_core::Interface for CompositionBatchCompletedEventArgs {
    type Vtable = <ICompositionBatchCompletedEventArgs as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionBatchCompletedEventArgs as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionBatchCompletedEventArgs {
    const NAME: &'static str = "Windows.UI.Composition.CompositionBatchCompletedEventArgs";
}
unsafe impl Send for CompositionBatchCompletedEventArgs {}
unsafe impl Sync for CompositionBatchCompletedEventArgs {}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CompositionBatchTypes(pub u32);
impl CompositionBatchTypes {
    pub const None: Self = Self(0u32);
    pub const Animation: Self = Self(1u32);
    pub const Effect: Self = Self(2u32);
    pub const InfiniteAnimation: Self = Self(4u32);
    pub const AllAnimations: Self = Self(5u32);
}
impl windows_core::TypeKind for CompositionBatchTypes {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for CompositionBatchTypes {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.CompositionBatchTypes;u4)");
}
impl CompositionBatchTypes {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CompositionBatchTypes {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CompositionBatchTypes {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CompositionBatchTypes {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CompositionBatchTypes {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CompositionBatchTypes {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CompositionBitmapInterpolationMode(pub i32);
impl CompositionBitmapInterpolationMode {
    pub const NearestNeighbor: Self = Self(0i32);
    pub const Linear: Self = Self(1i32);
    pub const MagLinearMinLinearMipLinear: Self = Self(2i32);
    pub const MagLinearMinLinearMipNearest: Self = Self(3i32);
    pub const MagLinearMinNearestMipLinear: Self = Self(4i32);
    pub const MagLinearMinNearestMipNearest: Self = Self(5i32);
    pub const MagNearestMinLinearMipLinear: Self = Self(6i32);
    pub const MagNearestMinLinearMipNearest: Self = Self(7i32);
    pub const MagNearestMinNearestMipLinear: Self = Self(8i32);
    pub const MagNearestMinNearestMipNearest: Self = Self(9i32);
}
impl windows_core::TypeKind for CompositionBitmapInterpolationMode {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for CompositionBitmapInterpolationMode {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.CompositionBitmapInterpolationMode;i4)");
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CompositionBorderMode(pub i32);
impl CompositionBorderMode {
    pub const Inherit: Self = Self(0i32);
    pub const Soft: Self = Self(1i32);
    pub const Hard: Self = Self(2i32);
}
impl windows_core::TypeKind for CompositionBorderMode {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for CompositionBorderMode {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.CompositionBorderMode;i4)");
}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionBrush(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionBrush, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionBrush, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionBrush {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionBrush {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionBrush>();
}
unsafe impl windows_core::Interface for CompositionBrush {
    type Vtable = <ICompositionBrush as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionBrush as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionBrush";
}
unsafe impl Send for CompositionBrush {}
unsafe impl Sync for CompositionBrush {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionCapabilities(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionCapabilities, windows_core::IUnknown, windows_core::IInspectable);
impl CompositionCapabilities {
    pub fn AreEffectsSupported(&self) -> windows_core::Result<bool> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).AreEffectsSupported)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn AreEffectsFast(&self) -> windows_core::Result<bool> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).AreEffectsFast)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn Changed<P0>(&self, handler: P0) -> windows_core::Result<i64>
    where
        P0: windows_core::Param<super::super::Foundation::TypedEventHandler<CompositionCapabilities, windows_core::IInspectable>>,
    {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Changed)(windows_core::Interface::as_raw(this), handler.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub fn RemoveChanged(&self, token: i64) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).RemoveChanged)(windows_core::Interface::as_raw(this), token).ok() }
    }
    pub fn GetForCurrentView() -> windows_core::Result<CompositionCapabilities> {
        Self::ICompositionCapabilitiesStatics(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).GetForCurrentView)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        })
    }
    fn ICompositionCapabilitiesStatics<R, F: FnOnce(&ICompositionCapabilitiesStatics) -> windows_core::Result<R>>(callback: F) -> windows_core::Result<R> {
        static SHARED: windows_core::imp::FactoryCache<CompositionCapabilities, ICompositionCapabilitiesStatics> = windows_core::imp::FactoryCache::new();
        SHARED.call(callback)
    }
}
impl windows_core::RuntimeType for CompositionCapabilities {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionCapabilities>();
}
unsafe impl windows_core::Interface for CompositionCapabilities {
    type Vtable = <ICompositionCapabilities as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionCapabilities as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionCapabilities {
    const NAME: &'static str = "Windows.UI.Composition.CompositionCapabilities";
}
unsafe impl Send for CompositionCapabilities {}
unsafe impl Sync for CompositionCapabilities {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionClip(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionClip, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionClip, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionClip {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn AnchorPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).AnchorPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetAnchorPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetAnchorPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CenterPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetCenterPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Offset)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngle(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngle)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngle)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngleInDegrees)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Scale)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetScale)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> windows_core::Result<super::super::Foundation::Numerics::Matrix3x2> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TransformMatrix)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix3x2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTransformMatrix)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionClip {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionClip>();
}
unsafe impl windows_core::Interface for CompositionClip {
    type Vtable = <ICompositionClip as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionClip as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionClip {
    const NAME: &'static str = "Windows.UI.Composition.CompositionClip";
}
unsafe impl Send for CompositionClip {}
unsafe impl Sync for CompositionClip {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionColorBrush(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionColorBrush, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionColorBrush, IAnimationObject, super::super::Foundation::IClosable, CompositionBrush, CompositionObject);
impl CompositionColorBrush {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Color(&self) -> windows_core::Result<super::Color> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Color)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetColor(&self, value: super::Color) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetColor)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionColorBrush {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionColorBrush>();
}
unsafe impl windows_core::Interface for CompositionColorBrush {
    type Vtable = <ICompositionColorBrush as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionColorBrush as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionColorBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionColorBrush";
}
unsafe impl Send for CompositionColorBrush {}
unsafe impl Sync for CompositionColorBrush {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionColorGradientStop(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionColorGradientStop, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionColorGradientStop, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionColorGradientStop {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Color(&self) -> windows_core::Result<super::Color> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Color)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetColor(&self, value: super::Color) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetColor)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Offset(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Offset)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetOffset(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionColorGradientStop {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionColorGradientStop>();
}
unsafe impl windows_core::Interface for CompositionColorGradientStop {
    type Vtable = <ICompositionColorGradientStop as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionColorGradientStop as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionColorGradientStop {
    const NAME: &'static str = "Windows.UI.Composition.CompositionColorGradientStop";
}
unsafe impl Send for CompositionColorGradientStop {}
unsafe impl Sync for CompositionColorGradientStop {}
#[cfg(feature = "Foundation_Collections")]
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionColorGradientStopCollection(windows_core::IUnknown);
#[cfg(feature = "Foundation_Collections")]
windows_core::imp::interface_hierarchy!(CompositionColorGradientStopCollection, windows_core::IUnknown, windows_core::IInspectable);
#[cfg(feature = "Foundation_Collections")]
windows_core::imp::required_hierarchy!(CompositionColorGradientStopCollection, super::super::Foundation::Collections::IIterable<CompositionColorGradientStop>, super::super::Foundation::Collections::IVector<CompositionColorGradientStop>);
#[cfg(feature = "Foundation_Collections")]
impl CompositionColorGradientStopCollection {
    pub fn First(&self) -> windows_core::Result<super::super::Foundation::Collections::IIterator<CompositionColorGradientStop>> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::Collections::IIterable<CompositionColorGradientStop>>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).First)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn GetAt(&self, index: u32) -> windows_core::Result<CompositionColorGradientStop> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).GetAt)(windows_core::Interface::as_raw(this), index, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Size(&self) -> windows_core::Result<u32> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Size)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn GetView(&self) -> windows_core::Result<super::super::Foundation::Collections::IVectorView<CompositionColorGradientStop>> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).GetView)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn IndexOf<P0>(&self, value: P0, index: &mut u32) -> windows_core::Result<bool>
    where
        P0: windows_core::Param<CompositionColorGradientStop>,
    {
        let this = &windows_core::Interface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IndexOf)(windows_core::Interface::as_raw(this), value.param().abi(), index, &mut result__).map(|| result__)
        }
    }
    pub fn SetAt<P1>(&self, index: u32, value: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionColorGradientStop>,
    {
        let this = &windows_core::Interface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetAt)(windows_core::Interface::as_raw(this), index, value.param().abi()).ok() }
    }
    pub fn InsertAt<P1>(&self, index: u32, value: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionColorGradientStop>,
    {
        let this = &windows_core::Interface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe { (windows_core::Interface::vtable(this).InsertAt)(windows_core::Interface::as_raw(this), index, value.param().abi()).ok() }
    }
    pub fn RemoveAt(&self, index: u32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe { (windows_core::Interface::vtable(this).RemoveAt)(windows_core::Interface::as_raw(this), index).ok() }
    }
    pub fn Append<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionColorGradientStop>,
    {
        let this = &windows_core::Interface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Append)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn RemoveAtEnd(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe { (windows_core::Interface::vtable(this).RemoveAtEnd)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Clear(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Clear)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn GetMany(&self, startindex: u32, items: &mut [Option<CompositionColorGradientStop>]) -> windows_core::Result<u32> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).GetMany)(windows_core::Interface::as_raw(this), startindex, items.len().try_into().unwrap(), core::mem::transmute_copy(&items), &mut result__).map(|| result__)
        }
    }
    pub fn ReplaceAll(&self, items: &[Option<CompositionColorGradientStop>]) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe { (windows_core::Interface::vtable(this).ReplaceAll)(windows_core::Interface::as_raw(this), items.len().try_into().unwrap(), core::mem::transmute(items.as_ptr())).ok() }
    }
}
#[cfg(feature = "Foundation_Collections")]
impl windows_core::RuntimeType for CompositionColorGradientStopCollection {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionColorGradientStopCollection>();
}
#[cfg(feature = "Foundation_Collections")]
unsafe impl windows_core::Interface for CompositionColorGradientStopCollection {
    type Vtable = <ICompositionColorGradientStopCollection as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionColorGradientStopCollection as windows_core::Interface>::IID;
}
#[cfg(feature = "Foundation_Collections")]
impl windows_core::RuntimeName for CompositionColorGradientStopCollection {
    const NAME: &'static str = "Windows.UI.Composition.CompositionColorGradientStopCollection";
}
#[cfg(feature = "Foundation_Collections")]
unsafe impl Send for CompositionColorGradientStopCollection {}
#[cfg(feature = "Foundation_Collections")]
unsafe impl Sync for CompositionColorGradientStopCollection {}
#[cfg(feature = "Foundation_Collections")]
impl IntoIterator for CompositionColorGradientStopCollection {
    type Item = CompositionColorGradientStop;
    type IntoIter = super::super::Foundation::Collections::IIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        IntoIterator::into_iter(&self)
    }
}
#[cfg(feature = "Foundation_Collections")]
impl IntoIterator for &CompositionColorGradientStopCollection {
    type Item = CompositionColorGradientStop;
    type IntoIter = super::super::Foundation::Collections::IIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        self.First().unwrap()
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CompositionColorSpace(pub i32);
impl CompositionColorSpace {
    pub const Auto: Self = Self(0i32);
    pub const Hsl: Self = Self(1i32);
    pub const Rgb: Self = Self(2i32);
    pub const HslLinear: Self = Self(3i32);
    pub const RgbLinear: Self = Self(4i32);
}
impl windows_core::TypeKind for CompositionColorSpace {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for CompositionColorSpace {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.CompositionColorSpace;i4)");
}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionCommitBatch(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionCommitBatch, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionCommitBatch, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionCommitBatch {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn IsActive(&self) -> windows_core::Result<bool> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IsActive)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn IsEnded(&self) -> windows_core::Result<bool> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IsEnded)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn Completed<P0>(&self, handler: P0) -> windows_core::Result<i64>
    where
        P0: windows_core::Param<super::super::Foundation::TypedEventHandler<windows_core::IInspectable, CompositionBatchCompletedEventArgs>>,
    {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Completed)(windows_core::Interface::as_raw(this), handler.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub fn RemoveCompleted(&self, token: i64) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).RemoveCompleted)(windows_core::Interface::as_raw(this), token).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionCommitBatch {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionCommitBatch>();
}
unsafe impl windows_core::Interface for CompositionCommitBatch {
    type Vtable = <ICompositionCommitBatch as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionCommitBatch as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionCommitBatch {
    const NAME: &'static str = "Windows.UI.Composition.CompositionCommitBatch";
}
unsafe impl Send for CompositionCommitBatch {}
unsafe impl Sync for CompositionCommitBatch {}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CompositionCompositeMode(pub i32);
impl CompositionCompositeMode {
    pub const Inherit: Self = Self(0i32);
    pub const SourceOver: Self = Self(1i32);
    pub const DestinationInvert: Self = Self(2i32);
    pub const MinBlend: Self = Self(3i32);
}
impl windows_core::TypeKind for CompositionCompositeMode {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for CompositionCompositeMode {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.CompositionCompositeMode;i4)");
}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionContainerShape(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionContainerShape, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionContainerShape, IAnimationObject, super::super::Foundation::IClosable, CompositionShape, CompositionObject);
impl CompositionContainerShape {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn Shapes(&self) -> windows_core::Result<CompositionShapeCollection> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Shapes)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CenterPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetCenterPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Offset)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngle(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngle)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngle)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngleInDegrees)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Scale)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetScale)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> windows_core::Result<super::super::Foundation::Numerics::Matrix3x2> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TransformMatrix)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix3x2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTransformMatrix)(windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl windows_core::RuntimeType for CompositionContainerShape {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionContainerShape>();
}
unsafe impl windows_core::Interface for CompositionContainerShape {
    type Vtable = <ICompositionContainerShape as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionContainerShape as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionContainerShape {
    const NAME: &'static str = "Windows.UI.Composition.CompositionContainerShape";
}
unsafe impl Send for CompositionContainerShape {}
unsafe impl Sync for CompositionContainerShape {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionDrawingSurface(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionDrawingSurface, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionDrawingSurface, IAnimationObject, super::super::Foundation::IClosable, ICompositionSurface, CompositionObject);
impl CompositionDrawingSurface {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    #[cfg(feature = "Graphics_DirectX")]
    pub fn AlphaMode(&self) -> windows_core::Result<super::super::Graphics::DirectX::DirectXAlphaMode> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).AlphaMode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Graphics_DirectX")]
    pub fn PixelFormat(&self) -> windows_core::Result<super::super::Graphics::DirectX::DirectXPixelFormat> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).PixelFormat)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn Size(&self) -> windows_core::Result<super::super::Foundation::Size> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Size)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Graphics")]
    pub fn SizeInt32(&self) -> windows_core::Result<super::super::Graphics::SizeInt32> {
        let this = &windows_core::Interface::cast::<ICompositionDrawingSurface2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).SizeInt32)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Graphics")]
    pub fn Resize(&self, sizepixels: super::super::Graphics::SizeInt32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionDrawingSurface2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Resize)(windows_core::Interface::as_raw(this), sizepixels).ok() }
    }
    #[cfg(feature = "Graphics")]
    pub fn Scroll(&self, offset: super::super::Graphics::PointInt32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionDrawingSurface2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Scroll)(windows_core::Interface::as_raw(this), offset).ok() }
    }
    #[cfg(feature = "Graphics")]
    pub fn ScrollRect(&self, offset: super::super::Graphics::PointInt32, scrollrect: super::super::Graphics::RectInt32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionDrawingSurface2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).ScrollRect)(windows_core::Interface::as_raw(this), offset, scrollrect).ok() }
    }
    #[cfg(feature = "Graphics")]
    pub fn ScrollWithClip(&self, offset: super::super::Graphics::PointInt32, cliprect: super::super::Graphics::RectInt32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionDrawingSurface2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).ScrollWithClip)(windows_core::Interface::as_raw(this), offset, cliprect).ok() }
    }
    #[cfg(feature = "Graphics")]
    pub fn ScrollRectWithClip(&self, offset: super::super::Graphics::PointInt32, cliprect: super::super::Graphics::RectInt32, scrollrect: super::super::Graphics::RectInt32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionDrawingSurface2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).ScrollRectWithClip)(windows_core::Interface::as_raw(this), offset, cliprect, scrollrect).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionDrawingSurface {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionDrawingSurface>();
}
unsafe impl windows_core::Interface for CompositionDrawingSurface {
    type Vtable = <ICompositionDrawingSurface as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionDrawingSurface as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionDrawingSurface {
    const NAME: &'static str = "Windows.UI.Composition.CompositionDrawingSurface";
}
unsafe impl Send for CompositionDrawingSurface {}
unsafe impl Sync for CompositionDrawingSurface {}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CompositionDropShadowSourcePolicy(pub i32);
impl CompositionDropShadowSourcePolicy {
    pub const Default: Self = Self(0i32);
    pub const InheritFromVisualContent: Self = Self(1i32);
}
impl windows_core::TypeKind for CompositionDropShadowSourcePolicy {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for CompositionDropShadowSourcePolicy {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.CompositionDropShadowSourcePolicy;i4)");
}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionEasingFunction(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionEasingFunction, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionEasingFunction, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionEasingFunction {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CreateCubicBezierEasingFunction<P0>(owner: P0, controlpoint1: super::super::Foundation::Numerics::Vector2, controlpoint2: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<CubicBezierEasingFunction>
    where
        P0: windows_core::Param<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateCubicBezierEasingFunction)(windows_core::Interface::as_raw(this), owner.param().abi(), controlpoint1, controlpoint2, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        })
    }
    pub fn CreateLinearEasingFunction<P0>(owner: P0) -> windows_core::Result<LinearEasingFunction>
    where
        P0: windows_core::Param<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateLinearEasingFunction)(windows_core::Interface::as_raw(this), owner.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        })
    }
    pub fn CreateStepEasingFunction<P0>(owner: P0) -> windows_core::Result<StepEasingFunction>
    where
        P0: windows_core::Param<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateStepEasingFunction)(windows_core::Interface::as_raw(this), owner.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        })
    }
    pub fn CreateStepEasingFunctionWithStepCount<P0>(owner: P0, stepcount: i32) -> windows_core::Result<StepEasingFunction>
    where
        P0: windows_core::Param<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateStepEasingFunctionWithStepCount)(windows_core::Interface::as_raw(this), owner.param().abi(), stepcount, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        })
    }
    pub fn CreateBackEasingFunction<P0>(owner: P0, mode: CompositionEasingFunctionMode, amplitude: f32) -> windows_core::Result<BackEasingFunction>
    where
        P0: windows_core::Param<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateBackEasingFunction)(windows_core::Interface::as_raw(this), owner.param().abi(), mode, amplitude, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        })
    }
    pub fn CreateBounceEasingFunction<P0>(owner: P0, mode: CompositionEasingFunctionMode, bounces: i32, bounciness: f32) -> windows_core::Result<BounceEasingFunction>
    where
        P0: windows_core::Param<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateBounceEasingFunction)(windows_core::Interface::as_raw(this), owner.param().abi(), mode, bounces, bounciness, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        })
    }
    pub fn CreateCircleEasingFunction<P0>(owner: P0, mode: CompositionEasingFunctionMode) -> windows_core::Result<CircleEasingFunction>
    where
        P0: windows_core::Param<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateCircleEasingFunction)(windows_core::Interface::as_raw(this), owner.param().abi(), mode, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        })
    }
    pub fn CreateElasticEasingFunction<P0>(owner: P0, mode: CompositionEasingFunctionMode, oscillations: i32, springiness: f32) -> windows_core::Result<ElasticEasingFunction>
    where
        P0: windows_core::Param<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateElasticEasingFunction)(windows_core::Interface::as_raw(this), owner.param().abi(), mode, oscillations, springiness, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        })
    }
    pub fn CreateExponentialEasingFunction<P0>(owner: P0, mode: CompositionEasingFunctionMode, exponent: f32) -> windows_core::Result<ExponentialEasingFunction>
    where
        P0: windows_core::Param<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateExponentialEasingFunction)(windows_core::Interface::as_raw(this), owner.param().abi(), mode, exponent, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        })
    }
    pub fn CreatePowerEasingFunction<P0>(owner: P0, mode: CompositionEasingFunctionMode, power: f32) -> windows_core::Result<PowerEasingFunction>
    where
        P0: windows_core::Param<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreatePowerEasingFunction)(windows_core::Interface::as_raw(this), owner.param().abi(), mode, power, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        })
    }
    pub fn CreateSineEasingFunction<P0>(owner: P0, mode: CompositionEasingFunctionMode) -> windows_core::Result<SineEasingFunction>
    where
        P0: windows_core::Param<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateSineEasingFunction)(windows_core::Interface::as_raw(this), owner.param().abi(), mode, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        })
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    fn ICompositionEasingFunctionStatics<R, F: FnOnce(&ICompositionEasingFunctionStatics) -> windows_core::Result<R>>(callback: F) -> windows_core::Result<R> {
        static SHARED: windows_core::imp::FactoryCache<CompositionEasingFunction, ICompositionEasingFunctionStatics> = windows_core::imp::FactoryCache::new();
        SHARED.call(callback)
    }
}
impl windows_core::RuntimeType for CompositionEasingFunction {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionEasingFunction>();
}
unsafe impl windows_core::Interface for CompositionEasingFunction {
    type Vtable = <ICompositionEasingFunction as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionEasingFunction as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionEasingFunction {
    const NAME: &'static str = "Windows.UI.Composition.CompositionEasingFunction";
}
unsafe impl Send for CompositionEasingFunction {}
unsafe impl Sync for CompositionEasingFunction {}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CompositionEasingFunctionMode(pub i32);
impl CompositionEasingFunctionMode {
    pub const In: Self = Self(0i32);
    pub const Out: Self = Self(1i32);
    pub const InOut: Self = Self(2i32);
}
impl windows_core::TypeKind for CompositionEasingFunctionMode {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for CompositionEasingFunctionMode {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.CompositionEasingFunctionMode;i4)");
}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionEffectBrush(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionEffectBrush, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionEffectBrush, IAnimationObject, super::super::Foundation::IClosable, CompositionBrush, CompositionObject);
impl CompositionEffectBrush {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn GetSourceParameter(&self, name: &windows_core::HSTRING) -> windows_core::Result<CompositionBrush> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).GetSourceParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(name), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetSourceParameter<P1>(&self, name: &windows_core::HSTRING, source: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionBrush>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetSourceParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(name), source.param().abi()).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionEffectBrush {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionEffectBrush>();
}
unsafe impl windows_core::Interface for CompositionEffectBrush {
    type Vtable = <ICompositionEffectBrush as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionEffectBrush as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionEffectBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionEffectBrush";
}
unsafe impl Send for CompositionEffectBrush {}
unsafe impl Sync for CompositionEffectBrush {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionEffectFactory(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionEffectFactory, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionEffectFactory, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionEffectFactory {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn CreateBrush(&self) -> windows_core::Result<CompositionEffectBrush> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateBrush)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn ExtendedError(&self) -> windows_core::Result<windows_core::HRESULT> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ExtendedError)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn LoadStatus(&self) -> windows_core::Result<CompositionEffectFactoryLoadStatus> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).LoadStatus)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionEffectFactory {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionEffectFactory>();
}
unsafe impl windows_core::Interface for CompositionEffectFactory {
    type Vtable = <ICompositionEffectFactory as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionEffectFactory as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionEffectFactory {
    const NAME: &'static str = "Windows.UI.Composition.CompositionEffectFactory";
}
unsafe impl Send for CompositionEffectFactory {}
unsafe impl Sync for CompositionEffectFactory {}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CompositionEffectFactoryLoadStatus(pub i32);
impl CompositionEffectFactoryLoadStatus {
    pub const Success: Self = Self(0i32);
    pub const EffectTooComplex: Self = Self(1i32);
    pub const Pending: Self = Self(2i32);
    pub const Other: Self = Self(-1i32);
}
impl windows_core::TypeKind for CompositionEffectFactoryLoadStatus {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for CompositionEffectFactoryLoadStatus {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.CompositionEffectFactoryLoadStatus;i4)");
}
#[cfg(feature = "Graphics_Effects")]
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionEffectSourceParameter(windows_core::IUnknown);
#[cfg(feature = "Graphics_Effects")]
windows_core::imp::interface_hierarchy!(CompositionEffectSourceParameter, windows_core::IUnknown, windows_core::IInspectable);
#[cfg(feature = "Graphics_Effects")]
windows_core::imp::required_hierarchy!(CompositionEffectSourceParameter, super::super::Graphics::Effects::IGraphicsEffectSource);
#[cfg(feature = "Graphics_Effects")]
impl CompositionEffectSourceParameter {
    pub fn Name(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Name)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn Create(name: &windows_core::HSTRING) -> windows_core::Result<CompositionEffectSourceParameter> {
        Self::ICompositionEffectSourceParameterFactory(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Create)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(name), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        })
    }
    fn ICompositionEffectSourceParameterFactory<R, F: FnOnce(&ICompositionEffectSourceParameterFactory) -> windows_core::Result<R>>(callback: F) -> windows_core::Result<R> {
        static SHARED: windows_core::imp::FactoryCache<CompositionEffectSourceParameter, ICompositionEffectSourceParameterFactory> = windows_core::imp::FactoryCache::new();
        SHARED.call(callback)
    }
}
#[cfg(feature = "Graphics_Effects")]
impl windows_core::RuntimeType for CompositionEffectSourceParameter {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionEffectSourceParameter>();
}
#[cfg(feature = "Graphics_Effects")]
unsafe impl windows_core::Interface for CompositionEffectSourceParameter {
    type Vtable = <ICompositionEffectSourceParameter as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionEffectSourceParameter as windows_core::Interface>::IID;
}
#[cfg(feature = "Graphics_Effects")]
impl windows_core::RuntimeName for CompositionEffectSourceParameter {
    const NAME: &'static str = "Windows.UI.Composition.CompositionEffectSourceParameter";
}
#[cfg(feature = "Graphics_Effects")]
unsafe impl Send for CompositionEffectSourceParameter {}
#[cfg(feature = "Graphics_Effects")]
unsafe impl Sync for CompositionEffectSourceParameter {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionEllipseGeometry(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionEllipseGeometry, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionEllipseGeometry, IAnimationObject, super::super::Foundation::IClosable, CompositionGeometry, CompositionObject);
impl CompositionEllipseGeometry {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Center(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Center)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenter(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetCenter)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Radius(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Radius)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetRadius(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetRadius)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimEnd(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TrimEnd)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTrimEnd(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTrimEnd)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimOffset(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TrimOffset)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTrimOffset(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTrimOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimStart(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TrimStart)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTrimStart(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTrimStart)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionEllipseGeometry {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionEllipseGeometry>();
}
unsafe impl windows_core::Interface for CompositionEllipseGeometry {
    type Vtable = <ICompositionEllipseGeometry as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionEllipseGeometry as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionEllipseGeometry {
    const NAME: &'static str = "Windows.UI.Composition.CompositionEllipseGeometry";
}
unsafe impl Send for CompositionEllipseGeometry {}
unsafe impl Sync for CompositionEllipseGeometry {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionGeometricClip(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionGeometricClip, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionGeometricClip, IAnimationObject, super::super::Foundation::IClosable, CompositionClip, CompositionObject);
impl CompositionGeometricClip {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn AnchorPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).AnchorPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetAnchorPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetAnchorPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CenterPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetCenterPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Offset)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngle(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngle)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngle)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngleInDegrees)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Scale)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetScale)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> windows_core::Result<super::super::Foundation::Numerics::Matrix3x2> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TransformMatrix)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix3x2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionClip2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTransformMatrix)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Geometry(&self) -> windows_core::Result<CompositionGeometry> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Geometry)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetGeometry<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionGeometry>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetGeometry)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn ViewBox(&self) -> windows_core::Result<CompositionViewBox> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ViewBox)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetViewBox<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionViewBox>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetViewBox)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionGeometricClip {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionGeometricClip>();
}
unsafe impl windows_core::Interface for CompositionGeometricClip {
    type Vtable = <ICompositionGeometricClip as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionGeometricClip as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionGeometricClip {
    const NAME: &'static str = "Windows.UI.Composition.CompositionGeometricClip";
}
unsafe impl Send for CompositionGeometricClip {}
unsafe impl Sync for CompositionGeometricClip {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionGeometry(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionGeometry, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionGeometry, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionGeometry {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn TrimEnd(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TrimEnd)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTrimEnd(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetTrimEnd)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimOffset(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TrimOffset)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTrimOffset(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetTrimOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimStart(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TrimStart)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTrimStart(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetTrimStart)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionGeometry {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionGeometry>();
}
unsafe impl windows_core::Interface for CompositionGeometry {
    type Vtable = <ICompositionGeometry as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionGeometry as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionGeometry {
    const NAME: &'static str = "Windows.UI.Composition.CompositionGeometry";
}
unsafe impl Send for CompositionGeometry {}
unsafe impl Sync for CompositionGeometry {}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CompositionGetValueStatus(pub i32);
impl CompositionGetValueStatus {
    pub const Succeeded: Self = Self(0i32);
    pub const TypeMismatch: Self = Self(1i32);
    pub const NotFound: Self = Self(2i32);
}
impl windows_core::TypeKind for CompositionGetValueStatus {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for CompositionGetValueStatus {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.CompositionGetValueStatus;i4)");
}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionGradientBrush(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionGradientBrush, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionGradientBrush, IAnimationObject, super::super::Foundation::IClosable, CompositionBrush, CompositionObject);
impl CompositionGradientBrush {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn AnchorPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).AnchorPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetAnchorPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetAnchorPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CenterPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetCenterPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ColorStops(&self) -> windows_core::Result<CompositionColorGradientStopCollection> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ColorStops)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn ExtendMode(&self) -> windows_core::Result<CompositionGradientExtendMode> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ExtendMode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetExtendMode(&self, value: CompositionGradientExtendMode) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetExtendMode)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn InterpolationSpace(&self) -> windows_core::Result<CompositionColorSpace> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).InterpolationSpace)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetInterpolationSpace(&self, value: CompositionColorSpace) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetInterpolationSpace)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Offset)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngle(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngle)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngle)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngleInDegrees)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Scale)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetScale)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> windows_core::Result<super::super::Foundation::Numerics::Matrix3x2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TransformMatrix)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix3x2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetTransformMatrix)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn MappingMode(&self) -> windows_core::Result<CompositionMappingMode> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).MappingMode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetMappingMode(&self, value: CompositionMappingMode) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetMappingMode)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionGradientBrush {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionGradientBrush>();
}
unsafe impl windows_core::Interface for CompositionGradientBrush {
    type Vtable = <ICompositionGradientBrush as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionGradientBrush as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionGradientBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionGradientBrush";
}
unsafe impl Send for CompositionGradientBrush {}
unsafe impl Sync for CompositionGradientBrush {}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CompositionGradientExtendMode(pub i32);
impl CompositionGradientExtendMode {
    pub const Clamp: Self = Self(0i32);
    pub const Wrap: Self = Self(1i32);
    pub const Mirror: Self = Self(2i32);
}
impl windows_core::TypeKind for CompositionGradientExtendMode {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for CompositionGradientExtendMode {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.CompositionGradientExtendMode;i4)");
}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionGraphicsDevice(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionGraphicsDevice, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionGraphicsDevice, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionGraphicsDevice {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    #[cfg(feature = "Graphics_DirectX")]
    pub fn CreateDrawingSurface(&self, sizepixels: super::super::Foundation::Size, pixelformat: super::super::Graphics::DirectX::DirectXPixelFormat, alphamode: super::super::Graphics::DirectX::DirectXAlphaMode) -> windows_core::Result<CompositionDrawingSurface> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateDrawingSurface)(windows_core::Interface::as_raw(this), sizepixels, pixelformat, alphamode, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn RenderingDeviceReplaced<P0>(&self, handler: P0) -> windows_core::Result<i64>
    where
        P0: windows_core::Param<super::super::Foundation::TypedEventHandler<CompositionGraphicsDevice, RenderingDeviceReplacedEventArgs>>,
    {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RenderingDeviceReplaced)(windows_core::Interface::as_raw(this), handler.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub fn RemoveRenderingDeviceReplaced(&self, token: i64) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).RemoveRenderingDeviceReplaced)(windows_core::Interface::as_raw(this), token).ok() }
    }
    #[cfg(feature = "Graphics_DirectX")]
    pub fn CreateDrawingSurface2(&self, sizepixels: super::super::Graphics::SizeInt32, pixelformat: super::super::Graphics::DirectX::DirectXPixelFormat, alphamode: super::super::Graphics::DirectX::DirectXAlphaMode) -> windows_core::Result<CompositionDrawingSurface> {
        let this = &windows_core::Interface::cast::<ICompositionGraphicsDevice2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateDrawingSurface2)(windows_core::Interface::as_raw(this), sizepixels, pixelformat, alphamode, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Graphics_DirectX")]
    pub fn CreateVirtualDrawingSurface(&self, sizepixels: super::super::Graphics::SizeInt32, pixelformat: super::super::Graphics::DirectX::DirectXPixelFormat, alphamode: super::super::Graphics::DirectX::DirectXAlphaMode) -> windows_core::Result<CompositionVirtualDrawingSurface> {
        let this = &windows_core::Interface::cast::<ICompositionGraphicsDevice2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateVirtualDrawingSurface)(windows_core::Interface::as_raw(this), sizepixels, pixelformat, alphamode, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Graphics_DirectX")]
    pub fn CreateMipmapSurface(&self, sizepixels: super::super::Graphics::SizeInt32, pixelformat: super::super::Graphics::DirectX::DirectXPixelFormat, alphamode: super::super::Graphics::DirectX::DirectXAlphaMode) -> windows_core::Result<CompositionMipmapSurface> {
        let this = &windows_core::Interface::cast::<ICompositionGraphicsDevice3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateMipmapSurface)(windows_core::Interface::as_raw(this), sizepixels, pixelformat, alphamode, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Trim(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGraphicsDevice3>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Trim)(windows_core::Interface::as_raw(this)).ok() }
    }
    #[cfg(feature = "Graphics_DirectX")]
    pub fn CaptureAsync<P0>(&self, capturevisual: P0, size: super::super::Graphics::SizeInt32, pixelformat: super::super::Graphics::DirectX::DirectXPixelFormat, alphamode: super::super::Graphics::DirectX::DirectXAlphaMode, sdrboost: f32) -> windows_core::Result<super::super::Foundation::IAsyncOperation<ICompositionSurface>>
    where
        P0: windows_core::Param<Visual>,
    {
        let this = &windows_core::Interface::cast::<ICompositionGraphicsDevice4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CaptureAsync)(windows_core::Interface::as_raw(this), capturevisual.param().abi(), size, pixelformat, alphamode, sdrboost, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionGraphicsDevice {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionGraphicsDevice>();
}
unsafe impl windows_core::Interface for CompositionGraphicsDevice {
    type Vtable = <ICompositionGraphicsDevice as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionGraphicsDevice as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionGraphicsDevice {
    const NAME: &'static str = "Windows.UI.Composition.CompositionGraphicsDevice";
}
unsafe impl Send for CompositionGraphicsDevice {}
unsafe impl Sync for CompositionGraphicsDevice {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionLight(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionLight, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionLight, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionLight {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn Targets(&self) -> windows_core::Result<VisualUnorderedCollection> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Targets)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ExclusionsFromTargets(&self) -> windows_core::Result<VisualUnorderedCollection> {
        let this = &windows_core::Interface::cast::<ICompositionLight2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ExclusionsFromTargets)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn IsEnabled(&self) -> windows_core::Result<bool> {
        let this = &windows_core::Interface::cast::<ICompositionLight3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IsEnabled)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetIsEnabled(&self, value: bool) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionLight3>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetIsEnabled)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionLight {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionLight>();
}
unsafe impl windows_core::Interface for CompositionLight {
    type Vtable = <ICompositionLight as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionLight as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionLight {
    const NAME: &'static str = "Windows.UI.Composition.CompositionLight";
}
unsafe impl Send for CompositionLight {}
unsafe impl Sync for CompositionLight {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionLineGeometry(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionLineGeometry, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionLineGeometry, IAnimationObject, super::super::Foundation::IClosable, CompositionGeometry, CompositionObject);
impl CompositionLineGeometry {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn TrimEnd(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TrimEnd)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTrimEnd(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTrimEnd)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimOffset(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TrimOffset)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTrimOffset(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTrimOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimStart(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TrimStart)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTrimStart(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTrimStart)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Start(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Start)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetStart(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetStart)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn End(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).End)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetEnd(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetEnd)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionLineGeometry {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionLineGeometry>();
}
unsafe impl windows_core::Interface for CompositionLineGeometry {
    type Vtable = <ICompositionLineGeometry as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionLineGeometry as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionLineGeometry {
    const NAME: &'static str = "Windows.UI.Composition.CompositionLineGeometry";
}
unsafe impl Send for CompositionLineGeometry {}
unsafe impl Sync for CompositionLineGeometry {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionLinearGradientBrush(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionLinearGradientBrush, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionLinearGradientBrush, IAnimationObject, super::super::Foundation::IClosable, CompositionGradientBrush, CompositionBrush, CompositionObject);
impl CompositionLinearGradientBrush {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn AnchorPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).AnchorPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetAnchorPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetAnchorPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CenterPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetCenterPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ColorStops(&self) -> windows_core::Result<CompositionColorGradientStopCollection> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ColorStops)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn ExtendMode(&self) -> windows_core::Result<CompositionGradientExtendMode> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ExtendMode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetExtendMode(&self, value: CompositionGradientExtendMode) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetExtendMode)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn InterpolationSpace(&self) -> windows_core::Result<CompositionColorSpace> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).InterpolationSpace)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetInterpolationSpace(&self, value: CompositionColorSpace) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetInterpolationSpace)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Offset)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngle(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngle)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngle)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngleInDegrees)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Scale)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetScale)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> windows_core::Result<super::super::Foundation::Numerics::Matrix3x2> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TransformMatrix)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix3x2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTransformMatrix)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn MappingMode(&self) -> windows_core::Result<CompositionMappingMode> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).MappingMode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetMappingMode(&self, value: CompositionMappingMode) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetMappingMode)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn EndPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).EndPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetEndPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetEndPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn StartPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).StartPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetStartPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetStartPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionLinearGradientBrush {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionLinearGradientBrush>();
}
unsafe impl windows_core::Interface for CompositionLinearGradientBrush {
    type Vtable = <ICompositionLinearGradientBrush as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionLinearGradientBrush as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionLinearGradientBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionLinearGradientBrush";
}
unsafe impl Send for CompositionLinearGradientBrush {}
unsafe impl Sync for CompositionLinearGradientBrush {}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CompositionMappingMode(pub i32);
impl CompositionMappingMode {
    pub const Absolute: Self = Self(0i32);
    pub const Relative: Self = Self(1i32);
}
impl windows_core::TypeKind for CompositionMappingMode {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for CompositionMappingMode {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.CompositionMappingMode;i4)");
}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionMaskBrush(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionMaskBrush, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionMaskBrush, IAnimationObject, super::super::Foundation::IClosable, CompositionBrush, CompositionObject);
impl CompositionMaskBrush {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Mask(&self) -> windows_core::Result<CompositionBrush> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Mask)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetMask<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionBrush>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetMask)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn Source(&self) -> windows_core::Result<CompositionBrush> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Source)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetSource<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionBrush>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetSource)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionMaskBrush {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionMaskBrush>();
}
unsafe impl windows_core::Interface for CompositionMaskBrush {
    type Vtable = <ICompositionMaskBrush as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionMaskBrush as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionMaskBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionMaskBrush";
}
unsafe impl Send for CompositionMaskBrush {}
unsafe impl Sync for CompositionMaskBrush {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionMipmapSurface(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionMipmapSurface, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionMipmapSurface, IAnimationObject, super::super::Foundation::IClosable, ICompositionSurface, CompositionObject);
impl CompositionMipmapSurface {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn LevelCount(&self) -> windows_core::Result<u32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).LevelCount)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Graphics_DirectX")]
    pub fn AlphaMode(&self) -> windows_core::Result<super::super::Graphics::DirectX::DirectXAlphaMode> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).AlphaMode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Graphics_DirectX")]
    pub fn PixelFormat(&self) -> windows_core::Result<super::super::Graphics::DirectX::DirectXPixelFormat> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).PixelFormat)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Graphics")]
    pub fn SizeInt32(&self) -> windows_core::Result<super::super::Graphics::SizeInt32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).SizeInt32)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn GetDrawingSurfaceForLevel(&self, level: u32) -> windows_core::Result<CompositionDrawingSurface> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).GetDrawingSurfaceForLevel)(windows_core::Interface::as_raw(this), level, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionMipmapSurface {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionMipmapSurface>();
}
unsafe impl windows_core::Interface for CompositionMipmapSurface {
    type Vtable = <ICompositionMipmapSurface as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionMipmapSurface as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionMipmapSurface {
    const NAME: &'static str = "Windows.UI.Composition.CompositionMipmapSurface";
}
unsafe impl Send for CompositionMipmapSurface {}
unsafe impl Sync for CompositionMipmapSurface {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionNineGridBrush(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionNineGridBrush, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionNineGridBrush, IAnimationObject, super::super::Foundation::IClosable, CompositionBrush, CompositionObject);
impl CompositionNineGridBrush {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn BottomInset(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).BottomInset)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetBottomInset(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetBottomInset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn BottomInsetScale(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).BottomInsetScale)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetBottomInsetScale(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetBottomInsetScale)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn IsCenterHollow(&self) -> windows_core::Result<bool> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IsCenterHollow)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetIsCenterHollow(&self, value: bool) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetIsCenterHollow)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn LeftInset(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).LeftInset)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetLeftInset(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetLeftInset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn LeftInsetScale(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).LeftInsetScale)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetLeftInsetScale(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetLeftInsetScale)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RightInset(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RightInset)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRightInset(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetRightInset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RightInsetScale(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RightInsetScale)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRightInsetScale(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetRightInsetScale)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Source(&self) -> windows_core::Result<CompositionBrush> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Source)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetSource<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionBrush>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetSource)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn TopInset(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TopInset)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTopInset(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetTopInset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TopInsetScale(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TopInsetScale)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTopInsetScale(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetTopInsetScale)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn SetInsets(&self, inset: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetInsets)(windows_core::Interface::as_raw(this), inset).ok() }
    }
    pub fn SetInsetsWithValues(&self, left: f32, top: f32, right: f32, bottom: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetInsetsWithValues)(windows_core::Interface::as_raw(this), left, top, right, bottom).ok() }
    }
    pub fn SetInsetScales(&self, scale: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetInsetScales)(windows_core::Interface::as_raw(this), scale).ok() }
    }
    pub fn SetInsetScalesWithValues(&self, left: f32, top: f32, right: f32, bottom: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetInsetScalesWithValues)(windows_core::Interface::as_raw(this), left, top, right, bottom).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionNineGridBrush {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionNineGridBrush>();
}
unsafe impl windows_core::Interface for CompositionNineGridBrush {
    type Vtable = <ICompositionNineGridBrush as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionNineGridBrush as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionNineGridBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionNineGridBrush";
}
unsafe impl Send for CompositionNineGridBrush {}
unsafe impl Sync for CompositionNineGridBrush {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionObject(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionObject, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionObject, IAnimationObject, super::super::Foundation::IClosable);
impl CompositionObject {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn StartAnimationWithIAnimationObject<P0, P2>(target: P0, propertyname: &windows_core::HSTRING, animation: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IAnimationObject>,
        P2: windows_core::Param<CompositionAnimation>,
    {
        Self::ICompositionObjectStatics(|this| unsafe { (windows_core::Interface::vtable(this).StartAnimationWithIAnimationObject)(windows_core::Interface::as_raw(this), target.param().abi(), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() })
    }
    pub fn StartAnimationGroupWithIAnimationObject<P0, P1>(target: P0, animation: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IAnimationObject>,
        P1: windows_core::Param<ICompositionAnimationBase>,
    {
        Self::ICompositionObjectStatics(|this| unsafe { (windows_core::Interface::vtable(this).StartAnimationGroupWithIAnimationObject)(windows_core::Interface::as_raw(this), target.param().abi(), animation.param().abi()).ok() })
    }
    fn ICompositionObjectStatics<R, F: FnOnce(&ICompositionObjectStatics) -> windows_core::Result<R>>(callback: F) -> windows_core::Result<R> {
        static SHARED: windows_core::imp::FactoryCache<CompositionObject, ICompositionObjectStatics> = windows_core::imp::FactoryCache::new();
        SHARED.call(callback)
    }
}
impl windows_core::RuntimeType for CompositionObject {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionObject>();
}
unsafe impl windows_core::Interface for CompositionObject {
    type Vtable = <ICompositionObject as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionObject as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionObject {
    const NAME: &'static str = "Windows.UI.Composition.CompositionObject";
}
unsafe impl Send for CompositionObject {}
unsafe impl Sync for CompositionObject {}
#[cfg(feature = "Graphics")]
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionPath(windows_core::IUnknown);
#[cfg(feature = "Graphics")]
windows_core::imp::interface_hierarchy!(CompositionPath, windows_core::IUnknown, windows_core::IInspectable);
#[cfg(feature = "Graphics")]
windows_core::imp::required_hierarchy!(CompositionPath, super::super::Graphics::IGeometrySource2D);
#[cfg(feature = "Graphics")]
impl CompositionPath {
    pub fn Create<P0>(source: P0) -> windows_core::Result<CompositionPath>
    where
        P0: windows_core::Param<super::super::Graphics::IGeometrySource2D>,
    {
        Self::ICompositionPathFactory(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Create)(windows_core::Interface::as_raw(this), source.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        })
    }
    fn ICompositionPathFactory<R, F: FnOnce(&ICompositionPathFactory) -> windows_core::Result<R>>(callback: F) -> windows_core::Result<R> {
        static SHARED: windows_core::imp::FactoryCache<CompositionPath, ICompositionPathFactory> = windows_core::imp::FactoryCache::new();
        SHARED.call(callback)
    }
}
#[cfg(feature = "Graphics")]
impl windows_core::RuntimeType for CompositionPath {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionPath>();
}
#[cfg(feature = "Graphics")]
unsafe impl windows_core::Interface for CompositionPath {
    type Vtable = <ICompositionPath as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionPath as windows_core::Interface>::IID;
}
#[cfg(feature = "Graphics")]
impl windows_core::RuntimeName for CompositionPath {
    const NAME: &'static str = "Windows.UI.Composition.CompositionPath";
}
#[cfg(feature = "Graphics")]
unsafe impl Send for CompositionPath {}
#[cfg(feature = "Graphics")]
unsafe impl Sync for CompositionPath {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionPathGeometry(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionPathGeometry, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionPathGeometry, IAnimationObject, super::super::Foundation::IClosable, CompositionGeometry, CompositionObject);
impl CompositionPathGeometry {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn TrimEnd(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TrimEnd)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTrimEnd(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTrimEnd)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimOffset(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TrimOffset)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTrimOffset(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTrimOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimStart(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TrimStart)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTrimStart(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTrimStart)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    #[cfg(feature = "Graphics")]
    pub fn Path(&self) -> windows_core::Result<CompositionPath> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Path)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Graphics")]
    pub fn SetPath<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionPath>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetPath)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionPathGeometry {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionPathGeometry>();
}
unsafe impl windows_core::Interface for CompositionPathGeometry {
    type Vtable = <ICompositionPathGeometry as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionPathGeometry as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionPathGeometry {
    const NAME: &'static str = "Windows.UI.Composition.CompositionPathGeometry";
}
unsafe impl Send for CompositionPathGeometry {}
unsafe impl Sync for CompositionPathGeometry {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionProjectedShadow(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionProjectedShadow, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionProjectedShadow, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionProjectedShadow {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn BlurRadiusMultiplier(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).BlurRadiusMultiplier)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetBlurRadiusMultiplier(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetBlurRadiusMultiplier)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn Casters(&self) -> windows_core::Result<CompositionProjectedShadowCasterCollection> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Casters)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn LightSource(&self) -> windows_core::Result<CompositionLight> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).LightSource)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetLightSource<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionLight>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetLightSource)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn MaxBlurRadius(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).MaxBlurRadius)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetMaxBlurRadius(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetMaxBlurRadius)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn MinBlurRadius(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).MinBlurRadius)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetMinBlurRadius(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetMinBlurRadius)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn Receivers(&self) -> windows_core::Result<CompositionProjectedShadowReceiverUnorderedCollection> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Receivers)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
impl windows_core::RuntimeType for CompositionProjectedShadow {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionProjectedShadow>();
}
unsafe impl windows_core::Interface for CompositionProjectedShadow {
    type Vtable = <ICompositionProjectedShadow as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionProjectedShadow as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionProjectedShadow {
    const NAME: &'static str = "Windows.UI.Composition.CompositionProjectedShadow";
}
unsafe impl Send for CompositionProjectedShadow {}
unsafe impl Sync for CompositionProjectedShadow {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionProjectedShadowCaster(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionProjectedShadowCaster, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionProjectedShadowCaster, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionProjectedShadowCaster {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn Brush(&self) -> windows_core::Result<CompositionBrush> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Brush)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetBrush<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionBrush>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetBrush)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn CastingVisual(&self) -> windows_core::Result<Visual> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CastingVisual)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetCastingVisual<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<Visual>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetCastingVisual)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionProjectedShadowCaster {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionProjectedShadowCaster>();
}
unsafe impl windows_core::Interface for CompositionProjectedShadowCaster {
    type Vtable = <ICompositionProjectedShadowCaster as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionProjectedShadowCaster as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionProjectedShadowCaster {
    const NAME: &'static str = "Windows.UI.Composition.CompositionProjectedShadowCaster";
}
unsafe impl Send for CompositionProjectedShadowCaster {}
unsafe impl Sync for CompositionProjectedShadowCaster {}
#[cfg(feature = "Foundation_Collections")]
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionProjectedShadowCasterCollection(windows_core::IUnknown);
#[cfg(feature = "Foundation_Collections")]
windows_core::imp::interface_hierarchy!(CompositionProjectedShadowCasterCollection, windows_core::IUnknown, windows_core::IInspectable);
#[cfg(feature = "Foundation_Collections")]
windows_core::imp::required_hierarchy!(CompositionProjectedShadowCasterCollection, IAnimationObject, super::super::Foundation::IClosable, super::super::Foundation::Collections::IIterable<CompositionProjectedShadowCaster>, CompositionObject);
#[cfg(feature = "Foundation_Collections")]
impl CompositionProjectedShadowCasterCollection {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn Count(&self) -> windows_core::Result<i32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Count)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn InsertAbove<P0, P1>(&self, newcaster: P0, reference: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionProjectedShadowCaster>,
        P1: windows_core::Param<CompositionProjectedShadowCaster>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).InsertAbove)(windows_core::Interface::as_raw(this), newcaster.param().abi(), reference.param().abi()).ok() }
    }
    pub fn InsertAtBottom<P0>(&self, newcaster: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionProjectedShadowCaster>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).InsertAtBottom)(windows_core::Interface::as_raw(this), newcaster.param().abi()).ok() }
    }
    pub fn InsertAtTop<P0>(&self, newcaster: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionProjectedShadowCaster>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).InsertAtTop)(windows_core::Interface::as_raw(this), newcaster.param().abi()).ok() }
    }
    pub fn InsertBelow<P0, P1>(&self, newcaster: P0, reference: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionProjectedShadowCaster>,
        P1: windows_core::Param<CompositionProjectedShadowCaster>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).InsertBelow)(windows_core::Interface::as_raw(this), newcaster.param().abi(), reference.param().abi()).ok() }
    }
    pub fn Remove<P0>(&self, caster: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionProjectedShadowCaster>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).Remove)(windows_core::Interface::as_raw(this), caster.param().abi()).ok() }
    }
    pub fn RemoveAll(&self) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).RemoveAll)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn MaxRespectedCasters() -> windows_core::Result<i32> {
        Self::ICompositionProjectedShadowCasterCollectionStatics(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).MaxRespectedCasters)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        })
    }
    pub fn First(&self) -> windows_core::Result<super::super::Foundation::Collections::IIterator<CompositionProjectedShadowCaster>> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::Collections::IIterable<CompositionProjectedShadowCaster>>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).First)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    fn ICompositionProjectedShadowCasterCollectionStatics<R, F: FnOnce(&ICompositionProjectedShadowCasterCollectionStatics) -> windows_core::Result<R>>(callback: F) -> windows_core::Result<R> {
        static SHARED: windows_core::imp::FactoryCache<CompositionProjectedShadowCasterCollection, ICompositionProjectedShadowCasterCollectionStatics> = windows_core::imp::FactoryCache::new();
        SHARED.call(callback)
    }
}
#[cfg(feature = "Foundation_Collections")]
impl windows_core::RuntimeType for CompositionProjectedShadowCasterCollection {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionProjectedShadowCasterCollection>();
}
#[cfg(feature = "Foundation_Collections")]
unsafe impl windows_core::Interface for CompositionProjectedShadowCasterCollection {
    type Vtable = <ICompositionProjectedShadowCasterCollection as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionProjectedShadowCasterCollection as windows_core::Interface>::IID;
}
#[cfg(feature = "Foundation_Collections")]
impl windows_core::RuntimeName for CompositionProjectedShadowCasterCollection {
    const NAME: &'static str = "Windows.UI.Composition.CompositionProjectedShadowCasterCollection";
}
#[cfg(feature = "Foundation_Collections")]
unsafe impl Send for CompositionProjectedShadowCasterCollection {}
#[cfg(feature = "Foundation_Collections")]
unsafe impl Sync for CompositionProjectedShadowCasterCollection {}
#[cfg(feature = "Foundation_Collections")]
impl IntoIterator for CompositionProjectedShadowCasterCollection {
    type Item = CompositionProjectedShadowCaster;
    type IntoIter = super::super::Foundation::Collections::IIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        IntoIterator::into_iter(&self)
    }
}
#[cfg(feature = "Foundation_Collections")]
impl IntoIterator for &CompositionProjectedShadowCasterCollection {
    type Item = CompositionProjectedShadowCaster;
    type IntoIter = super::super::Foundation::Collections::IIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        self.First().unwrap()
    }
}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionProjectedShadowReceiver(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionProjectedShadowReceiver, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionProjectedShadowReceiver, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionProjectedShadowReceiver {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn ReceivingVisual(&self) -> windows_core::Result<Visual> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ReceivingVisual)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetReceivingVisual<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<Visual>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetReceivingVisual)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionProjectedShadowReceiver {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionProjectedShadowReceiver>();
}
unsafe impl windows_core::Interface for CompositionProjectedShadowReceiver {
    type Vtable = <ICompositionProjectedShadowReceiver as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionProjectedShadowReceiver as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionProjectedShadowReceiver {
    const NAME: &'static str = "Windows.UI.Composition.CompositionProjectedShadowReceiver";
}
unsafe impl Send for CompositionProjectedShadowReceiver {}
unsafe impl Sync for CompositionProjectedShadowReceiver {}
#[cfg(feature = "Foundation_Collections")]
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionProjectedShadowReceiverUnorderedCollection(windows_core::IUnknown);
#[cfg(feature = "Foundation_Collections")]
windows_core::imp::interface_hierarchy!(CompositionProjectedShadowReceiverUnorderedCollection, windows_core::IUnknown, windows_core::IInspectable);
#[cfg(feature = "Foundation_Collections")]
windows_core::imp::required_hierarchy!(CompositionProjectedShadowReceiverUnorderedCollection, IAnimationObject, super::super::Foundation::IClosable, super::super::Foundation::Collections::IIterable<CompositionProjectedShadowReceiver>, CompositionObject);
#[cfg(feature = "Foundation_Collections")]
impl CompositionProjectedShadowReceiverUnorderedCollection {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn Add<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionProjectedShadowReceiver>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).Add)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn Count(&self) -> windows_core::Result<i32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Count)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn Remove<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionProjectedShadowReceiver>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).Remove)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn RemoveAll(&self) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).RemoveAll)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn First(&self) -> windows_core::Result<super::super::Foundation::Collections::IIterator<CompositionProjectedShadowReceiver>> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::Collections::IIterable<CompositionProjectedShadowReceiver>>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).First)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[cfg(feature = "Foundation_Collections")]
impl windows_core::RuntimeType for CompositionProjectedShadowReceiverUnorderedCollection {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionProjectedShadowReceiverUnorderedCollection>();
}
#[cfg(feature = "Foundation_Collections")]
unsafe impl windows_core::Interface for CompositionProjectedShadowReceiverUnorderedCollection {
    type Vtable = <ICompositionProjectedShadowReceiverUnorderedCollection as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionProjectedShadowReceiverUnorderedCollection as windows_core::Interface>::IID;
}
#[cfg(feature = "Foundation_Collections")]
impl windows_core::RuntimeName for CompositionProjectedShadowReceiverUnorderedCollection {
    const NAME: &'static str = "Windows.UI.Composition.CompositionProjectedShadowReceiverUnorderedCollection";
}
#[cfg(feature = "Foundation_Collections")]
unsafe impl Send for CompositionProjectedShadowReceiverUnorderedCollection {}
#[cfg(feature = "Foundation_Collections")]
unsafe impl Sync for CompositionProjectedShadowReceiverUnorderedCollection {}
#[cfg(feature = "Foundation_Collections")]
impl IntoIterator for CompositionProjectedShadowReceiverUnorderedCollection {
    type Item = CompositionProjectedShadowReceiver;
    type IntoIter = super::super::Foundation::Collections::IIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        IntoIterator::into_iter(&self)
    }
}
#[cfg(feature = "Foundation_Collections")]
impl IntoIterator for &CompositionProjectedShadowReceiverUnorderedCollection {
    type Item = CompositionProjectedShadowReceiver;
    type IntoIter = super::super::Foundation::Collections::IIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        self.First().unwrap()
    }
}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionPropertySet(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionPropertySet, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionPropertySet, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionPropertySet {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn InsertColor(&self, propertyname: &windows_core::HSTRING, value: super::Color) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).InsertColor)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InsertMatrix3x2(&self, propertyname: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix3x2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).InsertMatrix3x2)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InsertMatrix4x4(&self, propertyname: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix4x4) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).InsertMatrix4x4)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InsertQuaternion(&self, propertyname: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Quaternion) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).InsertQuaternion)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), value).ok() }
    }
    pub fn InsertScalar(&self, propertyname: &windows_core::HSTRING, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).InsertScalar)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InsertVector2(&self, propertyname: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).InsertVector2)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InsertVector3(&self, propertyname: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).InsertVector3)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InsertVector4(&self, propertyname: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector4) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).InsertVector4)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), value).ok() }
    }
    pub fn TryGetColor(&self, propertyname: &windows_core::HSTRING, value: &mut super::Color) -> windows_core::Result<CompositionGetValueStatus> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetColor)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), value, &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TryGetMatrix3x2(&self, propertyname: &windows_core::HSTRING, value: &mut super::super::Foundation::Numerics::Matrix3x2) -> windows_core::Result<CompositionGetValueStatus> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetMatrix3x2)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), value, &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TryGetMatrix4x4(&self, propertyname: &windows_core::HSTRING, value: &mut super::super::Foundation::Numerics::Matrix4x4) -> windows_core::Result<CompositionGetValueStatus> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetMatrix4x4)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), value, &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TryGetQuaternion(&self, propertyname: &windows_core::HSTRING, value: &mut super::super::Foundation::Numerics::Quaternion) -> windows_core::Result<CompositionGetValueStatus> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetQuaternion)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), value, &mut result__).map(|| result__)
        }
    }
    pub fn TryGetScalar(&self, propertyname: &windows_core::HSTRING, value: &mut f32) -> windows_core::Result<CompositionGetValueStatus> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetScalar)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), value, &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TryGetVector2(&self, propertyname: &windows_core::HSTRING, value: &mut super::super::Foundation::Numerics::Vector2) -> windows_core::Result<CompositionGetValueStatus> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetVector2)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), value, &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TryGetVector3(&self, propertyname: &windows_core::HSTRING, value: &mut super::super::Foundation::Numerics::Vector3) -> windows_core::Result<CompositionGetValueStatus> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetVector3)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), value, &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TryGetVector4(&self, propertyname: &windows_core::HSTRING, value: &mut super::super::Foundation::Numerics::Vector4) -> windows_core::Result<CompositionGetValueStatus> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetVector4)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), value, &mut result__).map(|| result__)
        }
    }
    pub fn InsertBoolean(&self, propertyname: &windows_core::HSTRING, value: bool) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionPropertySet2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).InsertBoolean)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), value).ok() }
    }
    pub fn TryGetBoolean(&self, propertyname: &windows_core::HSTRING, value: &mut bool) -> windows_core::Result<CompositionGetValueStatus> {
        let this = &windows_core::Interface::cast::<ICompositionPropertySet2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetBoolean)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), value, &mut result__).map(|| result__)
        }
    }
}
impl windows_core::RuntimeType for CompositionPropertySet {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionPropertySet>();
}
unsafe impl windows_core::Interface for CompositionPropertySet {
    type Vtable = <ICompositionPropertySet as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionPropertySet as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionPropertySet {
    const NAME: &'static str = "Windows.UI.Composition.CompositionPropertySet";
}
unsafe impl Send for CompositionPropertySet {}
unsafe impl Sync for CompositionPropertySet {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionRadialGradientBrush(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionRadialGradientBrush, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionRadialGradientBrush, IAnimationObject, super::super::Foundation::IClosable, CompositionGradientBrush, CompositionBrush, CompositionObject);
impl CompositionRadialGradientBrush {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn AnchorPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).AnchorPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetAnchorPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetAnchorPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CenterPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetCenterPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ColorStops(&self) -> windows_core::Result<CompositionColorGradientStopCollection> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ColorStops)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn ExtendMode(&self) -> windows_core::Result<CompositionGradientExtendMode> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ExtendMode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetExtendMode(&self, value: CompositionGradientExtendMode) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetExtendMode)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn InterpolationSpace(&self) -> windows_core::Result<CompositionColorSpace> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).InterpolationSpace)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetInterpolationSpace(&self, value: CompositionColorSpace) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetInterpolationSpace)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Offset)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngle(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngle)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngle)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngleInDegrees)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Scale)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetScale)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> windows_core::Result<super::super::Foundation::Numerics::Matrix3x2> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TransformMatrix)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix3x2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTransformMatrix)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn MappingMode(&self) -> windows_core::Result<CompositionMappingMode> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).MappingMode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetMappingMode(&self, value: CompositionMappingMode) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGradientBrush2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetMappingMode)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn EllipseCenter(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).EllipseCenter)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetEllipseCenter(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetEllipseCenter)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn EllipseRadius(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).EllipseRadius)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetEllipseRadius(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetEllipseRadius)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn GradientOriginOffset(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).GradientOriginOffset)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetGradientOriginOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetGradientOriginOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl windows_core::RuntimeType for CompositionRadialGradientBrush {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionRadialGradientBrush>();
}
unsafe impl windows_core::Interface for CompositionRadialGradientBrush {
    type Vtable = <ICompositionRadialGradientBrush as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionRadialGradientBrush as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionRadialGradientBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionRadialGradientBrush";
}
unsafe impl Send for CompositionRadialGradientBrush {}
unsafe impl Sync for CompositionRadialGradientBrush {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionRectangleGeometry(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionRectangleGeometry, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionRectangleGeometry, IAnimationObject, super::super::Foundation::IClosable, CompositionGeometry, CompositionObject);
impl CompositionRectangleGeometry {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn TrimEnd(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TrimEnd)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTrimEnd(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTrimEnd)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimOffset(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TrimOffset)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTrimOffset(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTrimOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimStart(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TrimStart)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTrimStart(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTrimStart)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Offset)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Size(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Size)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetSize(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetSize)(windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl windows_core::RuntimeType for CompositionRectangleGeometry {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionRectangleGeometry>();
}
unsafe impl windows_core::Interface for CompositionRectangleGeometry {
    type Vtable = <ICompositionRectangleGeometry as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionRectangleGeometry as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionRectangleGeometry {
    const NAME: &'static str = "Windows.UI.Composition.CompositionRectangleGeometry";
}
unsafe impl Send for CompositionRectangleGeometry {}
unsafe impl Sync for CompositionRectangleGeometry {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionRoundedRectangleGeometry(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionRoundedRectangleGeometry, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionRoundedRectangleGeometry, IAnimationObject, super::super::Foundation::IClosable, CompositionGeometry, CompositionObject);
impl CompositionRoundedRectangleGeometry {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn TrimEnd(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TrimEnd)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTrimEnd(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTrimEnd)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimOffset(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TrimOffset)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTrimOffset(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTrimOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimStart(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TrimStart)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetTrimStart(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionGeometry>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTrimStart)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CornerRadius(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CornerRadius)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCornerRadius(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetCornerRadius)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Offset)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Size(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Size)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetSize(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetSize)(windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl windows_core::RuntimeType for CompositionRoundedRectangleGeometry {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionRoundedRectangleGeometry>();
}
unsafe impl windows_core::Interface for CompositionRoundedRectangleGeometry {
    type Vtable = <ICompositionRoundedRectangleGeometry as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionRoundedRectangleGeometry as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionRoundedRectangleGeometry {
    const NAME: &'static str = "Windows.UI.Composition.CompositionRoundedRectangleGeometry";
}
unsafe impl Send for CompositionRoundedRectangleGeometry {}
unsafe impl Sync for CompositionRoundedRectangleGeometry {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionScopedBatch(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionScopedBatch, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionScopedBatch, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionScopedBatch {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn IsActive(&self) -> windows_core::Result<bool> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IsActive)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn IsEnded(&self) -> windows_core::Result<bool> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IsEnded)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn End(&self) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).End)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Resume(&self) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).Resume)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Suspend(&self) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).Suspend)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Completed<P0>(&self, handler: P0) -> windows_core::Result<i64>
    where
        P0: windows_core::Param<super::super::Foundation::TypedEventHandler<windows_core::IInspectable, CompositionBatchCompletedEventArgs>>,
    {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Completed)(windows_core::Interface::as_raw(this), handler.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub fn RemoveCompleted(&self, token: i64) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).RemoveCompleted)(windows_core::Interface::as_raw(this), token).ok() }
    }
}
impl windows_core::RuntimeType for CompositionScopedBatch {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionScopedBatch>();
}
unsafe impl windows_core::Interface for CompositionScopedBatch {
    type Vtable = <ICompositionScopedBatch as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionScopedBatch as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionScopedBatch {
    const NAME: &'static str = "Windows.UI.Composition.CompositionScopedBatch";
}
unsafe impl Send for CompositionScopedBatch {}
unsafe impl Sync for CompositionScopedBatch {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionShadow(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionShadow, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionShadow, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionShadow {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionShadow {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionShadow>();
}
unsafe impl windows_core::Interface for CompositionShadow {
    type Vtable = <ICompositionShadow as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionShadow as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionShadow {
    const NAME: &'static str = "Windows.UI.Composition.CompositionShadow";
}
unsafe impl Send for CompositionShadow {}
unsafe impl Sync for CompositionShadow {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionShape(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionShape, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionShape, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionShape {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CenterPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetCenterPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Offset)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngle(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngle)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngle)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngleInDegrees)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Scale)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetScale)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> windows_core::Result<super::super::Foundation::Numerics::Matrix3x2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TransformMatrix)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix3x2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetTransformMatrix)(windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl windows_core::RuntimeType for CompositionShape {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionShape>();
}
unsafe impl windows_core::Interface for CompositionShape {
    type Vtable = <ICompositionShape as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionShape as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionShape {
    const NAME: &'static str = "Windows.UI.Composition.CompositionShape";
}
unsafe impl Send for CompositionShape {}
unsafe impl Sync for CompositionShape {}
#[cfg(feature = "Foundation_Collections")]
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionShapeCollection(windows_core::IUnknown);
#[cfg(feature = "Foundation_Collections")]
windows_core::imp::interface_hierarchy!(CompositionShapeCollection, windows_core::IUnknown, windows_core::IInspectable, super::super::Foundation::Collections::IVector<CompositionShape>);
#[cfg(feature = "Foundation_Collections")]
windows_core::imp::required_hierarchy!(CompositionShapeCollection, IAnimationObject, super::super::Foundation::IClosable, super::super::Foundation::Collections::IIterable<CompositionShape>, CompositionObject);
#[cfg(feature = "Foundation_Collections")]
impl CompositionShapeCollection {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn First(&self) -> windows_core::Result<super::super::Foundation::Collections::IIterator<CompositionShape>> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::Collections::IIterable<CompositionShape>>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).First)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn GetAt(&self, index: u32) -> windows_core::Result<CompositionShape> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).GetAt)(windows_core::Interface::as_raw(this), index, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Size(&self) -> windows_core::Result<u32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Size)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn GetView(&self) -> windows_core::Result<super::super::Foundation::Collections::IVectorView<CompositionShape>> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).GetView)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn IndexOf<P0>(&self, value: P0, index: &mut u32) -> windows_core::Result<bool>
    where
        P0: windows_core::Param<CompositionShape>,
    {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IndexOf)(windows_core::Interface::as_raw(this), value.param().abi(), index, &mut result__).map(|| result__)
        }
    }
    pub fn SetAt<P1>(&self, index: u32, value: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionShape>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetAt)(windows_core::Interface::as_raw(this), index, value.param().abi()).ok() }
    }
    pub fn InsertAt<P1>(&self, index: u32, value: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionShape>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).InsertAt)(windows_core::Interface::as_raw(this), index, value.param().abi()).ok() }
    }
    pub fn RemoveAt(&self, index: u32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).RemoveAt)(windows_core::Interface::as_raw(this), index).ok() }
    }
    pub fn Append<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionShape>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).Append)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn RemoveAtEnd(&self) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).RemoveAtEnd)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Clear(&self) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).Clear)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn GetMany(&self, startindex: u32, items: &mut [Option<CompositionShape>]) -> windows_core::Result<u32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).GetMany)(windows_core::Interface::as_raw(this), startindex, items.len().try_into().unwrap(), core::mem::transmute_copy(&items), &mut result__).map(|| result__)
        }
    }
    pub fn ReplaceAll(&self, items: &[Option<CompositionShape>]) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).ReplaceAll)(windows_core::Interface::as_raw(this), items.len().try_into().unwrap(), core::mem::transmute(items.as_ptr())).ok() }
    }
}
#[cfg(feature = "Foundation_Collections")]
impl windows_core::RuntimeType for CompositionShapeCollection {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, super::super::Foundation::Collections::IVector<CompositionShape>>();
}
#[cfg(feature = "Foundation_Collections")]
unsafe impl windows_core::Interface for CompositionShapeCollection {
    type Vtable = <super::super::Foundation::Collections::IVector<CompositionShape> as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <super::super::Foundation::Collections::IVector<CompositionShape> as windows_core::Interface>::IID;
}
#[cfg(feature = "Foundation_Collections")]
impl windows_core::RuntimeName for CompositionShapeCollection {
    const NAME: &'static str = "Windows.UI.Composition.CompositionShapeCollection";
}
#[cfg(feature = "Foundation_Collections")]
unsafe impl Send for CompositionShapeCollection {}
#[cfg(feature = "Foundation_Collections")]
unsafe impl Sync for CompositionShapeCollection {}
#[cfg(feature = "Foundation_Collections")]
impl IntoIterator for CompositionShapeCollection {
    type Item = CompositionShape;
    type IntoIter = super::super::Foundation::Collections::IIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        IntoIterator::into_iter(&self)
    }
}
#[cfg(feature = "Foundation_Collections")]
impl IntoIterator for &CompositionShapeCollection {
    type Item = CompositionShape;
    type IntoIter = super::super::Foundation::Collections::IIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        self.First().unwrap()
    }
}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionSpriteShape(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionSpriteShape, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionSpriteShape, IAnimationObject, super::super::Foundation::IClosable, CompositionShape, CompositionObject);
impl CompositionSpriteShape {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CenterPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetCenterPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Offset)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngle(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngle)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngle)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngleInDegrees)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Scale)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetScale)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> windows_core::Result<super::super::Foundation::Numerics::Matrix3x2> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TransformMatrix)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix3x2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionShape>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTransformMatrix)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn FillBrush(&self) -> windows_core::Result<CompositionBrush> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).FillBrush)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetFillBrush<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionBrush>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetFillBrush)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn Geometry(&self) -> windows_core::Result<CompositionGeometry> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Geometry)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetGeometry<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionGeometry>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetGeometry)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn IsStrokeNonScaling(&self) -> windows_core::Result<bool> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IsStrokeNonScaling)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetIsStrokeNonScaling(&self, value: bool) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetIsStrokeNonScaling)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StrokeBrush(&self) -> windows_core::Result<CompositionBrush> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).StrokeBrush)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetStrokeBrush<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionBrush>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetStrokeBrush)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn StrokeDashArray(&self) -> windows_core::Result<CompositionStrokeDashArray> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).StrokeDashArray)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StrokeDashCap(&self) -> windows_core::Result<CompositionStrokeCap> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).StrokeDashCap)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetStrokeDashCap(&self, value: CompositionStrokeCap) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetStrokeDashCap)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StrokeDashOffset(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).StrokeDashOffset)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetStrokeDashOffset(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetStrokeDashOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StrokeEndCap(&self) -> windows_core::Result<CompositionStrokeCap> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).StrokeEndCap)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetStrokeEndCap(&self, value: CompositionStrokeCap) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetStrokeEndCap)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StrokeLineJoin(&self) -> windows_core::Result<CompositionStrokeLineJoin> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).StrokeLineJoin)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetStrokeLineJoin(&self, value: CompositionStrokeLineJoin) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetStrokeLineJoin)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StrokeMiterLimit(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).StrokeMiterLimit)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetStrokeMiterLimit(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetStrokeMiterLimit)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StrokeStartCap(&self) -> windows_core::Result<CompositionStrokeCap> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).StrokeStartCap)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetStrokeStartCap(&self, value: CompositionStrokeCap) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetStrokeStartCap)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StrokeThickness(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).StrokeThickness)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetStrokeThickness(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetStrokeThickness)(windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl windows_core::RuntimeType for CompositionSpriteShape {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionSpriteShape>();
}
unsafe impl windows_core::Interface for CompositionSpriteShape {
    type Vtable = <ICompositionSpriteShape as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionSpriteShape as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionSpriteShape {
    const NAME: &'static str = "Windows.UI.Composition.CompositionSpriteShape";
}
unsafe impl Send for CompositionSpriteShape {}
unsafe impl Sync for CompositionSpriteShape {}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CompositionStretch(pub i32);
impl CompositionStretch {
    pub const None: Self = Self(0i32);
    pub const Fill: Self = Self(1i32);
    pub const Uniform: Self = Self(2i32);
    pub const UniformToFill: Self = Self(3i32);
}
impl windows_core::TypeKind for CompositionStretch {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for CompositionStretch {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.CompositionStretch;i4)");
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CompositionStrokeCap(pub i32);
impl CompositionStrokeCap {
    pub const Flat: Self = Self(0i32);
    pub const Square: Self = Self(1i32);
    pub const Round: Self = Self(2i32);
    pub const Triangle: Self = Self(3i32);
}
impl windows_core::TypeKind for CompositionStrokeCap {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for CompositionStrokeCap {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.CompositionStrokeCap;i4)");
}
#[cfg(feature = "Foundation_Collections")]
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionStrokeDashArray(windows_core::IUnknown);
#[cfg(feature = "Foundation_Collections")]
windows_core::imp::interface_hierarchy!(CompositionStrokeDashArray, windows_core::IUnknown, windows_core::IInspectable, super::super::Foundation::Collections::IVector<f32>);
#[cfg(feature = "Foundation_Collections")]
windows_core::imp::required_hierarchy!(CompositionStrokeDashArray, IAnimationObject, super::super::Foundation::IClosable, super::super::Foundation::Collections::IIterable<f32>, CompositionObject);
#[cfg(feature = "Foundation_Collections")]
impl CompositionStrokeDashArray {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn First(&self) -> windows_core::Result<super::super::Foundation::Collections::IIterator<f32>> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::Collections::IIterable<f32>>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).First)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn GetAt(&self, index: u32) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).GetAt)(windows_core::Interface::as_raw(this), index, &mut result__).map(|| result__)
        }
    }
    pub fn Size(&self) -> windows_core::Result<u32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Size)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn GetView(&self) -> windows_core::Result<super::super::Foundation::Collections::IVectorView<f32>> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).GetView)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn IndexOf(&self, value: f32, index: &mut u32) -> windows_core::Result<bool> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IndexOf)(windows_core::Interface::as_raw(this), value, index, &mut result__).map(|| result__)
        }
    }
    pub fn SetAt(&self, index: u32, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetAt)(windows_core::Interface::as_raw(this), index, value).ok() }
    }
    pub fn InsertAt(&self, index: u32, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).InsertAt)(windows_core::Interface::as_raw(this), index, value).ok() }
    }
    pub fn RemoveAt(&self, index: u32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).RemoveAt)(windows_core::Interface::as_raw(this), index).ok() }
    }
    pub fn Append(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).Append)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RemoveAtEnd(&self) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).RemoveAtEnd)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Clear(&self) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).Clear)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn GetMany(&self, startindex: u32, items: &mut [f32]) -> windows_core::Result<u32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).GetMany)(windows_core::Interface::as_raw(this), startindex, items.len().try_into().unwrap(), items.as_mut_ptr(), &mut result__).map(|| result__)
        }
    }
    pub fn ReplaceAll(&self, items: &[f32]) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).ReplaceAll)(windows_core::Interface::as_raw(this), items.len().try_into().unwrap(), items.as_ptr()).ok() }
    }
}
#[cfg(feature = "Foundation_Collections")]
impl windows_core::RuntimeType for CompositionStrokeDashArray {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, super::super::Foundation::Collections::IVector<f32>>();
}
#[cfg(feature = "Foundation_Collections")]
unsafe impl windows_core::Interface for CompositionStrokeDashArray {
    type Vtable = <super::super::Foundation::Collections::IVector<f32> as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <super::super::Foundation::Collections::IVector<f32> as windows_core::Interface>::IID;
}
#[cfg(feature = "Foundation_Collections")]
impl windows_core::RuntimeName for CompositionStrokeDashArray {
    const NAME: &'static str = "Windows.UI.Composition.CompositionStrokeDashArray";
}
#[cfg(feature = "Foundation_Collections")]
unsafe impl Send for CompositionStrokeDashArray {}
#[cfg(feature = "Foundation_Collections")]
unsafe impl Sync for CompositionStrokeDashArray {}
#[cfg(feature = "Foundation_Collections")]
impl IntoIterator for CompositionStrokeDashArray {
    type Item = f32;
    type IntoIter = super::super::Foundation::Collections::IIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        IntoIterator::into_iter(&self)
    }
}
#[cfg(feature = "Foundation_Collections")]
impl IntoIterator for &CompositionStrokeDashArray {
    type Item = f32;
    type IntoIter = super::super::Foundation::Collections::IIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        self.First().unwrap()
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CompositionStrokeLineJoin(pub i32);
impl CompositionStrokeLineJoin {
    pub const Miter: Self = Self(0i32);
    pub const Bevel: Self = Self(1i32);
    pub const Round: Self = Self(2i32);
    pub const MiterOrBevel: Self = Self(3i32);
}
impl windows_core::TypeKind for CompositionStrokeLineJoin {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::RuntimeType for CompositionStrokeLineJoin {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::from_slice(b"enum(Windows.UI.Composition.CompositionStrokeLineJoin;i4)");
}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionSurfaceBrush(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionSurfaceBrush, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionSurfaceBrush, IAnimationObject, super::super::Foundation::IClosable, CompositionBrush, CompositionObject);
impl CompositionSurfaceBrush {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn BitmapInterpolationMode(&self) -> windows_core::Result<CompositionBitmapInterpolationMode> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).BitmapInterpolationMode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetBitmapInterpolationMode(&self, value: CompositionBitmapInterpolationMode) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetBitmapInterpolationMode)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn HorizontalAlignmentRatio(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).HorizontalAlignmentRatio)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetHorizontalAlignmentRatio(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetHorizontalAlignmentRatio)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Stretch(&self) -> windows_core::Result<CompositionStretch> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Stretch)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetStretch(&self, value: CompositionStretch) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetStretch)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Surface(&self) -> windows_core::Result<ICompositionSurface> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Surface)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetSurface<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionSurface>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetSurface)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn VerticalAlignmentRatio(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).VerticalAlignmentRatio)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetVerticalAlignmentRatio(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetVerticalAlignmentRatio)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn AnchorPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).AnchorPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetAnchorPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetAnchorPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CenterPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetCenterPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Offset)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngle(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngle)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngle)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngleInDegrees)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Scale)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetScale)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> windows_core::Result<super::super::Foundation::Numerics::Matrix3x2> {
        let this = &windows_core::Interface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TransformMatrix)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix3x2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTransformMatrix)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn SnapToPixels(&self) -> windows_core::Result<bool> {
        let this = &windows_core::Interface::cast::<ICompositionSurfaceBrush3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).SnapToPixels)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetSnapToPixels(&self, value: bool) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionSurfaceBrush3>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetSnapToPixels)(windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl windows_core::RuntimeType for CompositionSurfaceBrush {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionSurfaceBrush>();
}
unsafe impl windows_core::Interface for CompositionSurfaceBrush {
    type Vtable = <ICompositionSurfaceBrush as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionSurfaceBrush as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionSurfaceBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionSurfaceBrush";
}
unsafe impl Send for CompositionSurfaceBrush {}
unsafe impl Sync for CompositionSurfaceBrush {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionTarget(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionTarget, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionTarget, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionTarget {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn Root(&self) -> windows_core::Result<Visual> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Root)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetRoot<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<Visual>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetRoot)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionTarget {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionTarget>();
}
unsafe impl windows_core::Interface for CompositionTarget {
    type Vtable = <ICompositionTarget as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionTarget as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionTarget {
    const NAME: &'static str = "Windows.UI.Composition.CompositionTarget";
}
unsafe impl Send for CompositionTarget {}
unsafe impl Sync for CompositionTarget {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionTexture(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionTexture, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionTexture, IAnimationObject, super::super::Foundation::IClosable, ICompositionSurface, CompositionObject);
impl CompositionTexture {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    #[cfg(feature = "Graphics")]
    pub fn SourceRect(&self) -> windows_core::Result<super::super::Graphics::RectInt32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).SourceRect)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Graphics")]
    pub fn SetSourceRect(&self, value: super::super::Graphics::RectInt32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetSourceRect)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Graphics_DirectX")]
    pub fn AlphaMode(&self) -> windows_core::Result<super::super::Graphics::DirectX::DirectXAlphaMode> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).AlphaMode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Graphics_DirectX")]
    pub fn SetAlphaMode(&self, value: super::super::Graphics::DirectX::DirectXAlphaMode) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetAlphaMode)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Graphics_DirectX")]
    pub fn ColorSpace(&self) -> windows_core::Result<super::super::Graphics::DirectX::DirectXColorSpace> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ColorSpace)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Graphics_DirectX")]
    pub fn SetColorSpace(&self, value: super::super::Graphics::DirectX::DirectXColorSpace) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetColorSpace)(windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl windows_core::RuntimeType for CompositionTexture {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionTexture>();
}
unsafe impl windows_core::Interface for CompositionTexture {
    type Vtable = <ICompositionTexture as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionTexture as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionTexture {
    const NAME: &'static str = "Windows.UI.Composition.CompositionTexture";
}
unsafe impl Send for CompositionTexture {}
unsafe impl Sync for CompositionTexture {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionTransform(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionTransform, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionTransform, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionTransform {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionTransform {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionTransform>();
}
unsafe impl windows_core::Interface for CompositionTransform {
    type Vtable = <ICompositionTransform as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionTransform as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionTransform {
    const NAME: &'static str = "Windows.UI.Composition.CompositionTransform";
}
unsafe impl Send for CompositionTransform {}
unsafe impl Sync for CompositionTransform {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionViewBox(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionViewBox, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionViewBox, IAnimationObject, super::super::Foundation::IClosable, CompositionObject);
impl CompositionViewBox {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn HorizontalAlignmentRatio(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).HorizontalAlignmentRatio)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetHorizontalAlignmentRatio(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetHorizontalAlignmentRatio)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Offset)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Size(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Size)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetSize(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetSize)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Stretch(&self) -> windows_core::Result<CompositionStretch> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Stretch)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetStretch(&self, value: CompositionStretch) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetStretch)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn VerticalAlignmentRatio(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).VerticalAlignmentRatio)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetVerticalAlignmentRatio(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetVerticalAlignmentRatio)(windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl windows_core::RuntimeType for CompositionViewBox {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionViewBox>();
}
unsafe impl windows_core::Interface for CompositionViewBox {
    type Vtable = <ICompositionViewBox as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionViewBox as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionViewBox {
    const NAME: &'static str = "Windows.UI.Composition.CompositionViewBox";
}
unsafe impl Send for CompositionViewBox {}
unsafe impl Sync for CompositionViewBox {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionVirtualDrawingSurface(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionVirtualDrawingSurface, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionVirtualDrawingSurface, IAnimationObject, super::super::Foundation::IClosable, ICompositionSurface, CompositionDrawingSurface, CompositionObject);
impl CompositionVirtualDrawingSurface {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    #[cfg(feature = "Graphics_DirectX")]
    pub fn AlphaMode(&self) -> windows_core::Result<super::super::Graphics::DirectX::DirectXAlphaMode> {
        let this = &windows_core::Interface::cast::<ICompositionDrawingSurface>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).AlphaMode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Graphics_DirectX")]
    pub fn PixelFormat(&self) -> windows_core::Result<super::super::Graphics::DirectX::DirectXPixelFormat> {
        let this = &windows_core::Interface::cast::<ICompositionDrawingSurface>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).PixelFormat)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn Size(&self) -> windows_core::Result<super::super::Foundation::Size> {
        let this = &windows_core::Interface::cast::<ICompositionDrawingSurface>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Size)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Graphics")]
    pub fn SizeInt32(&self) -> windows_core::Result<super::super::Graphics::SizeInt32> {
        let this = &windows_core::Interface::cast::<ICompositionDrawingSurface2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).SizeInt32)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Graphics")]
    pub fn Resize(&self, sizepixels: super::super::Graphics::SizeInt32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionDrawingSurface2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Resize)(windows_core::Interface::as_raw(this), sizepixels).ok() }
    }
    #[cfg(feature = "Graphics")]
    pub fn Scroll(&self, offset: super::super::Graphics::PointInt32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionDrawingSurface2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Scroll)(windows_core::Interface::as_raw(this), offset).ok() }
    }
    #[cfg(feature = "Graphics")]
    pub fn ScrollRect(&self, offset: super::super::Graphics::PointInt32, scrollrect: super::super::Graphics::RectInt32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionDrawingSurface2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).ScrollRect)(windows_core::Interface::as_raw(this), offset, scrollrect).ok() }
    }
    #[cfg(feature = "Graphics")]
    pub fn ScrollWithClip(&self, offset: super::super::Graphics::PointInt32, cliprect: super::super::Graphics::RectInt32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionDrawingSurface2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).ScrollWithClip)(windows_core::Interface::as_raw(this), offset, cliprect).ok() }
    }
    #[cfg(feature = "Graphics")]
    pub fn ScrollRectWithClip(&self, offset: super::super::Graphics::PointInt32, cliprect: super::super::Graphics::RectInt32, scrollrect: super::super::Graphics::RectInt32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionDrawingSurface2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).ScrollRectWithClip)(windows_core::Interface::as_raw(this), offset, cliprect, scrollrect).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    #[cfg(feature = "Graphics")]
    pub fn Trim(&self, rects: &[super::super::Graphics::RectInt32]) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).Trim)(windows_core::Interface::as_raw(this), rects.len().try_into().unwrap(), rects.as_ptr()).ok() }
    }
}
impl windows_core::RuntimeType for CompositionVirtualDrawingSurface {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionVirtualDrawingSurface>();
}
unsafe impl windows_core::Interface for CompositionVirtualDrawingSurface {
    type Vtable = <ICompositionVirtualDrawingSurface as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionVirtualDrawingSurface as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionVirtualDrawingSurface {
    const NAME: &'static str = "Windows.UI.Composition.CompositionVirtualDrawingSurface";
}
unsafe impl Send for CompositionVirtualDrawingSurface {}
unsafe impl Sync for CompositionVirtualDrawingSurface {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CompositionVisualSurface(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CompositionVisualSurface, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CompositionVisualSurface, IAnimationObject, super::super::Foundation::IClosable, ICompositionSurface, CompositionObject);
impl CompositionVisualSurface {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn SourceVisual(&self) -> windows_core::Result<Visual> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).SourceVisual)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetSourceVisual<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<Visual>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetSourceVisual)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SourceOffset(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).SourceOffset)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetSourceOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetSourceOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SourceSize(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).SourceSize)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetSourceSize(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetSourceSize)(windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl windows_core::RuntimeType for CompositionVisualSurface {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositionVisualSurface>();
}
unsafe impl windows_core::Interface for CompositionVisualSurface {
    type Vtable = <ICompositionVisualSurface as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositionVisualSurface as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CompositionVisualSurface {
    const NAME: &'static str = "Windows.UI.Composition.CompositionVisualSurface";
}
unsafe impl Send for CompositionVisualSurface {}
unsafe impl Sync for CompositionVisualSurface {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct Compositor(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(Compositor, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(Compositor, super::super::Foundation::IClosable);
impl Compositor {
    pub fn new() -> windows_core::Result<Self> {
        Self::IActivationFactory(|f| f.ActivateInstance::<Self>())
    }
    fn IActivationFactory<R, F: FnOnce(&windows_core::imp::IGenericFactory) -> windows_core::Result<R>>(callback: F) -> windows_core::Result<R> {
        static SHARED: windows_core::imp::FactoryCache<Compositor, windows_core::imp::IGenericFactory> = windows_core::imp::FactoryCache::new();
        SHARED.call(callback)
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn CreateColorKeyFrameAnimation(&self) -> windows_core::Result<ColorKeyFrameAnimation> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateColorKeyFrameAnimation)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateColorBrush(&self) -> windows_core::Result<CompositionColorBrush> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateColorBrush)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateColorBrushWithColor(&self, color: super::Color) -> windows_core::Result<CompositionColorBrush> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateColorBrushWithColor)(windows_core::Interface::as_raw(this), color, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateContainerVisual(&self) -> windows_core::Result<ContainerVisual> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateContainerVisual)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CreateCubicBezierEasingFunction(&self, controlpoint1: super::super::Foundation::Numerics::Vector2, controlpoint2: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<CubicBezierEasingFunction> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateCubicBezierEasingFunction)(windows_core::Interface::as_raw(this), controlpoint1, controlpoint2, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Graphics_Effects")]
    pub fn CreateEffectFactory<P0>(&self, graphicseffect: P0) -> windows_core::Result<CompositionEffectFactory>
    where
        P0: windows_core::Param<super::super::Graphics::Effects::IGraphicsEffect>,
    {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateEffectFactory)(windows_core::Interface::as_raw(this), graphicseffect.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(all(feature = "Foundation_Collections", feature = "Graphics_Effects"))]
    pub fn CreateEffectFactoryWithProperties<P0, P1>(&self, graphicseffect: P0, animatableproperties: P1) -> windows_core::Result<CompositionEffectFactory>
    where
        P0: windows_core::Param<super::super::Graphics::Effects::IGraphicsEffect>,
        P1: windows_core::Param<super::super::Foundation::Collections::IIterable<windows_core::HSTRING>>,
    {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateEffectFactoryWithProperties)(windows_core::Interface::as_raw(this), graphicseffect.param().abi(), animatableproperties.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateExpressionAnimation(&self) -> windows_core::Result<ExpressionAnimation> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateExpressionAnimation)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateExpressionAnimationWithExpression(&self, expression: &windows_core::HSTRING) -> windows_core::Result<ExpressionAnimation> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateExpressionAnimationWithExpression)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(expression), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateInsetClip(&self) -> windows_core::Result<InsetClip> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateInsetClip)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateInsetClipWithInsets(&self, leftinset: f32, topinset: f32, rightinset: f32, bottominset: f32) -> windows_core::Result<InsetClip> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateInsetClipWithInsets)(windows_core::Interface::as_raw(this), leftinset, topinset, rightinset, bottominset, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateLinearEasingFunction(&self) -> windows_core::Result<LinearEasingFunction> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateLinearEasingFunction)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreatePropertySet(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreatePropertySet)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateQuaternionKeyFrameAnimation(&self) -> windows_core::Result<QuaternionKeyFrameAnimation> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateQuaternionKeyFrameAnimation)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateScalarKeyFrameAnimation(&self) -> windows_core::Result<ScalarKeyFrameAnimation> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateScalarKeyFrameAnimation)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateScopedBatch(&self, batchtype: CompositionBatchTypes) -> windows_core::Result<CompositionScopedBatch> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateScopedBatch)(windows_core::Interface::as_raw(this), batchtype, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateSpriteVisual(&self) -> windows_core::Result<SpriteVisual> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateSpriteVisual)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateSurfaceBrush(&self) -> windows_core::Result<CompositionSurfaceBrush> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateSurfaceBrush)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateSurfaceBrushWithSurface<P0>(&self, surface: P0) -> windows_core::Result<CompositionSurfaceBrush>
    where
        P0: windows_core::Param<ICompositionSurface>,
    {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateSurfaceBrushWithSurface)(windows_core::Interface::as_raw(this), surface.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateTargetForCurrentView(&self) -> windows_core::Result<CompositionTarget> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateTargetForCurrentView)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateVector2KeyFrameAnimation(&self) -> windows_core::Result<Vector2KeyFrameAnimation> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateVector2KeyFrameAnimation)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateVector3KeyFrameAnimation(&self) -> windows_core::Result<Vector3KeyFrameAnimation> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateVector3KeyFrameAnimation)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateVector4KeyFrameAnimation(&self) -> windows_core::Result<Vector4KeyFrameAnimation> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateVector4KeyFrameAnimation)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn GetCommitBatch(&self, batchtype: CompositionBatchTypes) -> windows_core::Result<CompositionCommitBatch> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).GetCommitBatch)(windows_core::Interface::as_raw(this), batchtype, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateAmbientLight(&self) -> windows_core::Result<AmbientLight> {
        let this = &windows_core::Interface::cast::<ICompositor2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateAmbientLight)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn CreateAnimationGroup(&self) -> windows_core::Result<CompositionAnimationGroup> {
        let this = &windows_core::Interface::cast::<ICompositor2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateAnimationGroup)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateBackdropBrush(&self) -> windows_core::Result<CompositionBackdropBrush> {
        let this = &windows_core::Interface::cast::<ICompositor2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateBackdropBrush)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateDistantLight(&self) -> windows_core::Result<DistantLight> {
        let this = &windows_core::Interface::cast::<ICompositor2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateDistantLight)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateDropShadow(&self) -> windows_core::Result<DropShadow> {
        let this = &windows_core::Interface::cast::<ICompositor2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateDropShadow)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn CreateImplicitAnimationCollection(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositor2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateImplicitAnimationCollection)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateLayerVisual(&self) -> windows_core::Result<LayerVisual> {
        let this = &windows_core::Interface::cast::<ICompositor2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateLayerVisual)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateMaskBrush(&self) -> windows_core::Result<CompositionMaskBrush> {
        let this = &windows_core::Interface::cast::<ICompositor2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateMaskBrush)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateNineGridBrush(&self) -> windows_core::Result<CompositionNineGridBrush> {
        let this = &windows_core::Interface::cast::<ICompositor2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateNineGridBrush)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreatePointLight(&self) -> windows_core::Result<PointLight> {
        let this = &windows_core::Interface::cast::<ICompositor2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreatePointLight)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateSpotLight(&self) -> windows_core::Result<SpotLight> {
        let this = &windows_core::Interface::cast::<ICompositor2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateSpotLight)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateStepEasingFunction(&self) -> windows_core::Result<StepEasingFunction> {
        let this = &windows_core::Interface::cast::<ICompositor2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateStepEasingFunction)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateStepEasingFunctionWithStepCount(&self, stepcount: i32) -> windows_core::Result<StepEasingFunction> {
        let this = &windows_core::Interface::cast::<ICompositor2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateStepEasingFunctionWithStepCount)(windows_core::Interface::as_raw(this), stepcount, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateHostBackdropBrush(&self) -> windows_core::Result<CompositionBackdropBrush> {
        let this = &windows_core::Interface::cast::<ICompositor3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateHostBackdropBrush)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateColorGradientStop(&self) -> windows_core::Result<CompositionColorGradientStop> {
        let this = &windows_core::Interface::cast::<ICompositor4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateColorGradientStop)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateColorGradientStopWithOffsetAndColor(&self, offset: f32, color: super::Color) -> windows_core::Result<CompositionColorGradientStop> {
        let this = &windows_core::Interface::cast::<ICompositor4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateColorGradientStopWithOffsetAndColor)(windows_core::Interface::as_raw(this), offset, color, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateLinearGradientBrush(&self) -> windows_core::Result<CompositionLinearGradientBrush> {
        let this = &windows_core::Interface::cast::<ICompositor4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateLinearGradientBrush)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateSpringScalarAnimation(&self) -> windows_core::Result<SpringScalarNaturalMotionAnimation> {
        let this = &windows_core::Interface::cast::<ICompositor4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateSpringScalarAnimation)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateSpringVector2Animation(&self) -> windows_core::Result<SpringVector2NaturalMotionAnimation> {
        let this = &windows_core::Interface::cast::<ICompositor4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateSpringVector2Animation)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateSpringVector3Animation(&self) -> windows_core::Result<SpringVector3NaturalMotionAnimation> {
        let this = &windows_core::Interface::cast::<ICompositor4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateSpringVector3Animation)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    pub fn GlobalPlaybackRate(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).GlobalPlaybackRate)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetGlobalPlaybackRate(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetGlobalPlaybackRate)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn CreateBounceScalarAnimation(&self) -> windows_core::Result<BounceScalarNaturalMotionAnimation> {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateBounceScalarAnimation)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateBounceVector2Animation(&self) -> windows_core::Result<BounceVector2NaturalMotionAnimation> {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateBounceVector2Animation)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateBounceVector3Animation(&self) -> windows_core::Result<BounceVector3NaturalMotionAnimation> {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateBounceVector3Animation)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateContainerShape(&self) -> windows_core::Result<CompositionContainerShape> {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateContainerShape)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateEllipseGeometry(&self) -> windows_core::Result<CompositionEllipseGeometry> {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateEllipseGeometry)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateLineGeometry(&self) -> windows_core::Result<CompositionLineGeometry> {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateLineGeometry)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreatePathGeometry(&self) -> windows_core::Result<CompositionPathGeometry> {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreatePathGeometry)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Graphics")]
    pub fn CreatePathGeometryWithPath<P0>(&self, path: P0) -> windows_core::Result<CompositionPathGeometry>
    where
        P0: windows_core::Param<CompositionPath>,
    {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreatePathGeometryWithPath)(windows_core::Interface::as_raw(this), path.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreatePathKeyFrameAnimation(&self) -> windows_core::Result<PathKeyFrameAnimation> {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreatePathKeyFrameAnimation)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateRectangleGeometry(&self) -> windows_core::Result<CompositionRectangleGeometry> {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateRectangleGeometry)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateRoundedRectangleGeometry(&self) -> windows_core::Result<CompositionRoundedRectangleGeometry> {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateRoundedRectangleGeometry)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateShapeVisual(&self) -> windows_core::Result<ShapeVisual> {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateShapeVisual)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateSpriteShape(&self) -> windows_core::Result<CompositionSpriteShape> {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateSpriteShape)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateSpriteShapeWithGeometry<P0>(&self, geometry: P0) -> windows_core::Result<CompositionSpriteShape>
    where
        P0: windows_core::Param<CompositionGeometry>,
    {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateSpriteShapeWithGeometry)(windows_core::Interface::as_raw(this), geometry.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateViewBox(&self) -> windows_core::Result<CompositionViewBox> {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateViewBox)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn RequestCommitAsync(&self) -> windows_core::Result<super::super::Foundation::IAsyncAction> {
        let this = &windows_core::Interface::cast::<ICompositor5>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RequestCommitAsync)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateGeometricClip(&self) -> windows_core::Result<CompositionGeometricClip> {
        let this = &windows_core::Interface::cast::<ICompositor6>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateGeometricClip)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateGeometricClipWithGeometry<P0>(&self, geometry: P0) -> windows_core::Result<CompositionGeometricClip>
    where
        P0: windows_core::Param<CompositionGeometry>,
    {
        let this = &windows_core::Interface::cast::<ICompositor6>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateGeometricClipWithGeometry)(windows_core::Interface::as_raw(this), geometry.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateRedirectVisual(&self) -> windows_core::Result<RedirectVisual> {
        let this = &windows_core::Interface::cast::<ICompositor6>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateRedirectVisual)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateRedirectVisualWithSourceVisual<P0>(&self, source: P0) -> windows_core::Result<RedirectVisual>
    where
        P0: windows_core::Param<Visual>,
    {
        let this = &windows_core::Interface::cast::<ICompositor6>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateRedirectVisualWithSourceVisual)(windows_core::Interface::as_raw(this), source.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateBooleanKeyFrameAnimation(&self) -> windows_core::Result<BooleanKeyFrameAnimation> {
        let this = &windows_core::Interface::cast::<ICompositor6>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateBooleanKeyFrameAnimation)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositor7>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateAnimationPropertyInfo(&self) -> windows_core::Result<AnimationPropertyInfo> {
        let this = &windows_core::Interface::cast::<ICompositor7>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateAnimationPropertyInfo)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateRectangleClip(&self) -> windows_core::Result<RectangleClip> {
        let this = &windows_core::Interface::cast::<ICompositor7>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateRectangleClip)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateRectangleClipWithSides(&self, left: f32, top: f32, right: f32, bottom: f32) -> windows_core::Result<RectangleClip> {
        let this = &windows_core::Interface::cast::<ICompositor7>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateRectangleClipWithSides)(windows_core::Interface::as_raw(this), left, top, right, bottom, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CreateRectangleClipWithSidesAndRadius(&self, left: f32, top: f32, right: f32, bottom: f32, topleftradius: super::super::Foundation::Numerics::Vector2, toprightradius: super::super::Foundation::Numerics::Vector2, bottomrightradius: super::super::Foundation::Numerics::Vector2, bottomleftradius: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<RectangleClip> {
        let this = &windows_core::Interface::cast::<ICompositor7>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateRectangleClipWithSidesAndRadius)(windows_core::Interface::as_raw(this), left, top, right, bottom, topleftradius, toprightradius, bottomrightradius, bottomleftradius, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateAnimationController(&self) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositor8>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateAnimationController)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn MaxGlobalPlaybackRate() -> windows_core::Result<f32> {
        Self::ICompositorStatics(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).MaxGlobalPlaybackRate)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        })
    }
    pub fn MinGlobalPlaybackRate() -> windows_core::Result<f32> {
        Self::ICompositorStatics(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).MinGlobalPlaybackRate)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        })
    }
    pub fn TryCreateBlurredWallpaperBackdropBrush(&self) -> windows_core::Result<CompositionBackdropBrush> {
        let this = &windows_core::Interface::cast::<ICompositorWithBlurredWallpaperBackdropBrush>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryCreateBlurredWallpaperBackdropBrush)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateProjectedShadowCaster(&self) -> windows_core::Result<CompositionProjectedShadowCaster> {
        let this = &windows_core::Interface::cast::<ICompositorWithProjectedShadow>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateProjectedShadowCaster)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateProjectedShadow(&self) -> windows_core::Result<CompositionProjectedShadow> {
        let this = &windows_core::Interface::cast::<ICompositorWithProjectedShadow>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateProjectedShadow)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateProjectedShadowReceiver(&self) -> windows_core::Result<CompositionProjectedShadowReceiver> {
        let this = &windows_core::Interface::cast::<ICompositorWithProjectedShadow>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateProjectedShadowReceiver)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateRadialGradientBrush(&self) -> windows_core::Result<CompositionRadialGradientBrush> {
        let this = &windows_core::Interface::cast::<ICompositorWithRadialGradient>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateRadialGradientBrush)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn CreateVisualSurface(&self) -> windows_core::Result<CompositionVisualSurface> {
        let this = &windows_core::Interface::cast::<ICompositorWithVisualSurface>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateVisualSurface)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    fn ICompositorStatics<R, F: FnOnce(&ICompositorStatics) -> windows_core::Result<R>>(callback: F) -> windows_core::Result<R> {
        static SHARED: windows_core::imp::FactoryCache<Compositor, ICompositorStatics> = windows_core::imp::FactoryCache::new();
        SHARED.call(callback)
    }
}
impl windows_core::RuntimeType for Compositor {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICompositor>();
}
unsafe impl windows_core::Interface for Compositor {
    type Vtable = <ICompositor as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICompositor as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for Compositor {
    const NAME: &'static str = "Windows.UI.Composition.Compositor";
}
unsafe impl Send for Compositor {}
unsafe impl Sync for Compositor {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct ContainerVisual(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(ContainerVisual, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(ContainerVisual, IAnimationObject, super::super::Foundation::IClosable, Visual, CompositionObject);
impl ContainerVisual {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn Children(&self) -> windows_core::Result<VisualCollection> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Children)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn AnchorPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).AnchorPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetAnchorPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetAnchorPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn BackfaceVisibility(&self) -> windows_core::Result<CompositionBackfaceVisibility> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).BackfaceVisibility)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetBackfaceVisibility(&self, value: CompositionBackfaceVisibility) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetBackfaceVisibility)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn BorderMode(&self) -> windows_core::Result<CompositionBorderMode> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).BorderMode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetBorderMode(&self, value: CompositionBorderMode) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetBorderMode)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector3> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CenterPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetCenterPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Clip(&self) -> windows_core::Result<CompositionClip> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Clip)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetClip<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionClip>,
    {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetClip)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn CompositeMode(&self) -> windows_core::Result<CompositionCompositeMode> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CompositeMode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetCompositeMode(&self, value: CompositionCompositeMode) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetCompositeMode)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn IsVisible(&self) -> windows_core::Result<bool> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IsVisible)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetIsVisible(&self, value: bool) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetIsVisible)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector3> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Offset)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Opacity(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Opacity)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetOpacity(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetOpacity)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Orientation(&self) -> windows_core::Result<super::super::Foundation::Numerics::Quaternion> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Orientation)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOrientation(&self, value: super::super::Foundation::Numerics::Quaternion) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetOrientation)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Parent(&self) -> windows_core::Result<ContainerVisual> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Parent)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn RotationAngle(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngle)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngle)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngleInDegrees)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn RotationAxis(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector3> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAxis)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetRotationAxis(&self, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAxis)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector3> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Scale)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetScale)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Size(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Size)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetSize(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetSize)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> windows_core::Result<super::super::Foundation::Numerics::Matrix4x4> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TransformMatrix)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix4x4) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTransformMatrix)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn ParentForTransform(&self) -> windows_core::Result<Visual> {
        let this = &windows_core::Interface::cast::<IVisual2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ParentForTransform)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetParentForTransform<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<Visual>,
    {
        let this = &windows_core::Interface::cast::<IVisual2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetParentForTransform)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn RelativeOffsetAdjustment(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector3> {
        let this = &windows_core::Interface::cast::<IVisual2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RelativeOffsetAdjustment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetRelativeOffsetAdjustment(&self, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRelativeOffsetAdjustment)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn RelativeSizeAdjustment(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<IVisual2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RelativeSizeAdjustment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetRelativeSizeAdjustment(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRelativeSizeAdjustment)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn IsHitTestVisible(&self) -> windows_core::Result<bool> {
        let this = &windows_core::Interface::cast::<IVisual3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IsHitTestVisible)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetIsHitTestVisible(&self, value: bool) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual3>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetIsHitTestVisible)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn IsPixelSnappingEnabled(&self) -> windows_core::Result<bool> {
        let this = &windows_core::Interface::cast::<IVisual4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IsPixelSnappingEnabled)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetIsPixelSnappingEnabled(&self, value: bool) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual4>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetIsPixelSnappingEnabled)(windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl windows_core::RuntimeType for ContainerVisual {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, IContainerVisual>();
}
unsafe impl windows_core::Interface for ContainerVisual {
    type Vtable = <IContainerVisual as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <IContainerVisual as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for ContainerVisual {
    const NAME: &'static str = "Windows.UI.Composition.ContainerVisual";
}
unsafe impl Send for ContainerVisual {}
unsafe impl Sync for ContainerVisual {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct CubicBezierEasingFunction(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(CubicBezierEasingFunction, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(CubicBezierEasingFunction, IAnimationObject, super::super::Foundation::IClosable, CompositionEasingFunction, CompositionObject);
impl CubicBezierEasingFunction {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn ControlPoint1(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ControlPoint1)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn ControlPoint2(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ControlPoint2)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
}
impl windows_core::RuntimeType for CubicBezierEasingFunction {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, ICubicBezierEasingFunction>();
}
unsafe impl windows_core::Interface for CubicBezierEasingFunction {
    type Vtable = <ICubicBezierEasingFunction as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <ICubicBezierEasingFunction as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for CubicBezierEasingFunction {
    const NAME: &'static str = "Windows.UI.Composition.CubicBezierEasingFunction";
}
unsafe impl Send for CubicBezierEasingFunction {}
unsafe impl Sync for CubicBezierEasingFunction {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct DelegatedInkTrailVisual(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(DelegatedInkTrailVisual, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(DelegatedInkTrailVisual, IAnimationObject, super::super::Foundation::IClosable, Visual, CompositionObject);
impl DelegatedInkTrailVisual {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn AddTrailPoints(&self, inkpoints: &[InkTrailPoint]) -> windows_core::Result<u32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).AddTrailPoints)(windows_core::Interface::as_raw(this), inkpoints.len().try_into().unwrap(), inkpoints.as_ptr(), &mut result__).map(|| result__)
        }
    }
    pub fn AddTrailPointsWithPrediction(&self, inkpoints: &[InkTrailPoint], predictedinkpoints: &[InkTrailPoint]) -> windows_core::Result<u32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).AddTrailPointsWithPrediction)(windows_core::Interface::as_raw(this), inkpoints.len().try_into().unwrap(), inkpoints.as_ptr(), predictedinkpoints.len().try_into().unwrap(), predictedinkpoints.as_ptr(), &mut result__).map(|| result__)
        }
    }
    pub fn RemoveTrailPoints(&self, generationid: u32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).RemoveTrailPoints)(windows_core::Interface::as_raw(this), generationid).ok() }
    }
    pub fn StartNewTrail(&self, color: super::Color) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).StartNewTrail)(windows_core::Interface::as_raw(this), color).ok() }
    }
    pub fn Create<P0>(compositor: P0) -> windows_core::Result<DelegatedInkTrailVisual>
    where
        P0: windows_core::Param<Compositor>,
    {
        Self::IDelegatedInkTrailVisualStatics(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Create)(windows_core::Interface::as_raw(this), compositor.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        })
    }
    pub fn CreateForSwapChain<P0, P1>(compositor: P0, swapchain: P1) -> windows_core::Result<DelegatedInkTrailVisual>
    where
        P0: windows_core::Param<Compositor>,
        P1: windows_core::Param<ICompositionSurface>,
    {
        Self::IDelegatedInkTrailVisualStatics(|this| unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CreateForSwapChain)(windows_core::Interface::as_raw(this), compositor.param().abi(), swapchain.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        })
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn AnchorPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).AnchorPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetAnchorPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetAnchorPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn BackfaceVisibility(&self) -> windows_core::Result<CompositionBackfaceVisibility> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).BackfaceVisibility)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetBackfaceVisibility(&self, value: CompositionBackfaceVisibility) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetBackfaceVisibility)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn BorderMode(&self) -> windows_core::Result<CompositionBorderMode> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).BorderMode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetBorderMode(&self, value: CompositionBorderMode) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetBorderMode)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector3> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CenterPoint)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetCenterPoint)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Clip(&self) -> windows_core::Result<CompositionClip> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Clip)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetClip<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionClip>,
    {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetClip)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn CompositeMode(&self) -> windows_core::Result<CompositionCompositeMode> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CompositeMode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetCompositeMode(&self, value: CompositionCompositeMode) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetCompositeMode)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn IsVisible(&self) -> windows_core::Result<bool> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IsVisible)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetIsVisible(&self, value: bool) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetIsVisible)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector3> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Offset)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Opacity(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Opacity)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetOpacity(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetOpacity)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Orientation(&self) -> windows_core::Result<super::super::Foundation::Numerics::Quaternion> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Orientation)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOrientation(&self, value: super::super::Foundation::Numerics::Quaternion) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetOrientation)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Parent(&self) -> windows_core::Result<ContainerVisual> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Parent)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn RotationAngle(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngle)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngle)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAngleInDegrees)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn RotationAxis(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector3> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RotationAxis)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetRotationAxis(&self, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRotationAxis)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector3> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Scale)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetScale)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Size(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Size)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetSize(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetSize)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> windows_core::Result<super::super::Foundation::Numerics::Matrix4x4> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TransformMatrix)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix4x4) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTransformMatrix)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn ParentForTransform(&self) -> windows_core::Result<Visual> {
        let this = &windows_core::Interface::cast::<IVisual2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ParentForTransform)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetParentForTransform<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<Visual>,
    {
        let this = &windows_core::Interface::cast::<IVisual2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetParentForTransform)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn RelativeOffsetAdjustment(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector3> {
        let this = &windows_core::Interface::cast::<IVisual2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RelativeOffsetAdjustment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetRelativeOffsetAdjustment(&self, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRelativeOffsetAdjustment)(windows_core::Interface::as_raw(this), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn RelativeSizeAdjustment(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &windows_core::Interface::cast::<IVisual2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).RelativeSizeAdjustment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetRelativeSizeAdjustment(&self, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetRelativeSizeAdjustment)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn IsHitTestVisible(&self) -> windows_core::Result<bool> {
        let this = &windows_core::Interface::cast::<IVisual3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IsHitTestVisible)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetIsHitTestVisible(&self, value: bool) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual3>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetIsHitTestVisible)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn IsPixelSnappingEnabled(&self) -> windows_core::Result<bool> {
        let this = &windows_core::Interface::cast::<IVisual4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IsPixelSnappingEnabled)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetIsPixelSnappingEnabled(&self, value: bool) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IVisual4>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetIsPixelSnappingEnabled)(windows_core::Interface::as_raw(this), value).ok() }
    }
    fn IDelegatedInkTrailVisualStatics<R, F: FnOnce(&IDelegatedInkTrailVisualStatics) -> windows_core::Result<R>>(callback: F) -> windows_core::Result<R> {
        static SHARED: windows_core::imp::FactoryCache<DelegatedInkTrailVisual, IDelegatedInkTrailVisualStatics> = windows_core::imp::FactoryCache::new();
        SHARED.call(callback)
    }
}
impl windows_core::RuntimeType for DelegatedInkTrailVisual {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, IDelegatedInkTrailVisual>();
}
unsafe impl windows_core::Interface for DelegatedInkTrailVisual {
    type Vtable = <IDelegatedInkTrailVisual as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <IDelegatedInkTrailVisual as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for DelegatedInkTrailVisual {
    const NAME: &'static str = "Windows.UI.Composition.DelegatedInkTrailVisual";
}
unsafe impl Send for DelegatedInkTrailVisual {}
unsafe impl Sync for DelegatedInkTrailVisual {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct DistantLight(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(DistantLight, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(DistantLight, IAnimationObject, super::super::Foundation::IClosable, CompositionLight, CompositionObject);
impl DistantLight {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn Targets(&self) -> windows_core::Result<VisualUnorderedCollection> {
        let this = &windows_core::Interface::cast::<ICompositionLight>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Targets)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ExclusionsFromTargets(&self) -> windows_core::Result<VisualUnorderedCollection> {
        let this = &windows_core::Interface::cast::<ICompositionLight2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ExclusionsFromTargets)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn IsEnabled(&self) -> windows_core::Result<bool> {
        let this = &windows_core::Interface::cast::<ICompositionLight3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).IsEnabled)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetIsEnabled(&self, value: bool) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionLight3>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetIsEnabled)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn Color(&self) -> windows_core::Result<super::Color> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Color)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetColor(&self, value: super::Color) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetColor)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn CoordinateSpace(&self) -> windows_core::Result<Visual> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).CoordinateSpace)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetCoordinateSpace<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<Visual>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetCoordinateSpace)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Direction(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector3> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Direction)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetDirection(&self, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetDirection)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Intensity(&self) -> windows_core::Result<f32> {
        let this = &windows_core::Interface::cast::<IDistantLight2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Intensity)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetIntensity(&self, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IDistantLight2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetIntensity)(windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl windows_core::RuntimeType for DistantLight {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, IDistantLight>();
}
unsafe impl windows_core::Interface for DistantLight {
    type Vtable = <IDistantLight as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <IDistantLight as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for DistantLight {
    const NAME: &'static str = "Windows.UI.Composition.DistantLight";
}
unsafe impl Send for DistantLight {}
unsafe impl Sync for DistantLight {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct DropShadow(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(DropShadow, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(DropShadow, IAnimationObject, super::super::Foundation::IClosable, CompositionShadow, CompositionObject);
impl DropShadow {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn BlurRadius(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).BlurRadius)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetBlurRadius(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetBlurRadius)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Color(&self) -> windows_core::Result<super::Color> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Color)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetColor(&self, value: super::Color) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetColor)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Mask(&self) -> windows_core::Result<CompositionBrush> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Mask)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetMask<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<CompositionBrush>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetMask)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> windows_core::Result<super::super::Foundation::Numerics::Vector3> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Offset)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetOffset)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Opacity(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Opacity)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetOpacity(&self, value: f32) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetOpacity)(windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn SourcePolicy(&self) -> windows_core::Result<CompositionDropShadowSourcePolicy> {
        let this = &windows_core::Interface::cast::<IDropShadow2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).SourcePolicy)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn SetSourcePolicy(&self, value: CompositionDropShadowSourcePolicy) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<IDropShadow2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetSourcePolicy)(windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl windows_core::RuntimeType for DropShadow {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, IDropShadow>();
}
unsafe impl windows_core::Interface for DropShadow {
    type Vtable = <IDropShadow as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <IDropShadow as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for DropShadow {
    const NAME: &'static str = "Windows.UI.Composition.DropShadow";
}
unsafe impl Send for DropShadow {}
unsafe impl Sync for DropShadow {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct ElasticEasingFunction(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(ElasticEasingFunction, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(ElasticEasingFunction, IAnimationObject, super::super::Foundation::IClosable, CompositionEasingFunction, CompositionObject);
impl ElasticEasingFunction {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn Mode(&self) -> windows_core::Result<CompositionEasingFunctionMode> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Mode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn Oscillations(&self) -> windows_core::Result<i32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Oscillations)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn Springiness(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Springiness)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
}
impl windows_core::RuntimeType for ElasticEasingFunction {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, IElasticEasingFunction>();
}
unsafe impl windows_core::Interface for ElasticEasingFunction {
    type Vtable = <IElasticEasingFunction as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <IElasticEasingFunction as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for ElasticEasingFunction {
    const NAME: &'static str = "Windows.UI.Composition.ElasticEasingFunction";
}
unsafe impl Send for ElasticEasingFunction {}
unsafe impl Sync for ElasticEasingFunction {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct ExponentialEasingFunction(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(ExponentialEasingFunction, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(ExponentialEasingFunction, IAnimationObject, super::super::Foundation::IClosable, CompositionEasingFunction, CompositionObject);
impl ExponentialEasingFunction {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn Mode(&self) -> windows_core::Result<CompositionEasingFunctionMode> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Mode)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
    pub fn Exponent(&self) -> windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Exponent)(windows_core::Interface::as_raw(this), &mut result__).map(|| result__)
        }
    }
}
impl windows_core::RuntimeType for ExponentialEasingFunction {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, IExponentialEasingFunction>();
}
unsafe impl windows_core::Interface for ExponentialEasingFunction {
    type Vtable = <IExponentialEasingFunction as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <IExponentialEasingFunction as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for ExponentialEasingFunction {
    const NAME: &'static str = "Windows.UI.Composition.ExponentialEasingFunction";
}
unsafe impl Send for ExponentialEasingFunction {}
unsafe impl Sync for ExponentialEasingFunction {}
#[repr(transparent)]
#[derive(Clone, Debug, Eq, PartialEq)]
pub struct ExpressionAnimation(windows_core::IUnknown);
windows_core::imp::interface_hierarchy!(ExpressionAnimation, windows_core::IUnknown, windows_core::IInspectable);
windows_core::imp::required_hierarchy!(ExpressionAnimation, IAnimationObject, super::super::Foundation::IClosable, ICompositionAnimationBase, CompositionAnimation, CompositionObject);
impl ExpressionAnimation {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = &windows_core::Interface::cast::<IAnimationObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
    pub fn Close(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearAllParameters(&self) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).ClearAllParameters)(windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearParameter(&self, key: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).ClearParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key)).ok() }
    }
    pub fn SetColorParameter(&self, key: &windows_core::HSTRING, value: super::Color) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetColorParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix3x2Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix3x2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetMatrix3x2Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix4x4Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix4x4) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetMatrix4x4Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetQuaternionParameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Quaternion) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetQuaternionParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetReferenceParameter<P1>(&self, key: &windows_core::HSTRING, compositionobject: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionObject>,
    {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetReferenceParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), compositionobject.param().abi()).ok() }
    }
    pub fn SetScalarParameter(&self, key: &windows_core::HSTRING, value: f32) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetScalarParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector2Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector2) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetVector2Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector3Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector3) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetVector3Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector4Parameter(&self, key: &windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector4) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetVector4Parameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetBooleanParameter(&self, key: &windows_core::HSTRING, value: bool) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetBooleanParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(key), value).ok() }
    }
    pub fn Target(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Target)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetTarget(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetTarget)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn InitialValueExpressions(&self) -> windows_core::Result<InitialValueExpressionCollection> {
        let this = &windows_core::Interface::cast::<ICompositionAnimation3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).InitialValueExpressions)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn SetExpressionReferenceParameter<P1>(&self, parametername: &windows_core::HSTRING, source: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<IAnimationObject>,
    {
        let this = &windows_core::Interface::cast::<ICompositionAnimation4>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetExpressionReferenceParameter)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(parametername), source.param().abi()).ok() }
    }
    pub fn Compositor(&self) -> windows_core::Result<Compositor> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Compositor)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> windows_core::Result<super::Core::CoreDispatcher> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Dispatcher)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn Properties(&self) -> windows_core::Result<CompositionPropertySet> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Properties)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimation<P1>(&self, propertyname: &windows_core::HSTRING, animation: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimation)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Comment)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetComment(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetComment)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn ImplicitAnimations(&self) -> windows_core::Result<ImplicitAnimationCollection> {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).ImplicitAnimations)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ImplicitAnimationCollection>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).SetImplicitAnimations)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICompositionAnimationBase>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject2>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StopAnimationGroup)(windows_core::Interface::as_raw(this), value.param().abi()).ok() }
    }
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &windows_core::Interface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).DispatcherQueue)(windows_core::Interface::as_raw(this), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &windows_core::HSTRING) -> windows_core::Result<AnimationController> {
        let this = &windows_core::Interface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).TryGetAnimationController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub fn StartAnimationWithController<P1, P2>(&self, propertyname: &windows_core::HSTRING, animation: P1, animationcontroller: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<CompositionAnimation>,
        P2: windows_core::Param<AnimationController>,
    {
        let this = &windows_core::Interface::cast::<ICompositionObject5>(self)?;
        unsafe { (windows_core::Interface::vtable(this).StartAnimationWithController)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), animation.param().abi(), animationcontroller.param().abi()).ok() }
    }
    pub fn Expression(&self) -> windows_core::Result<windows_core::HSTRING> {
        let this = self;
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(this).Expression)(windows_core::Interface::as_raw(this), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub fn SetExpression(&self, value: &windows_core::HSTRING) -> windows_core::Result<()> {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).SetExpression)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(value)).ok() }
    }
}
impl windows_core::RuntimeType for ExpressionAnimation {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_class::<Self, IExpressionAnimation>();
}
unsafe impl windows_core::Interface for ExpressionAnimation {
    type Vtable = <IExpressionAnimation as windows_core::Interface>::Vtable;
    const IID: windows_core::GUID = <IExpressionAnimation as windows_core::Interface>::IID;
}
impl windows_core::RuntimeName for ExpressionAnimation {
    const NAME: &'static str = "Windows.UI.Composition.ExpressionAnimation";
}
unsafe impl Send for ExpressionAnimation {}
unsafe impl Sync for ExpressionAnimation {}
windows_core::imp::define_interface!(IAmbientLight, IAmbientLight_Vtbl, 0xa48130a1_b7c4_46f7_b9bf_daf43a44e6ee);
impl windows_core::RuntimeType for IAmbientLight {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct IAmbientLight_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub Color: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::Color) -> windows_core::HRESULT,
    pub SetColor: unsafe extern "system" fn(*mut core::ffi::c_void, super::Color) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IAmbientLight2, IAmbientLight2_Vtbl, 0x3b64a6bf_5f97_4c94_86e5_042dd386b27d);
impl windows_core::RuntimeType for IAmbientLight2 {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct IAmbientLight2_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub Intensity: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetIntensity: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IAnimationController, IAnimationController_Vtbl, 0xc934efd2_0722_4f5f_a4e2_9510f3d43bf7);
impl windows_core::RuntimeType for IAnimationController {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct IAnimationController_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub PlaybackRate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetPlaybackRate: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub Progress: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetProgress: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub ProgressBehavior: unsafe extern "system" fn(*mut core::ffi::c_void, *mut AnimationControllerProgressBehavior) -> windows_core::HRESULT,
    pub SetProgressBehavior: unsafe extern "system" fn(*mut core::ffi::c_void, AnimationControllerProgressBehavior) -> windows_core::HRESULT,
    pub Pause: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Resume: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IAnimationControllerStatics, IAnimationControllerStatics_Vtbl, 0xe71164df_651b_4800_b9e5_6a3bcfed3365);
impl windows_core::RuntimeType for IAnimationControllerStatics {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct IAnimationControllerStatics_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub MaxPlaybackRate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub MinPlaybackRate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IAnimationObject, IAnimationObject_Vtbl, 0xe7141e0a_04b8_4fc5_a4dc_195392e57807);
impl windows_core::RuntimeType for IAnimationObject {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
windows_core::imp::interface_hierarchy!(IAnimationObject, windows_core::IUnknown, windows_core::IInspectable);
impl IAnimationObject {
    pub fn PopulatePropertyInfo<P1>(&self, propertyname: &windows_core::HSTRING, propertyinfo: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<AnimationPropertyInfo>,
    {
        let this = self;
        unsafe { (windows_core::Interface::vtable(this).PopulatePropertyInfo)(windows_core::Interface::as_raw(this), core::mem::transmute_copy(propertyname), propertyinfo.param().abi()).ok() }
    }
}
impl windows_core::RuntimeName for IAnimationObject {
    const NAME: &'static str = "Windows.UI.Composition.IAnimationObject";
}
pub trait IAnimationObject_Impl: windows_core::IUnknownImpl {
    fn PopulatePropertyInfo(&self, propertyName: &windows_core::HSTRING, propertyInfo: windows_core::Ref<'_, AnimationPropertyInfo>) -> windows_core::Result<()>;
}
impl IAnimationObject_Vtbl {
    pub const fn new<Identity: IAnimationObject_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn PopulatePropertyInfo<Identity: IAnimationObject_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, propertyname: *mut core::ffi::c_void, propertyinfo: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAnimationObject_Impl::PopulatePropertyInfo(this, core::mem::transmute(&propertyname), core::mem::transmute_copy(&propertyinfo)).into()
            }
        }
        Self {
            base__: windows_core::IInspectable_Vtbl::new::<Identity, IAnimationObject, OFFSET>(),
            PopulatePropertyInfo: PopulatePropertyInfo::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAnimationObject as windows_core::Interface>::IID
    }
}
#[repr(C)]
pub struct IAnimationObject_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub PopulatePropertyInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IAnimationPropertyInfo, IAnimationPropertyInfo_Vtbl, 0xf4716f05_ed77_4e3c_b328_5c3985b3738f);
impl windows_core::RuntimeType for IAnimationPropertyInfo {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct IAnimationPropertyInfo_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub AccessMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut AnimationPropertyAccessMode) -> windows_core::HRESULT,
    pub SetAccessMode: unsafe extern "system" fn(*mut core::ffi::c_void, AnimationPropertyAccessMode) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IAnimationPropertyInfo2, IAnimationPropertyInfo2_Vtbl, 0x591720b4_7472_5218_8b39_dffe615ae6da);
impl windows_core::RuntimeType for IAnimationPropertyInfo2 {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct IAnimationPropertyInfo2_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub GetResolvedCompositionObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetResolvedCompositionObjectProperty: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IBackEasingFunction, IBackEasingFunction_Vtbl, 0xb8560da4_5e3c_545d_b263_7987a2bd27cb);
impl windows_core::RuntimeType for IBackEasingFunction {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct IBackEasingFunction_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub Mode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut CompositionEasingFunctionMode) -> windows_core::HRESULT,
    pub Amplitude: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IBooleanKeyFrameAnimation, IBooleanKeyFrameAnimation_Vtbl, 0x95e23a08_d1f4_4972_9770_3efe68d82e14);
impl windows_core::RuntimeType for IBooleanKeyFrameAnimation {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct IBooleanKeyFrameAnimation_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub InsertKeyFrame: unsafe extern "system" fn(*mut core::ffi::c_void, f32, bool) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IBounceEasingFunction, IBounceEasingFunction_Vtbl, 0xe7fdb44b_aad5_5174_9421_eef8b75a6a43);
impl windows_core::RuntimeType for IBounceEasingFunction {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct IBounceEasingFunction_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub Mode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut CompositionEasingFunctionMode) -> windows_core::HRESULT,
    pub Bounces: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub Bounciness: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IBounceScalarNaturalMotionAnimation, IBounceScalarNaturalMotionAnimation_Vtbl, 0xbaa30dcc_a633_4618_9b06_7f7c72c87cff);
impl windows_core::RuntimeType for IBounceScalarNaturalMotionAnimation {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct IBounceScalarNaturalMotionAnimation_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub Acceleration: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetAcceleration: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub Restitution: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetRestitution: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IBounceVector2NaturalMotionAnimation, IBounceVector2NaturalMotionAnimation_Vtbl, 0xda344196_2154_4b3c_88aa_47361204eccd);
impl windows_core::RuntimeType for IBounceVector2NaturalMotionAnimation {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct IBounceVector2NaturalMotionAnimation_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub Acceleration: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetAcceleration: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub Restitution: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetRestitution: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IBounceVector3NaturalMotionAnimation, IBounceVector3NaturalMotionAnimation_Vtbl, 0x47dabc31_10d3_4518_86f1_09caf742d113);
impl windows_core::RuntimeType for IBounceVector3NaturalMotionAnimation {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct IBounceVector3NaturalMotionAnimation_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub Acceleration: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetAcceleration: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub Restitution: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetRestitution: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICircleEasingFunction, ICircleEasingFunction_Vtbl, 0x1e07222a_6f82_5a28_8748_2e92fc46ee2b);
impl windows_core::RuntimeType for ICircleEasingFunction {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICircleEasingFunction_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub Mode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut CompositionEasingFunctionMode) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IColorKeyFrameAnimation, IColorKeyFrameAnimation_Vtbl, 0x93adb5e9_8e05_4593_84a3_dca152781e56);
impl windows_core::RuntimeType for IColorKeyFrameAnimation {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct IColorKeyFrameAnimation_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub InterpolationColorSpace: unsafe extern "system" fn(*mut core::ffi::c_void, *mut CompositionColorSpace) -> windows_core::HRESULT,
    pub SetInterpolationColorSpace: unsafe extern "system" fn(*mut core::ffi::c_void, CompositionColorSpace) -> windows_core::HRESULT,
    pub InsertKeyFrame: unsafe extern "system" fn(*mut core::ffi::c_void, f32, super::Color) -> windows_core::HRESULT,
    pub InsertKeyFrameWithEasingFunction: unsafe extern "system" fn(*mut core::ffi::c_void, f32, super::Color, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionAnimation, ICompositionAnimation_Vtbl, 0x464c4c2c_1caa_4061_9b40_e13fde1503ca);
impl windows_core::RuntimeType for ICompositionAnimation {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionAnimation_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub ClearAllParameters: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ClearParameter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetColorParameter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::Color) -> windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetMatrix3x2Parameter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::Numerics::Matrix3x2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetMatrix3x2Parameter: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetMatrix4x4Parameter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::Numerics::Matrix4x4) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetMatrix4x4Parameter: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetQuaternionParameter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::Numerics::Quaternion) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetQuaternionParameter: usize,
    pub SetReferenceParameter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetScalarParameter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetVector2Parameter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetVector2Parameter: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetVector3Parameter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::Numerics::Vector3) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetVector3Parameter: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetVector4Parameter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::Numerics::Vector4) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetVector4Parameter: usize,
}
windows_core::imp::define_interface!(ICompositionAnimation2, ICompositionAnimation2_Vtbl, 0x369b603e_a80f_4948_93e3_ed23fb38c6cb);
impl windows_core::RuntimeType for ICompositionAnimation2 {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionAnimation2_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub SetBooleanParameter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, bool) -> windows_core::HRESULT,
    pub Target: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetTarget: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionAnimation3, ICompositionAnimation3_Vtbl, 0xd51e030d_7da4_4bd7_bc2d_f4517529f43a);
impl windows_core::RuntimeType for ICompositionAnimation3 {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionAnimation3_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Collections")]
    pub InitialValueExpressions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Collections"))]
    InitialValueExpressions: usize,
}
windows_core::imp::define_interface!(ICompositionAnimation4, ICompositionAnimation4_Vtbl, 0x770137be_76bc_4e23_bfed_fe9cc20f6ec9);
impl windows_core::RuntimeType for ICompositionAnimation4 {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionAnimation4_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub SetExpressionReferenceParameter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionAnimationBase, ICompositionAnimationBase_Vtbl, 0x1c2c2999_e818_48d3_a6dd_d78c82f8ace9);
impl windows_core::RuntimeType for ICompositionAnimationBase {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
windows_core::imp::interface_hierarchy!(ICompositionAnimationBase, windows_core::IUnknown, windows_core::IInspectable);
impl windows_core::RuntimeName for ICompositionAnimationBase {
    const NAME: &'static str = "Windows.UI.Composition.ICompositionAnimationBase";
}
pub trait ICompositionAnimationBase_Impl: windows_core::IUnknownImpl {}
impl ICompositionAnimationBase_Vtbl {
    pub const fn new<Identity: ICompositionAnimationBase_Impl, const OFFSET: isize>() -> Self {
        Self { base__: windows_core::IInspectable_Vtbl::new::<Identity, ICompositionAnimationBase, OFFSET>() }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ICompositionAnimationBase as windows_core::Interface>::IID
    }
}
#[repr(C)]
pub struct ICompositionAnimationBase_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
}
windows_core::imp::define_interface!(ICompositionAnimationFactory, ICompositionAnimationFactory_Vtbl, 0x10f6c4fb_6e51_4c25_bbd3_586a9bec3ef4);
impl windows_core::RuntimeType for ICompositionAnimationFactory {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionAnimationFactory_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
}
windows_core::imp::define_interface!(ICompositionAnimationGroup, ICompositionAnimationGroup_Vtbl, 0x5e7cc90c_cd14_4e07_8a55_c72527aabdac);
impl windows_core::RuntimeType for ICompositionAnimationGroup {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionAnimationGroup_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub Count: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub Add: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Remove: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveAll: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionBackdropBrush, ICompositionBackdropBrush_Vtbl, 0xc5acae58_3898_499e_8d7f_224e91286a5d);
impl windows_core::RuntimeType for ICompositionBackdropBrush {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionBackdropBrush_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
}
windows_core::imp::define_interface!(ICompositionBatchCompletedEventArgs, ICompositionBatchCompletedEventArgs_Vtbl, 0x0d00dad0_9464_450a_a562_2e2698b0a812);
impl windows_core::RuntimeType for ICompositionBatchCompletedEventArgs {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionBatchCompletedEventArgs_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
}
windows_core::imp::define_interface!(ICompositionBrush, ICompositionBrush_Vtbl, 0xab0d7608_30c0_40e9_b568_b60a6bd1fb46);
impl windows_core::RuntimeType for ICompositionBrush {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionBrush_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
}
windows_core::imp::define_interface!(ICompositionBrushFactory, ICompositionBrushFactory_Vtbl, 0xda53fb4c_4650_47c4_ad76_765379607ed6);
impl windows_core::RuntimeType for ICompositionBrushFactory {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionBrushFactory_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
}
windows_core::imp::define_interface!(ICompositionCapabilities, ICompositionCapabilities_Vtbl, 0x8253353e_b517_48bc_b1e8_4b3561a2e181);
impl windows_core::RuntimeType for ICompositionCapabilities {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionCapabilities_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub AreEffectsSupported: unsafe extern "system" fn(*mut core::ffi::c_void, *mut bool) -> windows_core::HRESULT,
    pub AreEffectsFast: unsafe extern "system" fn(*mut core::ffi::c_void, *mut bool) -> windows_core::HRESULT,
    pub Changed: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut i64) -> windows_core::HRESULT,
    pub RemoveChanged: unsafe extern "system" fn(*mut core::ffi::c_void, i64) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionCapabilitiesStatics, ICompositionCapabilitiesStatics_Vtbl, 0xf7b7a86e_6416_49e5_8ddf_afe949e20562);
impl windows_core::RuntimeType for ICompositionCapabilitiesStatics {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionCapabilitiesStatics_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub GetForCurrentView: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionClip, ICompositionClip_Vtbl, 0x1ccd2a52_cfc7_4ace_9983_146bb8eb6a3c);
impl windows_core::RuntimeType for ICompositionClip {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionClip_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
}
windows_core::imp::define_interface!(ICompositionClip2, ICompositionClip2_Vtbl, 0x5893e069_3516_40e1_89e0_5ba924927235);
impl windows_core::RuntimeType for ICompositionClip2 {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionClip2_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub AnchorPoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    AnchorPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetAnchorPoint: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetAnchorPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub CenterPoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    CenterPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetCenterPoint: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetCenterPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub Offset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Offset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetOffset: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetOffset: usize,
    pub RotationAngle: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetRotationAngle: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub RotationAngleInDegrees: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetRotationAngleInDegrees: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub Scale: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Scale: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetScale: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetScale: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub TransformMatrix: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Matrix3x2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TransformMatrix: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetTransformMatrix: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Matrix3x2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetTransformMatrix: usize,
}
windows_core::imp::define_interface!(ICompositionClipFactory, ICompositionClipFactory_Vtbl, 0xb9484caf_20c7_4aed_ac4a_9c78ba1302cf);
impl windows_core::RuntimeType for ICompositionClipFactory {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionClipFactory_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
}
windows_core::imp::define_interface!(ICompositionColorBrush, ICompositionColorBrush_Vtbl, 0x2b264c5e_bf35_4831_8642_cf70c20fff2f);
impl windows_core::RuntimeType for ICompositionColorBrush {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionColorBrush_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub Color: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::Color) -> windows_core::HRESULT,
    pub SetColor: unsafe extern "system" fn(*mut core::ffi::c_void, super::Color) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionColorGradientStop, ICompositionColorGradientStop_Vtbl, 0x6f00ca92_c801_4e41_9a8f_a53e20f57778);
impl windows_core::RuntimeType for ICompositionColorGradientStop {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionColorGradientStop_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub Color: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::Color) -> windows_core::HRESULT,
    pub SetColor: unsafe extern "system" fn(*mut core::ffi::c_void, super::Color) -> windows_core::HRESULT,
    pub Offset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetOffset: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionColorGradientStopCollection, ICompositionColorGradientStopCollection_Vtbl, 0x9f1d20ec_7b04_4b1d_90bc_9fa32c0cfd26);
impl windows_core::RuntimeType for ICompositionColorGradientStopCollection {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionColorGradientStopCollection_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
}
windows_core::imp::define_interface!(ICompositionCommitBatch, ICompositionCommitBatch_Vtbl, 0x0d00dad0_ca07_4400_8c8e_cb5db08559cc);
impl windows_core::RuntimeType for ICompositionCommitBatch {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionCommitBatch_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub IsActive: unsafe extern "system" fn(*mut core::ffi::c_void, *mut bool) -> windows_core::HRESULT,
    pub IsEnded: unsafe extern "system" fn(*mut core::ffi::c_void, *mut bool) -> windows_core::HRESULT,
    pub Completed: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut i64) -> windows_core::HRESULT,
    pub RemoveCompleted: unsafe extern "system" fn(*mut core::ffi::c_void, i64) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionContainerShape, ICompositionContainerShape_Vtbl, 0x4f5e859b_2e5b_44a8_982c_aa0f69c16059);
impl windows_core::RuntimeType for ICompositionContainerShape {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionContainerShape_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Collections")]
    pub Shapes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Collections"))]
    Shapes: usize,
}
windows_core::imp::define_interface!(ICompositionDrawingSurface, ICompositionDrawingSurface_Vtbl, 0xa166c300_fad0_4d11_9e67_e433162ff49e);
impl windows_core::RuntimeType for ICompositionDrawingSurface {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionDrawingSurface_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Graphics_DirectX")]
    pub AlphaMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Graphics::DirectX::DirectXAlphaMode) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics_DirectX"))]
    AlphaMode: usize,
    #[cfg(feature = "Graphics_DirectX")]
    pub PixelFormat: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Graphics::DirectX::DirectXPixelFormat) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics_DirectX"))]
    PixelFormat: usize,
    pub Size: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Size) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionDrawingSurface2, ICompositionDrawingSurface2_Vtbl, 0xfad0e88b_e354_44e8_8e3d_c4880d5a213f);
impl windows_core::RuntimeType for ICompositionDrawingSurface2 {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionDrawingSurface2_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Graphics")]
    pub SizeInt32: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Graphics::SizeInt32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics"))]
    SizeInt32: usize,
    #[cfg(feature = "Graphics")]
    pub Resize: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::SizeInt32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics"))]
    Resize: usize,
    #[cfg(feature = "Graphics")]
    pub Scroll: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::PointInt32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics"))]
    Scroll: usize,
    #[cfg(feature = "Graphics")]
    pub ScrollRect: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::PointInt32, super::super::Graphics::RectInt32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics"))]
    ScrollRect: usize,
    #[cfg(feature = "Graphics")]
    pub ScrollWithClip: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::PointInt32, super::super::Graphics::RectInt32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics"))]
    ScrollWithClip: usize,
    #[cfg(feature = "Graphics")]
    pub ScrollRectWithClip: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::PointInt32, super::super::Graphics::RectInt32, super::super::Graphics::RectInt32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics"))]
    ScrollRectWithClip: usize,
}
windows_core::imp::define_interface!(ICompositionDrawingSurfaceFactory, ICompositionDrawingSurfaceFactory_Vtbl, 0x9497b00a_312d_46b9_9db3_412fd79464c8);
impl windows_core::RuntimeType for ICompositionDrawingSurfaceFactory {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionDrawingSurfaceFactory_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
}
windows_core::imp::define_interface!(ICompositionEasingFunction, ICompositionEasingFunction_Vtbl, 0x5145e356_bf79_4ea8_8cc2_6b5b472e6c9a);
impl windows_core::RuntimeType for ICompositionEasingFunction {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionEasingFunction_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
}
windows_core::imp::define_interface!(ICompositionEasingFunctionFactory, ICompositionEasingFunctionFactory_Vtbl, 0x60840774_3da0_4949_8200_7206c00190a0);
impl windows_core::RuntimeType for ICompositionEasingFunctionFactory {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionEasingFunctionFactory_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
}
windows_core::imp::define_interface!(ICompositionEasingFunctionStatics, ICompositionEasingFunctionStatics_Vtbl, 0x17a766b6_2936_53ea_b5af_c642f4a61083);
impl windows_core::RuntimeType for ICompositionEasingFunctionStatics {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionEasingFunctionStatics_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub CreateCubicBezierEasingFunction: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2, super::super::Foundation::Numerics::Vector2, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    CreateCubicBezierEasingFunction: usize,
    pub CreateLinearEasingFunction: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateStepEasingFunction: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateStepEasingFunctionWithStepCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, i32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateBackEasingFunction: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, CompositionEasingFunctionMode, f32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateBounceEasingFunction: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, CompositionEasingFunctionMode, i32, f32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateCircleEasingFunction: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, CompositionEasingFunctionMode, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateElasticEasingFunction: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, CompositionEasingFunctionMode, i32, f32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateExponentialEasingFunction: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, CompositionEasingFunctionMode, f32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreatePowerEasingFunction: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, CompositionEasingFunctionMode, f32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateSineEasingFunction: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, CompositionEasingFunctionMode, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionEffectBrush, ICompositionEffectBrush_Vtbl, 0xbf7f795e_83cc_44bf_a447_3e3c071789ec);
impl windows_core::RuntimeType for ICompositionEffectBrush {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionEffectBrush_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub GetSourceParameter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetSourceParameter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionEffectFactory, ICompositionEffectFactory_Vtbl, 0xbe5624af_ba7e_4510_9850_41c0b4ff74df);
impl windows_core::RuntimeType for ICompositionEffectFactory {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionEffectFactory_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub CreateBrush: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ExtendedError: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::HRESULT) -> windows_core::HRESULT,
    pub LoadStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut CompositionEffectFactoryLoadStatus) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionEffectSourceParameter, ICompositionEffectSourceParameter_Vtbl, 0x858ab13a_3292_4e4e_b3bb_2b6c6544a6ee);
impl windows_core::RuntimeType for ICompositionEffectSourceParameter {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionEffectSourceParameter_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub Name: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionEffectSourceParameterFactory, ICompositionEffectSourceParameterFactory_Vtbl, 0xb3d9f276_aba3_4724_acf3_d0397464db1c);
impl windows_core::RuntimeType for ICompositionEffectSourceParameterFactory {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionEffectSourceParameterFactory_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Graphics_Effects")]
    pub Create: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics_Effects"))]
    Create: usize,
}
windows_core::imp::define_interface!(ICompositionEllipseGeometry, ICompositionEllipseGeometry_Vtbl, 0x4801f884_f6ad_4b93_afa9_897b64e57b1f);
impl windows_core::RuntimeType for ICompositionEllipseGeometry {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionEllipseGeometry_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub Center: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Center: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetCenter: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetCenter: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub Radius: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Radius: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetRadius: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetRadius: usize,
}
windows_core::imp::define_interface!(ICompositionGeometricClip, ICompositionGeometricClip_Vtbl, 0xc840b581_81c9_4444_a2c1_ccaece3a50e5);
impl windows_core::RuntimeType for ICompositionGeometricClip {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionGeometricClip_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub Geometry: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetGeometry: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ViewBox: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetViewBox: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionGeometry, ICompositionGeometry_Vtbl, 0xe985217c_6a17_4207_abd8_5fd3dd612a9d);
impl windows_core::RuntimeType for ICompositionGeometry {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionGeometry_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub TrimEnd: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetTrimEnd: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub TrimOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetTrimOffset: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub TrimStart: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetTrimStart: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionGeometryFactory, ICompositionGeometryFactory_Vtbl, 0xbffebfe1_8c25_480b_9f56_fed6b288055d);
impl windows_core::RuntimeType for ICompositionGeometryFactory {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionGeometryFactory_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
}
windows_core::imp::define_interface!(ICompositionGradientBrush, ICompositionGradientBrush_Vtbl, 0x1d9709e0_ffc6_4c0e_a9ab_34144d4c9098);
impl windows_core::RuntimeType for ICompositionGradientBrush {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionGradientBrush_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub AnchorPoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    AnchorPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetAnchorPoint: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetAnchorPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub CenterPoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    CenterPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetCenterPoint: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetCenterPoint: usize,
    #[cfg(feature = "Foundation_Collections")]
    pub ColorStops: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Collections"))]
    ColorStops: usize,
    pub ExtendMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut CompositionGradientExtendMode) -> windows_core::HRESULT,
    pub SetExtendMode: unsafe extern "system" fn(*mut core::ffi::c_void, CompositionGradientExtendMode) -> windows_core::HRESULT,
    pub InterpolationSpace: unsafe extern "system" fn(*mut core::ffi::c_void, *mut CompositionColorSpace) -> windows_core::HRESULT,
    pub SetInterpolationSpace: unsafe extern "system" fn(*mut core::ffi::c_void, CompositionColorSpace) -> windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub Offset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Offset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetOffset: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetOffset: usize,
    pub RotationAngle: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetRotationAngle: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub RotationAngleInDegrees: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetRotationAngleInDegrees: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub Scale: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Scale: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetScale: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetScale: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub TransformMatrix: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Matrix3x2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TransformMatrix: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetTransformMatrix: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Matrix3x2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetTransformMatrix: usize,
}
windows_core::imp::define_interface!(ICompositionGradientBrush2, ICompositionGradientBrush2_Vtbl, 0x899dd5a1_b4c7_4b33_a1b6_264addc26d10);
impl windows_core::RuntimeType for ICompositionGradientBrush2 {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionGradientBrush2_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub MappingMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut CompositionMappingMode) -> windows_core::HRESULT,
    pub SetMappingMode: unsafe extern "system" fn(*mut core::ffi::c_void, CompositionMappingMode) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionGradientBrushFactory, ICompositionGradientBrushFactory_Vtbl, 0x56d765d7_f189_48c9_9c8d_94daf1bec010);
impl windows_core::RuntimeType for ICompositionGradientBrushFactory {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionGradientBrushFactory_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
}
windows_core::imp::define_interface!(ICompositionGraphicsDevice, ICompositionGraphicsDevice_Vtbl, 0xfb22c6e1_80a2_4667_9936_dbeaf6eefe95);
impl windows_core::RuntimeType for ICompositionGraphicsDevice {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionGraphicsDevice_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Graphics_DirectX")]
    pub CreateDrawingSurface: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Size, super::super::Graphics::DirectX::DirectXPixelFormat, super::super::Graphics::DirectX::DirectXAlphaMode, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics_DirectX"))]
    CreateDrawingSurface: usize,
    pub RenderingDeviceReplaced: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut i64) -> windows_core::HRESULT,
    pub RemoveRenderingDeviceReplaced: unsafe extern "system" fn(*mut core::ffi::c_void, i64) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionGraphicsDevice2, ICompositionGraphicsDevice2_Vtbl, 0x0fb8bdf6_c0f0_4bcc_9fb8_084982490d7d);
impl windows_core::RuntimeType for ICompositionGraphicsDevice2 {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionGraphicsDevice2_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Graphics_DirectX")]
    pub CreateDrawingSurface2: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::SizeInt32, super::super::Graphics::DirectX::DirectXPixelFormat, super::super::Graphics::DirectX::DirectXAlphaMode, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics_DirectX"))]
    CreateDrawingSurface2: usize,
    #[cfg(feature = "Graphics_DirectX")]
    pub CreateVirtualDrawingSurface: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::SizeInt32, super::super::Graphics::DirectX::DirectXPixelFormat, super::super::Graphics::DirectX::DirectXAlphaMode, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics_DirectX"))]
    CreateVirtualDrawingSurface: usize,
}
windows_core::imp::define_interface!(ICompositionGraphicsDevice3, ICompositionGraphicsDevice3_Vtbl, 0x37f67514_d3ef_49d1_b69d_0d8eabeb3626);
impl windows_core::RuntimeType for ICompositionGraphicsDevice3 {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionGraphicsDevice3_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Graphics_DirectX")]
    pub CreateMipmapSurface: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::SizeInt32, super::super::Graphics::DirectX::DirectXPixelFormat, super::super::Graphics::DirectX::DirectXAlphaMode, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics_DirectX"))]
    CreateMipmapSurface: usize,
    pub Trim: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionGraphicsDevice4, ICompositionGraphicsDevice4_Vtbl, 0x5a73bff9_a97f_4cf5_ba46_98ef358e71b1);
impl windows_core::RuntimeType for ICompositionGraphicsDevice4 {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionGraphicsDevice4_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Graphics_DirectX")]
    pub CaptureAsync: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Graphics::SizeInt32, super::super::Graphics::DirectX::DirectXPixelFormat, super::super::Graphics::DirectX::DirectXAlphaMode, f32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics_DirectX"))]
    CaptureAsync: usize,
}
windows_core::imp::define_interface!(ICompositionLight, ICompositionLight_Vtbl, 0x41a6d7c2_2e5d_4bc1_b09e_8f0a03e3d8d3);
impl windows_core::RuntimeType for ICompositionLight {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionLight_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Collections")]
    pub Targets: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Collections"))]
    Targets: usize,
}
windows_core::imp::define_interface!(ICompositionLight2, ICompositionLight2_Vtbl, 0xa7bcda72_f35d_425d_9b98_23f4205f6669);
impl windows_core::RuntimeType for ICompositionLight2 {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionLight2_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Collections")]
    pub ExclusionsFromTargets: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Collections"))]
    ExclusionsFromTargets: usize,
}
windows_core::imp::define_interface!(ICompositionLight3, ICompositionLight3_Vtbl, 0x4b0b00e4_df07_4959_b7a4_4f7e4233f838);
impl windows_core::RuntimeType for ICompositionLight3 {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionLight3_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub IsEnabled: unsafe extern "system" fn(*mut core::ffi::c_void, *mut bool) -> windows_core::HRESULT,
    pub SetIsEnabled: unsafe extern "system" fn(*mut core::ffi::c_void, bool) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionLightFactory, ICompositionLightFactory_Vtbl, 0x069cf306_da3c_4b44_838a_5e03d51ace55);
impl windows_core::RuntimeType for ICompositionLightFactory {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionLightFactory_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
}
windows_core::imp::define_interface!(ICompositionLineGeometry, ICompositionLineGeometry_Vtbl, 0xdd7615a4_0c9a_4b67_8dce_440a5bf9cdec);
impl windows_core::RuntimeType for ICompositionLineGeometry {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionLineGeometry_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub Start: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Start: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetStart: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetStart: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub End: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    End: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetEnd: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetEnd: usize,
}
windows_core::imp::define_interface!(ICompositionLinearGradientBrush, ICompositionLinearGradientBrush_Vtbl, 0x983bc519_a9db_413c_a2d8_2a9056fc525e);
impl windows_core::RuntimeType for ICompositionLinearGradientBrush {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionLinearGradientBrush_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub EndPoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    EndPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetEndPoint: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetEndPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub StartPoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    StartPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetStartPoint: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetStartPoint: usize,
}
windows_core::imp::define_interface!(ICompositionMaskBrush, ICompositionMaskBrush_Vtbl, 0x522cf09e_be6b_4f41_be49_f9226d471b4a);
impl windows_core::RuntimeType for ICompositionMaskBrush {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionMaskBrush_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub Mask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Source: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetSource: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionMipmapSurface, ICompositionMipmapSurface_Vtbl, 0x4863675c_cf4a_4b1c_9ece_c5ec0c2b2fe6);
impl windows_core::RuntimeType for ICompositionMipmapSurface {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionMipmapSurface_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub LevelCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Graphics_DirectX")]
    pub AlphaMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Graphics::DirectX::DirectXAlphaMode) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics_DirectX"))]
    AlphaMode: usize,
    #[cfg(feature = "Graphics_DirectX")]
    pub PixelFormat: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Graphics::DirectX::DirectXPixelFormat) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics_DirectX"))]
    PixelFormat: usize,
    #[cfg(feature = "Graphics")]
    pub SizeInt32: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Graphics::SizeInt32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics"))]
    SizeInt32: usize,
    pub GetDrawingSurfaceForLevel: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionNineGridBrush, ICompositionNineGridBrush_Vtbl, 0xf25154e4_bc8c_4be7_b80f_8685b83c0186);
impl windows_core::RuntimeType for ICompositionNineGridBrush {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionNineGridBrush_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub BottomInset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetBottomInset: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub BottomInsetScale: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetBottomInsetScale: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub IsCenterHollow: unsafe extern "system" fn(*mut core::ffi::c_void, *mut bool) -> windows_core::HRESULT,
    pub SetIsCenterHollow: unsafe extern "system" fn(*mut core::ffi::c_void, bool) -> windows_core::HRESULT,
    pub LeftInset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetLeftInset: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub LeftInsetScale: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetLeftInsetScale: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub RightInset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetRightInset: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub RightInsetScale: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetRightInsetScale: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub Source: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetSource: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub TopInset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetTopInset: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub TopInsetScale: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetTopInsetScale: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub SetInsets: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub SetInsetsWithValues: unsafe extern "system" fn(*mut core::ffi::c_void, f32, f32, f32, f32) -> windows_core::HRESULT,
    pub SetInsetScales: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub SetInsetScalesWithValues: unsafe extern "system" fn(*mut core::ffi::c_void, f32, f32, f32, f32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionObject, ICompositionObject_Vtbl, 0xbcb4ad45_7609_4550_934f_16002a68fded);
impl windows_core::RuntimeType for ICompositionObject {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionObject_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub Compositor: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "UI_Core")]
    pub Dispatcher: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "UI_Core"))]
    Dispatcher: usize,
    pub Properties: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub StartAnimation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub StopAnimation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionObject2, ICompositionObject2_Vtbl, 0xef874ea1_5cff_4b68_9e30_a1519d08ba03);
impl windows_core::RuntimeType for ICompositionObject2 {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionObject2_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub Comment: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetComment: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Foundation_Collections")]
    pub ImplicitAnimations: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Collections"))]
    ImplicitAnimations: usize,
    #[cfg(feature = "Foundation_Collections")]
    pub SetImplicitAnimations: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Collections"))]
    SetImplicitAnimations: usize,
    pub StartAnimationGroup: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub StopAnimationGroup: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionObject3, ICompositionObject3_Vtbl, 0x4bc27925_dacd_4cf2_98b1_986b76e7ebe6);
impl windows_core::RuntimeType for ICompositionObject3 {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionObject3_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "System")]
    pub DispatcherQueue: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "System"))]
    DispatcherQueue: usize,
}
windows_core::imp::define_interface!(ICompositionObject4, ICompositionObject4_Vtbl, 0x0bb3784c_346b_4a7c_966b_7310966553d5);
impl windows_core::RuntimeType for ICompositionObject4 {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionObject4_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub TryGetAnimationController: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionObject5, ICompositionObject5_Vtbl, 0x1d7f391b_a130_5265_a62b_60b8e668965a);
impl windows_core::RuntimeType for ICompositionObject5 {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionObject5_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub StartAnimationWithController: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionObjectFactory, ICompositionObjectFactory_Vtbl, 0x51205c5e_558a_4f2a_8d39_37bfe1e20ddd);
impl windows_core::RuntimeType for ICompositionObjectFactory {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionObjectFactory_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
}
windows_core::imp::define_interface!(ICompositionObjectStatics, ICompositionObjectStatics_Vtbl, 0xc1ed052f_1ba2_44ba_a904_6a882a0a5adb);
impl windows_core::RuntimeType for ICompositionObjectStatics {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionObjectStatics_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub StartAnimationWithIAnimationObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub StartAnimationGroupWithIAnimationObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionPath, ICompositionPath_Vtbl, 0x66da1d5f_2e10_4f22_8a06_0a8151919e60);
impl windows_core::RuntimeType for ICompositionPath {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionPath_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
}
windows_core::imp::define_interface!(ICompositionPathFactory, ICompositionPathFactory_Vtbl, 0x9c1e8c6a_0f33_4751_9437_eb3fb9d3ab07);
impl windows_core::RuntimeType for ICompositionPathFactory {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionPathFactory_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Graphics")]
    pub Create: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics"))]
    Create: usize,
}
windows_core::imp::define_interface!(ICompositionPathGeometry, ICompositionPathGeometry_Vtbl, 0x0b6a417e_2c77_4c23_af5e_6304c147bb61);
impl windows_core::RuntimeType for ICompositionPathGeometry {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionPathGeometry_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Graphics")]
    pub Path: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics"))]
    Path: usize,
    #[cfg(feature = "Graphics")]
    pub SetPath: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Graphics"))]
    SetPath: usize,
}
windows_core::imp::define_interface!(ICompositionProjectedShadow, ICompositionProjectedShadow_Vtbl, 0x285b8e72_4328_523f_bcf2_5557c52c3b25);
impl windows_core::RuntimeType for ICompositionProjectedShadow {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionProjectedShadow_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub BlurRadiusMultiplier: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetBlurRadiusMultiplier: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    #[cfg(feature = "Foundation_Collections")]
    pub Casters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Collections"))]
    Casters: usize,
    pub LightSource: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetLightSource: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub MaxBlurRadius: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetMaxBlurRadius: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    pub MinBlurRadius: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f32) -> windows_core::HRESULT,
    pub SetMinBlurRadius: unsafe extern "system" fn(*mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    #[cfg(feature = "Foundation_Collections")]
    pub Receivers: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Collections"))]
    Receivers: usize,
}
windows_core::imp::define_interface!(ICompositionProjectedShadowCaster, ICompositionProjectedShadowCaster_Vtbl, 0xb1d7d426_1e36_5a62_be56_a16112fdd148);
impl windows_core::RuntimeType for ICompositionProjectedShadowCaster {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionProjectedShadowCaster_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub Brush: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetBrush: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CastingVisual: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetCastingVisual: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionProjectedShadowCasterCollection, ICompositionProjectedShadowCasterCollection_Vtbl, 0xd2525c0c_e07f_58a3_ac91_37f73ee91740);
impl windows_core::RuntimeType for ICompositionProjectedShadowCasterCollection {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionProjectedShadowCasterCollection_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub Count: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub InsertAbove: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub InsertAtBottom: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub InsertAtTop: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub InsertBelow: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Remove: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveAll: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionProjectedShadowCasterCollectionStatics, ICompositionProjectedShadowCasterCollectionStatics_Vtbl, 0x56fbb136_e94f_5299_ab5b_6e15e38bd899);
impl windows_core::RuntimeType for ICompositionProjectedShadowCasterCollectionStatics {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionProjectedShadowCasterCollectionStatics_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub MaxRespectedCasters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionProjectedShadowReceiver, ICompositionProjectedShadowReceiver_Vtbl, 0x1377985a_6a49_536a_9be4_a96a8e5298a9);
impl windows_core::RuntimeType for ICompositionProjectedShadowReceiver {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionProjectedShadowReceiver_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub ReceivingVisual: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetReceivingVisual: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionProjectedShadowReceiverUnorderedCollection, ICompositionProjectedShadowReceiverUnorderedCollection_Vtbl, 0x02b3e3b7_27d2_599f_ac4b_ab787cdde6fd);
impl windows_core::RuntimeType for ICompositionProjectedShadowReceiverUnorderedCollection {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionProjectedShadowReceiverUnorderedCollection_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub Add: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Count: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub Remove: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveAll: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionPropertySet, ICompositionPropertySet_Vtbl, 0xc9d6d202_5f67_4453_9117_9eadd430d3c2);
impl windows_core::RuntimeType for ICompositionPropertySet {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionPropertySet_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub InsertColor: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::Color) -> windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertMatrix3x2: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::Numerics::Matrix3x2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertMatrix3x2: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertMatrix4x4: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::Numerics::Matrix4x4) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertMatrix4x4: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertQuaternion: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::Numerics::Quaternion) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertQuaternion: usize,
    pub InsertScalar: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, f32) -> windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertVector2: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertVector2: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertVector3: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::Numerics::Vector3) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertVector3: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertVector4: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::Numerics::Vector4) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertVector4: usize,
    pub TryGetColor: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut super::Color, *mut CompositionGetValueStatus) -> windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub TryGetMatrix3x2: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Matrix3x2, *mut CompositionGetValueStatus) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TryGetMatrix3x2: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub TryGetMatrix4x4: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Matrix4x4, *mut CompositionGetValueStatus) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TryGetMatrix4x4: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub TryGetQuaternion: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Quaternion, *mut CompositionGetValueStatus) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TryGetQuaternion: usize,
    pub TryGetScalar: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut f32, *mut CompositionGetValueStatus) -> windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub TryGetVector2: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2, *mut CompositionGetValueStatus) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TryGetVector2: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub TryGetVector3: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector3, *mut CompositionGetValueStatus) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TryGetVector3: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub TryGetVector4: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector4, *mut CompositionGetValueStatus) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TryGetVector4: usize,
}
windows_core::imp::define_interface!(ICompositionPropertySet2, ICompositionPropertySet2_Vtbl, 0xde80731e_a211_4455_8880_7d0f3f6a44fd);
impl windows_core::RuntimeType for ICompositionPropertySet2 {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionPropertySet2_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub InsertBoolean: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, bool) -> windows_core::HRESULT,
    pub TryGetBoolean: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut bool, *mut CompositionGetValueStatus) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICompositionRadialGradientBrush, ICompositionRadialGradientBrush_Vtbl, 0x3d3b50c5_e3fa_4ce2_b9fc_3ee12561788f);
impl windows_core::RuntimeType for ICompositionRadialGradientBrush {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionRadialGradientBrush_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub EllipseCenter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    EllipseCenter: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetEllipseCenter: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetEllipseCenter: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub EllipseRadius: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    EllipseRadius: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetEllipseRadius: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetEllipseRadius: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub GradientOriginOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    GradientOriginOffset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetGradientOriginOffset: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetGradientOriginOffset: usize,
}
windows_core::imp::define_interface!(ICompositionRectangleGeometry, ICompositionRectangleGeometry_Vtbl, 0x0cd51428_5356_4246_aecf_7a0b76975400);
impl windows_core::RuntimeType for ICompositionRectangleGeometry {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionRectangleGeometry_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub Offset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Offset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetOffset: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetOffset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub Size: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Size: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetSize: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetSize: usize,
}
windows_core::imp::define_interface!(ICompositionRoundedRectangleGeometry, ICompositionRoundedRectangleGeometry_Vtbl, 0x8770c822_1d50_4b8b_b013_7c9a0e46935f);
impl windows_core::RuntimeType for ICompositionRoundedRectangleGeometry {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionRoundedRectangleGeometry_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub CornerRadius: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    CornerRadius: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetCornerRadius: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetCornerRadius: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub Offset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Offset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetOffset: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetOffset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub Size: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Size: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetSize: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::Numerics::Vector2) -> windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetSize: usize,
}
windows_core::imp::define_interface!(ICompositionScopedBatch, ICompositionScopedBatch_Vtbl, 0x0d00dad0_fb07_46fd_8c72_6280d1a3d1dd);
impl windows_core::RuntimeType for ICompositionScopedBatch {
    const SIGNATURE: windows_core::imp::ConstBuffer = windows_core::imp::ConstBuffer::for_interface::<Self>();
}
#[repr(C)]
pub struct ICompositionScopedBatch_Vtbl {
    pub base__: windows_core::IInspectable_Vtbl,
    pub IsActive: unsafe extern "system" fn(*mut core::ffi::c_void, *mut bool) -> windows_core::HRESULT,
    pub IsEnded: unsafe extern "system" fn(*mut core::ffi::c_void, *mut bool) -> windows_core::HRESULT,
    pub End: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Resume: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Suspend: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Completed: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut i64) -> windows_core::HRESULT,
    pub RemoveC