# Stefan Achatz 2012
#
# Tries to find libgudev and sets following variables according to found capabilities:
#
# GUDEV_FOUND
# GUDEV_INCLUDE_DIRS
# GUDEV_LIBRARIES

FIND_PACKAGE(PkgConfig)
PKG_CHECK_MODULES(PKG_GUDEV gudev-1.0)

FIND_PATH(GUDEV_INCLUDE_DIRS gudev/gudev.h
  HINTS
    ${PKG_GUDEV_INCLUDE_DIRS}
    ${PKG_GUDEV_INCLUDEDIR}
  PATH_SUFFIXES gudev-1.0
)

FIND_LIBRARY(GUDEV_LIBRARIES gudev-1.0
  HINTS ${PKG_GUDEV_LIBRARY_DIRS}
)

IF(GUDEV_LIBRARIES AND GUDEV_INCLUDE_DIRS)
  SET(GUDEV_FOUND true)
ENDIF()

IF(GUDEV_FIND_REQUIRED AND NOT GUDEV_FOUND)
  MESSAGE(FATAL_ERROR "Could not find GUDEV")
ENDIF()
