/*
 * This file is part of roccat-tools.
 *
 * roccat-tools is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * roccat-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with roccat-tools. If not, see <http://www.gnu.org/licenses/>.
 */

#include "roccat_swarm_color_selection_button.h"
#include "gdk_roccat_helper.h"
#include "i18n-lib.h"

enum {
	ROCCAT_SWARM_COLORS_PER_ROW = 10,
};

static GdkColor const colors[ROCCAT_SWARM_COLORS_NUM] = {
	{0, 179 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0, 255 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0, 255 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,  41 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0, 254 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,  99 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0, 252 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 160 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0, 235 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 254 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0, 230 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 255 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0, 178 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 255 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0, 135 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 255 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0,  88 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 255 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 255 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 231 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 185 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 226 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 116 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 221 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 155 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 207 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 211 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0,  77 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 184 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 255 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0,  78 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 142 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 243 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0, 120 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 131 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 249 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0,  86 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,  91 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 244 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0,  98 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 255 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0, 103 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 255 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0,  76 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 198 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0, 132 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 255 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0, 153 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 255 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0, 185 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 255 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0, 185 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 241 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0, 196 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 225 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0, 218 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 225 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
	{0, 221 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR,   0 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR, 121 * GDK_ROCCAT_BYTE_TO_COLOR_FACTOR},
};

G_DEFINE_TYPE(RoccatSwarmColorSelectionButton, roccat_swarm_color_selection_button, ROCCAT_COLOR_SELECTION_BUTTON_TYPE);

GtkWidget *roccat_swarm_color_selection_button_new(void) {
	return GTK_WIDGET(g_object_new(ROCCAT_SWARM_COLOR_SELECTION_BUTTON_TYPE, NULL));
}

static void roccat_swarm_color_selection_button_init(RoccatSwarmColorSelectionButton *swarm_button) {
	RoccatColorSelectionButton *button = ROCCAT_COLOR_SELECTION_BUTTON(swarm_button);
	roccat_color_selection_button_set_view_type(button, ROCCAT_COLOR_SELECTION_DIALOG_TYPE_BOTH);
	roccat_color_selection_button_set_palette_dimensions(button, ROCCAT_SWARM_COLORS_NUM, ROCCAT_SWARM_COLORS_PER_ROW);
	roccat_color_selection_button_set_palette_colors(button, colors, ROCCAT_SWARM_COLORS_NUM);
}

static void roccat_swarm_color_selection_button_class_init(RoccatSwarmColorSelectionButtonClass *klass) {
}
