// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: opentelemetry/proto/profiles/v1experimental/pprofextended.proto

package v1experimental

import (
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"

	go_opentelemetry_io_collector_pdata_internal_data "go.opentelemetry.io/collector/pdata/internal/data"
	v1 "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Specifies the method of aggregating metric values, either DELTA (change since last report)
// or CUMULATIVE (total since a fixed start time).
type AggregationTemporality int32

const (
	// UNSPECIFIED is the default AggregationTemporality, it MUST not be used.
	AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED AggregationTemporality = 0
	//* DELTA is an AggregationTemporality for a profiler which reports
	//changes since last report time. Successive metrics contain aggregation of
	//values from continuous and non-overlapping intervals.
	//
	//The values for a DELTA metric are based only on the time interval
	//associated with one measurement cycle. There is no dependency on
	//previous measurements like is the case for CUMULATIVE metrics.
	//
	//For example, consider a system measuring the number of requests that
	//it receives and reports the sum of these requests every second as a
	//DELTA metric:
	//
	//1. The system starts receiving at time=t_0.
	//2. A request is received, the system measures 1 request.
	//3. A request is received, the system measures 1 request.
	//4. A request is received, the system measures 1 request.
	//5. The 1 second collection cycle ends. A metric is exported for the
	//number of requests received over the interval of time t_0 to
	//t_0+1 with a value of 3.
	//6. A request is received, the system measures 1 request.
	//7. A request is received, the system measures 1 request.
	//8. The 1 second collection cycle ends. A metric is exported for the
	//number of requests received over the interval of time t_0+1 to
	//t_0+2 with a value of 2.
	AggregationTemporality_AGGREGATION_TEMPORALITY_DELTA AggregationTemporality = 1
	//* CUMULATIVE is an AggregationTemporality for a profiler which
	//reports changes since a fixed start time. This means that current values
	//of a CUMULATIVE metric depend on all previous measurements since the
	//start time. Because of this, the sender is required to retain this state
	//in some form. If this state is lost or invalidated, the CUMULATIVE metric
	//values MUST be reset and a new fixed start time following the last
	//reported measurement time sent MUST be used.
	//
	//For example, consider a system measuring the number of requests that
	//it receives and reports the sum of these requests every second as a
	//CUMULATIVE metric:
	//
	//1. The system starts receiving at time=t_0.
	//2. A request is received, the system measures 1 request.
	//3. A request is received, the system measures 1 request.
	//4. A request is received, the system measures 1 request.
	//5. The 1 second collection cycle ends. A metric is exported for the
	//number of requests received over the interval of time t_0 to
	//t_0+1 with a value of 3.
	//6. A request is received, the system measures 1 request.
	//7. A request is received, the system measures 1 request.
	//8. The 1 second collection cycle ends. A metric is exported for the
	//number of requests received over the interval of time t_0 to
	//t_0+2 with a value of 5.
	//9. The system experiences a fault and loses state.
	//10. The system recovers and resumes receiving at time=t_1.
	//11. A request is received, the system measures 1 request.
	//12. The 1 second collection cycle ends. A metric is exported for the
	//number of requests received over the interval of time t_1 to
	//t_0+1 with a value of 1.
	//
	//Note: Even though, when reporting changes since last report time, using
	//CUMULATIVE is valid, it is not recommended.
	AggregationTemporality_AGGREGATION_TEMPORALITY_CUMULATIVE AggregationTemporality = 2
)

var AggregationTemporality_name = map[int32]string{
	0: "AGGREGATION_TEMPORALITY_UNSPECIFIED",
	1: "AGGREGATION_TEMPORALITY_DELTA",
	2: "AGGREGATION_TEMPORALITY_CUMULATIVE",
}

var AggregationTemporality_value = map[string]int32{
	"AGGREGATION_TEMPORALITY_UNSPECIFIED": 0,
	"AGGREGATION_TEMPORALITY_DELTA":       1,
	"AGGREGATION_TEMPORALITY_CUMULATIVE":  2,
}

func (x AggregationTemporality) String() string {
	return proto.EnumName(AggregationTemporality_name, int32(x))
}

func (AggregationTemporality) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_05f9ce3fdbeb046f, []int{0}
}

// Indicates the semantics of the build_id field.
type BuildIdKind int32

const (
	// Linker-generated build ID, stored in the ELF binary notes.
	BuildIdKind_BUILD_ID_LINKER BuildIdKind = 0
	// Build ID based on the content hash of the binary. Currently no particular
	// hashing approach is standardized, so a given producer needs to define it
	// themselves and thus unlike BUILD_ID_LINKER this kind of hash is producer-specific.
	// We may choose to provide a standardized stable hash recommendation later.
	BuildIdKind_BUILD_ID_BINARY_HASH BuildIdKind = 1
)

var BuildIdKind_name = map[int32]string{
	0: "BUILD_ID_LINKER",
	1: "BUILD_ID_BINARY_HASH",
}

var BuildIdKind_value = map[string]int32{
	"BUILD_ID_LINKER":      0,
	"BUILD_ID_BINARY_HASH": 1,
}

func (x BuildIdKind) String() string {
	return proto.EnumName(BuildIdKind_name, int32(x))
}

func (BuildIdKind) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_05f9ce3fdbeb046f, []int{1}
}

// Represents a complete profile, including sample types, samples,
// mappings to binaries, locations, functions, string table, and additional metadata.
type Profile struct {
	// A description of the samples associated with each Sample.value.
	// For a cpu profile this might be:
	//   [["cpu","nanoseconds"]] or [["wall","seconds"]] or [["syscall","count"]]
	// For a heap profile, this might be:
	//   [["allocations","count"], ["space","bytes"]],
	// If one of the values represents the number of events represented
	// by the sample, by convention it should be at index 0 and use
	// sample_type.unit == "count".
	SampleType []ValueType `protobuf:"bytes,1,rep,name=sample_type,json=sampleType,proto3" json:"sample_type"`
	// The set of samples recorded in this profile.
	Sample []Sample `protobuf:"bytes,2,rep,name=sample,proto3" json:"sample"`
	// Mapping from address ranges to the image/binary/library mapped
	// into that address range.  mapping[0] will be the main binary.
	Mapping []Mapping `protobuf:"bytes,3,rep,name=mapping,proto3" json:"mapping"`
	// Locations referenced by samples via location_indices.
	Location []Location `protobuf:"bytes,4,rep,name=location,proto3" json:"location"`
	// Array of locations referenced by samples.
	LocationIndices []int64 `protobuf:"varint,15,rep,packed,name=location_indices,json=locationIndices,proto3" json:"location_indices,omitempty"`
	// Functions referenced by locations.
	Function []Function `protobuf:"bytes,5,rep,name=function,proto3" json:"function"`
	// Lookup table for attributes.
	AttributeTable []v1.KeyValue `protobuf:"bytes,16,rep,name=attribute_table,json=attributeTable,proto3" json:"attribute_table"`
	// Represents a mapping between Attribute Keys and Units.
	AttributeUnits []AttributeUnit `protobuf:"bytes,17,rep,name=attribute_units,json=attributeUnits,proto3" json:"attribute_units"`
	// Lookup table for links.
	LinkTable []Link `protobuf:"bytes,18,rep,name=link_table,json=linkTable,proto3" json:"link_table"`
	// A common table for strings referenced by various messages.
	// string_table[0] must always be "".
	StringTable []string `protobuf:"bytes,6,rep,name=string_table,json=stringTable,proto3" json:"string_table,omitempty"`
	// frames with Function.function_name fully matching the following
	// regexp will be dropped from the samples, along with their successors.
	DropFrames int64 `protobuf:"varint,7,opt,name=drop_frames,json=dropFrames,proto3" json:"drop_frames,omitempty"`
	// frames with Function.function_name fully matching the following
	// regexp will be kept, even if it matches drop_frames.
	KeepFrames int64 `protobuf:"varint,8,opt,name=keep_frames,json=keepFrames,proto3" json:"keep_frames,omitempty"`
	// Time of collection (UTC) represented as nanoseconds past the epoch.
	TimeNanos int64 `protobuf:"varint,9,opt,name=time_nanos,json=timeNanos,proto3" json:"time_nanos,omitempty"`
	// Duration of the profile, if a duration makes sense.
	DurationNanos int64 `protobuf:"varint,10,opt,name=duration_nanos,json=durationNanos,proto3" json:"duration_nanos,omitempty"`
	// The kind of events between sampled occurrences.
	// e.g [ "cpu","cycles" ] or [ "heap","bytes" ]
	PeriodType ValueType `protobuf:"bytes,11,opt,name=period_type,json=periodType,proto3" json:"period_type"`
	// The number of events between sampled occurrences.
	Period int64 `protobuf:"varint,12,opt,name=period,proto3" json:"period,omitempty"`
	// Free-form text associated with the profile. The text is displayed as is
	// to the user by the tools that read profiles (e.g. by pprof). This field
	// should not be used to store any machine-readable information, it is only
	// for human-friendly content. The profile must stay functional if this field
	// is cleaned.
	Comment []int64 `protobuf:"varint,13,rep,packed,name=comment,proto3" json:"comment,omitempty"`
	// Index into the string table of the type of the preferred sample
	// value. If unset, clients should default to the last sample value.
	DefaultSampleType int64 `protobuf:"varint,14,opt,name=default_sample_type,json=defaultSampleType,proto3" json:"default_sample_type,omitempty"`
}

func (m *Profile) Reset()         { *m = Profile{} }
func (m *Profile) String() string { return proto.CompactTextString(m) }
func (*Profile) ProtoMessage()    {}
func (*Profile) Descriptor() ([]byte, []int) {
	return fileDescriptor_05f9ce3fdbeb046f, []int{0}
}
func (m *Profile) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Profile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Profile.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Profile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Profile.Merge(m, src)
}
func (m *Profile) XXX_Size() int {
	return m.Size()
}
func (m *Profile) XXX_DiscardUnknown() {
	xxx_messageInfo_Profile.DiscardUnknown(m)
}

var xxx_messageInfo_Profile proto.InternalMessageInfo

func (m *Profile) GetSampleType() []ValueType {
	if m != nil {
		return m.SampleType
	}
	return nil
}

func (m *Profile) GetSample() []Sample {
	if m != nil {
		return m.Sample
	}
	return nil
}

func (m *Profile) GetMapping() []Mapping {
	if m != nil {
		return m.Mapping
	}
	return nil
}

func (m *Profile) GetLocation() []Location {
	if m != nil {
		return m.Location
	}
	return nil
}

func (m *Profile) GetLocationIndices() []int64 {
	if m != nil {
		return m.LocationIndices
	}
	return nil
}

func (m *Profile) GetFunction() []Function {
	if m != nil {
		return m.Function
	}
	return nil
}

func (m *Profile) GetAttributeTable() []v1.KeyValue {
	if m != nil {
		return m.AttributeTable
	}
	return nil
}

func (m *Profile) GetAttributeUnits() []AttributeUnit {
	if m != nil {
		return m.AttributeUnits
	}
	return nil
}

func (m *Profile) GetLinkTable() []Link {
	if m != nil {
		return m.LinkTable
	}
	return nil
}

func (m *Profile) GetStringTable() []string {
	if m != nil {
		return m.StringTable
	}
	return nil
}

func (m *Profile) GetDropFrames() int64 {
	if m != nil {
		return m.DropFrames
	}
	return 0
}

func (m *Profile) GetKeepFrames() int64 {
	if m != nil {
		return m.KeepFrames
	}
	return 0
}

func (m *Profile) GetTimeNanos() int64 {
	if m != nil {
		return m.TimeNanos
	}
	return 0
}

func (m *Profile) GetDurationNanos() int64 {
	if m != nil {
		return m.DurationNanos
	}
	return 0
}

func (m *Profile) GetPeriodType() ValueType {
	if m != nil {
		return m.PeriodType
	}
	return ValueType{}
}

func (m *Profile) GetPeriod() int64 {
	if m != nil {
		return m.Period
	}
	return 0
}

func (m *Profile) GetComment() []int64 {
	if m != nil {
		return m.Comment
	}
	return nil
}

func (m *Profile) GetDefaultSampleType() int64 {
	if m != nil {
		return m.DefaultSampleType
	}
	return 0
}

// Represents a mapping between Attribute Keys and Units.
type AttributeUnit struct {
	// Index into string table.
	AttributeKey int64 `protobuf:"varint,1,opt,name=attribute_key,json=attributeKey,proto3" json:"attribute_key,omitempty"`
	// Index into string table.
	Unit int64 `protobuf:"varint,2,opt,name=unit,proto3" json:"unit,omitempty"`
}

func (m *AttributeUnit) Reset()         { *m = AttributeUnit{} }
func (m *AttributeUnit) String() string { return proto.CompactTextString(m) }
func (*AttributeUnit) ProtoMessage()    {}
func (*AttributeUnit) Descriptor() ([]byte, []int) {
	return fileDescriptor_05f9ce3fdbeb046f, []int{1}
}
func (m *AttributeUnit) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AttributeUnit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AttributeUnit.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AttributeUnit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttributeUnit.Merge(m, src)
}
func (m *AttributeUnit) XXX_Size() int {
	return m.Size()
}
func (m *AttributeUnit) XXX_DiscardUnknown() {
	xxx_messageInfo_AttributeUnit.DiscardUnknown(m)
}

var xxx_messageInfo_AttributeUnit proto.InternalMessageInfo

func (m *AttributeUnit) GetAttributeKey() int64 {
	if m != nil {
		return m.AttributeKey
	}
	return 0
}

func (m *AttributeUnit) GetUnit() int64 {
	if m != nil {
		return m.Unit
	}
	return 0
}

// A pointer from a profile Sample to a trace Span.
// Connects a profile sample to a trace span, identified by unique trace and span IDs.
type Link struct {
	// A unique identifier of a trace that this linked span is part of. The ID is a
	// 16-byte array.
	TraceId go_opentelemetry_io_collector_pdata_internal_data.TraceID `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3,customtype=go.opentelemetry.io/collector/pdata/internal/data.TraceID" json:"trace_id"`
	// A unique identifier for the linked span. The ID is an 8-byte array.
	SpanId go_opentelemetry_io_collector_pdata_internal_data.SpanID `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3,customtype=go.opentelemetry.io/collector/pdata/internal/data.SpanID" json:"span_id"`
}

func (m *Link) Reset()         { *m = Link{} }
func (m *Link) String() string { return proto.CompactTextString(m) }
func (*Link) ProtoMessage()    {}
func (*Link) Descriptor() ([]byte, []int) {
	return fileDescriptor_05f9ce3fdbeb046f, []int{2}
}
func (m *Link) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Link) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Link.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Link) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Link.Merge(m, src)
}
func (m *Link) XXX_Size() int {
	return m.Size()
}
func (m *Link) XXX_DiscardUnknown() {
	xxx_messageInfo_Link.DiscardUnknown(m)
}

var xxx_messageInfo_Link proto.InternalMessageInfo

// ValueType describes the type and units of a value, with an optional aggregation temporality.
type ValueType struct {
	Type                   int64                  `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	Unit                   int64                  `protobuf:"varint,2,opt,name=unit,proto3" json:"unit,omitempty"`
	AggregationTemporality AggregationTemporality `protobuf:"varint,3,opt,name=aggregation_temporality,json=aggregationTemporality,proto3,enum=opentelemetry.proto.profiles.v1experimental.AggregationTemporality" json:"aggregation_temporality,omitempty"`
}

func (m *ValueType) Reset()         { *m = ValueType{} }
func (m *ValueType) String() string { return proto.CompactTextString(m) }
func (*ValueType) ProtoMessage()    {}
func (*ValueType) Descriptor() ([]byte, []int) {
	return fileDescriptor_05f9ce3fdbeb046f, []int{3}
}
func (m *ValueType) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ValueType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ValueType.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ValueType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValueType.Merge(m, src)
}
func (m *ValueType) XXX_Size() int {
	return m.Size()
}
func (m *ValueType) XXX_DiscardUnknown() {
	xxx_messageInfo_ValueType.DiscardUnknown(m)
}

var xxx_messageInfo_ValueType proto.InternalMessageInfo

func (m *ValueType) GetType() int64 {
	if m != nil {
		return m.Type
	}
	return 0
}

func (m *ValueType) GetUnit() int64 {
	if m != nil {
		return m.Unit
	}
	return 0
}

func (m *ValueType) GetAggregationTemporality() AggregationTemporality {
	if m != nil {
		return m.AggregationTemporality
	}
	return AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED
}

// Each Sample records values encountered in some program
// context. The program context is typically a stack trace, perhaps
// augmented with auxiliary information like the thread-id, some
// indicator of a higher level request being handled etc.
type Sample struct {
	// The indices recorded here correspond to locations in Profile.location.
	// The leaf is at location_index[0]. [deprecated, superseded by locations_start_index / locations_length]
	LocationIndex []uint64 `protobuf:"varint,1,rep,packed,name=location_index,json=locationIndex,proto3" json:"location_index,omitempty"`
	// locations_start_index along with locations_length refers to to a slice of locations in Profile.location.
	// Supersedes location_index.
	LocationsStartIndex uint64 `protobuf:"varint,7,opt,name=locations_start_index,json=locationsStartIndex,proto3" json:"locations_start_index,omitempty"`
	// locations_length along with locations_start_index refers to a slice of locations in Profile.location.
	// Supersedes location_index.
	LocationsLength uint64 `protobuf:"varint,8,opt,name=locations_length,json=locationsLength,proto3" json:"locations_length,omitempty"`
	// A 128bit id that uniquely identifies this stacktrace, globally. Index into string table. [optional]
	StacktraceIdIndex uint32 `protobuf:"varint,9,opt,name=stacktrace_id_index,json=stacktraceIdIndex,proto3" json:"stacktrace_id_index,omitempty"`
	// The type and unit of each value is defined by the corresponding
	// entry in Profile.sample_type. All samples must have the same
	// number of values, the same as the length of Profile.sample_type.
	// When aggregating multiple samples into a single sample, the
	// result has a list of values that is the element-wise sum of the
	// lists of the originals.
	Value []int64 `protobuf:"varint,2,rep,packed,name=value,proto3" json:"value,omitempty"`
	// label includes additional context for this sample. It can include
	// things like a thread id, allocation size, etc.
	//
	// NOTE: While possible, having multiple values for the same label key is
	// strongly discouraged and should never be used. Most tools (e.g. pprof) do
	// not have good (or any) support for multi-value labels. And an even more
	// discouraged case is having a string label and a numeric label of the same
	// name on a sample.  Again, possible to express, but should not be used.
	// [deprecated, superseded by attributes]
	Label []Label `protobuf:"bytes,3,rep,name=label,proto3" json:"label"`
	// References to attributes in Profile.attribute_table. [optional]
	Attributes []uint64 `protobuf:"varint,10,rep,packed,name=attributes,proto3" json:"attributes,omitempty"`
	// Reference to link in Profile.link_table. [optional]
	Link uint64 `protobuf:"varint,12,opt,name=link,proto3" json:"link,omitempty"`
	// Timestamps associated with Sample represented in nanoseconds. These timestamps are expected
	// to fall within the Profile's time range. [optional]
	TimestampsUnixNano []uint64 `protobuf:"varint,13,rep,packed,name=timestamps_unix_nano,json=timestampsUnixNano,proto3" json:"timestamps_unix_nano,omitempty"`
}

func (m *Sample) Reset()         { *m = Sample{} }
func (m *Sample) String() string { return proto.CompactTextString(m) }
func (*Sample) ProtoMessage()    {}
func (*Sample) Descriptor() ([]byte, []int) {
	return fileDescriptor_05f9ce3fdbeb046f, []int{4}
}
func (m *Sample) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Sample) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Sample.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Sample) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Sample.Merge(m, src)
}
func (m *Sample) XXX_Size() int {
	return m.Size()
}
func (m *Sample) XXX_DiscardUnknown() {
	xxx_messageInfo_Sample.DiscardUnknown(m)
}

var xxx_messageInfo_Sample proto.InternalMessageInfo

func (m *Sample) GetLocationIndex() []uint64 {
	if m != nil {
		return m.LocationIndex
	}
	return nil
}

func (m *Sample) GetLocationsStartIndex() uint64 {
	if m != nil {
		return m.LocationsStartIndex
	}
	return 0
}

func (m *Sample) GetLocationsLength() uint64 {
	if m != nil {
		return m.LocationsLength
	}
	return 0
}

func (m *Sample) GetStacktraceIdIndex() uint32 {
	if m != nil {
		return m.StacktraceIdIndex
	}
	return 0
}

func (m *Sample) GetValue() []int64 {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Sample) GetLabel() []Label {
	if m != nil {
		return m.Label
	}
	return nil
}

func (m *Sample) GetAttributes() []uint64 {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Sample) GetLink() uint64 {
	if m != nil {
		return m.Link
	}
	return 0
}

func (m *Sample) GetTimestampsUnixNano() []uint64 {
	if m != nil {
		return m.TimestampsUnixNano
	}
	return nil
}

// Provides additional context for a sample,
// such as thread ID or allocation size, with optional units. [deprecated]
type Label struct {
	Key int64 `protobuf:"varint,1,opt,name=key,proto3" json:"key,omitempty"`
	// At most one of the following must be present
	Str int64 `protobuf:"varint,2,opt,name=str,proto3" json:"str,omitempty"`
	Num int64 `protobuf:"varint,3,opt,name=num,proto3" json:"num,omitempty"`
	// Should only be present when num is present.
	// Specifies the units of num.
	// Use arbitrary string (for example, "requests") as a custom count unit.
	// If no unit is specified, consumer may apply heuristic to deduce the unit.
	// Consumers may also  interpret units like "bytes" and "kilobytes" as memory
	// units and units like "seconds" and "nanoseconds" as time units,
	// and apply appropriate unit conversions to these.
	NumUnit int64 `protobuf:"varint,4,opt,name=num_unit,json=numUnit,proto3" json:"num_unit,omitempty"`
}

func (m *Label) Reset()         { *m = Label{} }
func (m *Label) String() string { return proto.CompactTextString(m) }
func (*Label) ProtoMessage()    {}
func (*Label) Descriptor() ([]byte, []int) {
	return fileDescriptor_05f9ce3fdbeb046f, []int{5}
}
func (m *Label) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Label) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Label.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Label) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Label.Merge(m, src)
}
func (m *Label) XXX_Size() int {
	return m.Size()
}
func (m *Label) XXX_DiscardUnknown() {
	xxx_messageInfo_Label.DiscardUnknown(m)
}

var xxx_messageInfo_Label proto.InternalMessageInfo

func (m *Label) GetKey() int64 {
	if m != nil {
		return m.Key
	}
	return 0
}

func (m *Label) GetStr() int64 {
	if m != nil {
		return m.Str
	}
	return 0
}

func (m *Label) GetNum() int64 {
	if m != nil {
		return m.Num
	}
	return 0
}

func (m *Label) GetNumUnit() int64 {
	if m != nil {
		return m.NumUnit
	}
	return 0
}

// Describes the mapping of a binary in memory, including its address range,
// file offset, and metadata like build ID
type Mapping struct {
	// Unique nonzero id for the mapping. [deprecated]
	Id uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Address at which the binary (or DLL) is loaded into memory.
	MemoryStart uint64 `protobuf:"varint,2,opt,name=memory_start,json=memoryStart,proto3" json:"memory_start,omitempty"`
	// The limit of the address range occupied by this mapping.
	MemoryLimit uint64 `protobuf:"varint,3,opt,name=memory_limit,json=memoryLimit,proto3" json:"memory_limit,omitempty"`
	// Offset in the binary that corresponds to the first mapped address.
	FileOffset uint64 `protobuf:"varint,4,opt,name=file_offset,json=fileOffset,proto3" json:"file_offset,omitempty"`
	// The object this entry is loaded from.  This can be a filename on
	// disk for the main binary and shared libraries, or virtual
	// abstractions like "[vdso]".
	Filename int64 `protobuf:"varint,5,opt,name=filename,proto3" json:"filename,omitempty"`
	// A string that uniquely identifies a particular program version
	// with high probability. E.g., for binaries generated by GNU tools,
	// it could be the contents of the .note.gnu.build-id field.
	BuildId int64 `protobuf:"varint,6,opt,name=build_id,json=buildId,proto3" json:"build_id,omitempty"`
	// Specifies the kind of build id. See BuildIdKind enum for more details [optional]
	BuildIdKind BuildIdKind `protobuf:"varint,11,opt,name=build_id_kind,json=buildIdKind,proto3,enum=opentelemetry.proto.profiles.v1experimental.BuildIdKind" json:"build_id_kind,omitempty"`
	// References to attributes in Profile.attribute_table. [optional]
	Attributes []uint64 `protobuf:"varint,12,rep,packed,name=attributes,proto3" json:"attributes,omitempty"`
	// The following fields indicate the resolution of symbolic info.
	HasFunctions    bool `protobuf:"varint,7,opt,name=has_functions,json=hasFunctions,proto3" json:"has_functions,omitempty"`
	HasFilenames    bool `protobuf:"varint,8,opt,name=has_filenames,json=hasFilenames,proto3" json:"has_filenames,omitempty"`
	HasLineNumbers  bool `protobuf:"varint,9,opt,name=has_line_numbers,json=hasLineNumbers,proto3" json:"has_line_numbers,omitempty"`
	HasInlineFrames bool `protobuf:"varint,10,opt,name=has_inline_frames,json=hasInlineFrames,proto3" json:"has_inline_frames,omitempty"`
}

func (m *Mapping) Reset()         { *m = Mapping{} }
func (m *Mapping) String() string { return proto.CompactTextString(m) }
func (*Mapping) ProtoMessage()    {}
func (*Mapping) Descriptor() ([]byte, []int) {
	return fileDescriptor_05f9ce3fdbeb046f, []int{6}
}
func (m *Mapping) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Mapping) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Mapping.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Mapping) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mapping.Merge(m, src)
}
func (m *Mapping) XXX_Size() int {
	return m.Size()
}
func (m *Mapping) XXX_DiscardUnknown() {
	xxx_messageInfo_Mapping.DiscardUnknown(m)
}

var xxx_messageInfo_Mapping proto.InternalMessageInfo

func (m *Mapping) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Mapping) GetMemoryStart() uint64 {
	if m != nil {
		return m.MemoryStart
	}
	return 0
}

func (m *Mapping) GetMemoryLimit() uint64 {
	if m != nil {
		return m.MemoryLimit
	}
	return 0
}

func (m *Mapping) GetFileOffset() uint64 {
	if m != nil {
		return m.FileOffset
	}
	return 0
}

func (m *Mapping) GetFilename() int64 {
	if m != nil {
		return m.Filename
	}
	return 0
}

func (m *Mapping) GetBuildId() int64 {
	if m != nil {
		return m.BuildId
	}
	return 0
}

func (m *Mapping) GetBuildIdKind() BuildIdKind {
	if m != nil {
		return m.BuildIdKind
	}
	return BuildIdKind_BUILD_ID_LINKER
}

func (m *Mapping) GetAttributes() []uint64 {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Mapping) GetHasFunctions() bool {
	if m != nil {
		return m.HasFunctions
	}
	return false
}

func (m *Mapping) GetHasFilenames() bool {
	if m != nil {
		return m.HasFilenames
	}
	return false
}

func (m *Mapping) GetHasLineNumbers() bool {
	if m != nil {
		return m.HasLineNumbers
	}
	return false
}

func (m *Mapping) GetHasInlineFrames() bool {
	if m != nil {
		return m.HasInlineFrames
	}
	return false
}

// Describes function and line table debug information.
type Location struct {
	// Unique nonzero id for the location.  A profile could use
	// instruction addresses or any integer sequence as ids. [deprecated]
	Id uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The index of the corresponding profile.Mapping for this location.
	// It can be unset if the mapping is unknown or not applicable for
	// this profile type.
	MappingIndex uint64 `protobuf:"varint,2,opt,name=mapping_index,json=mappingIndex,proto3" json:"mapping_index,omitempty"`
	// The instruction address for this location, if available.  It
	// should be within [Mapping.memory_start...Mapping.memory_limit]
	// for the corresponding mapping. A non-leaf address may be in the
	// middle of a call instruction. It is up to display tools to find
	// the beginning of the instruction if necessary.
	Address uint64 `protobuf:"varint,3,opt,name=address,proto3" json:"address,omitempty"`
	// Multiple line indicates this location has inlined functions,
	// where the last entry represents the caller into which the
	// preceding entries were inlined.
	//
	// E.g., if memcpy() is inlined into printf:
	//    line[0].function_name == "memcpy"
	//    line[1].function_name == "printf"
	Line []Line `protobuf:"bytes,4,rep,name=line,proto3" json:"line"`
	// Provides an indication that multiple symbols map to this location's
	// address, for example due to identical code folding by the linker. In that
	// case the line information above represents one of the multiple
	// symbols. This field must be recomputed when the symbolization state of the
	// profile changes.
	IsFolded bool `protobuf:"varint,5,opt,name=is_folded,json=isFolded,proto3" json:"is_folded,omitempty"`
	// Type of frame (e.g. kernel, native, python, hotspot, php). Index into string table.
	TypeIndex uint32 `protobuf:"varint,6,opt,name=type_index,json=typeIndex,proto3" json:"type_index,omitempty"`
	// References to attributes in Profile.attribute_table. [optional]
	Attributes []uint64 `protobuf:"varint,7,rep,packed,name=attributes,proto3" json:"attributes,omitempty"`
}

func (m *Location) Reset()         { *m = Location{} }
func (m *Location) String() string { return proto.CompactTextString(m) }
func (*Location) ProtoMessage()    {}
func (*Location) Descriptor() ([]byte, []int) {
	return fileDescriptor_05f9ce3fdbeb046f, []int{7}
}
func (m *Location) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Location) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Location.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Location) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Location.Merge(m, src)
}
func (m *Location) XXX_Size() int {
	return m.Size()
}
func (m *Location) XXX_DiscardUnknown() {
	xxx_messageInfo_Location.DiscardUnknown(m)
}

var xxx_messageInfo_Location proto.InternalMessageInfo

func (m *Location) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Location) GetMappingIndex() uint64 {
	if m != nil {
		return m.MappingIndex
	}
	return 0
}

func (m *Location) GetAddress() uint64 {
	if m != nil {
		return m.Address
	}
	return 0
}

func (m *Location) GetLine() []Line {
	if m != nil {
		return m.Line
	}
	return nil
}

func (m *Location) GetIsFolded() bool {
	if m != nil {
		return m.IsFolded
	}
	return false
}

func (m *Location) GetTypeIndex() uint32 {
	if m != nil {
		return m.TypeIndex
	}
	return 0
}

func (m *Location) GetAttributes() []uint64 {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// Details a specific line in a source code, linked to a function.
type Line struct {
	// The index of the corresponding profile.Function for this line.
	FunctionIndex uint64 `protobuf:"varint,1,opt,name=function_index,json=functionIndex,proto3" json:"function_index,omitempty"`
	// Line number in source code.
	Line int64 `protobuf:"varint,2,opt,name=line,proto3" json:"line,omitempty"`
	// Column number in source code.
	Column int64 `protobuf:"varint,3,opt,name=column,proto3" json:"column,omitempty"`
}

func (m *Line) Reset()         { *m = Line{} }
func (m *Line) String() string { return proto.CompactTextString(m) }
func (*Line) ProtoMessage()    {}
func (*Line) Descriptor() ([]byte, []int) {
	return fileDescriptor_05f9ce3fdbeb046f, []int{8}
}
func (m *Line) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Line) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Line.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Line) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Line.Merge(m, src)
}
func (m *Line) XXX_Size() int {
	return m.Size()
}
func (m *Line) XXX_DiscardUnknown() {
	xxx_messageInfo_Line.DiscardUnknown(m)
}

var xxx_messageInfo_Line proto.InternalMessageInfo

func (m *Line) GetFunctionIndex() uint64 {
	if m != nil {
		return m.FunctionIndex
	}
	return 0
}

func (m *Line) GetLine() int64 {
	if m != nil {
		return m.Line
	}
	return 0
}

func (m *Line) GetColumn() int64 {
	if m != nil {
		return m.Column
	}
	return 0
}

// Describes a function, including its human-readable name, system name,
// source file, and starting line number in the source.
type Function struct {
	// Unique nonzero id for the function. [deprecated]
	Id uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the function, in human-readable form if available.
	Name int64 `protobuf:"varint,2,opt,name=name,proto3" json:"name,omitempty"`
	// Name of the function, as identified by the system.
	// For instance, it can be a C++ mangled name.
	SystemName int64 `protobuf:"varint,3,opt,name=system_name,json=systemName,proto3" json:"system_name,omitempty"`
	// Source file containing the function.
	Filename int64 `protobuf:"varint,4,opt,name=filename,proto3" json:"filename,omitempty"`
	// Line number in source file.
	StartLine int64 `protobuf:"varint,5,opt,name=start_line,json=startLine,proto3" json:"start_line,omitempty"`
}

func (m *Function) Reset()         { *m = Function{} }
func (m *Function) String() string { return proto.CompactTextString(m) }
func (*Function) ProtoMessage()    {}
func (*Function) Descriptor() ([]byte, []int) {
	return fileDescriptor_05f9ce3fdbeb046f, []int{9}
}
func (m *Function) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Function) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Function.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Function) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Function.Merge(m, src)
}
func (m *Function) XXX_Size() int {
	return m.Size()
}
func (m *Function) XXX_DiscardUnknown() {
	xxx_messageInfo_Function.DiscardUnknown(m)
}

var xxx_messageInfo_Function proto.InternalMessageInfo

func (m *Function) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Function) GetName() int64 {
	if m != nil {
		return m.Name
	}
	return 0
}

func (m *Function) GetSystemName() int64 {
	if m != nil {
		return m.SystemName
	}
	return 0
}

func (m *Function) GetFilename() int64 {
	if m != nil {
		return m.Filename
	}
	return 0
}

func (m *Function) GetStartLine() int64 {
	if m != nil {
		return m.StartLine
	}
	return 0
}

func init() {
	proto.RegisterEnum("opentelemetry.proto.profiles.v1experimental.AggregationTemporality", AggregationTemporality_name, AggregationTemporality_value)
	proto.RegisterEnum("opentelemetry.proto.profiles.v1experimental.BuildIdKind", BuildIdKind_name, BuildIdKind_value)
	proto.RegisterType((*Profile)(nil), "opentelemetry.proto.profiles.v1experimental.Profile")
	proto.RegisterType((*AttributeUnit)(nil), "opentelemetry.proto.profiles.v1experimental.AttributeUnit")
	proto.RegisterType((*Link)(nil), "opentelemetry.proto.profiles.v1experimental.Link")
	proto.RegisterType((*ValueType)(nil), "opentelemetry.proto.profiles.v1experimental.ValueType")
	proto.RegisterType((*Sample)(nil), "opentelemetry.proto.profiles.v1experimental.Sample")
	proto.RegisterType((*Label)(nil), "opentelemetry.proto.profiles.v1experimental.Label")
	proto.RegisterType((*Mapping)(nil), "opentelemetry.proto.profiles.v1experimental.Mapping")
	proto.RegisterType((*Location)(nil), "opentelemetry.proto.profiles.v1experimental.Location")
	proto.RegisterType((*Line)(nil), "opentelemetry.proto.profiles.v1experimental.Line")
	proto.RegisterType((*Function)(nil), "opentelemetry.proto.profiles.v1experimental.Function")
}

func init() {
	proto.RegisterFile("opentelemetry/proto/profiles/v1experimental/pprofextended.proto", fileDescriptor_05f9ce3fdbeb046f)
}

var fileDescriptor_05f9ce3fdbeb046f = []byte{
	// 1483 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x57, 0xcd, 0x4f, 0x1b, 0x47,
	0x1b, 0xc7, 0x1f, 0xf8, 0xe3, 0x31, 0x06, 0x33, 0xe1, 0xe5, 0xdd, 0x37, 0xaf, 0x02, 0xc4, 0xa8,
	0x0d, 0x25, 0x92, 0x29, 0xa4, 0xad, 0xd2, 0xaa, 0x52, 0x6b, 0x82, 0x49, 0x56, 0x38, 0x86, 0x2e,
	0x86, 0x96, 0x2a, 0xd1, 0x6a, 0xf1, 0x0e, 0x66, 0xc4, 0xee, 0xec, 0x6a, 0x77, 0x8c, 0xb0, 0xd4,
	0x53, 0x8f, 0x51, 0x0f, 0x3d, 0xf7, 0x4f, 0xe8, 0xad, 0x7f, 0x41, 0xaf, 0x39, 0xe6, 0x52, 0xa9,
	0xea, 0x21, 0xaa, 0x92, 0xbf, 0xa1, 0xf7, 0x6a, 0x9e, 0x99, 0xb5, 0xcd, 0x47, 0x0e, 0x6e, 0x2f,
	0x68, 0x9e, 0xdf, 0xfc, 0xe6, 0x37, 0xcf, 0xec, 0xf3, 0x65, 0xe0, 0x8b, 0x20, 0xa4, 0x5c, 0x50,
	0x8f, 0xfa, 0x54, 0x44, 0xfd, 0xb5, 0x30, 0x0a, 0x44, 0x20, 0xff, 0x9e, 0x30, 0x8f, 0xc6, 0x6b,
	0xe7, 0xeb, 0xf4, 0x22, 0xa4, 0x11, 0xf3, 0x29, 0x17, 0x8e, 0xb7, 0x16, 0xca, 0x0d, 0x7a, 0x21,
	0x28, 0x77, 0xa9, 0x5b, 0x43, 0x2e, 0xb9, 0x7f, 0x49, 0x40, 0x81, 0xb5, 0x44, 0xa0, 0x76, 0x59,
	0xe0, 0xf6, 0x5c, 0x37, 0xe8, 0x06, 0xea, 0x0e, 0xb9, 0x52, 0xec, 0xdb, 0xab, 0x37, 0xf9, 0xd0,
	0x09, 0x7c, 0x3f, 0xe0, 0x6b, 0xe7, 0xeb, 0x7a, 0xa5, 0xb8, 0xd5, 0xbf, 0x0a, 0x90, 0xdf, 0x53,
	0xea, 0xe4, 0x39, 0x94, 0x62, 0xc7, 0x0f, 0x3d, 0x6a, 0x8b, 0x7e, 0x48, 0x8d, 0xd4, 0x52, 0x66,
	0xa5, 0xb4, 0xf1, 0x49, 0x6d, 0x0c, 0x87, 0x6a, 0x87, 0x8e, 0xd7, 0xa3, 0xed, 0x7e, 0x48, 0x37,
	0xb3, 0x2f, 0x5f, 0x2f, 0x4e, 0x58, 0xa0, 0x04, 0x25, 0x42, 0xbe, 0x82, 0x9c, 0xb2, 0x8c, 0x34,
	0x2a, 0x3f, 0x18, 0x4b, 0x79, 0x1f, 0x8f, 0x6a, 0x59, 0x2d, 0x44, 0xda, 0x90, 0xf7, 0x9d, 0x30,
	0x64, 0xbc, 0x6b, 0x64, 0x50, 0xf3, 0xa3, 0xb1, 0x34, 0x9f, 0xaa, 0xb3, 0x5a, 0x34, 0x91, 0x22,
	0x5f, 0x43, 0xc1, 0x0b, 0x3a, 0x8e, 0x60, 0x01, 0x37, 0xb2, 0x28, 0xfb, 0xf1, 0x58, 0xb2, 0x4d,
	0x7d, 0x58, 0xeb, 0x0e, 0xc4, 0xc8, 0x07, 0x50, 0x49, 0xd6, 0x36, 0xe3, 0x2e, 0xeb, 0xd0, 0xd8,
	0x98, 0x59, 0xca, 0xac, 0x64, 0xac, 0x99, 0x04, 0x37, 0x15, 0x2c, 0x7d, 0x38, 0xe9, 0xf1, 0x0e,
	0xfa, 0x30, 0xf9, 0x0f, 0x7c, 0xd8, 0xd6, 0x87, 0x13, 0x1f, 0x12, 0x31, 0x72, 0x08, 0x33, 0x8e,
	0x10, 0x11, 0x3b, 0xee, 0x09, 0x6a, 0x0b, 0xe7, 0xd8, 0xa3, 0x46, 0x05, 0xf5, 0xef, 0xdd, 0xa8,
	0xaf, 0x93, 0xe5, 0x7c, 0xbd, 0xb6, 0x43, 0xfb, 0x18, 0x5d, 0xad, 0x38, 0x3d, 0x50, 0x69, 0x4b,
	0x11, 0xc2, 0x46, 0x75, 0x7b, 0x9c, 0x89, 0xd8, 0x98, 0x45, 0xdd, 0xcf, 0xc6, 0xf2, 0xbb, 0x9e,
	0x68, 0x1c, 0x70, 0x26, 0xae, 0x5d, 0x25, 0xc1, 0x98, 0x1c, 0x02, 0x78, 0x8c, 0x9f, 0x69, 0xef,
	0x09, 0xde, 0xb2, 0x3e, 0x5e, 0x84, 0x18, 0x3f, 0xd3, 0xe2, 0x45, 0x29, 0xa5, 0x9e, 0x70, 0x17,
	0xa6, 0x62, 0x11, 0x31, 0xde, 0xd5, 0xca, 0xb9, 0xa5, 0xcc, 0x4a, 0xd1, 0x2a, 0x29, 0x4c, 0x51,
	0x16, 0xa1, 0xe4, 0x46, 0x41, 0x68, 0x9f, 0x44, 0x8e, 0x4f, 0x63, 0x23, 0xbf, 0x94, 0x5a, 0xc9,
	0x58, 0x20, 0xa1, 0x6d, 0x44, 0x24, 0xe1, 0x8c, 0xd2, 0x01, 0xa1, 0xa0, 0x08, 0x12, 0xd2, 0x84,
	0x3b, 0x00, 0x82, 0xf9, 0xd4, 0xe6, 0x0e, 0x0f, 0x62, 0xa3, 0x88, 0xfb, 0x45, 0x89, 0xb4, 0x24,
	0x40, 0xde, 0x83, 0x69, 0xb7, 0x17, 0xa9, 0x14, 0x51, 0x14, 0x40, 0x4a, 0x39, 0x41, 0x15, 0xed,
	0x39, 0x94, 0xe4, 0x73, 0x02, 0x57, 0x95, 0x6a, 0x69, 0x29, 0xf5, 0xef, 0x4b, 0x55, 0x09, 0x62,
	0xa9, 0xce, 0x43, 0x4e, 0x59, 0xc6, 0x14, 0xde, 0xae, 0x2d, 0x62, 0x40, 0x5e, 0x26, 0x04, 0xe5,
	0xc2, 0x28, 0x63, 0xde, 0x26, 0x26, 0xa9, 0xc1, 0x2d, 0x97, 0x9e, 0x38, 0x3d, 0x4f, 0xd8, 0xa3,
	0x3d, 0x64, 0x1a, 0x8f, 0xcf, 0xea, 0xad, 0xfd, 0x41, 0x33, 0xa8, 0x3e, 0x81, 0xf2, 0xa5, 0x50,
	0x93, 0x65, 0x28, 0x0f, 0xf3, 0xe7, 0x8c, 0xf6, 0x8d, 0x14, 0x1e, 0x9d, 0x1a, 0x80, 0x3b, 0xb4,
	0x4f, 0x08, 0x64, 0x65, 0x6a, 0x19, 0x69, 0xdc, 0xc3, 0x75, 0xf5, 0xd7, 0x14, 0x64, 0x65, 0x3c,
	0xc9, 0x33, 0x28, 0x88, 0xc8, 0xe9, 0x50, 0x9b, 0xb9, 0x78, 0x78, 0x6a, 0xb3, 0x2e, 0x1f, 0xf6,
	0xc7, 0xeb, 0xc5, 0x4f, 0xbb, 0xc1, 0x95, 0x4f, 0xc3, 0x64, 0x43, 0xf4, 0x3c, 0xda, 0x11, 0x41,
	0xb4, 0x16, 0xba, 0x8e, 0x70, 0xd6, 0x18, 0x17, 0x34, 0xe2, 0x8e, 0xb7, 0x26, 0xad, 0x5a, 0x5b,
	0x2a, 0x99, 0x5b, 0x56, 0x1e, 0x25, 0x4d, 0x97, 0x1c, 0x41, 0x3e, 0x0e, 0x1d, 0x2e, 0xc5, 0xd3,
	0x28, 0xfe, 0xa5, 0x16, 0x7f, 0x38, 0xbe, 0xf8, 0x7e, 0xe8, 0x70, 0x73, 0xcb, 0xca, 0x49, 0x41,
	0xd3, 0xad, 0xfe, 0x92, 0x82, 0xe2, 0x20, 0x1a, 0xf2, 0x8d, 0xba, 0xfd, 0xe2, 0x1b, 0x85, 0xc6,
	0xae, 0xbe, 0x9b, 0x7c, 0x07, 0xff, 0x75, 0xba, 0xdd, 0x88, 0x76, 0x55, 0xb2, 0x08, 0xea, 0x87,
	0x41, 0xe4, 0x78, 0x4c, 0xf4, 0x8d, 0xcc, 0x52, 0x6a, 0x65, 0x7a, 0xe3, 0xd1, 0x78, 0x85, 0x37,
	0xd4, 0x6a, 0x0f, 0xa5, 0xac, 0x79, 0xe7, 0x46, 0xbc, 0xfa, 0x22, 0x03, 0x39, 0x15, 0x4e, 0x99,
	0xb2, 0xa3, 0x5d, 0x8d, 0x5e, 0xe0, 0xe4, 0xc8, 0x5a, 0xe5, 0x91, 0x9e, 0x46, 0x2f, 0xc8, 0x06,
	0xfc, 0x27, 0x01, 0x62, 0x3b, 0x16, 0x4e, 0x24, 0x34, 0x5b, 0x16, 0x51, 0xd6, 0xba, 0x35, 0xd8,
	0xdc, 0x97, 0x7b, 0xea, 0xcc, 0x48, 0xc3, 0x8c, 0x6d, 0x8f, 0xf2, 0xae, 0x38, 0xc5, 0x92, 0xca,
	0x0e, 0x1b, 0x66, 0xdc, 0x44, 0x58, 0x26, 0x60, 0x2c, 0x9c, 0xce, 0x59, 0x92, 0x02, 0x5a, 0x5c,
	0x16, 0x58, 0xd9, 0x9a, 0x1d, 0x6e, 0x99, 0xae, 0x92, 0x9e, 0x83, 0xc9, 0x73, 0xf9, 0xcd, 0x71,
	0x18, 0x65, 0x2c, 0x65, 0x90, 0x16, 0x4c, 0x7a, 0xce, 0x31, 0xf5, 0xf4, 0x38, 0xd9, 0x18, 0xaf,
	0xab, 0xc8, 0x93, 0xba, 0x9a, 0x94, 0x0c, 0x59, 0x00, 0x18, 0x24, 0xb0, 0x2c, 0x65, 0xf9, 0x5d,
	0x46, 0x10, 0x19, 0x58, 0xd9, 0x7f, 0xb0, 0xcc, 0xb2, 0x16, 0xae, 0xc9, 0x87, 0x30, 0x27, 0xfb,
	0x41, 0x2c, 0x1c, 0x3f, 0x8c, 0x65, 0x2b, 0xbd, 0xc0, 0x4e, 0x80, 0x15, 0x97, 0xb5, 0xc8, 0x70,
	0xef, 0x80, 0xb3, 0x0b, 0xd9, 0x0e, 0xaa, 0xdf, 0xc0, 0x24, 0xde, 0x4d, 0x2a, 0x90, 0x19, 0x96,
	0x8e, 0x5c, 0x4a, 0x24, 0x16, 0x91, 0x4e, 0x1c, 0xb9, 0x94, 0x08, 0xef, 0xf9, 0x98, 0x23, 0x19,
	0x4b, 0x2e, 0xc9, 0xff, 0xa0, 0xc0, 0x7b, 0x3e, 0x36, 0x6d, 0x23, 0x8b, 0x70, 0x9e, 0xf7, 0x7c,
	0x59, 0x95, 0xd5, 0xdf, 0x32, 0x90, 0xd7, 0x53, 0x92, 0x4c, 0x43, 0x5a, 0x57, 0x56, 0xd6, 0x4a,
	0x33, 0x57, 0xb6, 0x4b, 0x9f, 0xfa, 0x41, 0xd4, 0x57, 0xd1, 0xc4, 0x3b, 0xb2, 0x56, 0x49, 0x61,
	0x18, 0xc4, 0x11, 0x8a, 0xc7, 0x7c, 0x26, 0xf0, 0xd2, 0x01, 0xa5, 0x29, 0x21, 0xd9, 0x30, 0xe5,
	0xc7, 0xb4, 0x83, 0x93, 0x93, 0x98, 0xaa, 0xfb, 0xb3, 0x16, 0x48, 0x68, 0x17, 0x11, 0x72, 0x1b,
	0x0a, 0xd2, 0xe2, 0x8e, 0x4f, 0x8d, 0x49, 0xf4, 0x6e, 0x60, 0x4b, 0xcf, 0x8f, 0x7b, 0xcc, 0x73,
	0x65, 0x55, 0xe6, 0x94, 0xe7, 0x68, 0x9b, 0x2e, 0x79, 0x06, 0xe5, 0x64, 0xcb, 0x3e, 0x63, 0xdc,
	0xc5, 0x1e, 0x39, 0xbd, 0xf1, 0x70, 0xac, 0x88, 0x6e, 0x2a, 0xb1, 0x1d, 0xc6, 0x5d, 0xab, 0x74,
	0x3c, 0x34, 0xae, 0xc4, 0x75, 0xea, 0x5a, 0x5c, 0x97, 0xa1, 0x7c, 0xea, 0xc4, 0x76, 0x32, 0x75,
	0xd5, 0xa4, 0x28, 0x58, 0x53, 0xa7, 0x4e, 0x9c, 0x4c, 0xe6, 0x21, 0x49, 0xbf, 0x46, 0x4d, 0x0b,
	0x4d, 0x4a, 0x30, 0xb2, 0x02, 0x15, 0x49, 0xf2, 0x18, 0xa7, 0x36, 0xef, 0xf9, 0xc7, 0x34, 0x52,
	0x53, 0xa3, 0x60, 0x4d, 0x9f, 0x3a, 0x71, 0x93, 0x71, 0xda, 0x52, 0x28, 0x59, 0x85, 0x59, 0xc9,
	0x64, 0x1c, 0xb9, 0x7a, 0x00, 0x01, 0x52, 0x67, 0x4e, 0x9d, 0xd8, 0x44, 0x5c, 0x4d, 0xa1, 0xea,
	0xf7, 0x69, 0x28, 0x24, 0x3f, 0x53, 0xae, 0x05, 0x76, 0x19, 0xca, 0xfa, 0xa7, 0x90, 0x2e, 0x22,
	0x15, 0xd9, 0x29, 0x0d, 0xaa, 0xfa, 0x31, 0x20, 0xef, 0xb8, 0x6e, 0x44, 0xe3, 0x58, 0x47, 0x35,
	0x31, 0xc9, 0x0e, 0xe6, 0x34, 0xd5, 0x3f, 0x9d, 0xc6, 0x1e, 0xcc, 0xc9, 0x3c, 0x42, 0x11, 0xf2,
	0x7f, 0x28, 0xb2, 0xd8, 0x3e, 0x09, 0x3c, 0x97, 0xba, 0x18, 0xfe, 0x82, 0x55, 0x60, 0xf1, 0x36,
	0xda, 0x38, 0x4b, 0xfb, 0x21, 0xd5, 0x5e, 0xe6, 0xb0, 0xd4, 0x8b, 0x12, 0x51, 0x2e, 0x5e, 0x0e,
	0x52, 0xfe, 0x6a, 0x90, 0xaa, 0x47, 0x38, 0x38, 0xb0, 0x81, 0x25, 0x81, 0x1a, 0x34, 0x30, 0xf9,
	0xa2, 0x72, 0x82, 0x2a, 0x39, 0xa2, 0xdf, 0xa5, 0x9b, 0x30, 0xba, 0x37, 0x0f, 0xb9, 0x4e, 0xe0,
	0xf5, 0x7c, 0xae, 0xeb, 0x49, 0x5b, 0xd5, 0x17, 0x29, 0x28, 0x24, 0x81, 0xbe, 0xf6, 0x7d, 0x09,
	0x64, 0x31, 0x9b, 0xb5, 0x10, 0x66, 0xf2, 0x22, 0x94, 0xe2, 0x7e, 0x2c, 0xa8, 0x6f, 0xe3, 0x96,
	0x52, 0x03, 0x05, 0xb5, 0x24, 0x61, 0xb4, 0x0c, 0xb2, 0x57, 0xca, 0xe0, 0x0e, 0x80, 0x6a, 0xa8,
	0xe8, 0x9f, 0x2a, 0x92, 0x22, 0x22, 0xf2, 0x7d, 0xab, 0x3f, 0xa4, 0x60, 0xfe, 0xe6, 0xf6, 0x4e,
	0xee, 0xc1, 0x72, 0xfd, 0xf1, 0x63, 0xab, 0xf1, 0xb8, 0xde, 0x36, 0x77, 0x5b, 0x76, 0xbb, 0xf1,
	0x74, 0x6f, 0xd7, 0xaa, 0x37, 0xcd, 0xf6, 0x91, 0x7d, 0xd0, 0xda, 0xdf, 0x6b, 0x3c, 0x32, 0xb7,
	0xcd, 0xc6, 0x56, 0x65, 0x82, 0xdc, 0x85, 0x3b, 0xef, 0x22, 0x6e, 0x35, 0x9a, 0xed, 0x7a, 0x25,
	0x45, 0xde, 0x87, 0xea, 0xbb, 0x28, 0x8f, 0x0e, 0x9e, 0x1e, 0x34, 0xeb, 0x6d, 0xf3, 0xb0, 0x51,
	0x49, 0xaf, 0x7e, 0x0e, 0xa5, 0x91, 0xba, 0x22, 0xb7, 0x60, 0x66, 0xf3, 0xc0, 0x6c, 0x6e, 0xd9,
	0xe6, 0x96, 0xdd, 0x34, 0x5b, 0x3b, 0x0d, 0xab, 0x32, 0x41, 0x0c, 0x98, 0x1b, 0x80, 0x9b, 0x66,
	0xab, 0x6e, 0x1d, 0xd9, 0x4f, 0xea, 0xfb, 0x4f, 0x2a, 0xa9, 0xcd, 0x9f, 0x52, 0x2f, 0xdf, 0x2c,
	0xa4, 0x5e, 0xbd, 0x59, 0x48, 0xfd, 0xf9, 0x66, 0x21, 0xf5, 0xe3, 0xdb, 0x85, 0x89, 0x57, 0x6f,
	0x17, 0x26, 0x7e, 0x7f, 0xbb, 0x30, 0xf1, 0xad, 0x35, 0xf6, 0x24, 0x56, 0xff, 0x1b, 0x75, 0x29,
	0x7f, 0xd7, 0xbf, 0x68, 0x3f, 0xa7, 0xef, 0xef, 0x86, 0x94, 0xb7, 0x07, 0x8a, 0x7b, 0x98, 0xbe,
	0x7b, 0x49, 0xfa, 0x1e, 0xae, 0x37, 0x46, 0xd8, 0xc7, 0x39, 0xd4, 0x7b, 0xf0, 0x77, 0x00, 0x00,
	0x00, 0xff, 0xff, 0xef, 0x03, 0x47, 0x6d, 0x06, 0x0e, 0x00, 0x00,
}

func (m *Profile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Profile) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Profile) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.LinkTable) > 0 {
		for iNdEx := len(m.LinkTable) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.LinkTable[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPprofextended(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x92
		}
	}
	if len(m.AttributeUnits) > 0 {
		for iNdEx := len(m.AttributeUnits) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.AttributeUnits[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPprofextended(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x8a
		}
	}
	if len(m.AttributeTable) > 0 {
		for iNdEx := len(m.AttributeTable) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.AttributeTable[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPprofextended(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x82
		}
	}
	if len(m.LocationIndices) > 0 {
		dAtA2 := make([]byte, len(m.LocationIndices)*10)
		var j1 int
		for _, num1 := range m.LocationIndices {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA2[j1] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j1++
			}
			dAtA2[j1] = uint8(num)
			j1++
		}
		i -= j1
		copy(dAtA[i:], dAtA2[:j1])
		i = encodeVarintPprofextended(dAtA, i, uint64(j1))
		i--
		dAtA[i] = 0x7a
	}
	if m.DefaultSampleType != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.DefaultSampleType))
		i--
		dAtA[i] = 0x70
	}
	if len(m.Comment) > 0 {
		dAtA4 := make([]byte, len(m.Comment)*10)
		var j3 int
		for _, num1 := range m.Comment {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA4[j3] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j3++
			}
			dAtA4[j3] = uint8(num)
			j3++
		}
		i -= j3
		copy(dAtA[i:], dAtA4[:j3])
		i = encodeVarintPprofextended(dAtA, i, uint64(j3))
		i--
		dAtA[i] = 0x6a
	}
	if m.Period != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.Period))
		i--
		dAtA[i] = 0x60
	}
	{
		size, err := m.PeriodType.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintPprofextended(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x5a
	if m.DurationNanos != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.DurationNanos))
		i--
		dAtA[i] = 0x50
	}
	if m.TimeNanos != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.TimeNanos))
		i--
		dAtA[i] = 0x48
	}
	if m.KeepFrames != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.KeepFrames))
		i--
		dAtA[i] = 0x40
	}
	if m.DropFrames != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.DropFrames))
		i--
		dAtA[i] = 0x38
	}
	if len(m.StringTable) > 0 {
		for iNdEx := len(m.StringTable) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.StringTable[iNdEx])
			copy(dAtA[i:], m.StringTable[iNdEx])
			i = encodeVarintPprofextended(dAtA, i, uint64(len(m.StringTable[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Function) > 0 {
		for iNdEx := len(m.Function) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Function[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPprofextended(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Location) > 0 {
		for iNdEx := len(m.Location) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Location[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPprofextended(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Mapping) > 0 {
		for iNdEx := len(m.Mapping) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Mapping[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPprofextended(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Sample) > 0 {
		for iNdEx := len(m.Sample) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Sample[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPprofextended(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.SampleType) > 0 {
		for iNdEx := len(m.SampleType) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.SampleType[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPprofextended(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *AttributeUnit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttributeUnit) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AttributeUnit) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Unit != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.Unit))
		i--
		dAtA[i] = 0x10
	}
	if m.AttributeKey != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.AttributeKey))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Link) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Link) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Link) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size := m.SpanId.Size()
		i -= size
		if _, err := m.SpanId.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintPprofextended(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size := m.TraceId.Size()
		i -= size
		if _, err := m.TraceId.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintPprofextended(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ValueType) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ValueType) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ValueType) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AggregationTemporality != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.AggregationTemporality))
		i--
		dAtA[i] = 0x18
	}
	if m.Unit != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.Unit))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Sample) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Sample) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Sample) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.TimestampsUnixNano) > 0 {
		dAtA7 := make([]byte, len(m.TimestampsUnixNano)*10)
		var j6 int
		for _, num := range m.TimestampsUnixNano {
			for num >= 1<<7 {
				dAtA7[j6] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j6++
			}
			dAtA7[j6] = uint8(num)
			j6++
		}
		i -= j6
		copy(dAtA[i:], dAtA7[:j6])
		i = encodeVarintPprofextended(dAtA, i, uint64(j6))
		i--
		dAtA[i] = 0x6a
	}
	if m.Link != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.Link))
		i--
		dAtA[i] = 0x60
	}
	if len(m.Attributes) > 0 {
		dAtA9 := make([]byte, len(m.Attributes)*10)
		var j8 int
		for _, num := range m.Attributes {
			for num >= 1<<7 {
				dAtA9[j8] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j8++
			}
			dAtA9[j8] = uint8(num)
			j8++
		}
		i -= j8
		copy(dAtA[i:], dAtA9[:j8])
		i = encodeVarintPprofextended(dAtA, i, uint64(j8))
		i--
		dAtA[i] = 0x52
	}
	if m.StacktraceIdIndex != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.StacktraceIdIndex))
		i--
		dAtA[i] = 0x48
	}
	if m.LocationsLength != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.LocationsLength))
		i--
		dAtA[i] = 0x40
	}
	if m.LocationsStartIndex != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.LocationsStartIndex))
		i--
		dAtA[i] = 0x38
	}
	if len(m.Label) > 0 {
		for iNdEx := len(m.Label) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Label[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPprofextended(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Value) > 0 {
		dAtA11 := make([]byte, len(m.Value)*10)
		var j10 int
		for _, num1 := range m.Value {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA11[j10] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j10++
			}
			dAtA11[j10] = uint8(num)
			j10++
		}
		i -= j10
		copy(dAtA[i:], dAtA11[:j10])
		i = encodeVarintPprofextended(dAtA, i, uint64(j10))
		i--
		dAtA[i] = 0x12
	}
	if len(m.LocationIndex) > 0 {
		dAtA13 := make([]byte, len(m.LocationIndex)*10)
		var j12 int
		for _, num := range m.LocationIndex {
			for num >= 1<<7 {
				dAtA13[j12] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j12++
			}
			dAtA13[j12] = uint8(num)
			j12++
		}
		i -= j12
		copy(dAtA[i:], dAtA13[:j12])
		i = encodeVarintPprofextended(dAtA, i, uint64(j12))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Label) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Label) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Label) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.NumUnit != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.NumUnit))
		i--
		dAtA[i] = 0x20
	}
	if m.Num != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.Num))
		i--
		dAtA[i] = 0x18
	}
	if m.Str != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.Str))
		i--
		dAtA[i] = 0x10
	}
	if m.Key != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.Key))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Mapping) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Mapping) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Mapping) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Attributes) > 0 {
		dAtA15 := make([]byte, len(m.Attributes)*10)
		var j14 int
		for _, num := range m.Attributes {
			for num >= 1<<7 {
				dAtA15[j14] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j14++
			}
			dAtA15[j14] = uint8(num)
			j14++
		}
		i -= j14
		copy(dAtA[i:], dAtA15[:j14])
		i = encodeVarintPprofextended(dAtA, i, uint64(j14))
		i--
		dAtA[i] = 0x62
	}
	if m.BuildIdKind != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.BuildIdKind))
		i--
		dAtA[i] = 0x58
	}
	if m.HasInlineFrames {
		i--
		if m.HasInlineFrames {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if m.HasLineNumbers {
		i--
		if m.HasLineNumbers {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.HasFilenames {
		i--
		if m.HasFilenames {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if m.HasFunctions {
		i--
		if m.HasFunctions {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.BuildId != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.BuildId))
		i--
		dAtA[i] = 0x30
	}
	if m.Filename != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.Filename))
		i--
		dAtA[i] = 0x28
	}
	if m.FileOffset != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.FileOffset))
		i--
		dAtA[i] = 0x20
	}
	if m.MemoryLimit != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.MemoryLimit))
		i--
		dAtA[i] = 0x18
	}
	if m.MemoryStart != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.MemoryStart))
		i--
		dAtA[i] = 0x10
	}
	if m.Id != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Location) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Location) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Location) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Attributes) > 0 {
		dAtA17 := make([]byte, len(m.Attributes)*10)
		var j16 int
		for _, num := range m.Attributes {
			for num >= 1<<7 {
				dAtA17[j16] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j16++
			}
			dAtA17[j16] = uint8(num)
			j16++
		}
		i -= j16
		copy(dAtA[i:], dAtA17[:j16])
		i = encodeVarintPprofextended(dAtA, i, uint64(j16))
		i--
		dAtA[i] = 0x3a
	}
	if m.TypeIndex != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.TypeIndex))
		i--
		dAtA[i] = 0x30
	}
	if m.IsFolded {
		i--
		if m.IsFolded {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.Line) > 0 {
		for iNdEx := len(m.Line) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Line[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPprofextended(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.Address != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.Address))
		i--
		dAtA[i] = 0x18
	}
	if m.MappingIndex != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.MappingIndex))
		i--
		dAtA[i] = 0x10
	}
	if m.Id != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Line) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Line) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Line) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Column != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.Column))
		i--
		dAtA[i] = 0x18
	}
	if m.Line != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.Line))
		i--
		dAtA[i] = 0x10
	}
	if m.FunctionIndex != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.FunctionIndex))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Function) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Function) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Function) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.StartLine != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.StartLine))
		i--
		dAtA[i] = 0x28
	}
	if m.Filename != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.Filename))
		i--
		dAtA[i] = 0x20
	}
	if m.SystemName != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.SystemName))
		i--
		dAtA[i] = 0x18
	}
	if m.Name != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.Name))
		i--
		dAtA[i] = 0x10
	}
	if m.Id != 0 {
		i = encodeVarintPprofextended(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintPprofextended(dAtA []byte, offset int, v uint64) int {
	offset -= sovPprofextended(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Profile) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.SampleType) > 0 {
		for _, e := range m.SampleType {
			l = e.Size()
			n += 1 + l + sovPprofextended(uint64(l))
		}
	}
	if len(m.Sample) > 0 {
		for _, e := range m.Sample {
			l = e.Size()
			n += 1 + l + sovPprofextended(uint64(l))
		}
	}
	if len(m.Mapping) > 0 {
		for _, e := range m.Mapping {
			l = e.Size()
			n += 1 + l + sovPprofextended(uint64(l))
		}
	}
	if len(m.Location) > 0 {
		for _, e := range m.Location {
			l = e.Size()
			n += 1 + l + sovPprofextended(uint64(l))
		}
	}
	if len(m.Function) > 0 {
		for _, e := range m.Function {
			l = e.Size()
			n += 1 + l + sovPprofextended(uint64(l))
		}
	}
	if len(m.StringTable) > 0 {
		for _, s := range m.StringTable {
			l = len(s)
			n += 1 + l + sovPprofextended(uint64(l))
		}
	}
	if m.DropFrames != 0 {
		n += 1 + sovPprofextended(uint64(m.DropFrames))
	}
	if m.KeepFrames != 0 {
		n += 1 + sovPprofextended(uint64(m.KeepFrames))
	}
	if m.TimeNanos != 0 {
		n += 1 + sovPprofextended(uint64(m.TimeNanos))
	}
	if m.DurationNanos != 0 {
		n += 1 + sovPprofextended(uint64(m.DurationNanos))
	}
	l = m.PeriodType.Size()
	n += 1 + l + sovPprofextended(uint64(l))
	if m.Period != 0 {
		n += 1 + sovPprofextended(uint64(m.Period))
	}
	if len(m.Comment) > 0 {
		l = 0
		for _, e := range m.Comment {
			l += sovPprofextended(uint64(e))
		}
		n += 1 + sovPprofextended(uint64(l)) + l
	}
	if m.DefaultSampleType != 0 {
		n += 1 + sovPprofextended(uint64(m.DefaultSampleType))
	}
	if len(m.LocationIndices) > 0 {
		l = 0
		for _, e := range m.LocationIndices {
			l += sovPprofextended(uint64(e))
		}
		n += 1 + sovPprofextended(uint64(l)) + l
	}
	if len(m.AttributeTable) > 0 {
		for _, e := range m.AttributeTable {
			l = e.Size()
			n += 2 + l + sovPprofextended(uint64(l))
		}
	}
	if len(m.AttributeUnits) > 0 {
		for _, e := range m.AttributeUnits {
			l = e.Size()
			n += 2 + l + sovPprofextended(uint64(l))
		}
	}
	if len(m.LinkTable) > 0 {
		for _, e := range m.LinkTable {
			l = e.Size()
			n += 2 + l + sovPprofextended(uint64(l))
		}
	}
	return n
}

func (m *AttributeUnit) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AttributeKey != 0 {
		n += 1 + sovPprofextended(uint64(m.AttributeKey))
	}
	if m.Unit != 0 {
		n += 1 + sovPprofextended(uint64(m.Unit))
	}
	return n
}

func (m *Link) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.TraceId.Size()
	n += 1 + l + sovPprofextended(uint64(l))
	l = m.SpanId.Size()
	n += 1 + l + sovPprofextended(uint64(l))
	return n
}

func (m *ValueType) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovPprofextended(uint64(m.Type))
	}
	if m.Unit != 0 {
		n += 1 + sovPprofextended(uint64(m.Unit))
	}
	if m.AggregationTemporality != 0 {
		n += 1 + sovPprofextended(uint64(m.AggregationTemporality))
	}
	return n
}

func (m *Sample) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.LocationIndex) > 0 {
		l = 0
		for _, e := range m.LocationIndex {
			l += sovPprofextended(uint64(e))
		}
		n += 1 + sovPprofextended(uint64(l)) + l
	}
	if len(m.Value) > 0 {
		l = 0
		for _, e := range m.Value {
			l += sovPprofextended(uint64(e))
		}
		n += 1 + sovPprofextended(uint64(l)) + l
	}
	if len(m.Label) > 0 {
		for _, e := range m.Label {
			l = e.Size()
			n += 1 + l + sovPprofextended(uint64(l))
		}
	}
	if m.LocationsStartIndex != 0 {
		n += 1 + sovPprofextended(uint64(m.LocationsStartIndex))
	}
	if m.LocationsLength != 0 {
		n += 1 + sovPprofextended(uint64(m.LocationsLength))
	}
	if m.StacktraceIdIndex != 0 {
		n += 1 + sovPprofextended(uint64(m.StacktraceIdIndex))
	}
	if len(m.Attributes) > 0 {
		l = 0
		for _, e := range m.Attributes {
			l += sovPprofextended(uint64(e))
		}
		n += 1 + sovPprofextended(uint64(l)) + l
	}
	if m.Link != 0 {
		n += 1 + sovPprofextended(uint64(m.Link))
	}
	if len(m.TimestampsUnixNano) > 0 {
		l = 0
		for _, e := range m.TimestampsUnixNano {
			l += sovPprofextended(uint64(e))
		}
		n += 1 + sovPprofextended(uint64(l)) + l
	}
	return n
}

func (m *Label) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Key != 0 {
		n += 1 + sovPprofextended(uint64(m.Key))
	}
	if m.Str != 0 {
		n += 1 + sovPprofextended(uint64(m.Str))
	}
	if m.Num != 0 {
		n += 1 + sovPprofextended(uint64(m.Num))
	}
	if m.NumUnit != 0 {
		n += 1 + sovPprofextended(uint64(m.NumUnit))
	}
	return n
}

func (m *Mapping) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovPprofextended(uint64(m.Id))
	}
	if m.MemoryStart != 0 {
		n += 1 + sovPprofextended(uint64(m.MemoryStart))
	}
	if m.MemoryLimit != 0 {
		n += 1 + sovPprofextended(uint64(m.MemoryLimit))
	}
	if m.FileOffset != 0 {
		n += 1 + sovPprofextended(uint64(m.FileOffset))
	}
	if m.Filename != 0 {
		n += 1 + sovPprofextended(uint64(m.Filename))
	}
	if m.BuildId != 0 {
		n += 1 + sovPprofextended(uint64(m.BuildId))
	}
	if m.HasFunctions {
		n += 2
	}
	if m.HasFilenames {
		n += 2
	}
	if m.HasLineNumbers {
		n += 2
	}
	if m.HasInlineFrames {
		n += 2
	}
	if m.BuildIdKind != 0 {
		n += 1 + sovPprofextended(uint64(m.BuildIdKind))
	}
	if len(m.Attributes) > 0 {
		l = 0
		for _, e := range m.Attributes {
			l += sovPprofextended(uint64(e))
		}
		n += 1 + sovPprofextended(uint64(l)) + l
	}
	return n
}

func (m *Location) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovPprofextended(uint64(m.Id))
	}
	if m.MappingIndex != 0 {
		n += 1 + sovPprofextended(uint64(m.MappingIndex))
	}
	if m.Address != 0 {
		n += 1 + sovPprofextended(uint64(m.Address))
	}
	if len(m.Line) > 0 {
		for _, e := range m.Line {
			l = e.Size()
			n += 1 + l + sovPprofextended(uint64(l))
		}
	}
	if m.IsFolded {
		n += 2
	}
	if m.TypeIndex != 0 {
		n += 1 + sovPprofextended(uint64(m.TypeIndex))
	}
	if len(m.Attributes) > 0 {
		l = 0
		for _, e := range m.Attributes {
			l += sovPprofextended(uint64(e))
		}
		n += 1 + sovPprofextended(uint64(l)) + l
	}
	return n
}

func (m *Line) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.FunctionIndex != 0 {
		n += 1 + sovPprofextended(uint64(m.FunctionIndex))
	}
	if m.Line != 0 {
		n += 1 + sovPprofextended(uint64(m.Line))
	}
	if m.Column != 0 {
		n += 1 + sovPprofextended(uint64(m.Column))
	}
	return n
}

func (m *Function) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovPprofextended(uint64(m.Id))
	}
	if m.Name != 0 {
		n += 1 + sovPprofextended(uint64(m.Name))
	}
	if m.SystemName != 0 {
		n += 1 + sovPprofextended(uint64(m.SystemName))
	}
	if m.Filename != 0 {
		n += 1 + sovPprofextended(uint64(m.Filename))
	}
	if m.StartLine != 0 {
		n += 1 + sovPprofextended(uint64(m.StartLine))
	}
	return n
}

func sovPprofextended(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozPprofextended(x uint64) (n int) {
	return sovPprofextended(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Profile) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPprofextended
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Profile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Profile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SampleType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPprofextended
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPprofextended
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SampleType = append(m.SampleType, ValueType{})
			if err := m.SampleType[len(m.SampleType)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sample", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPprofextended
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPprofextended
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sample = append(m.Sample, Sample{})
			if err := m.Sample[len(m.Sample)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mapping", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPprofextended
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPprofextended
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Mapping = append(m.Mapping, Mapping{})
			if err := m.Mapping[len(m.Mapping)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Location", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPprofextended
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPprofextended
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Location = append(m.Location, Location{})
			if err := m.Location[len(m.Location)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Function", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPprofextended
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPprofextended
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Function = append(m.Function, Function{})
			if err := m.Function[len(m.Function)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringTable", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPprofextended
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPprofextended
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StringTable = append(m.StringTable, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DropFrames", wireType)
			}
			m.DropFrames = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DropFrames |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeepFrames", wireType)
			}
			m.KeepFrames = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeepFrames |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeNanos", wireType)
			}
			m.TimeNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TimeNanos |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DurationNanos", wireType)
			}
			m.DurationNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DurationNanos |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeriodType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPprofextended
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPprofextended
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PeriodType.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Period", wireType)
			}
			m.Period = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Period |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPprofextended
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Comment = append(m.Comment, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPprofextended
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPprofextended
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPprofextended
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.Comment) == 0 {
					m.Comment = make([]int64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPprofextended
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Comment = append(m.Comment, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Comment", wireType)
			}
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultSampleType", wireType)
			}
			m.DefaultSampleType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DefaultSampleType |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 15:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPprofextended
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.LocationIndices = append(m.LocationIndices, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPprofextended
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPprofextended
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPprofextended
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.LocationIndices) == 0 {
					m.LocationIndices = make([]int64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPprofextended
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.LocationIndices = append(m.LocationIndices, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field LocationIndices", wireType)
			}
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeTable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPprofextended
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPprofextended
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AttributeTable = append(m.AttributeTable, v1.KeyValue{})
			if err := m.AttributeTable[len(m.AttributeTable)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeUnits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPprofextended
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPprofextended
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AttributeUnits = append(m.AttributeUnits, AttributeUnit{})
			if err := m.AttributeUnits[len(m.AttributeUnits)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LinkTable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPprofextended
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPprofextended
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LinkTable = append(m.LinkTable, Link{})
			if err := m.LinkTable[len(m.LinkTable)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPprofextended(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPprofextended
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AttributeUnit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPprofextended
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AttributeUnit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AttributeUnit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeKey", wireType)
			}
			m.AttributeKey = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AttributeKey |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unit", wireType)
			}
			m.Unit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Unit |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPprofextended(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPprofextended
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Link) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPprofextended
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Link: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Link: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthPprofextended
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthPprofextended
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TraceId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthPprofextended
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthPprofextended
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.SpanId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPprofextended(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPprofextended
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ValueType) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPprofextended
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValueType: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValueType: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unit", wireType)
			}
			m.Unit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Unit |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregationTemporality", wireType)
			}
			m.AggregationTemporality = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AggregationTemporality |= AggregationTemporality(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPprofextended(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPprofextended
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Sample) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPprofextended
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Sample: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Sample: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPprofextended
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.LocationIndex = append(m.LocationIndex, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPprofextended
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPprofextended
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPprofextended
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.LocationIndex) == 0 {
					m.LocationIndex = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPprofextended
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.LocationIndex = append(m.LocationIndex, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field LocationIndex", wireType)
			}
		case 2:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPprofextended
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Value = append(m.Value, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPprofextended
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPprofextended
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPprofextended
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.Value) == 0 {
					m.Value = make([]int64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPprofextended
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Value = append(m.Value, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Label", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPprofextended
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPprofextended
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Label = append(m.Label, Label{})
			if err := m.Label[len(m.Label)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocationsStartIndex", wireType)
			}
			m.LocationsStartIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LocationsStartIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocationsLength", wireType)
			}
			m.LocationsLength = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LocationsLength |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StacktraceIdIndex", wireType)
			}
			m.StacktraceIdIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StacktraceIdIndex |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPprofextended
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Attributes = append(m.Attributes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPprofextended
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPprofextended
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPprofextended
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.Attributes) == 0 {
					m.Attributes = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPprofextended
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Attributes = append(m.Attributes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Link", wireType)
			}
			m.Link = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Link |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPprofextended
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.TimestampsUnixNano = append(m.TimestampsUnixNano, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPprofextended
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPprofextended
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPprofextended
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.TimestampsUnixNano) == 0 {
					m.TimestampsUnixNano = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPprofextended
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.TimestampsUnixNano = append(m.TimestampsUnixNano, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field TimestampsUnixNano", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPprofextended(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPprofextended
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Label) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPprofextended
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Label: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Label: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			m.Key = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Key |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Str", wireType)
			}
			m.Str = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Str |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Num", wireType)
			}
			m.Num = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Num |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumUnit", wireType)
			}
			m.NumUnit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumUnit |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPprofextended(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPprofextended
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Mapping) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPprofextended
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Mapping: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Mapping: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryStart", wireType)
			}
			m.MemoryStart = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MemoryStart |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryLimit", wireType)
			}
			m.MemoryLimit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MemoryLimit |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FileOffset", wireType)
			}
			m.FileOffset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FileOffset |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filename", wireType)
			}
			m.Filename = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Filename |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BuildId", wireType)
			}
			m.BuildId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BuildId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasFunctions", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasFunctions = bool(v != 0)
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasFilenames", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasFilenames = bool(v != 0)
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasLineNumbers", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasLineNumbers = bool(v != 0)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasInlineFrames", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasInlineFrames = bool(v != 0)
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BuildIdKind", wireType)
			}
			m.BuildIdKind = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BuildIdKind |= BuildIdKind(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPprofextended
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Attributes = append(m.Attributes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPprofextended
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPprofextended
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPprofextended
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.Attributes) == 0 {
					m.Attributes = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPprofextended
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Attributes = append(m.Attributes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPprofextended(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPprofextended
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Location) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPprofextended
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Location: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Location: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MappingIndex", wireType)
			}
			m.MappingIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MappingIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			m.Address = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Address |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Line", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPprofextended
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPprofextended
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Line = append(m.Line, Line{})
			if err := m.Line[len(m.Line)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsFolded", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsFolded = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypeIndex", wireType)
			}
			m.TypeIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TypeIndex |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPprofextended
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Attributes = append(m.Attributes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPprofextended
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPprofextended
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPprofextended
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.Attributes) == 0 {
					m.Attributes = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPprofextended
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Attributes = append(m.Attributes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPprofextended(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPprofextended
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Line) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPprofextended
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Line: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Line: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FunctionIndex", wireType)
			}
			m.FunctionIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FunctionIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Line", wireType)
			}
			m.Line = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Line |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Column", wireType)
			}
			m.Column = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Column |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPprofextended(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPprofextended
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Function) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPprofextended
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Function: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Function: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			m.Name = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Name |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SystemName", wireType)
			}
			m.SystemName = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SystemName |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filename", wireType)
			}
			m.Filename = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Filename |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartLine", wireType)
			}
			m.StartLine = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartLine |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPprofextended(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPprofextended
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipPprofextended(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowPprofextended
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPprofextended
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthPprofextended
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupPprofextended
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthPprofextended
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthPprofextended        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowPprofextended          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupPprofextended = fmt.Errorf("proto: unexpected end of group")
)
