/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// CpuArchitectureProperties struct for CpuArchitectureProperties
type CpuArchitectureProperties struct {
	// A valid CPU family name.
	CpuFamily *string `json:"cpuFamily,omitempty"`
	// The maximum number of cores available.
	MaxCores *int32 `json:"maxCores,omitempty"`
	// The maximum RAM size in MB.
	MaxRam *int32 `json:"maxRam,omitempty"`
	// A valid CPU vendor name.
	Vendor *string `json:"vendor,omitempty"`
}

// NewCpuArchitectureProperties instantiates a new CpuArchitectureProperties object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCpuArchitectureProperties() *CpuArchitectureProperties {
	this := CpuArchitectureProperties{}

	return &this
}

// NewCpuArchitecturePropertiesWithDefaults instantiates a new CpuArchitectureProperties object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCpuArchitecturePropertiesWithDefaults() *CpuArchitectureProperties {
	this := CpuArchitectureProperties{}
	return &this
}

// GetCpuFamily returns the CpuFamily field value
// If the value is explicit nil, nil is returned
func (o *CpuArchitectureProperties) GetCpuFamily() *string {
	if o == nil {
		return nil
	}

	return o.CpuFamily

}

// GetCpuFamilyOk returns a tuple with the CpuFamily field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *CpuArchitectureProperties) GetCpuFamilyOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.CpuFamily, true
}

// SetCpuFamily sets field value
func (o *CpuArchitectureProperties) SetCpuFamily(v string) {

	o.CpuFamily = &v

}

// HasCpuFamily returns a boolean if a field has been set.
func (o *CpuArchitectureProperties) HasCpuFamily() bool {
	if o != nil && o.CpuFamily != nil {
		return true
	}

	return false
}

// GetMaxCores returns the MaxCores field value
// If the value is explicit nil, nil is returned
func (o *CpuArchitectureProperties) GetMaxCores() *int32 {
	if o == nil {
		return nil
	}

	return o.MaxCores

}

// GetMaxCoresOk returns a tuple with the MaxCores field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *CpuArchitectureProperties) GetMaxCoresOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.MaxCores, true
}

// SetMaxCores sets field value
func (o *CpuArchitectureProperties) SetMaxCores(v int32) {

	o.MaxCores = &v

}

// HasMaxCores returns a boolean if a field has been set.
func (o *CpuArchitectureProperties) HasMaxCores() bool {
	if o != nil && o.MaxCores != nil {
		return true
	}

	return false
}

// GetMaxRam returns the MaxRam field value
// If the value is explicit nil, nil is returned
func (o *CpuArchitectureProperties) GetMaxRam() *int32 {
	if o == nil {
		return nil
	}

	return o.MaxRam

}

// GetMaxRamOk returns a tuple with the MaxRam field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *CpuArchitectureProperties) GetMaxRamOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.MaxRam, true
}

// SetMaxRam sets field value
func (o *CpuArchitectureProperties) SetMaxRam(v int32) {

	o.MaxRam = &v

}

// HasMaxRam returns a boolean if a field has been set.
func (o *CpuArchitectureProperties) HasMaxRam() bool {
	if o != nil && o.MaxRam != nil {
		return true
	}

	return false
}

// GetVendor returns the Vendor field value
// If the value is explicit nil, nil is returned
func (o *CpuArchitectureProperties) GetVendor() *string {
	if o == nil {
		return nil
	}

	return o.Vendor

}

// GetVendorOk returns a tuple with the Vendor field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *CpuArchitectureProperties) GetVendorOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Vendor, true
}

// SetVendor sets field value
func (o *CpuArchitectureProperties) SetVendor(v string) {

	o.Vendor = &v

}

// HasVendor returns a boolean if a field has been set.
func (o *CpuArchitectureProperties) HasVendor() bool {
	if o != nil && o.Vendor != nil {
		return true
	}

	return false
}

func (o CpuArchitectureProperties) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.CpuFamily != nil {
		toSerialize["cpuFamily"] = o.CpuFamily
	}

	if o.MaxCores != nil {
		toSerialize["maxCores"] = o.MaxCores
	}

	if o.MaxRam != nil {
		toSerialize["maxRam"] = o.MaxRam
	}

	if o.Vendor != nil {
		toSerialize["vendor"] = o.Vendor
	}

	return json.Marshal(toSerialize)
}

type NullableCpuArchitectureProperties struct {
	value *CpuArchitectureProperties
	isSet bool
}

func (v NullableCpuArchitectureProperties) Get() *CpuArchitectureProperties {
	return v.value
}

func (v *NullableCpuArchitectureProperties) Set(val *CpuArchitectureProperties) {
	v.value = val
	v.isSet = true
}

func (v NullableCpuArchitectureProperties) IsSet() bool {
	return v.isSet
}

func (v *NullableCpuArchitectureProperties) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCpuArchitectureProperties(val *CpuArchitectureProperties) *NullableCpuArchitectureProperties {
	return &NullableCpuArchitectureProperties{value: val, isSet: true}
}

func (v NullableCpuArchitectureProperties) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCpuArchitectureProperties) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
