function encodeQueryParams(paramConfigMap, query) {
  const encodedQuery = {};
  const paramNames = Object.keys(query);
  for (const paramName of paramNames) {
    const decodedValue = query[paramName];
    if (!paramConfigMap[paramName]) {
      encodedQuery[paramName] = decodedValue == null ? decodedValue : String(decodedValue);
    } else {
      encodedQuery[paramName] = paramConfigMap[paramName].encode(query[paramName]);
    }
  }
  return encodedQuery;
}
var encodeQueryParams_default = encodeQueryParams;
export {
  encodeQueryParams_default as default,
  encodeQueryParams
};
//# sourceMappingURL=encodeQueryParams.js.map
