"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

exports.__esModule = true;
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutPropertiesLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutPropertiesLoose"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _utils = require("./utils");

var _CustomFileInput = _interopRequireDefault(require("./CustomFileInput"));

var _excluded = ["className", "label", "inline", "valid", "invalid", "cssModule", "children", "bsSize", "innerRef", "htmlFor"],
    _excluded2 = ["type"],
    _excluded3 = ["hidden"];
var propTypes = {
  className: _propTypes.default.string,
  id: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]).isRequired,
  type: _propTypes.default.string.isRequired,
  label: _propTypes.default.node,
  inline: _propTypes.default.bool,
  valid: _propTypes.default.bool,
  invalid: _propTypes.default.bool,
  bsSize: _propTypes.default.string,
  htmlFor: _propTypes.default.string,
  cssModule: _propTypes.default.object,
  children: _propTypes.default.oneOfType([_propTypes.default.node, _propTypes.default.array, _propTypes.default.func]),
  innerRef: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string, _propTypes.default.func])
};

function CustomInput(props) {
  var className = props.className,
      label = props.label,
      inline = props.inline,
      valid = props.valid,
      invalid = props.invalid,
      cssModule = props.cssModule,
      children = props.children,
      bsSize = props.bsSize,
      innerRef = props.innerRef,
      htmlFor = props.htmlFor,
      attributes = (0, _objectWithoutPropertiesLoose2.default)(props, _excluded);
  var type = attributes.type;
  var customClass = (0, _utils.mapToCssModules)((0, _classnames.default)(className, "custom-" + type, bsSize ? "custom-" + type + "-" + bsSize : false), cssModule);
  var validationClassNames = (0, _utils.mapToCssModules)((0, _classnames.default)(invalid && "is-invalid", valid && "is-valid"), cssModule);
  var labelHtmlFor = htmlFor || attributes.id;

  if (type === "select") {
    var _type = attributes.type,
        _rest = (0, _objectWithoutPropertiesLoose2.default)(attributes, _excluded2);

    return /*#__PURE__*/_react.default.createElement("select", (0, _extends2.default)({}, _rest, {
      ref: innerRef,
      className: (0, _classnames.default)(validationClassNames, customClass),
      "aria-invalid": invalid
    }), children);
  }

  if (type === "file") {
    return /*#__PURE__*/_react.default.createElement(_CustomFileInput.default, props);
  }

  if (type !== "checkbox" && type !== "radio" && type !== "switch") {
    return /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({}, attributes, {
      ref: innerRef,
      "aria-invalid": invalid,
      className: (0, _classnames.default)(validationClassNames, customClass)
    }));
  }

  var wrapperClasses = (0, _classnames.default)(customClass, (0, _utils.mapToCssModules)((0, _classnames.default)("custom-control", {
    "custom-control-inline": inline
  }), cssModule));
  var hidden = attributes.hidden,
      rest = (0, _objectWithoutPropertiesLoose2.default)(attributes, _excluded3);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: wrapperClasses,
    hidden: hidden || false
  }, /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({}, rest, {
    type: type === "switch" ? "checkbox" : type,
    ref: innerRef,
    "aria-invalid": invalid,
    className: (0, _classnames.default)(validationClassNames, (0, _utils.mapToCssModules)("custom-control-input", cssModule))
  })), /*#__PURE__*/_react.default.createElement("label", {
    className: (0, _utils.mapToCssModules)("custom-control-label", cssModule),
    htmlFor: labelHtmlFor
  }, label), children);
}

CustomInput.propTypes = propTypes;
var _default = CustomInput;
exports.default = _default;