//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfstreamerror?language=objc)
#[cfg(feature = "CFBase")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFStreamError {
    pub domain: CFIndex,
    pub error: i32,
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFStreamError {
    const ENCODING: Encoding = Encoding::Struct("?", &[<CFIndex>::ENCODING, <i32>::ENCODING]);
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFStreamError {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfstreampropertykey?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
#[cfg(feature = "CFBase")]
pub type CFStreamPropertyKey = CFString;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfstreamstatus?language=objc)
// NS_ENUM
#[cfg(feature = "CFBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFStreamStatus(pub CFIndex);
#[cfg(feature = "CFBase")]
impl CFStreamStatus {
    #[doc(alias = "kCFStreamStatusNotOpen")]
    pub const NotOpen: Self = Self(0);
    #[doc(alias = "kCFStreamStatusOpening")]
    pub const Opening: Self = Self(1);
    #[doc(alias = "kCFStreamStatusOpen")]
    pub const Open: Self = Self(2);
    #[doc(alias = "kCFStreamStatusReading")]
    pub const Reading: Self = Self(3);
    #[doc(alias = "kCFStreamStatusWriting")]
    pub const Writing: Self = Self(4);
    #[doc(alias = "kCFStreamStatusAtEnd")]
    pub const AtEnd: Self = Self(5);
    #[doc(alias = "kCFStreamStatusClosed")]
    pub const Closed: Self = Self(6);
    #[doc(alias = "kCFStreamStatusError")]
    pub const Error: Self = Self(7);
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFStreamStatus {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFStreamStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfstreameventtype?language=objc)
// NS_OPTIONS
#[cfg(feature = "CFBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFStreamEventType(pub CFOptionFlags);
#[cfg(feature = "CFBase")]
bitflags::bitflags! {
    impl CFStreamEventType: CFOptionFlags {
        #[doc(alias = "kCFStreamEventNone")]
        const None = 0;
        #[doc(alias = "kCFStreamEventOpenCompleted")]
        const OpenCompleted = 1;
        #[doc(alias = "kCFStreamEventHasBytesAvailable")]
        const HasBytesAvailable = 2;
        #[doc(alias = "kCFStreamEventCanAcceptBytes")]
        const CanAcceptBytes = 4;
        #[doc(alias = "kCFStreamEventErrorOccurred")]
        const ErrorOccurred = 8;
        #[doc(alias = "kCFStreamEventEndEncountered")]
        const EndEncountered = 16;
    }
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFStreamEventType {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFStreamEventType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfstreamclientcontext?language=objc)
#[cfg(feature = "CFBase")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFStreamClientContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut c_void>,
    pub release: Option<unsafe extern "C-unwind" fn(*mut c_void)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(*mut c_void) -> *const CFString>,
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFStreamClientContext {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <*mut c_void>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut c_void>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*mut c_void)>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*mut c_void) -> *const CFString>>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFStreamClientContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfreadstream?language=objc)
#[repr(C)]
pub struct CFReadStream {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFReadStream"]
    unsafe impl CFReadStream {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfwritestream?language=objc)
#[repr(C)]
pub struct CFWriteStream {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFWriteStream"]
    unsafe impl CFWriteStream {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfreadstreamclientcallback?language=objc)
#[cfg(feature = "CFBase")]
pub type CFReadStreamClientCallBack =
    Option<unsafe extern "C-unwind" fn(*mut CFReadStream, CFStreamEventType, *mut c_void)>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfwritestreamclientcallback?language=objc)
#[cfg(feature = "CFBase")]
pub type CFWriteStreamClientCallBack =
    Option<unsafe extern "C-unwind" fn(*mut CFWriteStream, CFStreamEventType, *mut c_void)>;

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFReadStream {
    #[doc(alias = "CFReadStreamGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFReadStreamGetTypeID() -> CFTypeID;
        }
        unsafe { CFReadStreamGetTypeID() }
    }
}

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFWriteStream {
    #[doc(alias = "CFWriteStreamGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFWriteStreamGetTypeID() -> CFTypeID;
        }
        unsafe { CFWriteStreamGetTypeID() }
    }
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertydatawritten?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamPropertyDataWritten: Option<&'static CFStreamPropertyKey>;
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFReadStreamCreateWithBytesNoCopy(
    alloc: Option<&CFAllocator>,
    bytes: *const u8,
    length: CFIndex,
    bytes_deallocator: Option<&CFAllocator>,
) -> Option<CFRetained<CFReadStream>> {
    extern "C-unwind" {
        fn CFReadStreamCreateWithBytesNoCopy(
            alloc: Option<&CFAllocator>,
            bytes: *const u8,
            length: CFIndex,
            bytes_deallocator: Option<&CFAllocator>,
        ) -> Option<NonNull<CFReadStream>>;
    }
    let ret = unsafe { CFReadStreamCreateWithBytesNoCopy(alloc, bytes, length, bytes_deallocator) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFWriteStreamCreateWithBuffer(
    alloc: Option<&CFAllocator>,
    buffer: *mut u8,
    buffer_capacity: CFIndex,
) -> Option<CFRetained<CFWriteStream>> {
    extern "C-unwind" {
        fn CFWriteStreamCreateWithBuffer(
            alloc: Option<&CFAllocator>,
            buffer: *mut u8,
            buffer_capacity: CFIndex,
        ) -> Option<NonNull<CFWriteStream>>;
    }
    let ret = unsafe { CFWriteStreamCreateWithBuffer(alloc, buffer, buffer_capacity) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFWriteStreamCreateWithAllocatedBuffers(
    alloc: Option<&CFAllocator>,
    buffer_allocator: Option<&CFAllocator>,
) -> Option<CFRetained<CFWriteStream>> {
    extern "C-unwind" {
        fn CFWriteStreamCreateWithAllocatedBuffers(
            alloc: Option<&CFAllocator>,
            buffer_allocator: Option<&CFAllocator>,
        ) -> Option<NonNull<CFWriteStream>>;
    }
    let ret = unsafe { CFWriteStreamCreateWithAllocatedBuffers(alloc, buffer_allocator) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "CFURL"))]
#[inline]
pub unsafe extern "C-unwind" fn CFReadStreamCreateWithFile(
    alloc: Option<&CFAllocator>,
    file_url: Option<&CFURL>,
) -> Option<CFRetained<CFReadStream>> {
    extern "C-unwind" {
        fn CFReadStreamCreateWithFile(
            alloc: Option<&CFAllocator>,
            file_url: Option<&CFURL>,
        ) -> Option<NonNull<CFReadStream>>;
    }
    let ret = unsafe { CFReadStreamCreateWithFile(alloc, file_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "CFURL"))]
#[inline]
pub unsafe extern "C-unwind" fn CFWriteStreamCreateWithFile(
    alloc: Option<&CFAllocator>,
    file_url: Option<&CFURL>,
) -> Option<CFRetained<CFWriteStream>> {
    extern "C-unwind" {
        fn CFWriteStreamCreateWithFile(
            alloc: Option<&CFAllocator>,
            file_url: Option<&CFURL>,
        ) -> Option<NonNull<CFWriteStream>>;
    }
    let ret = unsafe { CFWriteStreamCreateWithFile(alloc, file_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStreamCreateBoundPair(
        alloc: Option<&CFAllocator>,
        read_stream: *mut *mut CFReadStream,
        write_stream: *mut *mut CFWriteStream,
        transfer_buffer_size: CFIndex,
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertyappendtofile?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamPropertyAppendToFile: Option<&'static CFStreamPropertyKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertyfilecurrentoffset?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamPropertyFileCurrentOffset: Option<&'static CFStreamPropertyKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysocketnativehandle?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamPropertySocketNativeHandle: Option<&'static CFStreamPropertyKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysocketremotehostname?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamPropertySocketRemoteHostName: Option<&'static CFStreamPropertyKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysocketremoteportnumber?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamPropertySocketRemotePortNumber: Option<&'static CFStreamPropertyKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreamerrordomainsocks?language=objc)
    pub static kCFStreamErrorDomainSOCKS: c_int;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysocksproxy?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamPropertySOCKSProxy: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysocksproxyhost?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamPropertySOCKSProxyHost: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysocksproxyport?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamPropertySOCKSProxyPort: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysocksversion?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamPropertySOCKSVersion: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreamsocketsocksversion4?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamSocketSOCKSVersion4: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreamsocketsocksversion5?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamSocketSOCKSVersion5: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysocksuser?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamPropertySOCKSUser: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysockspassword?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamPropertySOCKSPassword: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreamerrordomainssl?language=objc)
    pub static kCFStreamErrorDomainSSL: c_int;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysocketsecuritylevel?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamPropertySocketSecurityLevel: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreamsocketsecuritylevelnone?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamSocketSecurityLevelNone: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreamsocketsecuritylevelsslv2?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamSocketSecurityLevelSSLv2: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreamsocketsecuritylevelsslv3?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamSocketSecurityLevelSSLv3: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreamsocketsecurityleveltlsv1?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamSocketSecurityLevelTLSv1: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreamsocketsecuritylevelnegotiatedssl?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamSocketSecurityLevelNegotiatedSSL: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertyshouldclosenativesocket?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStreamPropertyShouldCloseNativeSocket: &'static CFString;
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "CFSocket"))]
    #[deprecated = "Use nw_connection_t in Network framework instead"]
    pub fn CFStreamCreatePairWithSocket(
        alloc: Option<&CFAllocator>,
        sock: CFSocketNativeHandle,
        read_stream: *mut *mut CFReadStream,
        write_stream: *mut *mut CFWriteStream,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    #[deprecated = "Use nw_connection_t in Network framework instead"]
    pub fn CFStreamCreatePairWithSocketToHost(
        alloc: Option<&CFAllocator>,
        host: Option<&CFString>,
        port: u32,
        read_stream: *mut *mut CFReadStream,
        write_stream: *mut *mut CFWriteStream,
    );
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "CFData", feature = "CFSocket"))]
    #[deprecated = "Use nw_connection_t in Network framework instead"]
    pub fn CFStreamCreatePairWithPeerSocketSignature(
        alloc: Option<&CFAllocator>,
        signature: *const CFSocketSignature,
        read_stream: *mut *mut CFReadStream,
        write_stream: *mut *mut CFWriteStream,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFReadStreamGetStatus(stream: &CFReadStream) -> CFStreamStatus;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFWriteStreamGetStatus(stream: &CFWriteStream) -> CFStreamStatus;
}

#[cfg(feature = "CFError")]
#[inline]
pub unsafe extern "C-unwind" fn CFReadStreamCopyError(
    stream: &CFReadStream,
) -> Option<CFRetained<CFError>> {
    extern "C-unwind" {
        fn CFReadStreamCopyError(stream: &CFReadStream) -> Option<NonNull<CFError>>;
    }
    let ret = unsafe { CFReadStreamCopyError(stream) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFError")]
#[inline]
pub unsafe extern "C-unwind" fn CFWriteStreamCopyError(
    stream: &CFWriteStream,
) -> Option<CFRetained<CFError>> {
    extern "C-unwind" {
        fn CFWriteStreamCopyError(stream: &CFWriteStream) -> Option<NonNull<CFError>>;
    }
    let ret = unsafe { CFWriteStreamCopyError(stream) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CFReadStreamOpen(stream: &CFReadStream) -> bool {
    extern "C-unwind" {
        fn CFReadStreamOpen(stream: &CFReadStream) -> Boolean;
    }
    let ret = unsafe { CFReadStreamOpen(stream) };
    ret != 0
}

#[inline]
pub unsafe extern "C-unwind" fn CFWriteStreamOpen(stream: &CFWriteStream) -> bool {
    extern "C-unwind" {
        fn CFWriteStreamOpen(stream: &CFWriteStream) -> Boolean;
    }
    let ret = unsafe { CFWriteStreamOpen(stream) };
    ret != 0
}

extern "C-unwind" {
    pub fn CFReadStreamClose(stream: &CFReadStream);
}

extern "C-unwind" {
    pub fn CFWriteStreamClose(stream: &CFWriteStream);
}

#[inline]
pub unsafe extern "C-unwind" fn CFReadStreamHasBytesAvailable(stream: &CFReadStream) -> bool {
    extern "C-unwind" {
        fn CFReadStreamHasBytesAvailable(stream: &CFReadStream) -> Boolean;
    }
    let ret = unsafe { CFReadStreamHasBytesAvailable(stream) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFReadStreamRead(
        stream: &CFReadStream,
        buffer: *mut u8,
        buffer_length: CFIndex,
    ) -> CFIndex;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFReadStreamGetBuffer(
        stream: &CFReadStream,
        max_bytes_to_read: CFIndex,
        num_bytes_read: *mut CFIndex,
    ) -> *const u8;
}

#[inline]
pub unsafe extern "C-unwind" fn CFWriteStreamCanAcceptBytes(stream: &CFWriteStream) -> bool {
    extern "C-unwind" {
        fn CFWriteStreamCanAcceptBytes(stream: &CFWriteStream) -> Boolean;
    }
    let ret = unsafe { CFWriteStreamCanAcceptBytes(stream) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFWriteStreamWrite(
        stream: &CFWriteStream,
        buffer: *const u8,
        buffer_length: CFIndex,
    ) -> CFIndex;
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFReadStreamCopyProperty(
    stream: &CFReadStream,
    property_name: Option<&CFStreamPropertyKey>,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn CFReadStreamCopyProperty(
            stream: &CFReadStream,
            property_name: Option<&CFStreamPropertyKey>,
        ) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe { CFReadStreamCopyProperty(stream, property_name) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFWriteStreamCopyProperty(
    stream: &CFWriteStream,
    property_name: Option<&CFStreamPropertyKey>,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn CFWriteStreamCopyProperty(
            stream: &CFWriteStream,
            property_name: Option<&CFStreamPropertyKey>,
        ) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe { CFWriteStreamCopyProperty(stream, property_name) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFReadStreamSetProperty(
    stream: &CFReadStream,
    property_name: Option<&CFStreamPropertyKey>,
    property_value: Option<&CFType>,
) -> bool {
    extern "C-unwind" {
        fn CFReadStreamSetProperty(
            stream: &CFReadStream,
            property_name: Option<&CFStreamPropertyKey>,
            property_value: Option<&CFType>,
        ) -> Boolean;
    }
    let ret = unsafe { CFReadStreamSetProperty(stream, property_name, property_value) };
    ret != 0
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFWriteStreamSetProperty(
    stream: &CFWriteStream,
    property_name: Option<&CFStreamPropertyKey>,
    property_value: Option<&CFType>,
) -> bool {
    extern "C-unwind" {
        fn CFWriteStreamSetProperty(
            stream: &CFWriteStream,
            property_name: Option<&CFStreamPropertyKey>,
            property_value: Option<&CFType>,
        ) -> Boolean;
    }
    let ret = unsafe { CFWriteStreamSetProperty(stream, property_name, property_value) };
    ret != 0
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFReadStreamSetClient(
    stream: &CFReadStream,
    stream_events: CFOptionFlags,
    client_cb: CFReadStreamClientCallBack,
    client_context: *mut CFStreamClientContext,
) -> bool {
    extern "C-unwind" {
        fn CFReadStreamSetClient(
            stream: &CFReadStream,
            stream_events: CFOptionFlags,
            client_cb: CFReadStreamClientCallBack,
            client_context: *mut CFStreamClientContext,
        ) -> Boolean;
    }
    let ret = unsafe { CFReadStreamSetClient(stream, stream_events, client_cb, client_context) };
    ret != 0
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFWriteStreamSetClient(
    stream: &CFWriteStream,
    stream_events: CFOptionFlags,
    client_cb: CFWriteStreamClientCallBack,
    client_context: *mut CFStreamClientContext,
) -> bool {
    extern "C-unwind" {
        fn CFWriteStreamSetClient(
            stream: &CFWriteStream,
            stream_events: CFOptionFlags,
            client_cb: CFWriteStreamClientCallBack,
            client_context: *mut CFStreamClientContext,
        ) -> Boolean;
    }
    let ret = unsafe { CFWriteStreamSetClient(stream, stream_events, client_cb, client_context) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "CFRunLoop"))]
    pub fn CFReadStreamScheduleWithRunLoop(
        stream: &CFReadStream,
        run_loop: Option<&CFRunLoop>,
        run_loop_mode: Option<&CFRunLoopMode>,
    );
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "CFRunLoop"))]
    pub fn CFWriteStreamScheduleWithRunLoop(
        stream: &CFWriteStream,
        run_loop: Option<&CFRunLoop>,
        run_loop_mode: Option<&CFRunLoopMode>,
    );
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "CFRunLoop"))]
    pub fn CFReadStreamUnscheduleFromRunLoop(
        stream: &CFReadStream,
        run_loop: Option<&CFRunLoop>,
        run_loop_mode: Option<&CFRunLoopMode>,
    );
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "CFRunLoop"))]
    pub fn CFWriteStreamUnscheduleFromRunLoop(
        stream: &CFWriteStream,
        run_loop: Option<&CFRunLoop>,
        run_loop_mode: Option<&CFRunLoopMode>,
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfstreamerrordomain?language=objc)
// NS_ENUM
#[cfg(feature = "CFBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFStreamErrorDomain(pub CFIndex);
#[cfg(feature = "CFBase")]
impl CFStreamErrorDomain {
    #[doc(alias = "kCFStreamErrorDomainCustom")]
    pub const Custom: Self = Self(-1);
    #[doc(alias = "kCFStreamErrorDomainPOSIX")]
    pub const POSIX: Self = Self(1);
    #[doc(alias = "kCFStreamErrorDomainMacOSStatus")]
    pub const MacOSStatus: Self = Self(2);
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFStreamErrorDomain {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFStreamErrorDomain {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFReadStreamGetError(stream: &CFReadStream) -> CFStreamError;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFWriteStreamGetError(stream: &CFWriteStream) -> CFStreamError;
}
