/*
 * Decompiled with CFR 0.152.
 */
package com.pegacat.jxworkbench;

import com.ca.commons.cbutil.CBDialog;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBUtility;
import com.ca.directory.jxplorer.JXConfig;
import com.pegacat.jxworkbench.JXWSaveLoadTemplate;
import java.awt.Component;
import java.awt.Frame;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;

public class JXWVault {
    private static char[] key;
    private static Logger log;
    private static JMenuItem vaultKey;
    private static JMenuItem vaultMgr;
    private static JMenuItem vaultClear;
    private static boolean userRefusedKeyEntry;

    public static char[] getKey() {
        return key;
    }

    public static void setKey(char[] newKey) {
        key = newKey;
    }

    public static void showVaultManager(Frame owner) {
        final JLabel header = new JLabel();
        final JPasswordField oldPwd = new JPasswordField();
        final JPasswordField newPwd = new JPasswordField();
        final JPasswordField confirmNewPwd = new JPasswordField();
        boolean hasOldPassword = JXWVault.getCheckCode() != 0;
        CBDialog dialog = new CBDialog(owner, CBIntText.get((String)"Password Vault Manager"), "workbench.vault"){

            public void doOK() {
                String confirmPassword;
                String newPassword = new String(newPwd.getPassword());
                if (newPassword.equals(confirmPassword = new String(confirmNewPwd.getPassword()))) {
                    int checkCode = JXWVault.getCheckCode();
                    if (checkCode != 0) {
                        String oldPassword = new String(oldPwd.getPassword());
                        if (oldPassword.hashCode() != checkCode) {
                            header.setText(CBIntText.get((String)"Old Passphrase incorrect - try again"));
                            oldPwd.setText("");
                            return;
                        }
                        JXWVault.recryptStoredPasswords(this.owner, oldPwd.getPassword(), newPwd.getPassword());
                    }
                    JXWVault.access$202(newPwd.getPassword());
                    JXWVault.setCheckCode(newPassword.hashCode());
                    JXWVault.setMenuState();
                    this.quit();
                } else {
                    header.setText(CBIntText.get((String)"New Passphrases do not match - try again"));
                }
            }
        };
        CBPanel display = dialog.getDisplayPanel();
        if (hasOldPassword) {
            header.setText(CBIntText.get((String)"Change Vault Passphrase"));
            header.setToolTipText(CBIntText.get((String)"note that this will change the encryption of all existing server passwords"));
            display.addWide((Component)header, 3);
            display.newLine();
            display.add((Component)new JLabel("   " + CBIntText.get((String)"Old Passphrase") + ": "));
            display.addGreedyWide((Component)oldPwd, 2);
            oldPwd.setToolTipText(CBIntText.get((String)"The existing vault passphrase"));
            display.newLine();
        } else {
            header.setText(CBIntText.get((String)"Set the initial passphrase for the Password Vault"));
            header.setToolTipText(CBIntText.get((String)"This sets an encryption key for server passwords "));
            display.addWide((Component)header, 3);
            display.newLine();
        }
        display.add((Component)new JLabel("   " + CBIntText.get((String)"New Passphrase") + ": "));
        display.addLine((Component)newPwd);
        newPwd.setToolTipText(CBIntText.get((String)"Set a new passphrase to lock the password vault"));
        display.add((Component)new JLabel("   " + CBIntText.get((String)"Confirm Passphrase") + ": "));
        display.addLine((Component)confirmNewPwd);
        confirmNewPwd.setToolTipText(CBIntText.get((String)"enter the new passphrase again "));
        dialog.setSize(360, 240);
        CBUtility.center((Component)dialog, (Component)owner);
        dialog.setVisible(true);
    }

    public static void registerMenuComponents(JMenuItem vaultKeyItem, JMenuItem vaultMgrItem, JMenuItem vaultClearItem) {
        vaultKey = vaultKeyItem;
        vaultMgr = vaultMgrItem;
        vaultClear = vaultClearItem;
    }

    public static void setMenuState() {
        boolean enabled = JXWVault.isEnabled();
        if (enabled) {
            vaultKey.setEnabled(!JXWVault.hasKey());
            vaultMgr.setEnabled(true);
            vaultClear.setEnabled(true);
        } else {
            vaultKey.setEnabled(false);
            vaultMgr.setEnabled(true);
            vaultClear.setEnabled(false);
        }
    }

    private static int getCheckCode() {
        try {
            String checkCodeString = JXConfig.getProperty((String)"checkcode");
            if (checkCodeString != null && checkCodeString.length() > 0) {
                int code = Integer.parseInt(checkCodeString);
                return code;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private static void setCheckCode(int code) {
        String checkCodeString = Integer.toString(code);
        JXConfig.setProperty((String)"checkcode", (String)checkCodeString);
        JXConfig.writePropertyFile();
    }

    public static boolean isEnabled() {
        String checkCodeString = JXConfig.getProperty((String)"checkcode");
        return checkCodeString != null && !"0".equals(checkCodeString);
    }

    public static boolean hasKey() {
        return key != null && key.length > 0;
    }

    public static void resetUserRefusedKeyEntry() {
        userRefusedKeyEntry = false;
    }

    public static void enterVaultKey(Frame owner) {
        final JLabel caption = new JLabel();
        final JPasswordField pwd = new JPasswordField();
        if (userRefusedKeyEntry) {
            return;
        }
        if (key == null && !JXWVault.isEnabled()) {
            JXWVault.showVaultManager(owner);
        } else {
            CBDialog dialog = new CBDialog(owner, CBIntText.get((String)"Password Vault Manager"), null){

                public void doOK() {
                    JXWVault.access$202(pwd.getPassword());
                    int checkCode = JXWVault.getCheckCode();
                    String keyString = new String(key);
                    if (checkCode != keyString.hashCode()) {
                        caption.setText(CBIntText.get((String)"Wrong Passphrase - try again"));
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        pwd.setText("");
                    } else {
                        JXWVault.setMenuState();
                        this.quit();
                    }
                }

                public void doCancel() {
                    JXWVault.access$202(null);
                    userRefusedKeyEntry = true;
                    super.doCancel();
                }
            };
            CBPanel display = dialog.getDisplayPanel();
            caption.setText(CBIntText.get((String)"Unlock Server Password Vault"));
            display.addLine((Component)caption);
            display.add((Component)new JLabel("   " + CBIntText.get((String)"Vault Passphrase") + ": "));
            display.addGreedyWide((Component)pwd);
            pwd.setToolTipText(CBIntText.get((String)"enter the passphrase to unlock the vault "));
            dialog.setSize(360, 120);
            CBUtility.center((Component)dialog, (Component)owner);
            dialog.setVisible(true);
        }
    }

    private static void recryptStoredPasswords(Frame owner, char[] oldPwd, char[] newPwd) {
        JXWSaveLoadTemplate template = JXWVault.getStandardSaveLoadTemplate();
        template.recodePasswords(oldPwd, newPwd);
        JOptionPane.showMessageDialog(owner, CBIntText.get((String)"Vault password has been changed"), CBIntText.get((String)"Recode Successful!"), 1);
    }

    protected static JXWSaveLoadTemplate getStandardSaveLoadTemplate() {
        JXWSaveLoadTemplate template = new JXWSaveLoadTemplate("connections.txt");
        return template;
    }

    public static String getMenuItem() {
        return "x12" + JXConfig.getProperty((String)"licenceKey") + ".getMouseX()";
    }

    public static void clearVault(Frame owner) {
        Object[] options = new Object[]{CBIntText.get((String)"Cancel"), CBIntText.get((String)"Clear Passwords")};
        int result = JOptionPane.showOptionDialog(owner, CBIntText.get((String)"Are you sure you want to clear ALL stored passwords and wipe the vault key?"), CBIntText.get((String)"Warning"), -1, 2, null, options, options[0]);
        if (result == 1) {
            JXWVault.clearPasswords();
            JOptionPane.showMessageDialog(owner, CBIntText.get((String)"Vault password has been cleared and passwords deleted"), CBIntText.get((String)"Success!"), 1);
        }
    }

    public static void clearPasswords() {
        JXWVault.setCheckCode(0);
        JXWSaveLoadTemplate template = JXWVault.getStandardSaveLoadTemplate();
        template.clearAllVaultPasswords();
        vaultKey.setEnabled(false);
        vaultClear.setEnabled(false);
    }

    static /* synthetic */ char[] access$202(char[] x0) {
        key = x0;
        return x0;
    }

    static {
        log = Logger.getLogger(JXWVault.class.getName());
        userRefusedKeyEntry = false;
    }
}

