/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.cert;

import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBDialog;
import com.ca.commons.cbutil.CBFileFilter;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBSecurity;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.cbutil.Theme;
import com.ca.commons.security.cert.CertDetailsViewPanel;
import com.ca.commons.security.cert.CertGeneralViewPanel;
import com.ca.commons.security.cert.CertPathViewPanel;
import com.ca.commons.security.util.CertUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;

public class CertViewer
extends CBDialog {
    private X509Certificate cert = null;
    private String fileName = null;
    private JTabbedPane tabs = new JTabbedPane();
    private CertGeneralViewPanel generalView = null;
    private CertDetailsViewPanel detailsView = null;
    private CertPathViewPanel pathView = null;
    private CBButton okButton;
    private CBButton saveButton;
    private CBButton loadButton;
    public static final int VIEW_ONLY = 0;
    public static final int VIEW_SAVE = 1;
    public static final int VIEW_LOAD = 2;
    public static final int VIEW_SAVE_LOAD = 3;
    public static final int VIEW_LOAD_SAVE = 3;
    protected int mode = 1;
    public static ImageIcon certLargeIcon = null;
    public static ImageIcon certIcon = null;
    public static ImageIcon attributeIcon = null;
    public static ImageIcon extensionIcon = null;
    public static ImageIcon criticalExtensionIcon = null;
    public static ImageIcon thumbprintIcon = null;
    public static Image frameIcon = null;
    public static Properties properties = null;
    public static String helpLink = null;

    protected static void setupGraphics() {
        try {
            certLargeIcon = CertViewer.getImageIcon("certificate_large.gif");
            certIcon = CertViewer.getImageIcon("certificate.gif");
            attributeIcon = CertViewer.getImageIcon("attribute.gif");
            extensionIcon = CertViewer.getImageIcon("extension.gif");
            criticalExtensionIcon = CertViewer.getImageIcon("criticalExtension.gif");
            thumbprintIcon = CertViewer.getImageIcon("thumbprint.gif");
            frameIcon = CertViewer.getImageIcon("pki_icon.gif").getImage();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static ImageIcon getImageIcon(String name) {
        if (properties == null) {
            return null;
        }
        ImageIcon newIcon = new ImageIcon(Theme.getInstance().getDirImages() + name);
        return newIcon;
    }

    public static void setupHelpLink(String link) {
        helpLink = link;
    }

    public static void setProperties(Properties props) {
        properties = props;
    }

    public static void setImageDirectory(String imagePath) {
        if (properties == null) {
            properties = new Properties();
        }
        properties.put("dir.images", imagePath);
    }

    public static CertAndFileName loadCertificate(Frame owner) {
        CertViewer viewer = new CertViewer(owner, null, 3);
        if (viewer.getCertificate() == null) {
            return null;
        }
        viewer.setVisible(true);
        CertAndFileName returnInfo = new CertAndFileName();
        returnInfo.cert = viewer.getCertificate();
        returnInfo.fileName = viewer.getFileName();
        return returnInfo;
    }

    public static CertAndFileName editCertificate(Frame owner, byte[] certData) {
        if (certData == null) {
            return CertViewer.loadCertificate(owner);
        }
        X509Certificate cert = CertUtil.loadX509Certificate(certData);
        CertViewer viewer = new CertViewer(owner, cert, 3);
        if (viewer.getCertificate() == null) {
            return null;
        }
        viewer.setVisible(true);
        CertAndFileName returnInfo = new CertAndFileName();
        returnInfo.cert = viewer.getCertificate();
        returnInfo.fileName = viewer.getFileName();
        return returnInfo;
    }

    public CertViewer(X509Certificate cert) {
        super(null, CBIntText.get("Certificate"), null);
        this.init(cert, 1);
    }

    public CertViewer(Frame owner, X509Certificate cert) {
        super(owner, CBIntText.get("Certificate"), helpLink);
        this.init(cert, 1);
    }

    public CertViewer(Frame owner, X509Certificate cert, int mode) {
        super(owner, CBIntText.get("Certificate"), helpLink);
        this.init(cert, mode);
    }

    public void init(X509Certificate cert, int mode) {
        if (certLargeIcon == null) {
            CertViewer.setupGraphics();
        }
        this.mode = mode;
        this.displayCert(cert);
        this.saveButton = new CBButton(CBIntText.get("Copy to File"), CBIntText.get("Copy to File"));
        this.loadButton = new CBButton(CBIntText.get("Read from File"), CBIntText.get("Read from File"));
        if (mode == 0 || mode == 1) {
            this.buttonPanel.remove(this.Cancel);
        }
        if (mode == 1 || mode == 3) {
            this.buttonPanel.add((Component)this.saveButton, 0);
        }
        if (mode == 2 || mode == 3) {
            this.buttonPanel.add((Component)this.loadButton, 0);
        }
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.setSize(440, 477);
        CBUtility.center(this, this.owner);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CertViewer.this.saveCert();
            }
        });
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CertViewer.this.loadCert();
            }
        });
        if (cert == null && (mode & 2) > 0) {
            this.loadCert();
        }
    }

    public void displayCert(X509Certificate displayCert) {
        this.cert = displayCert;
        this.tabs.removeAll();
        this.generalView = new CertGeneralViewPanel(displayCert);
        this.detailsView = new CertDetailsViewPanel(displayCert);
        this.pathView = new CertPathViewPanel(displayCert);
        this.tabs.add("General", this.generalView);
        this.tabs.add("Details", this.detailsView);
        this.tabs.add("Certification Path", this.pathView);
        this.display.removeAll();
        this.makeHeavy();
        this.display.add(this.tabs);
    }

    @Override
    public void doCancel() {
        this.cert = null;
        super.doCancel();
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public String getFileName() {
        return this.fileName;
    }

    protected void saveCert() {
        JFileChooser chooser = new JFileChooser(properties.getProperty("cert.homeDir", System.getProperty("user.dir")));
        chooser.addChoosableFileFilter(new CBFileFilter(new String[]{"der", "pem"}, CBIntText.get("Certificate File") + " (*.der) (*.pem)"));
        int option = chooser.showSaveDialog(this);
        File readFile = chooser.getSelectedFile();
        if (option != 0 || readFile == null) {
            return;
        }
        if (properties != null) {
            properties.setProperty("cert.homeDir", readFile.getParent());
        }
        this.fileName = readFile.toString();
        try {
            byte[] derout = this.cert.getEncoded();
            if (this.fileName.toLowerCase().endsWith(".pem")) {
                derout = CBSecurity.convertToPEMCertificate(derout);
            } else if (!this.fileName.toLowerCase().endsWith(".der")) {
                this.fileName = this.fileName + ".der";
                readFile = new File(this.fileName);
            }
            if (!this.saveFileCheck(readFile)) {
                return;
            }
            FileOutputStream fos = new FileOutputStream(readFile);
            fos.write(derout);
            fos.close();
        }
        catch (Exception ex) {
            CBUtility.error(CBIntText.get("Unable to save Certificate."), ex);
        }
    }

    public boolean saveFileCheck(File checkMe) {
        if (checkMe.isDirectory()) {
            CBUtility.error(checkMe.toString() + " is a directory.", null);
            return false;
        }
        if (checkMe.exists()) {
            int saveAnswer = JOptionPane.showConfirmDialog(this.owner, checkMe.toString() + "\n " + CBIntText.get("This file already exists.\nDo you want to overwrite this file?"), "Question", 2);
            return saveAnswer == 0;
        }
        return true;
    }

    protected void loadCert() {
        String browseDir = System.getProperty("user.dir");
        if (properties != null && properties.getProperty("cert.homeDir") != null) {
            browseDir = properties.getProperty("cert.homeDir");
        }
        JFileChooser chooser = new JFileChooser(browseDir);
        chooser.addChoosableFileFilter(new CBFileFilter(new String[]{"der", "pem"}, CBIntText.get("Certificate File") + " (*.der), (*.pem)"));
        int option = chooser.showOpenDialog(this);
        File readFile = chooser.getSelectedFile();
        if (option != 0 || readFile == null) {
            if (this.cert == null) {
                this.doCancel();
            }
            return;
        }
        try {
            if (properties != null) {
                properties.setProperty("cert.homeDir", readFile.getParent());
            }
            byte[] data = CertViewer.getDERCertDataFromFile(readFile);
            X509Certificate newCert = CertUtil.loadX509Certificate(data);
            this.displayCert(newCert);
            this.fileName = readFile.getName();
        }
        catch (Exception ex) {
            CBUtility.error(CBIntText.get("Unable to load Certificate."), ex);
        }
    }

    public static String getMostSignificantName(String dnstring) {
        String leftmostname = null;
        StringTokenizer stok = new StringTokenizer(dnstring, ",");
        if (stok.hasMoreTokens()) {
            leftmostname = stok.nextToken();
        }
        return leftmostname;
    }

    public static byte[] getDERCertDataFromFile(File file) throws CertificateParsingException, FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream(file);
        byte[] buffer = new byte[(int)file.length()];
        in.read(buffer);
        in.close();
        if (CBSecurity.isPEM(buffer)) {
            byte[] pemData = CBSecurity.convertFromPEMCertificate(buffer);
            if (pemData == null) {
                throw new CertificateParsingException("Unable to parse PEM encoded cert - invalid PEM encoding.");
            }
            buffer = pemData;
        }
        return buffer;
    }

    public static void main(String[] args) {
        JFrame parent = new JFrame();
        X509Certificate cert = null;
        try {
            byte[] data = CertViewer.getDERCertDataFromFile(new File(args[0]));
            cert = CertUtil.loadX509Certificate(data);
            if (cert == null) {
                System.out.println("Problem opening certfile \"" + args[0] + "\"");
                System.exit(1);
            }
            String localDir = System.getProperty("user.dir") + File.separator;
            Properties props = new Properties();
            props.setProperty("cert.homeDir", localDir + "certs" + File.separator);
            props.setProperty("dir.images", Theme.getInstance().getDirImages());
            CertViewer.setProperties(props);
            CertViewer me = new CertViewer((Frame)parent, cert);
            me.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            me.setVisible(true);
        }
        catch (Exception e) {
            System.err.println("ERROR OCCURRED");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static class CertAndFileName {
        public X509Certificate cert;
        public String fileName;
    }
}

