// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/resources/recommendation.proto

package resources // import "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import common "google.golang.org/genproto/googleapis/ads/googleads/v0/common"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v0/enums"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A recommendation.
type Recommendation struct {
	// The resource name of the recommendation.
	//
	// `customers/{customer_id}/recommendations/{recommendation_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The type of recommendation.
	Type enums.RecommendationTypeEnum_RecommendationType `protobuf:"varint,2,opt,name=type,proto3,enum=google.ads.googleads.v0.enums.RecommendationTypeEnum_RecommendationType" json:"type,omitempty"`
	// The impact on account performance as a result of applying the
	// recommendation.
	Impact *Recommendation_RecommendationImpact `protobuf:"bytes,3,opt,name=impact,proto3" json:"impact,omitempty"`
	// The budget targeted by this recommendation. This will be set only when
	// the recommendation affects a single campaign budget.
	//
	// This field will be set for the following recommendation types:
	// CAMPAIGN_BUDGET
	CampaignBudget *wrappers.StringValue `protobuf:"bytes,5,opt,name=campaign_budget,json=campaignBudget,proto3" json:"campaign_budget,omitempty"`
	// The campaign targeted by this recommendation. This will be set only when
	// the recommendation affects a single campaign.
	//
	// This field will be set for the following recommendation types:
	// ENHANCED_CPC_OPT_IN, KEYWORD, MAXIMIZE_CLICKS_OPT_IN,
	// MAXIMIZE_CONVERSIONS_OPT_IN, OPTIMIZE_AD_ROTATION, SEARCH_PARTNERS_OPT_IN,
	// TARGET_CPA_OPT_IN, TEXT_AD
	Campaign *wrappers.StringValue `protobuf:"bytes,6,opt,name=campaign,proto3" json:"campaign,omitempty"`
	// The ad group targeted by this recommendation. This will be set only when
	// the recommendation affects a single ad group.
	//
	// This field will be set for the following recommendation types:
	// KEYWORD, OPTIMIZE_AD_ROTATION, TEXT_AD
	AdGroup *wrappers.StringValue `protobuf:"bytes,7,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// Whether the recommendation is dismissed or not.
	Dismissed *wrappers.BoolValue `protobuf:"bytes,13,opt,name=dismissed,proto3" json:"dismissed,omitempty"`
	// The details of recommendation.
	//
	// Types that are valid to be assigned to Recommendation:
	//	*Recommendation_CampaignBudgetRecommendation_
	//	*Recommendation_KeywordRecommendation_
	//	*Recommendation_TextAdRecommendation_
	//	*Recommendation_TargetCpaOptInRecommendation_
	//	*Recommendation_MaximizeConversionsOptInRecommendation_
	//	*Recommendation_EnhancedCpcOptInRecommendation_
	//	*Recommendation_SearchPartnersOptInRecommendation_
	//	*Recommendation_MaximizeClicksOptInRecommendation_
	//	*Recommendation_OptimizeAdRotationRecommendation_
	Recommendation       isRecommendation_Recommendation `protobuf_oneof:"recommendation"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *Recommendation) Reset()         { *m = Recommendation{} }
func (m *Recommendation) String() string { return proto.CompactTextString(m) }
func (*Recommendation) ProtoMessage()    {}
func (*Recommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_d606c19f64e888c2, []int{0}
}
func (m *Recommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation.Unmarshal(m, b)
}
func (m *Recommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation.Merge(dst, src)
}
func (m *Recommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation.Size(m)
}
func (m *Recommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation proto.InternalMessageInfo

func (m *Recommendation) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *Recommendation) GetType() enums.RecommendationTypeEnum_RecommendationType {
	if m != nil {
		return m.Type
	}
	return enums.RecommendationTypeEnum_UNSPECIFIED
}

func (m *Recommendation) GetImpact() *Recommendation_RecommendationImpact {
	if m != nil {
		return m.Impact
	}
	return nil
}

func (m *Recommendation) GetCampaignBudget() *wrappers.StringValue {
	if m != nil {
		return m.CampaignBudget
	}
	return nil
}

func (m *Recommendation) GetCampaign() *wrappers.StringValue {
	if m != nil {
		return m.Campaign
	}
	return nil
}

func (m *Recommendation) GetAdGroup() *wrappers.StringValue {
	if m != nil {
		return m.AdGroup
	}
	return nil
}

func (m *Recommendation) GetDismissed() *wrappers.BoolValue {
	if m != nil {
		return m.Dismissed
	}
	return nil
}

type isRecommendation_Recommendation interface {
	isRecommendation_Recommendation()
}

type Recommendation_CampaignBudgetRecommendation_ struct {
	CampaignBudgetRecommendation *Recommendation_CampaignBudgetRecommendation `protobuf:"bytes,4,opt,name=campaign_budget_recommendation,json=campaignBudgetRecommendation,proto3,oneof"`
}

type Recommendation_KeywordRecommendation_ struct {
	KeywordRecommendation *Recommendation_KeywordRecommendation `protobuf:"bytes,8,opt,name=keyword_recommendation,json=keywordRecommendation,proto3,oneof"`
}

type Recommendation_TextAdRecommendation_ struct {
	TextAdRecommendation *Recommendation_TextAdRecommendation `protobuf:"bytes,9,opt,name=text_ad_recommendation,json=textAdRecommendation,proto3,oneof"`
}

type Recommendation_TargetCpaOptInRecommendation_ struct {
	TargetCpaOptInRecommendation *Recommendation_TargetCpaOptInRecommendation `protobuf:"bytes,10,opt,name=target_cpa_opt_in_recommendation,json=targetCpaOptInRecommendation,proto3,oneof"`
}

type Recommendation_MaximizeConversionsOptInRecommendation_ struct {
	MaximizeConversionsOptInRecommendation *Recommendation_MaximizeConversionsOptInRecommendation `protobuf:"bytes,11,opt,name=maximize_conversions_opt_in_recommendation,json=maximizeConversionsOptInRecommendation,proto3,oneof"`
}

type Recommendation_EnhancedCpcOptInRecommendation_ struct {
	EnhancedCpcOptInRecommendation *Recommendation_EnhancedCpcOptInRecommendation `protobuf:"bytes,12,opt,name=enhanced_cpc_opt_in_recommendation,json=enhancedCpcOptInRecommendation,proto3,oneof"`
}

type Recommendation_SearchPartnersOptInRecommendation_ struct {
	SearchPartnersOptInRecommendation *Recommendation_SearchPartnersOptInRecommendation `protobuf:"bytes,14,opt,name=search_partners_opt_in_recommendation,json=searchPartnersOptInRecommendation,proto3,oneof"`
}

type Recommendation_MaximizeClicksOptInRecommendation_ struct {
	MaximizeClicksOptInRecommendation *Recommendation_MaximizeClicksOptInRecommendation `protobuf:"bytes,15,opt,name=maximize_clicks_opt_in_recommendation,json=maximizeClicksOptInRecommendation,proto3,oneof"`
}

type Recommendation_OptimizeAdRotationRecommendation_ struct {
	OptimizeAdRotationRecommendation *Recommendation_OptimizeAdRotationRecommendation `protobuf:"bytes,16,opt,name=optimize_ad_rotation_recommendation,json=optimizeAdRotationRecommendation,proto3,oneof"`
}

func (*Recommendation_CampaignBudgetRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_KeywordRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_TextAdRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_TargetCpaOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_MaximizeConversionsOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_EnhancedCpcOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_SearchPartnersOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_MaximizeClicksOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_OptimizeAdRotationRecommendation_) isRecommendation_Recommendation() {}

func (m *Recommendation) GetRecommendation() isRecommendation_Recommendation {
	if m != nil {
		return m.Recommendation
	}
	return nil
}

func (m *Recommendation) GetCampaignBudgetRecommendation() *Recommendation_CampaignBudgetRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_CampaignBudgetRecommendation_); ok {
		return x.CampaignBudgetRecommendation
	}
	return nil
}

func (m *Recommendation) GetKeywordRecommendation() *Recommendation_KeywordRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_KeywordRecommendation_); ok {
		return x.KeywordRecommendation
	}
	return nil
}

func (m *Recommendation) GetTextAdRecommendation() *Recommendation_TextAdRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_TextAdRecommendation_); ok {
		return x.TextAdRecommendation
	}
	return nil
}

func (m *Recommendation) GetTargetCpaOptInRecommendation() *Recommendation_TargetCpaOptInRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_TargetCpaOptInRecommendation_); ok {
		return x.TargetCpaOptInRecommendation
	}
	return nil
}

func (m *Recommendation) GetMaximizeConversionsOptInRecommendation() *Recommendation_MaximizeConversionsOptInRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_MaximizeConversionsOptInRecommendation_); ok {
		return x.MaximizeConversionsOptInRecommendation
	}
	return nil
}

func (m *Recommendation) GetEnhancedCpcOptInRecommendation() *Recommendation_EnhancedCpcOptInRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_EnhancedCpcOptInRecommendation_); ok {
		return x.EnhancedCpcOptInRecommendation
	}
	return nil
}

func (m *Recommendation) GetSearchPartnersOptInRecommendation() *Recommendation_SearchPartnersOptInRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_SearchPartnersOptInRecommendation_); ok {
		return x.SearchPartnersOptInRecommendation
	}
	return nil
}

func (m *Recommendation) GetMaximizeClicksOptInRecommendation() *Recommendation_MaximizeClicksOptInRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_MaximizeClicksOptInRecommendation_); ok {
		return x.MaximizeClicksOptInRecommendation
	}
	return nil
}

func (m *Recommendation) GetOptimizeAdRotationRecommendation() *Recommendation_OptimizeAdRotationRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_OptimizeAdRotationRecommendation_); ok {
		return x.OptimizeAdRotationRecommendation
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Recommendation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Recommendation_OneofMarshaler, _Recommendation_OneofUnmarshaler, _Recommendation_OneofSizer, []interface{}{
		(*Recommendation_CampaignBudgetRecommendation_)(nil),
		(*Recommendation_KeywordRecommendation_)(nil),
		(*Recommendation_TextAdRecommendation_)(nil),
		(*Recommendation_TargetCpaOptInRecommendation_)(nil),
		(*Recommendation_MaximizeConversionsOptInRecommendation_)(nil),
		(*Recommendation_EnhancedCpcOptInRecommendation_)(nil),
		(*Recommendation_SearchPartnersOptInRecommendation_)(nil),
		(*Recommendation_MaximizeClicksOptInRecommendation_)(nil),
		(*Recommendation_OptimizeAdRotationRecommendation_)(nil),
	}
}

func _Recommendation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Recommendation)
	// recommendation
	switch x := m.Recommendation.(type) {
	case *Recommendation_CampaignBudgetRecommendation_:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CampaignBudgetRecommendation); err != nil {
			return err
		}
	case *Recommendation_KeywordRecommendation_:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.KeywordRecommendation); err != nil {
			return err
		}
	case *Recommendation_TextAdRecommendation_:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TextAdRecommendation); err != nil {
			return err
		}
	case *Recommendation_TargetCpaOptInRecommendation_:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TargetCpaOptInRecommendation); err != nil {
			return err
		}
	case *Recommendation_MaximizeConversionsOptInRecommendation_:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MaximizeConversionsOptInRecommendation); err != nil {
			return err
		}
	case *Recommendation_EnhancedCpcOptInRecommendation_:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.EnhancedCpcOptInRecommendation); err != nil {
			return err
		}
	case *Recommendation_SearchPartnersOptInRecommendation_:
		b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SearchPartnersOptInRecommendation); err != nil {
			return err
		}
	case *Recommendation_MaximizeClicksOptInRecommendation_:
		b.EncodeVarint(15<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MaximizeClicksOptInRecommendation); err != nil {
			return err
		}
	case *Recommendation_OptimizeAdRotationRecommendation_:
		b.EncodeVarint(16<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.OptimizeAdRotationRecommendation); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Recommendation.Recommendation has unexpected type %T", x)
	}
	return nil
}

func _Recommendation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Recommendation)
	switch tag {
	case 4: // recommendation.campaign_budget_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_CampaignBudgetRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_CampaignBudgetRecommendation_{msg}
		return true, err
	case 8: // recommendation.keyword_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_KeywordRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_KeywordRecommendation_{msg}
		return true, err
	case 9: // recommendation.text_ad_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_TextAdRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_TextAdRecommendation_{msg}
		return true, err
	case 10: // recommendation.target_cpa_opt_in_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_TargetCpaOptInRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_TargetCpaOptInRecommendation_{msg}
		return true, err
	case 11: // recommendation.maximize_conversions_opt_in_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_MaximizeConversionsOptInRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_MaximizeConversionsOptInRecommendation_{msg}
		return true, err
	case 12: // recommendation.enhanced_cpc_opt_in_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_EnhancedCpcOptInRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_EnhancedCpcOptInRecommendation_{msg}
		return true, err
	case 14: // recommendation.search_partners_opt_in_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_SearchPartnersOptInRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_SearchPartnersOptInRecommendation_{msg}
		return true, err
	case 15: // recommendation.maximize_clicks_opt_in_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_MaximizeClicksOptInRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_MaximizeClicksOptInRecommendation_{msg}
		return true, err
	case 16: // recommendation.optimize_ad_rotation_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_OptimizeAdRotationRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_OptimizeAdRotationRecommendation_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Recommendation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Recommendation)
	// recommendation
	switch x := m.Recommendation.(type) {
	case *Recommendation_CampaignBudgetRecommendation_:
		s := proto.Size(x.CampaignBudgetRecommendation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_KeywordRecommendation_:
		s := proto.Size(x.KeywordRecommendation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_TextAdRecommendation_:
		s := proto.Size(x.TextAdRecommendation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_TargetCpaOptInRecommendation_:
		s := proto.Size(x.TargetCpaOptInRecommendation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_MaximizeConversionsOptInRecommendation_:
		s := proto.Size(x.MaximizeConversionsOptInRecommendation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_EnhancedCpcOptInRecommendation_:
		s := proto.Size(x.EnhancedCpcOptInRecommendation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_SearchPartnersOptInRecommendation_:
		s := proto.Size(x.SearchPartnersOptInRecommendation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_MaximizeClicksOptInRecommendation_:
		s := proto.Size(x.MaximizeClicksOptInRecommendation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_OptimizeAdRotationRecommendation_:
		s := proto.Size(x.OptimizeAdRotationRecommendation)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The impact of making the change as described in the recommendation.
// Some types of recommendations may not have impact information.
type Recommendation_RecommendationImpact struct {
	// Base metrics at the time the recommendation was generated.
	BaseMetrics *Recommendation_RecommendationMetrics `protobuf:"bytes,1,opt,name=base_metrics,json=baseMetrics,proto3" json:"base_metrics,omitempty"`
	// Estimated metrics if the recommendation is applied.
	PotentialMetrics     *Recommendation_RecommendationMetrics `protobuf:"bytes,2,opt,name=potential_metrics,json=potentialMetrics,proto3" json:"potential_metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *Recommendation_RecommendationImpact) Reset()         { *m = Recommendation_RecommendationImpact{} }
func (m *Recommendation_RecommendationImpact) String() string { return proto.CompactTextString(m) }
func (*Recommendation_RecommendationImpact) ProtoMessage()    {}
func (*Recommendation_RecommendationImpact) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_d606c19f64e888c2, []int{0, 0}
}
func (m *Recommendation_RecommendationImpact) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_RecommendationImpact.Unmarshal(m, b)
}
func (m *Recommendation_RecommendationImpact) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_RecommendationImpact.Marshal(b, m, deterministic)
}
func (dst *Recommendation_RecommendationImpact) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_RecommendationImpact.Merge(dst, src)
}
func (m *Recommendation_RecommendationImpact) XXX_Size() int {
	return xxx_messageInfo_Recommendation_RecommendationImpact.Size(m)
}
func (m *Recommendation_RecommendationImpact) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_RecommendationImpact.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_RecommendationImpact proto.InternalMessageInfo

func (m *Recommendation_RecommendationImpact) GetBaseMetrics() *Recommendation_RecommendationMetrics {
	if m != nil {
		return m.BaseMetrics
	}
	return nil
}

func (m *Recommendation_RecommendationImpact) GetPotentialMetrics() *Recommendation_RecommendationMetrics {
	if m != nil {
		return m.PotentialMetrics
	}
	return nil
}

// Weekly account performance metrics. For some recommendation types, these
// are averaged over the past 90-day period and hence can be fractional.
type Recommendation_RecommendationMetrics struct {
	// Number of ad impressions.
	Impressions *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=impressions,proto3" json:"impressions,omitempty"`
	// Number of ad clicks.
	Clicks *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=clicks,proto3" json:"clicks,omitempty"`
	// Cost (in micros) for advertising, in the local currency for the account.
	CostMicros *wrappers.Int64Value `protobuf:"bytes,3,opt,name=cost_micros,json=costMicros,proto3" json:"cost_micros,omitempty"`
	// Number of conversions.
	Conversions *wrappers.DoubleValue `protobuf:"bytes,4,opt,name=conversions,proto3" json:"conversions,omitempty"`
	// Number of video views for a video ad campaign.
	VideoViews           *wrappers.DoubleValue `protobuf:"bytes,5,opt,name=video_views,json=videoViews,proto3" json:"video_views,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Recommendation_RecommendationMetrics) Reset()         { *m = Recommendation_RecommendationMetrics{} }
func (m *Recommendation_RecommendationMetrics) String() string { return proto.CompactTextString(m) }
func (*Recommendation_RecommendationMetrics) ProtoMessage()    {}
func (*Recommendation_RecommendationMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_d606c19f64e888c2, []int{0, 1}
}
func (m *Recommendation_RecommendationMetrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_RecommendationMetrics.Unmarshal(m, b)
}
func (m *Recommendation_RecommendationMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_RecommendationMetrics.Marshal(b, m, deterministic)
}
func (dst *Recommendation_RecommendationMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_RecommendationMetrics.Merge(dst, src)
}
func (m *Recommendation_RecommendationMetrics) XXX_Size() int {
	return xxx_messageInfo_Recommendation_RecommendationMetrics.Size(m)
}
func (m *Recommendation_RecommendationMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_RecommendationMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_RecommendationMetrics proto.InternalMessageInfo

func (m *Recommendation_RecommendationMetrics) GetImpressions() *wrappers.DoubleValue {
	if m != nil {
		return m.Impressions
	}
	return nil
}

func (m *Recommendation_RecommendationMetrics) GetClicks() *wrappers.DoubleValue {
	if m != nil {
		return m.Clicks
	}
	return nil
}

func (m *Recommendation_RecommendationMetrics) GetCostMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CostMicros
	}
	return nil
}

func (m *Recommendation_RecommendationMetrics) GetConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.Conversions
	}
	return nil
}

func (m *Recommendation_RecommendationMetrics) GetVideoViews() *wrappers.DoubleValue {
	if m != nil {
		return m.VideoViews
	}
	return nil
}

// The budget recommendation for budget constrained campaigns.
type Recommendation_CampaignBudgetRecommendation struct {
	// The current budget amount in micros.
	CurrentBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=current_budget_amount_micros,json=currentBudgetAmountMicros,proto3" json:"current_budget_amount_micros,omitempty"`
	// The recommended budget amount in micros.
	RecommendedBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=recommended_budget_amount_micros,json=recommendedBudgetAmountMicros,proto3" json:"recommended_budget_amount_micros,omitempty"`
	// The budget amounts and associated impact estimates for some values of
	// possible budget amounts.
	BudgetOptions        []*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption `protobuf:"bytes,3,rep,name=budget_options,json=budgetOptions,proto3" json:"budget_options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                                          `json:"-"`
	XXX_unrecognized     []byte                                                                            `json:"-"`
	XXX_sizecache        int32                                                                             `json:"-"`
}

func (m *Recommendation_CampaignBudgetRecommendation) Reset() {
	*m = Recommendation_CampaignBudgetRecommendation{}
}
func (m *Recommendation_CampaignBudgetRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_CampaignBudgetRecommendation) ProtoMessage() {}
func (*Recommendation_CampaignBudgetRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_d606c19f64e888c2, []int{0, 2}
}
func (m *Recommendation_CampaignBudgetRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_CampaignBudgetRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_CampaignBudgetRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_CampaignBudgetRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_CampaignBudgetRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_CampaignBudgetRecommendation.Merge(dst, src)
}
func (m *Recommendation_CampaignBudgetRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_CampaignBudgetRecommendation.Size(m)
}
func (m *Recommendation_CampaignBudgetRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_CampaignBudgetRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_CampaignBudgetRecommendation proto.InternalMessageInfo

func (m *Recommendation_CampaignBudgetRecommendation) GetCurrentBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CurrentBudgetAmountMicros
	}
	return nil
}

func (m *Recommendation_CampaignBudgetRecommendation) GetRecommendedBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetAmountMicros
	}
	return nil
}

func (m *Recommendation_CampaignBudgetRecommendation) GetBudgetOptions() []*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption {
	if m != nil {
		return m.BudgetOptions
	}
	return nil
}

// The impact estimates for a given budget amount.
type Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption struct {
	// The budget amount for this option.
	BudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=budget_amount_micros,json=budgetAmountMicros,proto3" json:"budget_amount_micros,omitempty"`
	// The impact estimate if budget is changed to amount specified in this
	// option.
	Impact               *Recommendation_RecommendationImpact `protobuf:"bytes,2,opt,name=impact,proto3" json:"impact,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) Reset() {
	*m = Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption{}
}
func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) ProtoMessage() {
}
func (*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_d606c19f64e888c2, []int{0, 2, 0}
}
func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption.Unmarshal(m, b)
}
func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption.Marshal(b, m, deterministic)
}
func (dst *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption.Merge(dst, src)
}
func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) XXX_Size() int {
	return xxx_messageInfo_Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption.Size(m)
}
func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption proto.InternalMessageInfo

func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) GetBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.BudgetAmountMicros
	}
	return nil
}

func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) GetImpact() *Recommendation_RecommendationImpact {
	if m != nil {
		return m.Impact
	}
	return nil
}

// The keyword recommendation.
type Recommendation_KeywordRecommendation struct {
	// The recommended keyword.
	Keyword *common.KeywordInfo `protobuf:"bytes,1,opt,name=keyword,proto3" json:"keyword,omitempty"`
	// The recommended CPC (cost-per-click) bid.
	RecommendedCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=recommended_cpc_bid_micros,json=recommendedCpcBidMicros,proto3" json:"recommended_cpc_bid_micros,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}             `json:"-"`
	XXX_unrecognized        []byte               `json:"-"`
	XXX_sizecache           int32                `json:"-"`
}

func (m *Recommendation_KeywordRecommendation) Reset()         { *m = Recommendation_KeywordRecommendation{} }
func (m *Recommendation_KeywordRecommendation) String() string { return proto.CompactTextString(m) }
func (*Recommendation_KeywordRecommendation) ProtoMessage()    {}
func (*Recommendation_KeywordRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_d606c19f64e888c2, []int{0, 3}
}
func (m *Recommendation_KeywordRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_KeywordRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_KeywordRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_KeywordRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_KeywordRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_KeywordRecommendation.Merge(dst, src)
}
func (m *Recommendation_KeywordRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_KeywordRecommendation.Size(m)
}
func (m *Recommendation_KeywordRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_KeywordRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_KeywordRecommendation proto.InternalMessageInfo

func (m *Recommendation_KeywordRecommendation) GetKeyword() *common.KeywordInfo {
	if m != nil {
		return m.Keyword
	}
	return nil
}

func (m *Recommendation_KeywordRecommendation) GetRecommendedCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedCpcBidMicros
	}
	return nil
}

// The text ad recommendation.
type Recommendation_TextAdRecommendation struct {
	// Recommended ad.
	Ad *Ad `protobuf:"bytes,1,opt,name=ad,proto3" json:"ad,omitempty"`
	// Creation date of the recommended ad.
	// YYYY-MM-DD format, e.g., 2018-04-17.
	CreationDate *wrappers.StringValue `protobuf:"bytes,2,opt,name=creation_date,json=creationDate,proto3" json:"creation_date,omitempty"`
	// Date, if present, is the earliest when the recommendation will be auto
	// applied.
	// YYYY-MM-DD format, e.g., 2018-04-17.
	AutoApplyDate        *wrappers.StringValue `protobuf:"bytes,3,opt,name=auto_apply_date,json=autoApplyDate,proto3" json:"auto_apply_date,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Recommendation_TextAdRecommendation) Reset()         { *m = Recommendation_TextAdRecommendation{} }
func (m *Recommendation_TextAdRecommendation) String() string { return proto.CompactTextString(m) }
func (*Recommendation_TextAdRecommendation) ProtoMessage()    {}
func (*Recommendation_TextAdRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_d606c19f64e888c2, []int{0, 4}
}
func (m *Recommendation_TextAdRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_TextAdRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_TextAdRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_TextAdRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_TextAdRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_TextAdRecommendation.Merge(dst, src)
}
func (m *Recommendation_TextAdRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_TextAdRecommendation.Size(m)
}
func (m *Recommendation_TextAdRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_TextAdRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_TextAdRecommendation proto.InternalMessageInfo

func (m *Recommendation_TextAdRecommendation) GetAd() *Ad {
	if m != nil {
		return m.Ad
	}
	return nil
}

func (m *Recommendation_TextAdRecommendation) GetCreationDate() *wrappers.StringValue {
	if m != nil {
		return m.CreationDate
	}
	return nil
}

func (m *Recommendation_TextAdRecommendation) GetAutoApplyDate() *wrappers.StringValue {
	if m != nil {
		return m.AutoApplyDate
	}
	return nil
}

// The Target CPA opt-in recommendation.
type Recommendation_TargetCpaOptInRecommendation struct {
	// The available goals and corresponding options for Target CPA strategy.
	Options []*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption `protobuf:"bytes,1,rep,name=options,proto3" json:"options,omitempty"`
	// The recommended average CPA target. See required budget amount and impact
	// of using this recommendation in options list.
	RecommendedTargetCpaMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=recommended_target_cpa_micros,json=recommendedTargetCpaMicros,proto3" json:"recommended_target_cpa_micros,omitempty"`
	XXX_NoUnkeyedLiteral       struct{}             `json:"-"`
	XXX_unrecognized           []byte               `json:"-"`
	XXX_sizecache              int32                `json:"-"`
}

func (m *Recommendation_TargetCpaOptInRecommendation) Reset() {
	*m = Recommendation_TargetCpaOptInRecommendation{}
}
func (m *Recommendation_TargetCpaOptInRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_TargetCpaOptInRecommendation) ProtoMessage() {}
func (*Recommendation_TargetCpaOptInRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_d606c19f64e888c2, []int{0, 5}
}
func (m *Recommendation_TargetCpaOptInRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_TargetCpaOptInRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_TargetCpaOptInRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation.Merge(dst, src)
}
func (m *Recommendation_TargetCpaOptInRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation.Size(m)
}
func (m *Recommendation_TargetCpaOptInRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation proto.InternalMessageInfo

func (m *Recommendation_TargetCpaOptInRecommendation) GetOptions() []*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *Recommendation_TargetCpaOptInRecommendation) GetRecommendedTargetCpaMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedTargetCpaMicros
	}
	return nil
}

// The Target CPA opt-in option with impact estimate.
type Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption struct {
	// The goal achieved by this option.
	Goal enums.TargetCpaOptInRecommendationGoalEnum_TargetCpaOptInRecommendationGoal `protobuf:"varint,1,opt,name=goal,proto3,enum=google.ads.googleads.v0.enums.TargetCpaOptInRecommendationGoalEnum_TargetCpaOptInRecommendationGoal" json:"goal,omitempty"`
	// Average CPA target.
	TargetCpaMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=target_cpa_micros,json=targetCpaMicros,proto3" json:"target_cpa_micros,omitempty"`
	// The minimum campaign budget, in local currency for the account,
	// required to achieve the target CPA.
	// Amount is specified in micros, where one million is equivalent to one
	// currency unit.
	RequiredCampaignBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,3,opt,name=required_campaign_budget_amount_micros,json=requiredCampaignBudgetAmountMicros,proto3" json:"required_campaign_budget_amount_micros,omitempty"`
	// The impact estimate if this option is selected.
	Impact               *Recommendation_RecommendationImpact `protobuf:"bytes,4,opt,name=impact,proto3" json:"impact,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) Reset() {
	*m = Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption{}
}
func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) ProtoMessage() {
}
func (*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_d606c19f64e888c2, []int{0, 5, 0}
}
func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption.Unmarshal(m, b)
}
func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption.Marshal(b, m, deterministic)
}
func (dst *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption.Merge(dst, src)
}
func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) XXX_Size() int {
	return xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption.Size(m)
}
func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption proto.InternalMessageInfo

func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) GetGoal() enums.TargetCpaOptInRecommendationGoalEnum_TargetCpaOptInRecommendationGoal {
	if m != nil {
		return m.Goal
	}
	return enums.TargetCpaOptInRecommendationGoalEnum_UNSPECIFIED
}

func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) GetTargetCpaMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TargetCpaMicros
	}
	return nil
}

func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) GetRequiredCampaignBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RequiredCampaignBudgetAmountMicros
	}
	return nil
}

func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) GetImpact() *Recommendation_RecommendationImpact {
	if m != nil {
		return m.Impact
	}
	return nil
}

// The Maximize Conversions Opt-In recommendation.
type Recommendation_MaximizeConversionsOptInRecommendation struct {
	// The recommended new budget amount.
	RecommendedBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=recommended_budget_amount_micros,json=recommendedBudgetAmountMicros,proto3" json:"recommended_budget_amount_micros,omitempty"`
	XXX_NoUnkeyedLiteral          struct{}             `json:"-"`
	XXX_unrecognized              []byte               `json:"-"`
	XXX_sizecache                 int32                `json:"-"`
}

func (m *Recommendation_MaximizeConversionsOptInRecommendation) Reset() {
	*m = Recommendation_MaximizeConversionsOptInRecommendation{}
}
func (m *Recommendation_MaximizeConversionsOptInRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_MaximizeConversionsOptInRecommendation) ProtoMessage() {}
func (*Recommendation_MaximizeConversionsOptInRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_d606c19f64e888c2, []int{0, 6}
}
func (m *Recommendation_MaximizeConversionsOptInRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_MaximizeConversionsOptInRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_MaximizeConversionsOptInRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_MaximizeConversionsOptInRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_MaximizeConversionsOptInRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_MaximizeConversionsOptInRecommendation.Merge(dst, src)
}
func (m *Recommendation_MaximizeConversionsOptInRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_MaximizeConversionsOptInRecommendation.Size(m)
}
func (m *Recommendation_MaximizeConversionsOptInRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_MaximizeConversionsOptInRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_MaximizeConversionsOptInRecommendation proto.InternalMessageInfo

func (m *Recommendation_MaximizeConversionsOptInRecommendation) GetRecommendedBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetAmountMicros
	}
	return nil
}

// The Enhanced Cost-Per-Click Opt-In recommendation.
type Recommendation_EnhancedCpcOptInRecommendation struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Recommendation_EnhancedCpcOptInRecommendation) Reset() {
	*m = Recommendation_EnhancedCpcOptInRecommendation{}
}
func (m *Recommendation_EnhancedCpcOptInRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_EnhancedCpcOptInRecommendation) ProtoMessage() {}
func (*Recommendation_EnhancedCpcOptInRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_d606c19f64e888c2, []int{0, 7}
}
func (m *Recommendation_EnhancedCpcOptInRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_EnhancedCpcOptInRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_EnhancedCpcOptInRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_EnhancedCpcOptInRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_EnhancedCpcOptInRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_EnhancedCpcOptInRecommendation.Merge(dst, src)
}
func (m *Recommendation_EnhancedCpcOptInRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_EnhancedCpcOptInRecommendation.Size(m)
}
func (m *Recommendation_EnhancedCpcOptInRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_EnhancedCpcOptInRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_EnhancedCpcOptInRecommendation proto.InternalMessageInfo

// The Search Partners Opt-In recommendation.
type Recommendation_SearchPartnersOptInRecommendation struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Recommendation_SearchPartnersOptInRecommendation) Reset() {
	*m = Recommendation_SearchPartnersOptInRecommendation{}
}
func (m *Recommendation_SearchPartnersOptInRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_SearchPartnersOptInRecommendation) ProtoMessage() {}
func (*Recommendation_SearchPartnersOptInRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_d606c19f64e888c2, []int{0, 8}
}
func (m *Recommendation_SearchPartnersOptInRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_SearchPartnersOptInRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_SearchPartnersOptInRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_SearchPartnersOptInRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_SearchPartnersOptInRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_SearchPartnersOptInRecommendation.Merge(dst, src)
}
func (m *Recommendation_SearchPartnersOptInRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_SearchPartnersOptInRecommendation.Size(m)
}
func (m *Recommendation_SearchPartnersOptInRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_SearchPartnersOptInRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_SearchPartnersOptInRecommendation proto.InternalMessageInfo

// The Maximize Clicks opt-in recommendation.
type Recommendation_MaximizeClicksOptInRecommendation struct {
	// The recommended new budget amount.
	// Only set if the current budget is too high.
	RecommendedBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=recommended_budget_amount_micros,json=recommendedBudgetAmountMicros,proto3" json:"recommended_budget_amount_micros,omitempty"`
	XXX_NoUnkeyedLiteral          struct{}             `json:"-"`
	XXX_unrecognized              []byte               `json:"-"`
	XXX_sizecache                 int32                `json:"-"`
}

func (m *Recommendation_MaximizeClicksOptInRecommendation) Reset() {
	*m = Recommendation_MaximizeClicksOptInRecommendation{}
}
func (m *Recommendation_MaximizeClicksOptInRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_MaximizeClicksOptInRecommendation) ProtoMessage() {}
func (*Recommendation_MaximizeClicksOptInRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_d606c19f64e888c2, []int{0, 9}
}
func (m *Recommendation_MaximizeClicksOptInRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_MaximizeClicksOptInRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_MaximizeClicksOptInRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_MaximizeClicksOptInRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_MaximizeClicksOptInRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_MaximizeClicksOptInRecommendation.Merge(dst, src)
}
func (m *Recommendation_MaximizeClicksOptInRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_MaximizeClicksOptInRecommendation.Size(m)
}
func (m *Recommendation_MaximizeClicksOptInRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_MaximizeClicksOptInRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_MaximizeClicksOptInRecommendation proto.InternalMessageInfo

func (m *Recommendation_MaximizeClicksOptInRecommendation) GetRecommendedBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetAmountMicros
	}
	return nil
}

// The Optimize Ad Rotation recommendation.
type Recommendation_OptimizeAdRotationRecommendation struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Recommendation_OptimizeAdRotationRecommendation) Reset() {
	*m = Recommendation_OptimizeAdRotationRecommendation{}
}
func (m *Recommendation_OptimizeAdRotationRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_OptimizeAdRotationRecommendation) ProtoMessage() {}
func (*Recommendation_OptimizeAdRotationRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_d606c19f64e888c2, []int{0, 10}
}
func (m *Recommendation_OptimizeAdRotationRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_OptimizeAdRotationRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_OptimizeAdRotationRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_OptimizeAdRotationRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_OptimizeAdRotationRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_OptimizeAdRotationRecommendation.Merge(dst, src)
}
func (m *Recommendation_OptimizeAdRotationRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_OptimizeAdRotationRecommendation.Size(m)
}
func (m *Recommendation_OptimizeAdRotationRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_OptimizeAdRotationRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_OptimizeAdRotationRecommendation proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Recommendation)(nil), "google.ads.googleads.v0.resources.Recommendation")
	proto.RegisterType((*Recommendation_RecommendationImpact)(nil), "google.ads.googleads.v0.resources.Recommendation.RecommendationImpact")
	proto.RegisterType((*Recommendation_RecommendationMetrics)(nil), "google.ads.googleads.v0.resources.Recommendation.RecommendationMetrics")
	proto.RegisterType((*Recommendation_CampaignBudgetRecommendation)(nil), "google.ads.googleads.v0.resources.Recommendation.CampaignBudgetRecommendation")
	proto.RegisterType((*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption)(nil), "google.ads.googleads.v0.resources.Recommendation.CampaignBudgetRecommendation.CampaignBudgetRecommendationOption")
	proto.RegisterType((*Recommendation_KeywordRecommendation)(nil), "google.ads.googleads.v0.resources.Recommendation.KeywordRecommendation")
	proto.RegisterType((*Recommendation_TextAdRecommendation)(nil), "google.ads.googleads.v0.resources.Recommendation.TextAdRecommendation")
	proto.RegisterType((*Recommendation_TargetCpaOptInRecommendation)(nil), "google.ads.googleads.v0.resources.Recommendation.TargetCpaOptInRecommendation")
	proto.RegisterType((*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption)(nil), "google.ads.googleads.v0.resources.Recommendation.TargetCpaOptInRecommendation.TargetCpaOptInRecommendationOption")
	proto.RegisterType((*Recommendation_MaximizeConversionsOptInRecommendation)(nil), "google.ads.googleads.v0.resources.Recommendation.MaximizeConversionsOptInRecommendation")
	proto.RegisterType((*Recommendation_EnhancedCpcOptInRecommendation)(nil), "google.ads.googleads.v0.resources.Recommendation.EnhancedCpcOptInRecommendation")
	proto.RegisterType((*Recommendation_SearchPartnersOptInRecommendation)(nil), "google.ads.googleads.v0.resources.Recommendation.SearchPartnersOptInRecommendation")
	proto.RegisterType((*Recommendation_MaximizeClicksOptInRecommendation)(nil), "google.ads.googleads.v0.resources.Recommendation.MaximizeClicksOptInRecommendation")
	proto.RegisterType((*Recommendation_OptimizeAdRotationRecommendation)(nil), "google.ads.googleads.v0.resources.Recommendation.OptimizeAdRotationRecommendation")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/resources/recommendation.proto", fileDescriptor_recommendation_d606c19f64e888c2)
}

var fileDescriptor_recommendation_d606c19f64e888c2 = []byte{
	// 1336 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0x4d, 0x6f, 0xdc, 0x44,
	0x18, 0xc6, 0x9b, 0x34, 0x69, 0xdf, 0x4d, 0x36, 0xed, 0x90, 0x96, 0xc5, 0x84, 0x68, 0x93, 0x92,
	0x2a, 0x2a, 0x62, 0x37, 0x0a, 0xa5, 0xad, 0x96, 0x0f, 0x69, 0x93, 0x86, 0x34, 0xa0, 0xb4, 0x91,
	0x5b, 0x45, 0x15, 0x8a, 0x6a, 0xcd, 0x7a, 0xa6, 0x5b, 0xd3, 0xb5, 0xc7, 0x1d, 0xcf, 0xa6, 0x09,
	0x07, 0xd4, 0x23, 0x08, 0x89, 0x23, 0xea, 0x89, 0x03, 0x1c, 0x90, 0xf8, 0x01, 0xa8, 0xff, 0x00,
	0xa9, 0xd7, 0x4a, 0xfc, 0x08, 0x7e, 0x01, 0x47, 0xe4, 0xf1, 0xd8, 0xd9, 0x0f, 0x7f, 0xec, 0x2e,
	0x2d, 0x37, 0xdb, 0xf3, 0x3c, 0xcf, 0xfb, 0xcc, 0xe7, 0xfb, 0x8e, 0xe1, 0x6a, 0x8b, 0xb1, 0x56,
	0x9b, 0xd6, 0x30, 0xf1, 0x6b, 0xe1, 0x63, 0xf0, 0x74, 0xb8, 0x56, 0xe3, 0xd4, 0x67, 0x1d, 0x6e,
	0x51, 0xbf, 0xc6, 0xa9, 0xc5, 0x1c, 0x87, 0xba, 0x04, 0x0b, 0x9b, 0xb9, 0x55, 0x8f, 0x33, 0xc1,
	0xd0, 0x52, 0x08, 0xae, 0x62, 0xe2, 0x57, 0x63, 0x5e, 0xf5, 0x70, 0xad, 0x1a, 0xf3, 0xf4, 0x0f,
	0xd2, 0xa4, 0x03, 0x39, 0xe6, 0xd6, 0x2c, 0x6e, 0x0b, 0xca, 0x6d, 0x1c, 0x2a, 0xea, 0xd7, 0xd2,
	0xe0, 0xd4, 0xed, 0x38, 0xfd, 0x2e, 0x4c, 0x71, 0xec, 0x51, 0x45, 0xdc, 0xc9, 0x26, 0x0a, 0xcc,
	0x5b, 0x54, 0x98, 0x96, 0x87, 0x4d, 0xe6, 0x09, 0xd3, 0x76, 0xcd, 0x3e, 0xa9, 0x16, 0xc3, 0x6d,
	0x25, 0x75, 0x39, 0x7f, 0x34, 0x30, 0x51, 0xd8, 0x45, 0x85, 0x95, 0x6f, 0xcd, 0xce, 0x83, 0xda,
	0x13, 0x8e, 0x3d, 0x8f, 0x72, 0x3f, 0x6c, 0x5f, 0xfe, 0xee, 0x3d, 0x28, 0x19, 0x3d, 0x91, 0xd0,
	0x45, 0x98, 0x8d, 0x84, 0x4c, 0x17, 0x3b, 0xb4, 0xac, 0x55, 0xb4, 0xd5, 0x33, 0xc6, 0x4c, 0xf4,
	0xf1, 0x16, 0x76, 0x28, 0x3a, 0x80, 0xc9, 0xa0, 0x73, 0xe5, 0x42, 0x45, 0x5b, 0x2d, 0xad, 0xdf,
	0xac, 0xa6, 0x0d, 0xb4, 0xec, 0x5d, 0xb5, 0x37, 0xc2, 0xdd, 0x63, 0x8f, 0x6e, 0xb9, 0x1d, 0x27,
	0xe1, 0xb3, 0x21, 0x55, 0xd1, 0x7d, 0x98, 0xb2, 0x1d, 0x0f, 0x5b, 0xa2, 0x3c, 0x51, 0xd1, 0x56,
	0x8b, 0xeb, 0x9f, 0x57, 0x73, 0x27, 0xb2, 0x4f, 0xac, 0xef, 0x75, 0x47, 0xaa, 0x19, 0x4a, 0x15,
	0x6d, 0xc1, 0x9c, 0x85, 0x1d, 0x0f, 0xdb, 0x2d, 0xd7, 0x6c, 0x76, 0x48, 0x8b, 0x8a, 0xf2, 0x29,
	0x19, 0x68, 0x21, 0x0a, 0x14, 0x8d, 0x57, 0xf5, 0x8e, 0xe0, 0xb6, 0xdb, 0xda, 0xc7, 0xed, 0x0e,
	0x35, 0x4a, 0x11, 0x69, 0x43, 0x72, 0xd0, 0x75, 0x38, 0x1d, 0x7d, 0x29, 0x4f, 0x0d, 0xc1, 0x8f,
	0xd1, 0xe8, 0x1a, 0x9c, 0xc6, 0xc4, 0x6c, 0x71, 0xd6, 0xf1, 0xca, 0xd3, 0x43, 0x30, 0xa7, 0x31,
	0xd9, 0x0e, 0xc0, 0xe8, 0x3a, 0x9c, 0x21, 0xb6, 0xef, 0xd8, 0xbe, 0x4f, 0x49, 0x79, 0x56, 0x32,
	0xf5, 0x01, 0xe6, 0x06, 0x63, 0xed, 0x90, 0x77, 0x02, 0x46, 0x3f, 0x69, 0xb0, 0xd8, 0xd7, 0xe9,
	0xbe, 0x35, 0x56, 0x9e, 0x94, 0x7a, 0xb7, 0x46, 0x1f, 0xec, 0xcd, 0x9e, 0x71, 0xe9, 0x6d, 0xbc,
	0xf9, 0x86, 0xb1, 0x60, 0x65, 0xb4, 0xa3, 0xa7, 0x1a, 0x5c, 0x78, 0x44, 0x8f, 0x9f, 0x30, 0x4e,
	0xfa, 0x0d, 0x9d, 0x96, 0x86, 0xb6, 0x47, 0x37, 0xf4, 0x65, 0xa8, 0x37, 0xe0, 0xe4, 0xfc, 0xa3,
	0xa4, 0x06, 0xf4, 0x2d, 0x5c, 0x10, 0xf4, 0x48, 0x98, 0x78, 0xc0, 0xc1, 0x99, 0x71, 0xd7, 0xdf,
	0x5d, 0x7a, 0x24, 0x1a, 0x83, 0x06, 0xe6, 0x45, 0xc2, 0x77, 0xf4, 0x4c, 0x83, 0x4a, 0xde, 0x09,
	0x50, 0x86, 0x71, 0x67, 0xe7, 0xae, 0x54, 0xde, 0xf4, 0xf0, 0x6d, 0x4f, 0xec, 0xb8, 0x83, 0xb3,
	0x23, 0x32, 0xda, 0xd1, 0x1f, 0x1a, 0x5c, 0x76, 0xf0, 0x91, 0xed, 0xd8, 0xdf, 0x50, 0xd3, 0x62,
	0xee, 0x21, 0xe5, 0xbe, 0xcd, 0x5c, 0x3f, 0xc5, 0x64, 0x51, 0x9a, 0xbc, 0x37, 0xba, 0xc9, 0x5d,
	0x15, 0x63, 0xf3, 0x24, 0x44, 0xb2, 0xdd, 0x4b, 0xce, 0x50, 0x48, 0xf4, 0xb3, 0x06, 0xcb, 0xd4,
	0x7d, 0x88, 0x5d, 0x8b, 0x12, 0xd3, 0xf2, 0xac, 0x14, 0xc3, 0x33, 0xd2, 0xf0, 0xde, 0xe8, 0x86,
	0xb7, 0x94, 0xf6, 0xa6, 0x67, 0x25, 0x1b, 0x5d, 0xa4, 0x99, 0x08, 0xf4, 0x9b, 0x06, 0x2b, 0x3e,
	0xc5, 0xdc, 0x7a, 0x68, 0x7a, 0x98, 0x0b, 0x97, 0xf2, 0xb4, 0x41, 0x2d, 0x49, 0x8f, 0x77, 0x46,
	0xf7, 0x78, 0x47, 0xca, 0xef, 0x29, 0xf5, 0x64, 0x9b, 0x4b, 0x7e, 0x1e, 0x48, 0x3a, 0x3d, 0x59,
	0x03, 0x6d, 0xdb, 0x7a, 0x94, 0xe6, 0x74, 0x6e, 0x5c, 0xa7, 0xf1, 0xf4, 0x4b, 0xf5, 0x14, 0xa7,
	0x4e, 0x1e, 0x08, 0xfd, 0xaa, 0xc1, 0x45, 0xe6, 0x89, 0xd0, 0x69, 0xb0, 0x9b, 0x99, 0x08, 0xd3,
	0x67, 0x9f, 0xcf, 0xb3, 0xd2, 0xa7, 0x31, 0xba, 0xcf, 0xdb, 0x4a, 0xbc, 0x41, 0x0c, 0x25, 0x3d,
	0x60, 0xb3, 0xc2, 0x72, 0x30, 0xfa, 0x3f, 0x1a, 0xcc, 0x27, 0xe5, 0x27, 0xf4, 0x35, 0xcc, 0x34,
	0xb1, 0x4f, 0x4d, 0x87, 0x0a, 0x6e, 0x5b, 0xbe, 0xcc, 0xbc, 0x63, 0x9d, 0x7f, 0xbd, 0xaf, 0xbb,
	0xa1, 0x9c, 0x51, 0x0c, 0xc4, 0xd5, 0x0b, 0x12, 0x70, 0xce, 0x63, 0x82, 0xba, 0xc2, 0xc6, 0xed,
	0x38, 0x60, 0xe1, 0xd5, 0x06, 0x3c, 0x1b, 0x47, 0x50, 0x5f, 0xf4, 0x17, 0x05, 0x38, 0x9f, 0x88,
	0x45, 0x9f, 0x41, 0xd1, 0x76, 0x3c, 0x4e, 0x7d, 0xb9, 0xa3, 0x55, 0xd7, 0x07, 0xb3, 0xe2, 0x0d,
	0xd6, 0x69, 0xb6, 0x69, 0x98, 0xdd, 0xba, 0x09, 0xe8, 0x0a, 0x4c, 0x85, 0x4b, 0x53, 0x75, 0x22,
	0x9b, 0xaa, 0xb0, 0xe8, 0x13, 0x28, 0x5a, 0xcc, 0x17, 0xa6, 0x63, 0x5b, 0x9c, 0xf9, 0xaa, 0xdc,
	0x78, 0x67, 0x80, 0xba, 0xe3, 0x8a, 0xab, 0x57, 0x42, 0x26, 0x04, 0xf8, 0x5d, 0x09, 0x0f, 0x3c,
	0x77, 0x1d, 0x89, 0x2a, 0x7f, 0xe6, 0x78, 0xee, 0x22, 0xa0, 0x4f, 0xa1, 0x78, 0x68, 0x13, 0xca,
	0xcc, 0x43, 0x9b, 0x3e, 0xf1, 0x53, 0x6b, 0x90, 0x6e, 0x3e, 0x48, 0xc2, 0x7e, 0x80, 0xd7, 0x5f,
	0x4e, 0xc2, 0x42, 0x56, 0xea, 0x45, 0x07, 0xb0, 0x60, 0x75, 0x38, 0xa7, 0xae, 0x88, 0x32, 0x3e,
	0x76, 0x58, 0xc7, 0x8d, 0xbb, 0xab, 0xe5, 0x77, 0xf7, 0x6d, 0x25, 0x10, 0xea, 0x37, 0x24, 0x5d,
	0xf5, 0x9e, 0x40, 0x25, 0xde, 0x56, 0x94, 0x24, 0x47, 0x28, 0xe4, 0x47, 0x78, 0xb7, 0x4b, 0x24,
	0x21, 0xca, 0x33, 0x0d, 0x4a, 0x4a, 0x3a, 0xd8, 0x58, 0xc1, 0x38, 0x4f, 0x54, 0x26, 0x56, 0x8b,
	0xeb, 0x8f, 0x5f, 0x6d, 0x9d, 0x92, 0xd9, 0x78, 0x5b, 0x46, 0x36, 0x66, 0x43, 0x23, 0xe1, 0x9b,
	0xaf, 0xbf, 0xd4, 0x60, 0x39, 0x9f, 0x85, 0x76, 0x61, 0x7e, 0xdc, 0xd1, 0x47, 0xcd, 0xc1, 0x01,
	0x39, 0x29, 0x8e, 0x0b, 0xaf, 0xa3, 0x38, 0xd6, 0x9f, 0x6b, 0x70, 0x3e, 0xb1, 0x7e, 0x42, 0x5b,
	0x30, 0xad, 0xea, 0x27, 0xe5, 0xfd, 0xfd, 0xd4, 0xd0, 0xe1, 0xed, 0x29, 0xaa, 0xc3, 0x76, 0xdc,
	0x07, 0xcc, 0x88, 0xb8, 0xe8, 0x1e, 0xe8, 0xdd, 0xeb, 0x26, 0xc8, 0xcd, 0x4d, 0x9b, 0x8c, 0xb0,
	0x62, 0xde, 0xea, 0xa2, 0x6f, 0x7a, 0xd6, 0x86, 0x4d, 0xc2, 0xa1, 0xd1, 0xff, 0xd2, 0x60, 0x3e,
	0xa9, 0xf0, 0x42, 0x1f, 0x41, 0x01, 0x47, 0xa6, 0x57, 0x86, 0x18, 0xaf, 0x06, 0x31, 0x0a, 0x98,
	0xa0, 0x06, 0xcc, 0x5a, 0x9c, 0x86, 0x19, 0x84, 0x60, 0x41, 0x53, 0x8f, 0x96, 0xee, 0x5a, 0x7d,
	0x26, 0xa2, 0xdc, 0xc0, 0x82, 0xa2, 0x1b, 0x30, 0x87, 0x3b, 0x82, 0x99, 0xd8, 0xf3, 0xda, 0xc7,
	0xa1, 0xc8, 0xc4, 0x10, 0x22, 0xb3, 0x01, 0xa9, 0x11, 0x70, 0x02, 0x15, 0xfd, 0xcf, 0x53, 0xb0,
	0x90, 0x55, 0xc6, 0xa1, 0x1f, 0x34, 0x98, 0x8e, 0xb6, 0x87, 0x36, 0xee, 0xf6, 0xc8, 0x8a, 0x90,
	0xd9, 0xa8, 0xb6, 0x47, 0xe4, 0x00, 0xdd, 0x87, 0xee, 0x4d, 0x6d, 0x76, 0x95, 0xb6, 0xc3, 0x4f,
	0x72, 0xf7, 0x1a, 0x89, 0x63, 0xab, 0x79, 0x7e, 0x3e, 0x01, 0xcb, 0xf9, 0x7e, 0xd0, 0x11, 0x4c,
	0x06, 0xd7, 0x66, 0x39, 0xef, 0xa5, 0x75, 0x92, 0x73, 0x49, 0xcd, 0x12, 0xdc, 0x66, 0xb8, 0x2d,
	0xaf, 0xac, 0x79, 0x20, 0x43, 0x46, 0x44, 0xdb, 0x70, 0x6e, 0xac, 0x4e, 0xcf, 0x89, 0xde, 0x9e,
	0x22, 0x06, 0x97, 0x38, 0x7d, 0xdc, 0xb1, 0x79, 0xb0, 0x51, 0xfa, 0x6e, 0x6f, 0xbd, 0xa7, 0xc9,
	0x10, 0xa9, 0x6b, 0x39, 0x92, 0xea, 0x3d, 0xb4, 0x52, 0x4e, 0x97, 0xc9, 0xd7, 0x72, 0xba, 0xfc,
	0xa8, 0xc1, 0xa5, 0xe1, 0x6a, 0xfd, 0xa1, 0xf2, 0x8b, 0xf6, 0x5f, 0xf3, 0x8b, 0x5e, 0x81, 0xc5,
	0xec, 0x52, 0x5e, 0xbf, 0x08, 0x4b, 0xb9, 0x85, 0xb4, 0xfe, 0xbd, 0x06, 0x4b, 0xb9, 0x45, 0xec,
	0xff, 0xd4, 0xa5, 0x65, 0xa8, 0xe4, 0xd5, 0xa9, 0x1b, 0x67, 0xa1, 0xd4, 0x5b, 0x13, 0x6f, 0x3c,
	0x2d, 0xc0, 0x8a, 0xc5, 0x9c, 0xfc, 0xf9, 0xde, 0x78, 0xb3, 0x57, 0x6b, 0x2f, 0x70, 0xb8, 0xa7,
	0x7d, 0xf5, 0x85, 0x62, 0xb6, 0x58, 0x1b, 0xbb, 0xad, 0x2a, 0xe3, 0xad, 0x5a, 0x8b, 0xba, 0xd2,
	0x7f, 0xf4, 0x9f, 0xca, 0xb3, 0xfd, 0x8c, 0xdf, 0x56, 0x1f, 0xc7, 0x4f, 0xbf, 0x14, 0x26, 0xb6,
	0x1b, 0x8d, 0xdf, 0x0b, 0x4b, 0xdb, 0xa1, 0x64, 0x83, 0xf8, 0xd5, 0xf0, 0x31, 0x78, 0xda, 0x5f,
	0xab, 0x1a, 0x11, 0xf2, 0x45, 0x84, 0x39, 0x68, 0x10, 0xff, 0x20, 0xc6, 0x1c, 0xec, 0xaf, 0x1d,
	0xc4, 0x98, 0xbf, 0x0b, 0x2b, 0x61, 0x43, 0xbd, 0xde, 0x20, 0x7e, 0xbd, 0x1e, 0xa3, 0xea, 0xf5,
	0xfd, 0xb5, 0x7a, 0x3d, 0xc6, 0x35, 0xa7, 0xa4, 0xd9, 0x0f, 0xff, 0x0d, 0x00, 0x00, 0xff, 0xff,
	0xa6, 0xbf, 0x64, 0x3a, 0x70, 0x14, 0x00, 0x00,
}
