// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/videointelligence/v1beta2/video_intelligence.proto

package videointelligence // import "google.golang.org/genproto/googleapis/cloud/videointelligence/v1beta2"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import duration "github.com/golang/protobuf/ptypes/duration"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"
import status "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Video annotation feature.
type Feature int32

const (
	// Unspecified.
	Feature_FEATURE_UNSPECIFIED Feature = 0
	// Label detection. Detect objects, such as dog or flower.
	Feature_LABEL_DETECTION Feature = 1
	// Shot change detection.
	Feature_SHOT_CHANGE_DETECTION Feature = 2
	// Explicit content detection.
	Feature_EXPLICIT_CONTENT_DETECTION Feature = 3
	// Human face detection and tracking.
	Feature_FACE_DETECTION Feature = 4
)

var Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "LABEL_DETECTION",
	2: "SHOT_CHANGE_DETECTION",
	3: "EXPLICIT_CONTENT_DETECTION",
	4: "FACE_DETECTION",
}
var Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":        0,
	"LABEL_DETECTION":            1,
	"SHOT_CHANGE_DETECTION":      2,
	"EXPLICIT_CONTENT_DETECTION": 3,
	"FACE_DETECTION":             4,
}

func (x Feature) String() string {
	return proto.EnumName(Feature_name, int32(x))
}
func (Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{0}
}

// Label detection mode.
type LabelDetectionMode int32

const (
	// Unspecified.
	LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED LabelDetectionMode = 0
	// Detect shot-level labels.
	LabelDetectionMode_SHOT_MODE LabelDetectionMode = 1
	// Detect frame-level labels.
	LabelDetectionMode_FRAME_MODE LabelDetectionMode = 2
	// Detect both shot-level and frame-level labels.
	LabelDetectionMode_SHOT_AND_FRAME_MODE LabelDetectionMode = 3
)

var LabelDetectionMode_name = map[int32]string{
	0: "LABEL_DETECTION_MODE_UNSPECIFIED",
	1: "SHOT_MODE",
	2: "FRAME_MODE",
	3: "SHOT_AND_FRAME_MODE",
}
var LabelDetectionMode_value = map[string]int32{
	"LABEL_DETECTION_MODE_UNSPECIFIED": 0,
	"SHOT_MODE":                        1,
	"FRAME_MODE":                       2,
	"SHOT_AND_FRAME_MODE":              3,
}

func (x LabelDetectionMode) String() string {
	return proto.EnumName(LabelDetectionMode_name, int32(x))
}
func (LabelDetectionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{1}
}

// Bucketized representation of likelihood.
type Likelihood int32

const (
	// Unspecified likelihood.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// Unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// Possible.
	Likelihood_POSSIBLE Likelihood = 3
	// Likely.
	Likelihood_LIKELY Likelihood = 4
	// Very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "LIKELIHOOD_UNSPECIFIED",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}
var Likelihood_value = map[string]int32{
	"LIKELIHOOD_UNSPECIFIED": 0,
	"VERY_UNLIKELY":          1,
	"UNLIKELY":               2,
	"POSSIBLE":               3,
	"LIKELY":                 4,
	"VERY_LIKELY":            5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}
func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{2}
}

// Video annotation request.
type AnnotateVideoRequest struct {
	// Input video location. Currently, only
	// [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](/storage/docs/reference-uris). A video
	// URI may include wildcards in `object-id`, and thus identify multiple
	// videos. Supported wildcards: '*' to match 0 or more characters;
	// '?' to match 1 character. If unset, the input video should be embedded
	// in the request as `input_content`. If set, `input_content` should be unset.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// The video data bytes.
	// If unset, the input video(s) should be specified via `input_uri`.
	// If set, `input_uri` should be unset.
	InputContent []byte `protobuf:"bytes,6,opt,name=input_content,json=inputContent,proto3" json:"input_content,omitempty"`
	// Requested video annotation features.
	Features []Feature `protobuf:"varint,2,rep,packed,name=features,proto3,enum=google.cloud.videointelligence.v1beta2.Feature" json:"features,omitempty"`
	// Additional video context and/or feature-specific parameters.
	VideoContext *VideoContext `protobuf:"bytes,3,opt,name=video_context,json=videoContext,proto3" json:"video_context,omitempty"`
	// Optional location where the output (in JSON format) should be stored.
	// Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
	// URIs are supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](/storage/docs/reference-uris).
	OutputUri string `protobuf:"bytes,4,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Optional cloud region where annotation should take place. Supported cloud
	// regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
	// is specified, a region will be determined based on video file location.
	LocationId           string   `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnnotateVideoRequest) Reset()         { *m = AnnotateVideoRequest{} }
func (m *AnnotateVideoRequest) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoRequest) ProtoMessage()    {}
func (*AnnotateVideoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{0}
}
func (m *AnnotateVideoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoRequest.Unmarshal(m, b)
}
func (m *AnnotateVideoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoRequest.Marshal(b, m, deterministic)
}
func (dst *AnnotateVideoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoRequest.Merge(dst, src)
}
func (m *AnnotateVideoRequest) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoRequest.Size(m)
}
func (m *AnnotateVideoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoRequest proto.InternalMessageInfo

func (m *AnnotateVideoRequest) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetInputContent() []byte {
	if m != nil {
		return m.InputContent
	}
	return nil
}

func (m *AnnotateVideoRequest) GetFeatures() []Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateVideoRequest) GetVideoContext() *VideoContext {
	if m != nil {
		return m.VideoContext
	}
	return nil
}

func (m *AnnotateVideoRequest) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

// Video context and/or feature-specific parameters.
type VideoContext struct {
	// Video segments to annotate. The segments may overlap and are not required
	// to be contiguous or span the whole video. If unspecified, each video
	// is treated as a single segment.
	Segments []*VideoSegment `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty"`
	// Config for LABEL_DETECTION.
	LabelDetectionConfig *LabelDetectionConfig `protobuf:"bytes,2,opt,name=label_detection_config,json=labelDetectionConfig,proto3" json:"label_detection_config,omitempty"`
	// Config for SHOT_CHANGE_DETECTION.
	ShotChangeDetectionConfig *ShotChangeDetectionConfig `protobuf:"bytes,3,opt,name=shot_change_detection_config,json=shotChangeDetectionConfig,proto3" json:"shot_change_detection_config,omitempty"`
	// Config for EXPLICIT_CONTENT_DETECTION.
	ExplicitContentDetectionConfig *ExplicitContentDetectionConfig `protobuf:"bytes,4,opt,name=explicit_content_detection_config,json=explicitContentDetectionConfig,proto3" json:"explicit_content_detection_config,omitempty"`
	// Config for FACE_DETECTION.
	FaceDetectionConfig  *FaceDetectionConfig `protobuf:"bytes,5,opt,name=face_detection_config,json=faceDetectionConfig,proto3" json:"face_detection_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *VideoContext) Reset()         { *m = VideoContext{} }
func (m *VideoContext) String() string { return proto.CompactTextString(m) }
func (*VideoContext) ProtoMessage()    {}
func (*VideoContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{1}
}
func (m *VideoContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoContext.Unmarshal(m, b)
}
func (m *VideoContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoContext.Marshal(b, m, deterministic)
}
func (dst *VideoContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoContext.Merge(dst, src)
}
func (m *VideoContext) XXX_Size() int {
	return xxx_messageInfo_VideoContext.Size(m)
}
func (m *VideoContext) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoContext.DiscardUnknown(m)
}

var xxx_messageInfo_VideoContext proto.InternalMessageInfo

func (m *VideoContext) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *VideoContext) GetLabelDetectionConfig() *LabelDetectionConfig {
	if m != nil {
		return m.LabelDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetShotChangeDetectionConfig() *ShotChangeDetectionConfig {
	if m != nil {
		return m.ShotChangeDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetExplicitContentDetectionConfig() *ExplicitContentDetectionConfig {
	if m != nil {
		return m.ExplicitContentDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetFaceDetectionConfig() *FaceDetectionConfig {
	if m != nil {
		return m.FaceDetectionConfig
	}
	return nil
}

// Config for LABEL_DETECTION.
type LabelDetectionConfig struct {
	// What labels should be detected with LABEL_DETECTION, in addition to
	// video-level labels or segment-level labels.
	// If unspecified, defaults to `SHOT_MODE`.
	LabelDetectionMode LabelDetectionMode `protobuf:"varint,1,opt,name=label_detection_mode,json=labelDetectionMode,proto3,enum=google.cloud.videointelligence.v1beta2.LabelDetectionMode" json:"label_detection_mode,omitempty"`
	// Whether the video has been shot from a stationary (i.e. non-moving) camera.
	// When set to true, might improve detection accuracy for moving objects.
	// Should be used with `SHOT_AND_FRAME_MODE` enabled.
	StationaryCamera bool `protobuf:"varint,2,opt,name=stationary_camera,json=stationaryCamera,proto3" json:"stationary_camera,omitempty"`
	// Model to use for label detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelDetectionConfig) Reset()         { *m = LabelDetectionConfig{} }
func (m *LabelDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*LabelDetectionConfig) ProtoMessage()    {}
func (*LabelDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{2}
}
func (m *LabelDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelDetectionConfig.Unmarshal(m, b)
}
func (m *LabelDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelDetectionConfig.Marshal(b, m, deterministic)
}
func (dst *LabelDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelDetectionConfig.Merge(dst, src)
}
func (m *LabelDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_LabelDetectionConfig.Size(m)
}
func (m *LabelDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_LabelDetectionConfig proto.InternalMessageInfo

func (m *LabelDetectionConfig) GetLabelDetectionMode() LabelDetectionMode {
	if m != nil {
		return m.LabelDetectionMode
	}
	return LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED
}

func (m *LabelDetectionConfig) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

func (m *LabelDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for SHOT_CHANGE_DETECTION.
type ShotChangeDetectionConfig struct {
	// Model to use for shot change detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShotChangeDetectionConfig) Reset()         { *m = ShotChangeDetectionConfig{} }
func (m *ShotChangeDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ShotChangeDetectionConfig) ProtoMessage()    {}
func (*ShotChangeDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{3}
}
func (m *ShotChangeDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShotChangeDetectionConfig.Unmarshal(m, b)
}
func (m *ShotChangeDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShotChangeDetectionConfig.Marshal(b, m, deterministic)
}
func (dst *ShotChangeDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShotChangeDetectionConfig.Merge(dst, src)
}
func (m *ShotChangeDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ShotChangeDetectionConfig.Size(m)
}
func (m *ShotChangeDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ShotChangeDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ShotChangeDetectionConfig proto.InternalMessageInfo

func (m *ShotChangeDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for EXPLICIT_CONTENT_DETECTION.
type ExplicitContentDetectionConfig struct {
	// Model to use for explicit content detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExplicitContentDetectionConfig) Reset()         { *m = ExplicitContentDetectionConfig{} }
func (m *ExplicitContentDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentDetectionConfig) ProtoMessage()    {}
func (*ExplicitContentDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{4}
}
func (m *ExplicitContentDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Unmarshal(m, b)
}
func (m *ExplicitContentDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Marshal(b, m, deterministic)
}
func (dst *ExplicitContentDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentDetectionConfig.Merge(dst, src)
}
func (m *ExplicitContentDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Size(m)
}
func (m *ExplicitContentDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentDetectionConfig proto.InternalMessageInfo

func (m *ExplicitContentDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for FACE_DETECTION.
type FaceDetectionConfig struct {
	// Model to use for face detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Whether bounding boxes be included in the face annotation output.
	IncludeBoundingBoxes bool     `protobuf:"varint,2,opt,name=include_bounding_boxes,json=includeBoundingBoxes,proto3" json:"include_bounding_boxes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FaceDetectionConfig) Reset()         { *m = FaceDetectionConfig{} }
func (m *FaceDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*FaceDetectionConfig) ProtoMessage()    {}
func (*FaceDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{5}
}
func (m *FaceDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceDetectionConfig.Unmarshal(m, b)
}
func (m *FaceDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceDetectionConfig.Marshal(b, m, deterministic)
}
func (dst *FaceDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceDetectionConfig.Merge(dst, src)
}
func (m *FaceDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_FaceDetectionConfig.Size(m)
}
func (m *FaceDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_FaceDetectionConfig proto.InternalMessageInfo

func (m *FaceDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *FaceDetectionConfig) GetIncludeBoundingBoxes() bool {
	if m != nil {
		return m.IncludeBoundingBoxes
	}
	return false
}

// Video segment.
type VideoSegment struct {
	// Time-offset, relative to the beginning of the video,
	// corresponding to the start of the segment (inclusive).
	StartTimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the end of the segment (inclusive).
	EndTimeOffset        *duration.Duration `protobuf:"bytes,2,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *VideoSegment) Reset()         { *m = VideoSegment{} }
func (m *VideoSegment) String() string { return proto.CompactTextString(m) }
func (*VideoSegment) ProtoMessage()    {}
func (*VideoSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{6}
}
func (m *VideoSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoSegment.Unmarshal(m, b)
}
func (m *VideoSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoSegment.Marshal(b, m, deterministic)
}
func (dst *VideoSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoSegment.Merge(dst, src)
}
func (m *VideoSegment) XXX_Size() int {
	return xxx_messageInfo_VideoSegment.Size(m)
}
func (m *VideoSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoSegment.DiscardUnknown(m)
}

var xxx_messageInfo_VideoSegment proto.InternalMessageInfo

func (m *VideoSegment) GetStartTimeOffset() *duration.Duration {
	if m != nil {
		return m.StartTimeOffset
	}
	return nil
}

func (m *VideoSegment) GetEndTimeOffset() *duration.Duration {
	if m != nil {
		return m.EndTimeOffset
	}
	return nil
}

// Video segment level annotation results for label detection.
type LabelSegment struct {
	// Video segment where a label was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelSegment) Reset()         { *m = LabelSegment{} }
func (m *LabelSegment) String() string { return proto.CompactTextString(m) }
func (*LabelSegment) ProtoMessage()    {}
func (*LabelSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{7}
}
func (m *LabelSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelSegment.Unmarshal(m, b)
}
func (m *LabelSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelSegment.Marshal(b, m, deterministic)
}
func (dst *LabelSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelSegment.Merge(dst, src)
}
func (m *LabelSegment) XXX_Size() int {
	return xxx_messageInfo_LabelSegment.Size(m)
}
func (m *LabelSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelSegment.DiscardUnknown(m)
}

var xxx_messageInfo_LabelSegment proto.InternalMessageInfo

func (m *LabelSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *LabelSegment) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Video frame level annotation results for label detection.
type LabelFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelFrame) Reset()         { *m = LabelFrame{} }
func (m *LabelFrame) String() string { return proto.CompactTextString(m) }
func (*LabelFrame) ProtoMessage()    {}
func (*LabelFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{8}
}
func (m *LabelFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelFrame.Unmarshal(m, b)
}
func (m *LabelFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelFrame.Marshal(b, m, deterministic)
}
func (dst *LabelFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelFrame.Merge(dst, src)
}
func (m *LabelFrame) XXX_Size() int {
	return xxx_messageInfo_LabelFrame.Size(m)
}
func (m *LabelFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelFrame.DiscardUnknown(m)
}

var xxx_messageInfo_LabelFrame proto.InternalMessageInfo

func (m *LabelFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *LabelFrame) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Detected entity from video analysis.
type Entity struct {
	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Textual description, e.g. `Fixed-gear bicycle`.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Language code for `description` in BCP-47 format.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Entity) Reset()         { *m = Entity{} }
func (m *Entity) String() string { return proto.CompactTextString(m) }
func (*Entity) ProtoMessage()    {}
func (*Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{9}
}
func (m *Entity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Entity.Unmarshal(m, b)
}
func (m *Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Entity.Marshal(b, m, deterministic)
}
func (dst *Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Entity.Merge(dst, src)
}
func (m *Entity) XXX_Size() int {
	return xxx_messageInfo_Entity.Size(m)
}
func (m *Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_Entity proto.InternalMessageInfo

func (m *Entity) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func (m *Entity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Entity) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Label annotation.
type LabelAnnotation struct {
	// Detected entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Common categories for the detected entity.
	// E.g. when the label is `Terrier` the category is likely `dog`. And in some
	// cases there might be more than one categories e.g. `Terrier` could also be
	// a `pet`.
	CategoryEntities []*Entity `protobuf:"bytes,2,rep,name=category_entities,json=categoryEntities,proto3" json:"category_entities,omitempty"`
	// All video segments where a label was detected.
	Segments []*LabelSegment `protobuf:"bytes,3,rep,name=segments,proto3" json:"segments,omitempty"`
	// All video frames where a label was detected.
	Frames               []*LabelFrame `protobuf:"bytes,4,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *LabelAnnotation) Reset()         { *m = LabelAnnotation{} }
func (m *LabelAnnotation) String() string { return proto.CompactTextString(m) }
func (*LabelAnnotation) ProtoMessage()    {}
func (*LabelAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{10}
}
func (m *LabelAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelAnnotation.Unmarshal(m, b)
}
func (m *LabelAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelAnnotation.Marshal(b, m, deterministic)
}
func (dst *LabelAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelAnnotation.Merge(dst, src)
}
func (m *LabelAnnotation) XXX_Size() int {
	return xxx_messageInfo_LabelAnnotation.Size(m)
}
func (m *LabelAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_LabelAnnotation proto.InternalMessageInfo

func (m *LabelAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *LabelAnnotation) GetCategoryEntities() []*Entity {
	if m != nil {
		return m.CategoryEntities
	}
	return nil
}

func (m *LabelAnnotation) GetSegments() []*LabelSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *LabelAnnotation) GetFrames() []*LabelFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Video frame level annotation results for explicit content.
type ExplicitContentFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Likelihood of the pornography content..
	PornographyLikelihood Likelihood `protobuf:"varint,2,opt,name=pornography_likelihood,json=pornographyLikelihood,proto3,enum=google.cloud.videointelligence.v1beta2.Likelihood" json:"pornography_likelihood,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}   `json:"-"`
	XXX_unrecognized      []byte     `json:"-"`
	XXX_sizecache         int32      `json:"-"`
}

func (m *ExplicitContentFrame) Reset()         { *m = ExplicitContentFrame{} }
func (m *ExplicitContentFrame) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentFrame) ProtoMessage()    {}
func (*ExplicitContentFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{11}
}
func (m *ExplicitContentFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentFrame.Unmarshal(m, b)
}
func (m *ExplicitContentFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentFrame.Marshal(b, m, deterministic)
}
func (dst *ExplicitContentFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentFrame.Merge(dst, src)
}
func (m *ExplicitContentFrame) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentFrame.Size(m)
}
func (m *ExplicitContentFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentFrame proto.InternalMessageInfo

func (m *ExplicitContentFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *ExplicitContentFrame) GetPornographyLikelihood() Likelihood {
	if m != nil {
		return m.PornographyLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

// Explicit content annotation (based on per-frame visual signals only).
// If no explicit content has been detected in a frame, no annotations are
// present for that frame.
type ExplicitContentAnnotation struct {
	// All video frames where explicit content was detected.
	Frames               []*ExplicitContentFrame `protobuf:"bytes,1,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ExplicitContentAnnotation) Reset()         { *m = ExplicitContentAnnotation{} }
func (m *ExplicitContentAnnotation) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentAnnotation) ProtoMessage()    {}
func (*ExplicitContentAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{12}
}
func (m *ExplicitContentAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentAnnotation.Unmarshal(m, b)
}
func (m *ExplicitContentAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentAnnotation.Marshal(b, m, deterministic)
}
func (dst *ExplicitContentAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentAnnotation.Merge(dst, src)
}
func (m *ExplicitContentAnnotation) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentAnnotation.Size(m)
}
func (m *ExplicitContentAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentAnnotation proto.InternalMessageInfo

func (m *ExplicitContentAnnotation) GetFrames() []*ExplicitContentFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Normalized bounding box.
// The normalized vertex coordinates are relative to the original image.
// Range: [0, 1].
type NormalizedBoundingBox struct {
	// Left X coordinate.
	Left float32 `protobuf:"fixed32,1,opt,name=left,proto3" json:"left,omitempty"`
	// Top Y coordinate.
	Top float32 `protobuf:"fixed32,2,opt,name=top,proto3" json:"top,omitempty"`
	// Right X coordinate.
	Right float32 `protobuf:"fixed32,3,opt,name=right,proto3" json:"right,omitempty"`
	// Bottom Y coordinate.
	Bottom               float32  `protobuf:"fixed32,4,opt,name=bottom,proto3" json:"bottom,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NormalizedBoundingBox) Reset()         { *m = NormalizedBoundingBox{} }
func (m *NormalizedBoundingBox) String() string { return proto.CompactTextString(m) }
func (*NormalizedBoundingBox) ProtoMessage()    {}
func (*NormalizedBoundingBox) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{13}
}
func (m *NormalizedBoundingBox) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedBoundingBox.Unmarshal(m, b)
}
func (m *NormalizedBoundingBox) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedBoundingBox.Marshal(b, m, deterministic)
}
func (dst *NormalizedBoundingBox) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedBoundingBox.Merge(dst, src)
}
func (m *NormalizedBoundingBox) XXX_Size() int {
	return xxx_messageInfo_NormalizedBoundingBox.Size(m)
}
func (m *NormalizedBoundingBox) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedBoundingBox.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedBoundingBox proto.InternalMessageInfo

func (m *NormalizedBoundingBox) GetLeft() float32 {
	if m != nil {
		return m.Left
	}
	return 0
}

func (m *NormalizedBoundingBox) GetTop() float32 {
	if m != nil {
		return m.Top
	}
	return 0
}

func (m *NormalizedBoundingBox) GetRight() float32 {
	if m != nil {
		return m.Right
	}
	return 0
}

func (m *NormalizedBoundingBox) GetBottom() float32 {
	if m != nil {
		return m.Bottom
	}
	return 0
}

// Video segment level annotation results for face detection.
type FaceSegment struct {
	// Video segment where a face was detected.
	Segment              *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *FaceSegment) Reset()         { *m = FaceSegment{} }
func (m *FaceSegment) String() string { return proto.CompactTextString(m) }
func (*FaceSegment) ProtoMessage()    {}
func (*FaceSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{14}
}
func (m *FaceSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceSegment.Unmarshal(m, b)
}
func (m *FaceSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceSegment.Marshal(b, m, deterministic)
}
func (dst *FaceSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceSegment.Merge(dst, src)
}
func (m *FaceSegment) XXX_Size() int {
	return xxx_messageInfo_FaceSegment.Size(m)
}
func (m *FaceSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceSegment.DiscardUnknown(m)
}

var xxx_messageInfo_FaceSegment proto.InternalMessageInfo

func (m *FaceSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

// Video frame level annotation results for face detection.
type FaceFrame struct {
	// Normalized Bounding boxes in a frame.
	// There can be more than one boxes if the same face is detected in multiple
	// locations within the current frame.
	NormalizedBoundingBoxes []*NormalizedBoundingBox `protobuf:"bytes,1,rep,name=normalized_bounding_boxes,json=normalizedBoundingBoxes,proto3" json:"normalized_bounding_boxes,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the video frame for this location.
	TimeOffset           *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *FaceFrame) Reset()         { *m = FaceFrame{} }
func (m *FaceFrame) String() string { return proto.CompactTextString(m) }
func (*FaceFrame) ProtoMessage()    {}
func (*FaceFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{15}
}
func (m *FaceFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceFrame.Unmarshal(m, b)
}
func (m *FaceFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceFrame.Marshal(b, m, deterministic)
}
func (dst *FaceFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceFrame.Merge(dst, src)
}
func (m *FaceFrame) XXX_Size() int {
	return xxx_messageInfo_FaceFrame.Size(m)
}
func (m *FaceFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceFrame.DiscardUnknown(m)
}

var xxx_messageInfo_FaceFrame proto.InternalMessageInfo

func (m *FaceFrame) GetNormalizedBoundingBoxes() []*NormalizedBoundingBox {
	if m != nil {
		return m.NormalizedBoundingBoxes
	}
	return nil
}

func (m *FaceFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

// Face annotation.
type FaceAnnotation struct {
	// Thumbnail of a representative face view (in JPEG format).
	Thumbnail []byte `protobuf:"bytes,1,opt,name=thumbnail,proto3" json:"thumbnail,omitempty"`
	// All video segments where a face was detected.
	Segments []*FaceSegment `protobuf:"bytes,2,rep,name=segments,proto3" json:"segments,omitempty"`
	// All video frames where a face was detected.
	Frames               []*FaceFrame `protobuf:"bytes,3,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *FaceAnnotation) Reset()         { *m = FaceAnnotation{} }
func (m *FaceAnnotation) String() string { return proto.CompactTextString(m) }
func (*FaceAnnotation) ProtoMessage()    {}
func (*FaceAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{16}
}
func (m *FaceAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceAnnotation.Unmarshal(m, b)
}
func (m *FaceAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceAnnotation.Marshal(b, m, deterministic)
}
func (dst *FaceAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceAnnotation.Merge(dst, src)
}
func (m *FaceAnnotation) XXX_Size() int {
	return xxx_messageInfo_FaceAnnotation.Size(m)
}
func (m *FaceAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_FaceAnnotation proto.InternalMessageInfo

func (m *FaceAnnotation) GetThumbnail() []byte {
	if m != nil {
		return m.Thumbnail
	}
	return nil
}

func (m *FaceAnnotation) GetSegments() []*FaceSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *FaceAnnotation) GetFrames() []*FaceFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Annotation results for a single video.
type VideoAnnotationResults struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label.
	SegmentLabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=segment_label_annotations,json=segmentLabelAnnotations,proto3" json:"segment_label_annotations,omitempty"`
	// Label annotations on shot level.
	// There is exactly one element for each unique label.
	ShotLabelAnnotations []*LabelAnnotation `protobuf:"bytes,3,rep,name=shot_label_annotations,json=shotLabelAnnotations,proto3" json:"shot_label_annotations,omitempty"`
	// Label annotations on frame level.
	// There is exactly one element for each unique label.
	FrameLabelAnnotations []*LabelAnnotation `protobuf:"bytes,4,rep,name=frame_label_annotations,json=frameLabelAnnotations,proto3" json:"frame_label_annotations,omitempty"`
	// Face annotations. There is exactly one element for each unique face.
	FaceAnnotations []*FaceAnnotation `protobuf:"bytes,5,rep,name=face_annotations,json=faceAnnotations,proto3" json:"face_annotations,omitempty"`
	// Shot annotations. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,6,rep,name=shot_annotations,json=shotAnnotations,proto3" json:"shot_annotations,omitempty"`
	// Explicit content annotation.
	ExplicitAnnotation *ExplicitContentAnnotation `protobuf:"bytes,7,opt,name=explicit_annotation,json=explicitAnnotation,proto3" json:"explicit_annotation,omitempty"`
	// If set, indicates an error. Note that for a single `AnnotateVideoRequest`
	// some videos may succeed and some may fail.
	Error                *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *VideoAnnotationResults) Reset()         { *m = VideoAnnotationResults{} }
func (m *VideoAnnotationResults) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationResults) ProtoMessage()    {}
func (*VideoAnnotationResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{17}
}
func (m *VideoAnnotationResults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationResults.Unmarshal(m, b)
}
func (m *VideoAnnotationResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationResults.Marshal(b, m, deterministic)
}
func (dst *VideoAnnotationResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationResults.Merge(dst, src)
}
func (m *VideoAnnotationResults) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationResults.Size(m)
}
func (m *VideoAnnotationResults) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationResults.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationResults proto.InternalMessageInfo

func (m *VideoAnnotationResults) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationResults) GetSegmentLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.SegmentLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.ShotLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFrameLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.FrameLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFaceAnnotations() []*FaceAnnotation {
	if m != nil {
		return m.FaceAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetExplicitAnnotation() *ExplicitContentAnnotation {
	if m != nil {
		return m.ExplicitAnnotation
	}
	return nil
}

func (m *VideoAnnotationResults) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Video annotation response. Included in the `response`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoResponse struct {
	// Annotation results for all videos specified in `AnnotateVideoRequest`.
	AnnotationResults    []*VideoAnnotationResults `protobuf:"bytes,1,rep,name=annotation_results,json=annotationResults,proto3" json:"annotation_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *AnnotateVideoResponse) Reset()         { *m = AnnotateVideoResponse{} }
func (m *AnnotateVideoResponse) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoResponse) ProtoMessage()    {}
func (*AnnotateVideoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{18}
}
func (m *AnnotateVideoResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoResponse.Unmarshal(m, b)
}
func (m *AnnotateVideoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoResponse.Marshal(b, m, deterministic)
}
func (dst *AnnotateVideoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoResponse.Merge(dst, src)
}
func (m *AnnotateVideoResponse) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoResponse.Size(m)
}
func (m *AnnotateVideoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoResponse proto.InternalMessageInfo

func (m *AnnotateVideoResponse) GetAnnotationResults() []*VideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

// Annotation progress for a single video.
type VideoAnnotationProgress struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Approximate percentage processed thus far.
	// Guaranteed to be 100 when fully processed.
	ProgressPercent int32 `protobuf:"varint,2,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time of the most recent update.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *VideoAnnotationProgress) Reset()         { *m = VideoAnnotationProgress{} }
func (m *VideoAnnotationProgress) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationProgress) ProtoMessage()    {}
func (*VideoAnnotationProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{19}
}
func (m *VideoAnnotationProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationProgress.Unmarshal(m, b)
}
func (m *VideoAnnotationProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationProgress.Marshal(b, m, deterministic)
}
func (dst *VideoAnnotationProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationProgress.Merge(dst, src)
}
func (m *VideoAnnotationProgress) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationProgress.Size(m)
}
func (m *VideoAnnotationProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationProgress.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationProgress proto.InternalMessageInfo

func (m *VideoAnnotationProgress) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationProgress) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *VideoAnnotationProgress) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// Video annotation progress. Included in the `metadata`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoProgress struct {
	// Progress metadata for all videos specified in `AnnotateVideoRequest`.
	AnnotationProgress   []*VideoAnnotationProgress `protobuf:"bytes,1,rep,name=annotation_progress,json=annotationProgress,proto3" json:"annotation_progress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *AnnotateVideoProgress) Reset()         { *m = AnnotateVideoProgress{} }
func (m *AnnotateVideoProgress) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoProgress) ProtoMessage()    {}
func (*AnnotateVideoProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_948f6bc85c1349e7, []int{20}
}
func (m *AnnotateVideoProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoProgress.Unmarshal(m, b)
}
func (m *AnnotateVideoProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoProgress.Marshal(b, m, deterministic)
}
func (dst *AnnotateVideoProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoProgress.Merge(dst, src)
}
func (m *AnnotateVideoProgress) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoProgress.Size(m)
}
func (m *AnnotateVideoProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoProgress.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoProgress proto.InternalMessageInfo

func (m *AnnotateVideoProgress) GetAnnotationProgress() []*VideoAnnotationProgress {
	if m != nil {
		return m.AnnotationProgress
	}
	return nil
}

func init() {
	proto.RegisterType((*AnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1beta2.AnnotateVideoRequest")
	proto.RegisterType((*VideoContext)(nil), "google.cloud.videointelligence.v1beta2.VideoContext")
	proto.RegisterType((*LabelDetectionConfig)(nil), "google.cloud.videointelligence.v1beta2.LabelDetectionConfig")
	proto.RegisterType((*ShotChangeDetectionConfig)(nil), "google.cloud.videointelligence.v1beta2.ShotChangeDetectionConfig")
	proto.RegisterType((*ExplicitContentDetectionConfig)(nil), "google.cloud.videointelligence.v1beta2.ExplicitContentDetectionConfig")
	proto.RegisterType((*FaceDetectionConfig)(nil), "google.cloud.videointelligence.v1beta2.FaceDetectionConfig")
	proto.RegisterType((*VideoSegment)(nil), "google.cloud.videointelligence.v1beta2.VideoSegment")
	proto.RegisterType((*LabelSegment)(nil), "google.cloud.videointelligence.v1beta2.LabelSegment")
	proto.RegisterType((*LabelFrame)(nil), "google.cloud.videointelligence.v1beta2.LabelFrame")
	proto.RegisterType((*Entity)(nil), "google.cloud.videointelligence.v1beta2.Entity")
	proto.RegisterType((*LabelAnnotation)(nil), "google.cloud.videointelligence.v1beta2.LabelAnnotation")
	proto.RegisterType((*ExplicitContentFrame)(nil), "google.cloud.videointelligence.v1beta2.ExplicitContentFrame")
	proto.RegisterType((*ExplicitContentAnnotation)(nil), "google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation")
	proto.RegisterType((*NormalizedBoundingBox)(nil), "google.cloud.videointelligence.v1beta2.NormalizedBoundingBox")
	proto.RegisterType((*FaceSegment)(nil), "google.cloud.videointelligence.v1beta2.FaceSegment")
	proto.RegisterType((*FaceFrame)(nil), "google.cloud.videointelligence.v1beta2.FaceFrame")
	proto.RegisterType((*FaceAnnotation)(nil), "google.cloud.videointelligence.v1beta2.FaceAnnotation")
	proto.RegisterType((*VideoAnnotationResults)(nil), "google.cloud.videointelligence.v1beta2.VideoAnnotationResults")
	proto.RegisterType((*AnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1beta2.AnnotateVideoResponse")
	proto.RegisterType((*VideoAnnotationProgress)(nil), "google.cloud.videointelligence.v1beta2.VideoAnnotationProgress")
	proto.RegisterType((*AnnotateVideoProgress)(nil), "google.cloud.videointelligence.v1beta2.AnnotateVideoProgress")
	proto.RegisterEnum("google.cloud.videointelligence.v1beta2.Feature", Feature_name, Feature_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1beta2.LabelDetectionMode", LabelDetectionMode_name, LabelDetectionMode_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1beta2.Likelihood", Likelihood_name, Likelihood_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// VideoIntelligenceServiceClient is the client API for VideoIntelligenceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VideoIntelligenceServiceClient interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type videoIntelligenceServiceClient struct {
	cc *grpc.ClientConn
}

func NewVideoIntelligenceServiceClient(cc *grpc.ClientConn) VideoIntelligenceServiceClient {
	return &videoIntelligenceServiceClient{cc}
}

func (c *videoIntelligenceServiceClient) AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.videointelligence.v1beta2.VideoIntelligenceService/AnnotateVideo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VideoIntelligenceServiceServer is the server API for VideoIntelligenceService service.
type VideoIntelligenceServiceServer interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(context.Context, *AnnotateVideoRequest) (*longrunning.Operation, error)
}

func RegisterVideoIntelligenceServiceServer(s *grpc.Server, srv VideoIntelligenceServiceServer) {
	s.RegisterService(&_VideoIntelligenceService_serviceDesc, srv)
}

func _VideoIntelligenceService_AnnotateVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.videointelligence.v1beta2.VideoIntelligenceService/AnnotateVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, req.(*AnnotateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1beta2.VideoIntelligenceService",
	HandlerType: (*VideoIntelligenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnnotateVideo",
			Handler:    _VideoIntelligenceService_AnnotateVideo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/videointelligence/v1beta2/video_intelligence.proto",
}

func init() {
	proto.RegisterFile("google/cloud/videointelligence/v1beta2/video_intelligence.proto", fileDescriptor_video_intelligence_948f6bc85c1349e7)
}

var fileDescriptor_video_intelligence_948f6bc85c1349e7 = []byte{
	// 1718 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0x4f, 0x6f, 0xdb, 0xc8,
	0x15, 0x2f, 0x25, 0xd9, 0xb1, 0x9e, 0xff, 0x48, 0x19, 0xcb, 0xb6, 0xec, 0x26, 0x5e, 0x97, 0x29,
	0x16, 0xae, 0x0b, 0x48, 0x88, 0x77, 0xb1, 0x45, 0x93, 0x6d, 0x17, 0xb2, 0x4c, 0x6d, 0xd4, 0x75,
	0x24, 0x81, 0x52, 0xd2, 0xa6, 0x4d, 0x41, 0x50, 0xe4, 0x88, 0x22, 0x96, 0xe2, 0x70, 0xc9, 0x61,
	0x10, 0xf7, 0xd0, 0xc3, 0x1e, 0x16, 0xe8, 0xb1, 0xe8, 0xa5, 0x9f, 0xa1, 0x87, 0x7e, 0x83, 0x02,
	0x45, 0x2f, 0x05, 0x72, 0x6d, 0x2f, 0xbd, 0xf4, 0xd4, 0x63, 0x3f, 0x40, 0x8f, 0x05, 0x67, 0x86,
	0x12, 0x45, 0xca, 0xb1, 0x94, 0x60, 0x6f, 0x9c, 0xf7, 0xe6, 0xfd, 0xde, 0xff, 0x37, 0x33, 0x84,
	0xcf, 0x2c, 0x42, 0x2c, 0x07, 0xd7, 0x0d, 0x87, 0x84, 0x66, 0xfd, 0x95, 0x6d, 0x62, 0x62, 0xbb,
	0x14, 0x3b, 0x8e, 0x6d, 0x61, 0xd7, 0xc0, 0xf5, 0x57, 0x0f, 0x87, 0x98, 0xea, 0xe7, 0x9c, 0xa3,
	0x25, 0x59, 0x35, 0xcf, 0x27, 0x94, 0xa0, 0x0f, 0x39, 0x40, 0x8d, 0x01, 0xd4, 0x32, 0x00, 0x35,
	0x01, 0x70, 0x74, 0x4f, 0x28, 0xd2, 0x3d, 0xbb, 0xae, 0xbb, 0x2e, 0xa1, 0x3a, 0xb5, 0x89, 0x1b,
	0x70, 0x94, 0xa3, 0x07, 0x82, 0xeb, 0x10, 0xd7, 0xf2, 0x43, 0xd7, 0xb5, 0x5d, 0xab, 0x4e, 0x3c,
	0xec, 0xcf, 0x6d, 0x3a, 0x16, 0x9b, 0xd8, 0x6a, 0x18, 0x8e, 0xea, 0x66, 0xc8, 0x37, 0x08, 0xfe,
	0x07, 0x69, 0x3e, 0xb5, 0x27, 0x38, 0xa0, 0xfa, 0xc4, 0x13, 0x1b, 0x0e, 0xc4, 0x06, 0xdf, 0x33,
	0xea, 0x01, 0xd5, 0x69, 0x28, 0x90, 0xe5, 0xbf, 0xe6, 0xa0, 0xd2, 0xe0, 0x46, 0xe1, 0xe7, 0x91,
	0x0b, 0x2a, 0xfe, 0x2a, 0xc4, 0x01, 0x45, 0xdf, 0x85, 0xa2, 0xed, 0x7a, 0x21, 0xd5, 0x42, 0xdf,
	0xae, 0x4a, 0x27, 0xd2, 0x69, 0x51, 0xdd, 0x60, 0x84, 0x67, 0xbe, 0x8d, 0x1e, 0xc0, 0x36, 0x67,
	0x1a, 0xc4, 0xa5, 0xd8, 0xa5, 0xd5, 0xf5, 0x13, 0xe9, 0x74, 0x4b, 0xdd, 0x62, 0xc4, 0x26, 0xa7,
	0xa1, 0x2f, 0x60, 0x63, 0x84, 0x75, 0x1a, 0xfa, 0x38, 0xa8, 0xe6, 0x4e, 0xf2, 0xa7, 0x3b, 0xe7,
	0xf5, 0xda, 0x72, 0x21, 0xab, 0xb5, 0xb8, 0x9c, 0x3a, 0x05, 0x40, 0x2f, 0x60, 0x9b, 0x27, 0x82,
	0x69, 0x7c, 0x4d, 0xab, 0xf9, 0x13, 0xe9, 0x74, 0xf3, 0xfc, 0xe3, 0x65, 0x11, 0x99, 0x6f, 0x4d,
	0x2e, 0xab, 0x6e, 0xbd, 0x4a, 0xac, 0xd0, 0x7d, 0x00, 0x12, 0xd2, 0xd8, 0xd5, 0x02, 0x73, 0xb5,
	0xc8, 0x29, 0x91, 0xaf, 0x1f, 0xc0, 0xa6, 0x43, 0x0c, 0x16, 0x6d, 0xcd, 0x36, 0xab, 0x6b, 0x8c,
	0x0f, 0x31, 0xa9, 0x6d, 0xca, 0xff, 0x2e, 0xc0, 0x56, 0x12, 0x1e, 0xf5, 0x60, 0x23, 0xc0, 0xd6,
	0x04, 0xbb, 0x34, 0xa8, 0x4a, 0x27, 0xf9, 0x95, 0xcd, 0xec, 0x73, 0x61, 0x75, 0x8a, 0x82, 0x7c,
	0xd8, 0x77, 0xf4, 0x21, 0x76, 0x34, 0x13, 0x53, 0x6c, 0x30, 0x53, 0x0c, 0xe2, 0x8e, 0x6c, 0xab,
	0x9a, 0x63, 0x61, 0xf8, 0x74, 0x59, 0xfc, 0xab, 0x08, 0xe5, 0x32, 0x06, 0x69, 0x32, 0x0c, 0xb5,
	0xe2, 0x2c, 0xa0, 0xa2, 0xaf, 0x25, 0xb8, 0x17, 0x8c, 0x09, 0xd5, 0x8c, 0xb1, 0xee, 0x5a, 0x38,
	0xab, 0x9a, 0x67, 0xa0, 0xb1, 0xac, 0xea, 0xfe, 0x98, 0xd0, 0x26, 0x83, 0x4a, 0xeb, 0x3f, 0x0c,
	0x6e, 0x62, 0xa1, 0xdf, 0x4b, 0xf0, 0x3d, 0xfc, 0xda, 0x73, 0x6c, 0xc3, 0x9e, 0x16, 0x5b, 0xd6,
	0x92, 0x02, 0xb3, 0xa4, 0xb5, 0xac, 0x25, 0x8a, 0x00, 0x14, 0x85, 0x9a, 0x36, 0xe7, 0x18, 0xbf,
	0x95, 0x8f, 0x08, 0xec, 0x8d, 0x74, 0x63, 0x41, 0x40, 0xd6, 0x98, 0x19, 0x8f, 0x97, 0x2e, 0x72,
	0xdd, 0xc8, 0x84, 0x62, 0x77, 0x94, 0x25, 0xca, 0x7f, 0x97, 0xa0, 0xb2, 0x28, 0x71, 0xc8, 0x81,
	0x4a, 0xba, 0x2c, 0x26, 0xc4, 0xc4, 0xac, 0x5d, 0x77, 0xce, 0x1f, 0xbd, 0x5b, 0x51, 0x3c, 0x25,
	0x26, 0x56, 0x91, 0x93, 0xa1, 0xa1, 0x1f, 0xc2, 0xdd, 0x80, 0xcf, 0x2e, 0xdd, 0xbf, 0xd6, 0x0c,
	0x7d, 0x82, 0x7d, 0x9d, 0xd5, 0xdf, 0x86, 0x5a, 0x9e, 0x31, 0x9a, 0x8c, 0x8e, 0x2a, 0xb0, 0x16,
	0x99, 0xe2, 0xb0, 0x2a, 0x29, 0xaa, 0x7c, 0x21, 0x3f, 0x84, 0xc3, 0x1b, 0xcb, 0x60, 0x26, 0x22,
	0x25, 0x45, 0x3e, 0x81, 0xe3, 0xb7, 0xe7, 0xeb, 0x06, 0x39, 0x1d, 0x76, 0x17, 0x04, 0x78, 0xf1,
	0x66, 0xf4, 0x31, 0xec, 0xdb, 0xae, 0xe1, 0x84, 0x26, 0xd6, 0x86, 0x24, 0x74, 0x4d, 0xdb, 0xb5,
	0xb4, 0x21, 0x79, 0xcd, 0x06, 0x57, 0xe4, 0x5f, 0x45, 0x70, 0x2f, 0x04, 0xf3, 0x22, 0xe2, 0xc9,
	0x7f, 0x94, 0x44, 0xe3, 0x8b, 0x86, 0x45, 0x0a, 0x8b, 0x90, 0x4f, 0xb5, 0x68, 0xfc, 0x6a, 0x64,
	0x34, 0x0a, 0x30, 0x65, 0x8a, 0x36, 0xcf, 0x0f, 0xe3, 0x64, 0xc4, 0x23, 0xba, 0x76, 0x29, 0x46,
	0xb8, 0x5a, 0x62, 0x32, 0x03, 0x7b, 0x82, 0xbb, 0x4c, 0x02, 0x35, 0xa0, 0x84, 0x5d, 0x73, 0x0e,
	0x24, 0x77, 0x1b, 0xc8, 0x36, 0x76, 0xcd, 0x19, 0x84, 0xfc, 0x5b, 0xd8, 0x62, 0x59, 0x8d, 0x2d,
	0xeb, 0xc0, 0x1d, 0x31, 0x4c, 0x84, 0x3d, 0xef, 0x36, 0x91, 0x62, 0x10, 0x74, 0x0c, 0xc0, 0x8a,
	0xde, 0x8c, 0xf6, 0x32, 0xeb, 0x72, 0x6a, 0x82, 0x22, 0x8f, 0x01, 0x98, 0xfe, 0x96, 0xaf, 0x4f,
	0x30, 0x7a, 0x04, 0x9b, 0x2b, 0x45, 0x04, 0xe8, 0x2c, 0x18, 0xb7, 0x69, 0x72, 0x60, 0x5d, 0x71,
	0xa9, 0x4d, 0xaf, 0xa3, 0x13, 0x0b, 0xb3, 0xaf, 0x68, 0x4c, 0x8b, 0x13, 0x8b, 0x13, 0xda, 0x26,
	0x3a, 0x81, 0x4d, 0x13, 0x07, 0x86, 0x6f, 0x7b, 0x91, 0x06, 0x86, 0x53, 0x54, 0x93, 0xa4, 0xe8,
	0x4c, 0x73, 0x74, 0xd7, 0x0a, 0x75, 0x0b, 0x6b, 0x46, 0xd4, 0x45, 0xbc, 0x72, 0xb7, 0x62, 0x62,
	0x93, 0x98, 0x58, 0xfe, 0x67, 0x0e, 0x4a, 0xcc, 0xb1, 0xc6, 0xf4, 0x20, 0x47, 0x2d, 0x58, 0xe7,
	0x6a, 0x84, 0x63, 0xb5, 0xa5, 0xe7, 0x10, 0x93, 0x52, 0x85, 0x34, 0xfa, 0x15, 0xdc, 0x35, 0x74,
	0x8a, 0x2d, 0xe2, 0x5f, 0x6b, 0x8c, 0x64, 0x8b, 0x83, 0x73, 0x75, 0xc8, 0x72, 0x0c, 0xa4, 0x08,
	0x9c, 0xb9, 0x33, 0x29, 0xbf, 0xda, 0x99, 0x94, 0x2c, 0xa4, 0xc4, 0x99, 0xf4, 0x33, 0x58, 0x1f,
	0x45, 0xd9, 0x0d, 0xaa, 0x05, 0x86, 0x77, 0xbe, 0x12, 0x1e, 0x2b, 0x0c, 0x55, 0x20, 0xc8, 0x7f,
	0x91, 0xa0, 0x92, 0xea, 0xf2, 0xf7, 0xaf, 0x1c, 0x1b, 0xf6, 0x3d, 0xe2, 0xbb, 0xc4, 0xf2, 0x75,
	0x6f, 0x7c, 0xad, 0x39, 0xf6, 0x97, 0xd8, 0xb1, 0xc7, 0x84, 0x98, 0x2c, 0xfb, 0x3b, 0x2b, 0x18,
	0x3c, 0x95, 0x54, 0xf7, 0x12, 0x88, 0x33, 0xb2, 0xfc, 0x15, 0x1c, 0xa6, 0xcc, 0x4f, 0xd4, 0xc7,
	0x60, 0x1a, 0x28, 0x7e, 0x19, 0xf8, 0xf4, 0x1d, 0xcf, 0xa9, 0xf9, 0x90, 0x7d, 0x09, 0x7b, 0x1d,
	0xe2, 0x4f, 0x74, 0xc7, 0xfe, 0x0d, 0x36, 0x13, 0x73, 0x09, 0x21, 0x28, 0x38, 0x78, 0xc4, 0x63,
	0x95, 0x53, 0xd9, 0x37, 0x2a, 0x43, 0x9e, 0x12, 0x4f, 0x74, 0x4f, 0xf4, 0x19, 0xcd, 0x41, 0xdf,
	0xb6, 0xc6, 0xfc, 0x1e, 0x95, 0x53, 0xf9, 0x02, 0xed, 0xc3, 0xfa, 0x90, 0x50, 0x4a, 0x26, 0xec,
	0x48, 0xcd, 0xa9, 0x62, 0x25, 0xff, 0x1a, 0x36, 0xa3, 0x61, 0xfa, 0x2d, 0x4d, 0x13, 0xf9, 0x6f,
	0x12, 0x14, 0x23, 0x7c, 0x9e, 0xf3, 0x6b, 0x38, 0x74, 0xa7, 0x9e, 0xa5, 0xe7, 0x31, 0x0f, 0xe1,
	0x4f, 0x96, 0xd5, 0xb7, 0x30, 0x44, 0xea, 0x81, 0xbb, 0x88, 0x8c, 0x83, 0x74, 0xb9, 0xe5, 0x56,
	0x28, 0x37, 0xf9, 0x8d, 0x04, 0x3b, 0x91, 0x13, 0x89, 0xcc, 0xdf, 0x83, 0x22, 0x1d, 0x87, 0x93,
	0xa1, 0xab, 0xdb, 0xfc, 0xc0, 0xd9, 0x52, 0x67, 0x04, 0xd4, 0x4d, 0xb4, 0x24, 0x6f, 0xf3, 0x8f,
	0x56, 0xb9, 0x3a, 0x64, 0x3b, 0xb2, 0x3d, 0x2d, 0x34, 0xde, 0xe1, 0x0f, 0x57, 0x81, 0x9b, 0xaf,
	0xae, 0xff, 0xae, 0xc1, 0x3e, 0xcb, 0xd5, 0xcc, 0x1b, 0x15, 0x07, 0xa1, 0x43, 0x83, 0xb7, 0x3f,
	0x0c, 0x02, 0x38, 0x14, 0xe6, 0x68, 0xfc, 0x66, 0x92, 0x78, 0xf0, 0x08, 0x27, 0x7f, 0xb4, 0xd2,
	0x9c, 0x48, 0xe8, 0x3f, 0x10, 0xc8, 0x29, 0x7a, 0x80, 0x26, 0xb0, 0xcf, 0x2e, 0xaa, 0x59, 0x8d,
	0xf9, 0xf7, 0xd3, 0x58, 0x89, 0x60, 0x33, 0xea, 0x08, 0x1c, 0xb0, 0x28, 0x2d, 0xd0, 0x57, 0x78,
	0x3f, 0x7d, 0x7b, 0x0c, 0x37, 0xa3, 0x50, 0x87, 0x32, 0xbb, 0x70, 0x26, 0x35, 0xad, 0x31, 0x4d,
	0x9f, 0xac, 0x92, 0xe1, 0x84, 0xa2, 0xd2, 0x68, 0x6e, 0x1d, 0x20, 0x0d, 0xca, 0x2c, 0x84, 0x49,
	0x15, 0xeb, 0xef, 0xf1, 0x74, 0x29, 0x45, 0x68, 0x49, 0x05, 0x3e, 0xec, 0x4e, 0xef, 0xf1, 0x33,
	0x25, 0xd5, 0x3b, 0xab, 0xbd, 0x21, 0x6e, 0x1c, 0xb2, 0x2a, 0x8a, 0xd1, 0x13, 0xed, 0x77, 0x0a,
	0x6b, 0xd8, 0xf7, 0x89, 0x5f, 0x2d, 0x32, 0x2d, 0x28, 0xd6, 0xe2, 0x7b, 0x46, 0xad, 0xcf, 0x1e,
	0xc1, 0x2a, 0xdf, 0x20, 0x7f, 0x23, 0xc1, 0x5e, 0xea, 0x15, 0x1c, 0x78, 0xc4, 0x0d, 0x30, 0x9a,
	0x00, 0x9a, 0x99, 0xab, 0xf9, 0xbc, 0x07, 0xc4, 0x14, 0xfa, 0xe9, 0x4a, 0xa1, 0xc9, 0x74, 0x92,
	0x7a, 0x57, 0x4f, 0x93, 0xe4, 0x7f, 0x49, 0x70, 0x90, 0xda, 0xdd, 0xf3, 0x89, 0xe5, 0xe3, 0xe0,
	0x96, 0xc6, 0xfb, 0x01, 0x94, 0x3d, 0xb1, 0x51, 0xf3, 0xb0, 0x6f, 0x44, 0xb3, 0x39, 0x1a, 0x5f,
	0x6b, 0x6a, 0x29, 0xa6, 0xf7, 0x38, 0x19, 0xfd, 0x18, 0x60, 0x76, 0x4b, 0x15, 0xaf, 0xb8, 0xa3,
	0xcc, 0x8c, 0x1b, 0xc4, 0x7f, 0x10, 0xd4, 0xe2, 0xf4, 0x7e, 0x8a, 0x1e, 0xc3, 0x66, 0xe8, 0x99,
	0x3a, 0xc5, 0x5c, 0xb6, 0x70, 0xab, 0x2c, 0xf0, 0xed, 0x11, 0x41, 0xfe, 0x5d, 0x3a, 0xc8, 0x53,
	0xcf, 0x3c, 0xd8, 0x4d, 0x04, 0x39, 0xb6, 0x57, 0x44, 0xf9, 0xb3, 0x77, 0x8c, 0x72, 0x8c, 0xae,
	0x26, 0x12, 0x18, 0xd3, 0xce, 0xbe, 0x91, 0xe0, 0x8e, 0xf8, 0xc9, 0x80, 0x0e, 0x60, 0xb7, 0xa5,
	0x34, 0x06, 0xcf, 0x54, 0x45, 0x7b, 0xd6, 0xe9, 0xf7, 0x94, 0x66, 0xbb, 0xd5, 0x56, 0x2e, 0xcb,
	0xdf, 0x41, 0xbb, 0x50, 0xba, 0x6a, 0x5c, 0x28, 0x57, 0xda, 0xa5, 0x32, 0x50, 0x9a, 0x83, 0x76,
	0xb7, 0x53, 0x96, 0xd0, 0x21, 0xec, 0xf5, 0x9f, 0x74, 0x07, 0x5a, 0xf3, 0x49, 0xa3, 0xf3, 0xb9,
	0x92, 0x60, 0xe5, 0xd0, 0x31, 0x1c, 0x29, 0xbf, 0xe8, 0x5d, 0xb5, 0x9b, 0xed, 0x81, 0xd6, 0xec,
	0x76, 0x06, 0x4a, 0x67, 0x90, 0xe0, 0xe7, 0x11, 0x82, 0x9d, 0x56, 0xa3, 0x99, 0x94, 0x29, 0x9c,
	0xf9, 0x80, 0xb2, 0xcf, 0x2f, 0xf4, 0x7d, 0x38, 0x49, 0x69, 0xd6, 0x9e, 0x76, 0x2f, 0xd3, 0xf6,
	0x6d, 0x43, 0x91, 0x99, 0x12, 0xb1, 0xca, 0x12, 0xda, 0x01, 0x68, 0xa9, 0x8d, 0xa7, 0x0a, 0x5f,
	0xe7, 0x22, 0xbf, 0x18, 0xbb, 0xd1, 0xb9, 0xd4, 0x12, 0x8c, 0xfc, 0x19, 0x05, 0x98, 0xdd, 0x5d,
	0xd0, 0x11, 0xec, 0x5f, 0xb5, 0xbf, 0x50, 0xae, 0xda, 0x4f, 0xba, 0xdd, 0xcb, 0x94, 0x86, 0xbb,
	0xb0, 0xfd, 0x5c, 0x51, 0x5f, 0x68, 0xcf, 0x3a, 0x6c, 0xcb, 0x8b, 0xb2, 0x84, 0xb6, 0x60, 0x63,
	0xba, 0xca, 0x45, 0xab, 0x5e, 0xb7, 0xdf, 0x6f, 0x5f, 0x5c, 0x29, 0xe5, 0x3c, 0x02, 0x58, 0x17,
	0x9c, 0x02, 0x2a, 0xc1, 0x26, 0x13, 0x15, 0x84, 0xb5, 0xf3, 0x3f, 0x4b, 0x50, 0x65, 0x29, 0x6a,
	0x27, 0x92, 0xd7, 0xc7, 0xfe, 0x2b, 0xdb, 0xc0, 0xd1, 0x3b, 0x7f, 0x7b, 0xae, 0x36, 0xd0, 0xd2,
	0xb7, 0xa4, 0x45, 0x7f, 0xaf, 0x8e, 0xee, 0xc7, 0xd2, 0x89, 0xdf, 0x6a, 0xb5, 0x6e, 0xfc, 0x5b,
	0x4d, 0x7e, 0xf0, 0xf5, 0x3f, 0xfe, 0xf3, 0x87, 0xdc, 0x7d, 0xb9, 0x3a, 0xff, 0x97, 0x2f, 0x78,
	0x24, 0x4a, 0x05, 0x3f, 0x92, 0xce, 0x2e, 0xfe, 0x27, 0xc1, 0x99, 0x41, 0x26, 0x4b, 0xda, 0x71,
	0x71, 0xff, 0x26, 0xe7, 0x7a, 0x51, 0x5b, 0xf4, 0xa4, 0x5f, 0xfe, 0x5c, 0x00, 0x59, 0x24, 0x7a,
	0x52, 0xd4, 0x88, 0x6f, 0xd5, 0x2d, 0xec, 0xb2, 0xa6, 0xa9, 0x73, 0x96, 0xee, 0xd9, 0xc1, 0x6d,
	0xff, 0x23, 0x1f, 0x67, 0x38, 0x7f, 0xca, 0x7d, 0xf8, 0x39, 0x47, 0x6e, 0x32, 0x13, 0x33, 0x76,
	0xd4, 0x9e, 0x3f, 0xbc, 0x88, 0x44, 0xdf, 0xc4, 0x1b, 0x5f, 0xb2, 0x8d, 0x2f, 0x33, 0x1b, 0x5f,
	0x3e, 0xe7, 0x3a, 0x86, 0xeb, 0xcc, 0xaa, 0x8f, 0xfe, 0x1f, 0x00, 0x00, 0xff, 0xff, 0x1e, 0x8a,
	0xa0, 0x1c, 0x24, 0x15, 0x00, 0x00,
}
