package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEcsStsStatus invokes the aegis.DescribeEcsStsStatus API synchronously
// api document: https://help.aliyun.com/api/aegis/describeecsstsstatus.html
func (client *Client) DescribeEcsStsStatus(request *DescribeEcsStsStatusRequest) (response *DescribeEcsStsStatusResponse, err error) {
	response = CreateDescribeEcsStsStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEcsStsStatusWithChan invokes the aegis.DescribeEcsStsStatus API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeecsstsstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEcsStsStatusWithChan(request *DescribeEcsStsStatusRequest) (<-chan *DescribeEcsStsStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeEcsStsStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEcsStsStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEcsStsStatusWithCallback invokes the aegis.DescribeEcsStsStatus API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeecsstsstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEcsStsStatusWithCallback(request *DescribeEcsStsStatusRequest, callback func(response *DescribeEcsStsStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEcsStsStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeEcsStsStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEcsStsStatusRequest is the request struct for api DescribeEcsStsStatus
type DescribeEcsStsStatusRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeEcsStsStatusResponse is the response struct for api DescribeEcsStsStatus
type DescribeEcsStsStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Grant     bool   `json:"Grant" xml:"Grant"`
}

// CreateDescribeEcsStsStatusRequest creates a request to invoke DescribeEcsStsStatus API
func CreateDescribeEcsStsStatusRequest() (request *DescribeEcsStsStatusRequest) {
	request = &DescribeEcsStsStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeEcsStsStatus", "vipaegis", "openAPI")
	return
}

// CreateDescribeEcsStsStatusResponse creates a response to parse from DescribeEcsStsStatus response
func CreateDescribeEcsStsStatusResponse() (response *DescribeEcsStsStatusResponse) {
	response = &DescribeEcsStsStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
