package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWarning invokes the aegis.DescribeWarning API synchronously
// api document: https://help.aliyun.com/api/aegis/describewarning.html
func (client *Client) DescribeWarning(request *DescribeWarningRequest) (response *DescribeWarningResponse, err error) {
	response = CreateDescribeWarningResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWarningWithChan invokes the aegis.DescribeWarning API asynchronously
// api document: https://help.aliyun.com/api/aegis/describewarning.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWarningWithChan(request *DescribeWarningRequest) (<-chan *DescribeWarningResponse, <-chan error) {
	responseChan := make(chan *DescribeWarningResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWarning(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWarningWithCallback invokes the aegis.DescribeWarning API asynchronously
// api document: https://help.aliyun.com/api/aegis/describewarning.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWarningWithCallback(request *DescribeWarningRequest, callback func(response *DescribeWarningResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWarningResponse
		var err error
		defer close(result)
		response, err = client.DescribeWarning(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWarningRequest is the request struct for api DescribeWarning
type DescribeWarningRequest struct {
	*requests.RpcRequest
	TypeNames    string           `position:"Query" name:"TypeNames"`
	RiskName     string           `position:"Query" name:"RiskName"`
	StatusList   string           `position:"Query" name:"StatusList"`
	SourceIp     string           `position:"Query" name:"SourceIp"`
	RiskLevels   string           `position:"Query" name:"RiskLevels"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	StrategyId   requests.Integer `position:"Query" name:"StrategyId"`
	CurrentPage  requests.Integer `position:"Query" name:"CurrentPage"`
	Dealed       string           `position:"Query" name:"Dealed"`
	SubTypeNames string           `position:"Query" name:"SubTypeNames"`
	Uuids        string           `position:"Query" name:"Uuids"`
}

// DescribeWarningResponse is the response struct for api DescribeWarning
type DescribeWarningResponse struct {
	*responses.BaseResponse
	RequestId   string    `json:"RequestId" xml:"RequestId"`
	Count       int       `json:"Count" xml:"Count"`
	PageSize    int       `json:"PageSize" xml:"PageSize"`
	TotalCount  int       `json:"TotalCount" xml:"TotalCount"`
	CurrentPage int       `json:"CurrentPage" xml:"CurrentPage"`
	Warnings    []Warning `json:"Warnings" xml:"Warnings"`
}

// CreateDescribeWarningRequest creates a request to invoke DescribeWarning API
func CreateDescribeWarningRequest() (request *DescribeWarningRequest) {
	request = &DescribeWarningRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeWarning", "vipaegis", "openAPI")
	return
}

// CreateDescribeWarningResponse creates a response to parse from DescribeWarning response
func CreateDescribeWarningResponse() (response *DescribeWarningResponse) {
	response = &DescribeWarningResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
