package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TransformLeakage invokes the aegis.TransformLeakage API synchronously
// api document: https://help.aliyun.com/api/aegis/transformleakage.html
func (client *Client) TransformLeakage(request *TransformLeakageRequest) (response *TransformLeakageResponse, err error) {
	response = CreateTransformLeakageResponse()
	err = client.DoAction(request, response)
	return
}

// TransformLeakageWithChan invokes the aegis.TransformLeakage API asynchronously
// api document: https://help.aliyun.com/api/aegis/transformleakage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TransformLeakageWithChan(request *TransformLeakageRequest) (<-chan *TransformLeakageResponse, <-chan error) {
	responseChan := make(chan *TransformLeakageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TransformLeakage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TransformLeakageWithCallback invokes the aegis.TransformLeakage API asynchronously
// api document: https://help.aliyun.com/api/aegis/transformleakage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TransformLeakageWithCallback(request *TransformLeakageRequest, callback func(response *TransformLeakageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TransformLeakageResponse
		var err error
		defer close(result)
		response, err = client.TransformLeakage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TransformLeakageRequest is the request struct for api TransformLeakage
type TransformLeakageRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// TransformLeakageResponse is the response struct for api TransformLeakage
type TransformLeakageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateTransformLeakageRequest creates a request to invoke TransformLeakage API
func CreateTransformLeakageRequest() (request *TransformLeakageRequest) {
	request = &TransformLeakageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "TransformLeakage", "vipaegis", "openAPI")
	return
}

// CreateTransformLeakageResponse creates a response to parse from TransformLeakage response
func CreateTransformLeakageResponse() (response *TransformLeakageResponse) {
	response = &TransformLeakageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
