package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSystemSecurityPolicies invokes the alb.ListSystemSecurityPolicies API synchronously
func (client *Client) ListSystemSecurityPolicies(request *ListSystemSecurityPoliciesRequest) (response *ListSystemSecurityPoliciesResponse, err error) {
	response = CreateListSystemSecurityPoliciesResponse()
	err = client.DoAction(request, response)
	return
}

// ListSystemSecurityPoliciesWithChan invokes the alb.ListSystemSecurityPolicies API asynchronously
func (client *Client) ListSystemSecurityPoliciesWithChan(request *ListSystemSecurityPoliciesRequest) (<-chan *ListSystemSecurityPoliciesResponse, <-chan error) {
	responseChan := make(chan *ListSystemSecurityPoliciesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSystemSecurityPolicies(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSystemSecurityPoliciesWithCallback invokes the alb.ListSystemSecurityPolicies API asynchronously
func (client *Client) ListSystemSecurityPoliciesWithCallback(request *ListSystemSecurityPoliciesRequest, callback func(response *ListSystemSecurityPoliciesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSystemSecurityPoliciesResponse
		var err error
		defer close(result)
		response, err = client.ListSystemSecurityPolicies(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSystemSecurityPoliciesRequest is the request struct for api ListSystemSecurityPolicies
type ListSystemSecurityPoliciesRequest struct {
	*requests.RpcRequest
}

// ListSystemSecurityPoliciesResponse is the response struct for api ListSystemSecurityPolicies
type ListSystemSecurityPoliciesResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	SecurityPolicies []SecurityPolicy `json:"SecurityPolicies" xml:"SecurityPolicies"`
}

// CreateListSystemSecurityPoliciesRequest creates a request to invoke ListSystemSecurityPolicies API
func CreateListSystemSecurityPoliciesRequest() (request *ListSystemSecurityPoliciesRequest) {
	request = &ListSystemSecurityPoliciesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "ListSystemSecurityPolicies", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSystemSecurityPoliciesResponse creates a response to parse from ListSystemSecurityPolicies response
func CreateListSystemSecurityPoliciesResponse() (response *ListSystemSecurityPoliciesResponse) {
	response = &ListSystemSecurityPoliciesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
