package cassandra

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCmsUrl invokes the cassandra.GetCmsUrl API synchronously
func (client *Client) GetCmsUrl(request *GetCmsUrlRequest) (response *GetCmsUrlResponse, err error) {
	response = CreateGetCmsUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GetCmsUrlWithChan invokes the cassandra.GetCmsUrl API asynchronously
func (client *Client) GetCmsUrlWithChan(request *GetCmsUrlRequest) (<-chan *GetCmsUrlResponse, <-chan error) {
	responseChan := make(chan *GetCmsUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCmsUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCmsUrlWithCallback invokes the cassandra.GetCmsUrl API asynchronously
func (client *Client) GetCmsUrlWithCallback(request *GetCmsUrlRequest, callback func(response *GetCmsUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCmsUrlResponse
		var err error
		defer close(result)
		response, err = client.GetCmsUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCmsUrlRequest is the request struct for api GetCmsUrl
type GetCmsUrlRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// GetCmsUrlResponse is the response struct for api GetCmsUrl
type GetCmsUrlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Url       string `json:"Url" xml:"Url"`
}

// CreateGetCmsUrlRequest creates a request to invoke GetCmsUrl API
func CreateGetCmsUrlRequest() (request *GetCmsUrlRequest) {
	request = &GetCmsUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cassandra", "2019-01-01", "GetCmsUrl", "Cassandra", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetCmsUrlResponse creates a response to parse from GetCmsUrl response
func CreateGetCmsUrlResponse() (response *GetCmsUrlResponse) {
	response = &GetCmsUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
