package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConfigOfVersion invokes the cdn.DescribeConfigOfVersion API synchronously
func (client *Client) DescribeConfigOfVersion(request *DescribeConfigOfVersionRequest) (response *DescribeConfigOfVersionResponse, err error) {
	response = CreateDescribeConfigOfVersionResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConfigOfVersionWithChan invokes the cdn.DescribeConfigOfVersion API asynchronously
func (client *Client) DescribeConfigOfVersionWithChan(request *DescribeConfigOfVersionRequest) (<-chan *DescribeConfigOfVersionResponse, <-chan error) {
	responseChan := make(chan *DescribeConfigOfVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConfigOfVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConfigOfVersionWithCallback invokes the cdn.DescribeConfigOfVersion API asynchronously
func (client *Client) DescribeConfigOfVersionWithCallback(request *DescribeConfigOfVersionRequest, callback func(response *DescribeConfigOfVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConfigOfVersionResponse
		var err error
		defer close(result)
		response, err = client.DescribeConfigOfVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConfigOfVersionRequest is the request struct for api DescribeConfigOfVersion
type DescribeConfigOfVersionRequest struct {
	*requests.RpcRequest
	VersionId     string           `position:"Query" name:"VersionId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	FunctionName  string           `position:"Query" name:"FunctionName"`
	GroupId       requests.Integer `position:"Query" name:"GroupId"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	FunctionId    requests.Integer `position:"Query" name:"FunctionId"`
}

// DescribeConfigOfVersionResponse is the response struct for api DescribeConfigOfVersion
type DescribeConfigOfVersionResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	VersionConfigs VersionConfigs `json:"VersionConfigs" xml:"VersionConfigs"`
}

// CreateDescribeConfigOfVersionRequest creates a request to invoke DescribeConfigOfVersion API
func CreateDescribeConfigOfVersionRequest() (request *DescribeConfigOfVersionRequest) {
	request = &DescribeConfigOfVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeConfigOfVersion", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeConfigOfVersionResponse creates a response to parse from DescribeConfigOfVersion response
func CreateDescribeConfigOfVersionResponse() (response *DescribeConfigOfVersionResponse) {
	response = &DescribeConfigOfVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
