package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchCreateFeeRecord invokes the cloudcallcenter.BatchCreateFeeRecord API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/batchcreatefeerecord.html
func (client *Client) BatchCreateFeeRecord(request *BatchCreateFeeRecordRequest) (response *BatchCreateFeeRecordResponse, err error) {
	response = CreateBatchCreateFeeRecordResponse()
	err = client.DoAction(request, response)
	return
}

// BatchCreateFeeRecordWithChan invokes the cloudcallcenter.BatchCreateFeeRecord API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/batchcreatefeerecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchCreateFeeRecordWithChan(request *BatchCreateFeeRecordRequest) (<-chan *BatchCreateFeeRecordResponse, <-chan error) {
	responseChan := make(chan *BatchCreateFeeRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchCreateFeeRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchCreateFeeRecordWithCallback invokes the cloudcallcenter.BatchCreateFeeRecord API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/batchcreatefeerecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchCreateFeeRecordWithCallback(request *BatchCreateFeeRecordRequest, callback func(response *BatchCreateFeeRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchCreateFeeRecordResponse
		var err error
		defer close(result)
		response, err = client.BatchCreateFeeRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchCreateFeeRecordRequest is the request struct for api BatchCreateFeeRecord
type BatchCreateFeeRecordRequest struct {
	*requests.RpcRequest
	Record *[]BatchCreateFeeRecordRecord `position:"Query" name:"Record"  type:"Repeated"`
}

// BatchCreateFeeRecordRecord is a repeated param struct in BatchCreateFeeRecordRequest
type BatchCreateFeeRecordRecord struct {
	StatusCode    string `name:"statusCode"`
	Duration      string `name:"duration"`
	Caller        string `name:"caller"`
	TaobaoMainUid string `name:"taobaoMainUid"`
	Callee        string `name:"callee"`
	BizId         string `name:"bizId"`
	EndTime       string `name:"endTime"`
	StartTime     string `name:"startTime"`
	TaobaoUid     string `name:"taobaoUid"`
	MainRamId     string `name:"mainRamId"`
	RamId         string `name:"ramId"`
	OrigDuration  string `name:"origDuration"`
}

// BatchCreateFeeRecordResponse is the response struct for api BatchCreateFeeRecord
type BatchCreateFeeRecordResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Count          int    `json:"Count" xml:"Count"`
}

// CreateBatchCreateFeeRecordRequest creates a request to invoke BatchCreateFeeRecord API
func CreateBatchCreateFeeRecordRequest() (request *BatchCreateFeeRecordRequest) {
	request = &BatchCreateFeeRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "BatchCreateFeeRecord", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchCreateFeeRecordResponse creates a response to parse from BatchCreateFeeRecord response
func CreateBatchCreateFeeRecordResponse() (response *BatchCreateFeeRecordResponse) {
	response = &BatchCreateFeeRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
