package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPrivilegesOfRole invokes the cloudcallcenter.ListPrivilegesOfRole API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listprivilegesofrole.html
func (client *Client) ListPrivilegesOfRole(request *ListPrivilegesOfRoleRequest) (response *ListPrivilegesOfRoleResponse, err error) {
	response = CreateListPrivilegesOfRoleResponse()
	err = client.DoAction(request, response)
	return
}

// ListPrivilegesOfRoleWithChan invokes the cloudcallcenter.ListPrivilegesOfRole API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listprivilegesofrole.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPrivilegesOfRoleWithChan(request *ListPrivilegesOfRoleRequest) (<-chan *ListPrivilegesOfRoleResponse, <-chan error) {
	responseChan := make(chan *ListPrivilegesOfRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPrivilegesOfRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPrivilegesOfRoleWithCallback invokes the cloudcallcenter.ListPrivilegesOfRole API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listprivilegesofrole.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPrivilegesOfRoleWithCallback(request *ListPrivilegesOfRoleRequest, callback func(response *ListPrivilegesOfRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPrivilegesOfRoleResponse
		var err error
		defer close(result)
		response, err = client.ListPrivilegesOfRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPrivilegesOfRoleRequest is the request struct for api ListPrivilegesOfRole
type ListPrivilegesOfRoleRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	RoleId     string `position:"Query" name:"RoleId"`
}

// ListPrivilegesOfRoleResponse is the response struct for api ListPrivilegesOfRole
type ListPrivilegesOfRoleResponse struct {
	*responses.BaseResponse
	RequestId      string                           `json:"RequestId" xml:"RequestId"`
	Success        bool                             `json:"Success" xml:"Success"`
	Code           string                           `json:"Code" xml:"Code"`
	Message        string                           `json:"Message" xml:"Message"`
	HttpStatusCode int                              `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Privileges     PrivilegesInListPrivilegesOfRole `json:"Privileges" xml:"Privileges"`
}

// CreateListPrivilegesOfRoleRequest creates a request to invoke ListPrivilegesOfRole API
func CreateListPrivilegesOfRoleRequest() (request *ListPrivilegesOfRoleRequest) {
	request = &ListPrivilegesOfRoleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListPrivilegesOfRole", "", "")
	request.Method = requests.POST
	return
}

// CreateListPrivilegesOfRoleResponse creates a response to parse from ListPrivilegesOfRole response
func CreateListPrivilegesOfRoleResponse() (response *ListPrivilegesOfRoleResponse) {
	response = &ListPrivilegesOfRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
