package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateEslDeviceLight invokes the cloudesl.UpdateEslDeviceLight API synchronously
func (client *Client) UpdateEslDeviceLight(request *UpdateEslDeviceLightRequest) (response *UpdateEslDeviceLightResponse, err error) {
	response = CreateUpdateEslDeviceLightResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateEslDeviceLightWithChan invokes the cloudesl.UpdateEslDeviceLight API asynchronously
func (client *Client) UpdateEslDeviceLightWithChan(request *UpdateEslDeviceLightRequest) (<-chan *UpdateEslDeviceLightResponse, <-chan error) {
	responseChan := make(chan *UpdateEslDeviceLightResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateEslDeviceLight(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateEslDeviceLightWithCallback invokes the cloudesl.UpdateEslDeviceLight API asynchronously
func (client *Client) UpdateEslDeviceLightWithCallback(request *UpdateEslDeviceLightRequest, callback func(response *UpdateEslDeviceLightResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateEslDeviceLightResponse
		var err error
		defer close(result)
		response, err = client.UpdateEslDeviceLight(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateEslDeviceLightRequest is the request struct for api UpdateEslDeviceLight
type UpdateEslDeviceLightRequest struct {
	*requests.RpcRequest
	ExtraParams string           `position:"Body" name:"ExtraParams"`
	LightUpTime requests.Integer `position:"Body" name:"LightUpTime"`
	StoreId     string           `position:"Body" name:"StoreId"`
	Frequency   string           `position:"Body" name:"Frequency"`
	EslBarCode  string           `position:"Body" name:"EslBarCode"`
	LedColor    string           `position:"Body" name:"LedColor"`
	ItemBarCode string           `position:"Body" name:"ItemBarCode"`
}

// UpdateEslDeviceLightResponse is the response struct for api UpdateEslDeviceLight
type UpdateEslDeviceLightResponse struct {
	*responses.BaseResponse
	ErrorMessage      string             `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode         string             `json:"ErrorCode" xml:"ErrorCode"`
	Message           string             `json:"Message" xml:"Message"`
	SuccessCount      int                `json:"SuccessCount" xml:"SuccessCount"`
	FailCount         int                `json:"FailCount" xml:"FailCount"`
	DynamicCode       string             `json:"DynamicCode" xml:"DynamicCode"`
	Code              string             `json:"Code" xml:"Code"`
	DynamicMessage    string             `json:"DynamicMessage" xml:"DynamicMessage"`
	RequestId         string             `json:"RequestId" xml:"RequestId"`
	Success           bool               `json:"Success" xml:"Success"`
	LightFailEslInfos []LightFailEslInfo `json:"LightFailEslInfos" xml:"LightFailEslInfos"`
}

// CreateUpdateEslDeviceLightRequest creates a request to invoke UpdateEslDeviceLight API
func CreateUpdateEslDeviceLightRequest() (request *UpdateEslDeviceLightRequest) {
	request = &UpdateEslDeviceLightRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "UpdateEslDeviceLight", "cloudesl", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateEslDeviceLightResponse creates a response to parse from UpdateEslDeviceLight response
func CreateUpdateEslDeviceLightResponse() (response *UpdateEslDeviceLightResponse) {
	response = &UpdateEslDeviceLightResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
