package cloudgameapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryProject invokes the cloudgameapi.QueryProject API synchronously
func (client *Client) QueryProject(request *QueryProjectRequest) (response *QueryProjectResponse, err error) {
	response = CreateQueryProjectResponse()
	err = client.DoAction(request, response)
	return
}

// QueryProjectWithChan invokes the cloudgameapi.QueryProject API asynchronously
func (client *Client) QueryProjectWithChan(request *QueryProjectRequest) (<-chan *QueryProjectResponse, <-chan error) {
	responseChan := make(chan *QueryProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryProjectWithCallback invokes the cloudgameapi.QueryProject API asynchronously
func (client *Client) QueryProjectWithCallback(request *QueryProjectRequest, callback func(response *QueryProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryProjectResponse
		var err error
		defer close(result)
		response, err = client.QueryProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryProjectRequest is the request struct for api QueryProject
type QueryProjectRequest struct {
	*requests.RpcRequest
	PageNo    requests.Integer `position:"Query" name:"PageNo"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	TenantId  requests.Integer `position:"Query" name:"TenantId"`
	ProjectId requests.Integer `position:"Query" name:"ProjectId"`
}

// QueryProjectResponse is the response struct for api QueryProject
type QueryProjectResponse struct {
	*responses.BaseResponse
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	PageNumber int     `json:"PageNumber" xml:"PageNumber"`
	PageSize   int     `json:"PageSize" xml:"PageSize"`
	TotalCount int     `json:"TotalCount" xml:"TotalCount"`
	Data       []Items `json:"Data" xml:"Data"`
}

// CreateQueryProjectRequest creates a request to invoke QueryProject API
func CreateQueryProjectRequest() (request *QueryProjectRequest) {
	request = &QueryProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudGameAPI", "2020-07-28", "QueryProject", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryProjectResponse creates a response to parse from QueryProject response
func CreateQueryProjectResponse() (response *QueryProjectResponse) {
	response = &QueryProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
