package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckUmengDataAnalysisPermission invokes the cloudwf.CheckUmengDataAnalysisPermission API synchronously
// api document: https://help.aliyun.com/api/cloudwf/checkumengdataanalysispermission.html
func (client *Client) CheckUmengDataAnalysisPermission(request *CheckUmengDataAnalysisPermissionRequest) (response *CheckUmengDataAnalysisPermissionResponse, err error) {
	response = CreateCheckUmengDataAnalysisPermissionResponse()
	err = client.DoAction(request, response)
	return
}

// CheckUmengDataAnalysisPermissionWithChan invokes the cloudwf.CheckUmengDataAnalysisPermission API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/checkumengdataanalysispermission.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckUmengDataAnalysisPermissionWithChan(request *CheckUmengDataAnalysisPermissionRequest) (<-chan *CheckUmengDataAnalysisPermissionResponse, <-chan error) {
	responseChan := make(chan *CheckUmengDataAnalysisPermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckUmengDataAnalysisPermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckUmengDataAnalysisPermissionWithCallback invokes the cloudwf.CheckUmengDataAnalysisPermission API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/checkumengdataanalysispermission.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckUmengDataAnalysisPermissionWithCallback(request *CheckUmengDataAnalysisPermissionRequest, callback func(response *CheckUmengDataAnalysisPermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckUmengDataAnalysisPermissionResponse
		var err error
		defer close(result)
		response, err = client.CheckUmengDataAnalysisPermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckUmengDataAnalysisPermissionRequest is the request struct for api CheckUmengDataAnalysisPermission
type CheckUmengDataAnalysisPermissionRequest struct {
	*requests.RpcRequest
}

// CheckUmengDataAnalysisPermissionResponse is the response struct for api CheckUmengDataAnalysisPermission
type CheckUmengDataAnalysisPermissionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateCheckUmengDataAnalysisPermissionRequest creates a request to invoke CheckUmengDataAnalysisPermission API
func CreateCheckUmengDataAnalysisPermissionRequest() (request *CheckUmengDataAnalysisPermissionRequest) {
	request = &CheckUmengDataAnalysisPermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "CheckUmengDataAnalysisPermission", "cloudwf", "openAPI")
	return
}

// CreateCheckUmengDataAnalysisPermissionResponse creates a response to parse from CheckUmengDataAnalysisPermission response
func CreateCheckUmengDataAnalysisPermissionResponse() (response *CheckUmengDataAnalysisPermissionResponse) {
	response = &CheckUmengDataAnalysisPermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
