package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OemSitingSelction invokes the cloudwf.OemSitingSelction API synchronously
// api document: https://help.aliyun.com/api/cloudwf/oemsitingselction.html
func (client *Client) OemSitingSelction(request *OemSitingSelctionRequest) (response *OemSitingSelctionResponse, err error) {
	response = CreateOemSitingSelctionResponse()
	err = client.DoAction(request, response)
	return
}

// OemSitingSelctionWithChan invokes the cloudwf.OemSitingSelction API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/oemsitingselction.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OemSitingSelctionWithChan(request *OemSitingSelctionRequest) (<-chan *OemSitingSelctionResponse, <-chan error) {
	responseChan := make(chan *OemSitingSelctionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OemSitingSelction(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OemSitingSelctionWithCallback invokes the cloudwf.OemSitingSelction API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/oemsitingselction.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OemSitingSelctionWithCallback(request *OemSitingSelctionRequest, callback func(response *OemSitingSelctionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OemSitingSelctionResponse
		var err error
		defer close(result)
		response, err = client.OemSitingSelction(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OemSitingSelctionRequest is the request struct for api OemSitingSelction
type OemSitingSelctionRequest struct {
	*requests.RpcRequest
	Bid requests.Integer `position:"Query" name:"Bid"`
}

// OemSitingSelctionResponse is the response struct for api OemSitingSelction
type OemSitingSelctionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateOemSitingSelctionRequest creates a request to invoke OemSitingSelction API
func CreateOemSitingSelctionRequest() (request *OemSitingSelctionRequest) {
	request = &OemSitingSelctionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "OemSitingSelction", "cloudwf", "openAPI")
	return
}

// CreateOemSitingSelctionResponse creates a response to parse from OemSitingSelction response
func CreateOemSitingSelctionResponse() (response *OemSitingSelctionResponse) {
	response = &OemSitingSelctionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
