package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRepositoryGroup invokes the codeup.CreateRepositoryGroup API synchronously
func (client *Client) CreateRepositoryGroup(request *CreateRepositoryGroupRequest) (response *CreateRepositoryGroupResponse, err error) {
	response = CreateCreateRepositoryGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRepositoryGroupWithChan invokes the codeup.CreateRepositoryGroup API asynchronously
func (client *Client) CreateRepositoryGroupWithChan(request *CreateRepositoryGroupRequest) (<-chan *CreateRepositoryGroupResponse, <-chan error) {
	responseChan := make(chan *CreateRepositoryGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRepositoryGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRepositoryGroupWithCallback invokes the codeup.CreateRepositoryGroup API asynchronously
func (client *Client) CreateRepositoryGroupWithCallback(request *CreateRepositoryGroupRequest, callback func(response *CreateRepositoryGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRepositoryGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateRepositoryGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRepositoryGroupRequest is the request struct for api CreateRepositoryGroup
type CreateRepositoryGroupRequest struct {
	*requests.RoaRequest
	OrganizationId string `position:"Query" name:"OrganizationId"`
	SubUserId      string `position:"Query" name:"SubUserId"`
	ClientToken    string `position:"Query" name:"ClientToken"`
	AccessToken    string `position:"Query" name:"AccessToken"`
}

// CreateRepositoryGroupResponse is the response struct for api CreateRepositoryGroup
type CreateRepositoryGroupResponse struct {
	*responses.BaseResponse
	ErrorCode    int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateCreateRepositoryGroupRequest creates a request to invoke CreateRepositoryGroup API
func CreateCreateRepositoryGroupRequest() (request *CreateRepositoryGroupRequest) {
	request = &CreateRepositoryGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "CreateRepositoryGroup", "/api/v3/groups", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateRepositoryGroupResponse creates a response to parse from CreateRepositoryGroup response
func CreateCreateRepositoryGroupResponse() (response *CreateRepositoryGroupResponse) {
	response = &CreateRepositoryGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
