package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateAggregateCompliancePackReport invokes the config.GenerateAggregateCompliancePackReport API synchronously
func (client *Client) GenerateAggregateCompliancePackReport(request *GenerateAggregateCompliancePackReportRequest) (response *GenerateAggregateCompliancePackReportResponse, err error) {
	response = CreateGenerateAggregateCompliancePackReportResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateAggregateCompliancePackReportWithChan invokes the config.GenerateAggregateCompliancePackReport API asynchronously
func (client *Client) GenerateAggregateCompliancePackReportWithChan(request *GenerateAggregateCompliancePackReportRequest) (<-chan *GenerateAggregateCompliancePackReportResponse, <-chan error) {
	responseChan := make(chan *GenerateAggregateCompliancePackReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateAggregateCompliancePackReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateAggregateCompliancePackReportWithCallback invokes the config.GenerateAggregateCompliancePackReport API asynchronously
func (client *Client) GenerateAggregateCompliancePackReportWithCallback(request *GenerateAggregateCompliancePackReportRequest, callback func(response *GenerateAggregateCompliancePackReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateAggregateCompliancePackReportResponse
		var err error
		defer close(result)
		response, err = client.GenerateAggregateCompliancePackReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateAggregateCompliancePackReportRequest is the request struct for api GenerateAggregateCompliancePackReport
type GenerateAggregateCompliancePackReportRequest struct {
	*requests.RpcRequest
	ClientToken      string `position:"Body" name:"ClientToken"`
	AggregatorId     string `position:"Body" name:"AggregatorId"`
	CompliancePackId string `position:"Body" name:"CompliancePackId"`
}

// GenerateAggregateCompliancePackReportResponse is the response struct for api GenerateAggregateCompliancePackReport
type GenerateAggregateCompliancePackReportResponse struct {
	*responses.BaseResponse
	CompliancePackId string `json:"CompliancePackId" xml:"CompliancePackId"`
	RequestId        string `json:"RequestId" xml:"RequestId"`
}

// CreateGenerateAggregateCompliancePackReportRequest creates a request to invoke GenerateAggregateCompliancePackReport API
func CreateGenerateAggregateCompliancePackReportRequest() (request *GenerateAggregateCompliancePackReportRequest) {
	request = &GenerateAggregateCompliancePackReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GenerateAggregateCompliancePackReport", "", "")
	request.Method = requests.POST
	return
}

// CreateGenerateAggregateCompliancePackReportResponse creates a response to parse from GenerateAggregateCompliancePackReport response
func CreateGenerateAggregateCompliancePackReportResponse() (response *GenerateAggregateCompliancePackReportResponse) {
	response = &GenerateAggregateCompliancePackReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
