package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetHDMAliyunResourceSyncResult invokes the das.GetHDMAliyunResourceSyncResult API synchronously
func (client *Client) GetHDMAliyunResourceSyncResult(request *GetHDMAliyunResourceSyncResultRequest) (response *GetHDMAliyunResourceSyncResultResponse, err error) {
	response = CreateGetHDMAliyunResourceSyncResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetHDMAliyunResourceSyncResultWithChan invokes the das.GetHDMAliyunResourceSyncResult API asynchronously
func (client *Client) GetHDMAliyunResourceSyncResultWithChan(request *GetHDMAliyunResourceSyncResultRequest) (<-chan *GetHDMAliyunResourceSyncResultResponse, <-chan error) {
	responseChan := make(chan *GetHDMAliyunResourceSyncResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetHDMAliyunResourceSyncResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetHDMAliyunResourceSyncResultWithCallback invokes the das.GetHDMAliyunResourceSyncResult API asynchronously
func (client *Client) GetHDMAliyunResourceSyncResultWithCallback(request *GetHDMAliyunResourceSyncResultRequest, callback func(response *GetHDMAliyunResourceSyncResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetHDMAliyunResourceSyncResultResponse
		var err error
		defer close(result)
		response, err = client.GetHDMAliyunResourceSyncResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetHDMAliyunResourceSyncResultRequest is the request struct for api GetHDMAliyunResourceSyncResult
type GetHDMAliyunResourceSyncResultRequest struct {
	*requests.RpcRequest
	SkipAuth  string `position:"Query" name:"skipAuth"`
	Context   string `position:"Query" name:"__context"`
	Signature string `position:"Query" name:"signature"`
	UserId    string `position:"Query" name:"UserId"`
	Uid       string `position:"Query" name:"Uid"`
	AccessKey string `position:"Query" name:"accessKey"`
	TaskId    string `position:"Query" name:"TaskId"`
	Timestamp string `position:"Query" name:"timestamp"`
}

// GetHDMAliyunResourceSyncResultResponse is the response struct for api GetHDMAliyunResourceSyncResult
type GetHDMAliyunResourceSyncResultResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Synchro   string `json:"Synchro" xml:"Synchro"`
	Code      string `json:"Code" xml:"Code"`
	Success   string `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetHDMAliyunResourceSyncResultRequest creates a request to invoke GetHDMAliyunResourceSyncResult API
func CreateGetHDMAliyunResourceSyncResultRequest() (request *GetHDMAliyunResourceSyncResultRequest) {
	request = &GetHDMAliyunResourceSyncResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetHDMAliyunResourceSyncResult", "", "")
	request.Method = requests.POST
	return
}

// CreateGetHDMAliyunResourceSyncResultResponse creates a response to parse from GetHDMAliyunResourceSyncResult response
func CreateGetHDMAliyunResourceSyncResultResponse() (response *GetHDMAliyunResourceSyncResultResponse) {
	response = &GetHDMAliyunResourceSyncResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
