package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckEngineMetaTable invokes the dataworks_public.CheckEngineMetaTable API synchronously
func (client *Client) CheckEngineMetaTable(request *CheckEngineMetaTableRequest) (response *CheckEngineMetaTableResponse, err error) {
	response = CreateCheckEngineMetaTableResponse()
	err = client.DoAction(request, response)
	return
}

// CheckEngineMetaTableWithChan invokes the dataworks_public.CheckEngineMetaTable API asynchronously
func (client *Client) CheckEngineMetaTableWithChan(request *CheckEngineMetaTableRequest) (<-chan *CheckEngineMetaTableResponse, <-chan error) {
	responseChan := make(chan *CheckEngineMetaTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckEngineMetaTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckEngineMetaTableWithCallback invokes the dataworks_public.CheckEngineMetaTable API asynchronously
func (client *Client) CheckEngineMetaTableWithCallback(request *CheckEngineMetaTableRequest, callback func(response *CheckEngineMetaTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckEngineMetaTableResponse
		var err error
		defer close(result)
		response, err = client.CheckEngineMetaTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckEngineMetaTableRequest is the request struct for api CheckEngineMetaTable
type CheckEngineMetaTableRequest struct {
	*requests.RpcRequest
	DataSourceType string `position:"Query" name:"DataSourceType"`
	TableGuid      string `position:"Query" name:"TableGuid"`
}

// CheckEngineMetaTableResponse is the response struct for api CheckEngineMetaTable
type CheckEngineMetaTableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateCheckEngineMetaTableRequest creates a request to invoke CheckEngineMetaTable API
func CreateCheckEngineMetaTableRequest() (request *CheckEngineMetaTableRequest) {
	request = &CheckEngineMetaTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CheckEngineMetaTable", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckEngineMetaTableResponse creates a response to parse from CheckEngineMetaTable response
func CreateCheckEngineMetaTableResponse() (response *CheckEngineMetaTableResponse) {
	response = &CheckEngineMetaTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
