package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDataServiceGroup invokes the dataworks_public.CreateDataServiceGroup API synchronously
func (client *Client) CreateDataServiceGroup(request *CreateDataServiceGroupRequest) (response *CreateDataServiceGroupResponse, err error) {
	response = CreateCreateDataServiceGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDataServiceGroupWithChan invokes the dataworks_public.CreateDataServiceGroup API asynchronously
func (client *Client) CreateDataServiceGroupWithChan(request *CreateDataServiceGroupRequest) (<-chan *CreateDataServiceGroupResponse, <-chan error) {
	responseChan := make(chan *CreateDataServiceGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDataServiceGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDataServiceGroupWithCallback invokes the dataworks_public.CreateDataServiceGroup API asynchronously
func (client *Client) CreateDataServiceGroupWithCallback(request *CreateDataServiceGroupRequest, callback func(response *CreateDataServiceGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDataServiceGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateDataServiceGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDataServiceGroupRequest is the request struct for api CreateDataServiceGroup
type CreateDataServiceGroupRequest struct {
	*requests.RpcRequest
	ApiGatewayGroupId string           `position:"Body" name:"ApiGatewayGroupId"`
	TenantId          requests.Integer `position:"Body" name:"TenantId"`
	Description       string           `position:"Body" name:"Description"`
	ProjectId         requests.Integer `position:"Body" name:"ProjectId"`
	GroupName         string           `position:"Body" name:"GroupName"`
}

// CreateDataServiceGroupResponse is the response struct for api CreateDataServiceGroup
type CreateDataServiceGroupResponse struct {
	*responses.BaseResponse
	GroupId   string `json:"GroupId" xml:"GroupId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateDataServiceGroupRequest creates a request to invoke CreateDataServiceGroup API
func CreateCreateDataServiceGroupRequest() (request *CreateDataServiceGroupRequest) {
	request = &CreateDataServiceGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CreateDataServiceGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDataServiceGroupResponse creates a response to parse from CreateDataServiceGroup response
func CreateCreateDataServiceGroupResponse() (response *CreateDataServiceGroupResponse) {
	response = &CreateDataServiceGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
